/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ChannelFormatter;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.MessageSettings;
import chatty.gui.components.settings.PathSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.chatlog.ChatLog;
import chatty.util.commands.CustomCommand;
import chatty.util.irc.IrcBadges;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LogSettings
extends SettingsPanel {
    private final JLabel info;
    private final ComboStringSetting modeSetting;
    private final CardLayout cardManager;
    private final JPanel cards;

    public LogSettings(final SettingsDialog d) {
        super(true);
        JPanel modePanel = this.createTitledPanel(Language.getString("settings.log.section.channels"));
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 13);
        gbc.weightx = 0.4;
        modePanel.add((Component)new JLabel(Language.getString("settings.log.loggingMode")), gbc);
        HashMap<String, String> logModeOptions = new HashMap<String, String>();
        logModeOptions.put("always", Language.getString("settings.option.logMode.always"));
        logModeOptions.put("blacklist", Language.getString("settings.option.logMode.blacklist"));
        logModeOptions.put("whitelist", Language.getString("settings.option.logMode.whitelist"));
        logModeOptions.put("off", Language.getString("settings.option.logMode.off"));
        this.modeSetting = d.addComboStringSetting("logMode", 1, false, logModeOptions);
        this.modeSetting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogSettings.this.update();
            }
        });
        gbc = SettingsDialog.makeGbc(1, 0, 1, 1, 17);
        gbc.weightx = 0.6;
        modePanel.add((Component)this.modeSetting, gbc);
        this.cardManager = new CardLayout();
        this.cards = new JPanel(this.cardManager);
        this.cards.setPreferredSize(new Dimension(220, 130));
        ChannelFormatter formatter = new ChannelFormatter();
        ListSelector whitelist = d.addListSetting("logWhitelist", "Chatlog Whitelist", 1, 1, true, true);
        whitelist.setDataFormatter(formatter);
        ListSelector blacklist = d.addListSetting("logBlacklist", "Chatlog Blacklist", 1, 1, true, true);
        blacklist.setDataFormatter(formatter);
        this.cards.add((Component)whitelist, "whitelist");
        this.cards.add((Component)blacklist, "blacklist");
        JPanel empty = new JPanel(new GridBagLayout());
        JLabel emptyLabel = new JLabel(Language.getString("settings.log.noList"));
        emptyLabel.setForeground(Color.gray);
        empty.add((Component)emptyLabel, SettingsDialog.makeGbc(0, 0, 1, 1));
        this.cards.add((Component)empty, "none");
        gbc = SettingsDialog.makeGbc(0, 1, 2, 1);
        gbc.insets = new Insets(5, 10, 5, 5);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        modePanel.add((Component)this.cards, gbc);
        this.info = new JLabel();
        gbc = SettingsDialog.makeGbc(0, 2, 3, 1);
        gbc.weightx = 0.5;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        modePanel.add((Component)this.info, gbc);
        JPanel typesPanel = this.createTitledPanel("Message Types");
        JPanel extraPanel = this.createTitledPanel("Extra log file");
        SimpleBooleanSetting logMessages = d.addSimpleBooleanSetting("logMessage");
        SimpleBooleanSetting logIgnored = d.addSimpleBooleanSetting("logIgnored");
        EditorStringSetting messageTemplate = d.addEditorStringSetting("logMessageTemplate", -1, true, Language.getString("settings.boolean.logMessage.template"), false, "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-logmessagetemplate.html", null), new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                CustomCommand command = CustomCommand.parse(value);
                if (command.hasError()) {
                    CommandSettings.showCommandInfoPopup(component, command);
                } else {
                    User user = new User("testuser", "\u30c6\u30b9\u30c8\u30e6\u30fc\u30b6\u30fc", Room.createRegular("#testchannel"));
                    user.setId("123456");
                    user.setSubscriber(true);
                    user.setTwitchBadges(IrcBadges.parse("subscriber/12"));
                    String normalResult = command.replace(ChatLog.messageParam(user, "Hello, good day! :)", false, d.settings, "[12:34:56]"));
                    String actionResult = command.replace(ChatLog.messageParam(user, "has arrived! ;)", true, d.settings, "[12:34:56]"));
                    user = new User("TestName", Room.createRegular("#testchannel"));
                    user.setId("123457");
                    user.setTwitchBadges(IrcBadges.parse("vip/1,founder/0,premium/1"));
                    user.setVip(true);
                    user.setSubscriber(true);
                    user.setTurbo(true);
                    String badgesResult = command.replace(ChatLog.messageParam(user, "HeyGuys", false, d.settings, "[12:34:56]"));
                    user = new User("testname", "TestName", Room.createRegular("#testchannel"));
                    user.setId("123457");
                    String noBadgesResult = command.replace(ChatLog.messageParam(user, "HeyGuys", false, d.settings, "[12:34:56]"));
                    GuiUtil.showNonModalMessage(parent, "Example", String.format("Regular message:<br />%s<br /><br />Action message:<br />%s<br /><br />More badges, no localized name:<br />%s<br /><br />No badges:<br />%s<br /><br />(The timestamp may not represent your current log timestamp setting.)", Helper.htmlspecialchars_encode(normalResult), Helper.htmlspecialchars_encode(actionResult), Helper.htmlspecialchars_encode(badgesResult), Helper.htmlspecialchars_encode(noBadgesResult)), 1, true);
                }
                return null;
            }
        });
        SettingsUtil.addSubsettings(logMessages, logIgnored, messageTemplate);
        typesPanel.add((Component)logMessages, SettingsDialog.makeGbcCloser(0, 0, 1, 1, 17));
        typesPanel.add((Component)messageTemplate, SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        typesPanel.add((Component)logIgnored, SettingsDialog.makeGbcCloser(0, 2, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logInfo"), SettingsDialog.makeGbcCloser(0, 3, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logBan"), SettingsDialog.makeGbcCloser(0, 4, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logDeleted"), SettingsDialog.makeGbcCloser(0, 5, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logMod"), SettingsDialog.makeGbcCloser(0, 6, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logJoinPart"), SettingsDialog.makeGbcCloser(0, 7, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logSystem"), SettingsDialog.makeGbcCloser(0, 8, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logViewerstats"), SettingsDialog.makeGbcCloser(0, 9, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logViewercount"), SettingsDialog.makeGbcCloser(0, 10, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logModAction"), SettingsDialog.makeGbcCloser(0, 11, 1, 1, 17));
        typesPanel.add((Component)d.addSimpleBooleanSetting("logBits"), SettingsDialog.makeGbcCloser(0, 12, 1, 1, 17));
        extraPanel.add((Component)d.addSimpleBooleanSetting("logHighlighted2"), SettingsDialog.makeGbcCloser(0, 0, 1, 1, 17));
        extraPanel.add((Component)d.addSimpleBooleanSetting("logIgnored2"), SettingsDialog.makeGbcCloser(0, 1, 1, 1, 17));
        extraPanel.add((Component)new JLabel("<html><body style='width:140px;'>" + Language.getString("settings.customTabSettings.logInfo2")), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
        JPanel otherSettings = this.createTitledPanel(Language.getString("settings.log.section.other"));
        PathSetting logPath = new PathSetting(d, Chatty.getDefaultPath(Chatty.PathType.LOGS).toString());
        d.addStringSetting("logPath", logPath);
        otherSettings.add((Component)new JLabel(Language.getString("settings.log.folder")), SettingsDialog.makeGbc(0, 0, 1, 1, 18));
        gbc = SettingsDialog.makeGbc(1, 0, 2, 1);
        gbc.fill = 2;
        gbc.weightx = 0.9;
        gbc.insets.bottom += 4;
        otherSettings.add((Component)logPath, gbc);
        LinkedHashMap<String, String> organizationOptions = new LinkedHashMap<String, String>();
        organizationOptions.put("never", Language.getString("settings.option.logSplit.never"));
        organizationOptions.put("daily", Language.getString("settings.option.logSplit.daily"));
        organizationOptions.put("weekly", Language.getString("settings.option.logSplit.weekly"));
        organizationOptions.put("monthly", Language.getString("settings.option.logSplit.monthly"));
        ComboStringSetting organizationCombo = new ComboStringSetting((Map<String, String>)organizationOptions);
        organizationCombo.setEditable(false);
        d.addStringSetting("logSplit", organizationCombo);
        otherSettings.add((Component)new JLabel(Language.getString("settings.log.splitLogs")), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        otherSettings.add((Component)organizationCombo, SettingsDialog.makeGbc(1, 1, 1, 1, 17));
        otherSettings.add((Component)d.addSimpleBooleanSetting("logSubdirectories"), SettingsDialog.makeGbcCloser(2, 1, 1, 1, 17));
        LinkedHashMap<String, String> timestampOptions = new LinkedHashMap<String, String>();
        timestampOptions.put("off", Language.getString("settings.option.logTimestamp.off"));
        MessageSettings.addTimestampFormat(timestampOptions, "[HH:mm:ss]");
        MessageSettings.addTimestampFormat(timestampOptions, "[hh:mm:ss a]");
        MessageSettings.addTimestampFormat(timestampOptions, "[hh:mm:ssa]");
        MessageSettings.addTimestampFormat(timestampOptions, "[yyyy-MM-dd HH:mm:ss]");
        MessageSettings.addTimestampFormat(timestampOptions, "[yyyy-MM-dd hh:mm:ss a]");
        MessageSettings.addTimestampFormat(timestampOptions, "[yyyy-MM-dd hh:mm:ssa]");
        ComboStringSetting timestampCombo = new ComboStringSetting((Map<String, String>)timestampOptions);
        timestampCombo.setEditable(false);
        d.addStringSetting("logTimestamp", timestampCombo);
        otherSettings.add((Component)new JLabel(Language.getString("settings.log.timestamp")), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
        otherSettings.add((Component)timestampCombo, SettingsDialog.makeGbc(1, 2, 1, 1, 17));
        otherSettings.add((Component)d.addSimpleBooleanSetting("logLockFiles"), SettingsDialog.makeGbcCloser(2, 2, 1, 1, 17));
        gbc = this.getGbc(0);
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.gridheight = 2;
        this.addPanel(modePanel, gbc);
        gbc = this.getGbc(0);
        gbc.anchor = 11;
        gbc.gridx = 1;
        this.addPanel(typesPanel, gbc);
        gbc = this.getGbc(1);
        gbc.anchor = 11;
        gbc.gridx = 1;
        this.addPanel(extraPanel, gbc);
        gbc = this.getGbc(2);
        gbc.gridwidth = 2;
        this.addPanel(otherSettings, gbc);
        this.update();
    }

    private void update() {
        String mode = this.modeSetting.getSettingValue();
        String infoText = "";
        String switchTo = "none";
        switch (mode) {
            case "off": {
                infoText = Language.getString("settings.log.offInfo");
                switchTo = "none";
                break;
            }
            case "always": {
                infoText = Language.getString("settings.log.alwaysInfo");
                switchTo = "none";
                break;
            }
            case "blacklist": {
                infoText = Language.getString("settings.log.blacklistInfo");
                switchTo = "blacklist";
                break;
            }
            case "whitelist": {
                infoText = Language.getString("settings.log.whitelistInfo");
                switchTo = "whitelist";
            }
        }
        this.info.setText("<html><body style='width: 200px;text-align:center;'>" + infoText);
        this.cardManager.show(this.cards, switchTo);
    }
}

