/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.RegexDocumentFilter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class LongTextField
extends JTextField {
    private String previousValue = "";

    public LongTextField(int size, boolean editable) {
        super(size);
        this.setEditable(editable);
        this.setInputVerifier(new IntegerVerifier());
        ((AbstractDocument)this.getDocument()).setDocumentFilter(new RegexDocumentFilter("\\D+", this));
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LongTextField.this.inputChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LongTextField.this.inputChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LongTextField.this.inputChanged();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (LongTextField.this.getText().isEmpty()) {
                    LongTextField.this.setText(LongTextField.this.previousValue);
                }
            }
        });
    }

    private void inputChanged() {
        if (!this.getText().isEmpty()) {
            this.previousValue = this.getText();
        }
    }

    class IntegerVerifier
    extends InputVerifier {
        IntegerVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField component = (JTextField)input;
            try {
                Long.parseLong(component.getText());
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
    }
}

