/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.ColorSettingListener;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.LongSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.StringSetting;
import chatty.gui.laf.LaF;
import chatty.gui.laf.LaFChanger;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class LookSettings
extends SettingsPanel {
    protected LookSettings(SettingsDialog d) {
        JPanel lafSettingsPanel = this.addTitledPanel(Language.getString("settings.section.lookandfeel"), 1);
        JPanel optionsPanel = this.addTitledPanel("Additional Options", 2);
        JPanel previewPanel = this.addTitledPanel(Language.getString("settings.section.preview"), 3);
        LinkedHashMap<String, String> lafDef = new LinkedHashMap<String, String>();
        lafDef.put("default", "Default");
        lafDef.put("system", "System");
        lafDef.put("flatdark", "Flat Dark");
        lafDef.put("flatlight", "Flat Light");
        lafDef.put("hifiCustom", "HiFi Custom (Dark)");
        lafDef.put("hifi2", "HiFi Soft (Dark)");
        lafDef.put("hifi", "HiFi (Dark)");
        lafDef.put("noire", "Noire (Dark)");
        lafDef.put("mint", "Mint");
        lafDef.put("graphite", "Graphite");
        lafDef.put("aero", "Aero");
        lafDef.put("fast", "Fast");
        lafDef.put("luna", "Luna");
        ComboStringSetting laf = new ComboStringSetting((Map<String, String>)lafDef);
        d.addStringSetting("laf", laf);
        LinkLabel lafInfo = new LinkLabel("", d.getLinkLabelListener());
        laf.addItemListener(e -> LookSettings.updateInfo(lafInfo, laf));
        LookSettings.updateInfo(lafInfo, laf);
        LinkedHashMap<String, String> themeDef = new LinkedHashMap<String, String>();
        themeDef.put("Default", Language.getString("settings.laf.option.defaultFont"));
        themeDef.put("Small-Font", Language.getString("settings.laf.option.smallFont"));
        themeDef.put("Large-Font", Language.getString("settings.laf.option.largeFont"));
        themeDef.put("Giant-Font", Language.getString("settings.laf.option.giantFont"));
        ComboStringSetting theme = new ComboStringSetting((Map<String, String>)themeDef);
        d.addStringSetting("lafTheme", theme);
        JButton lafPreviewButton = new JButton("Preview");
        lafPreviewButton.addActionListener(e -> {
            LaFChanger.changeLookAndFeel(LaF.LaFSettings.fromSettingsDialog(d, d.settings), this);
            d.lafPreviewed = true;
            d.pack();
        });
        final ColorSetting foregroundColor = new ColorSetting(0, "lafBackground", Language.getString("settings.general.foreground"), Language.getString("settings.general.foreground"), () -> new ColorChooser(d));
        final ColorSetting backgroundColor = new ColorSetting(1, "lafForeground", Language.getString("settings.general.background"), Language.getString("settings.general.background"), () -> new ColorChooser(d));
        ColorSettingListener colorChangeListener = new ColorSettingListener(){

            @Override
            public void colorUpdated() {
                foregroundColor.setBaseColor(backgroundColor.getSettingValue());
                backgroundColor.setBaseColor(foregroundColor.getSettingValue());
            }
        };
        foregroundColor.addListener(colorChangeListener);
        backgroundColor.addListener(colorChangeListener);
        d.addStringSetting("lafForeground", foregroundColor);
        d.addStringSetting("lafBackground", backgroundColor);
        ComboStringSetting lafScroll = d.addComboStringSetting("lafScroll", false, "default", "small", "smaller", "tiny");
        ComboLongSetting lafGradient = d.addComboLongSetting("lafGradient", 0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50);
        ComboLongSetting lafVariant = d.addComboLongSetting("lafVariant", 0, 1, 2, 3, 4);
        ComboStringSetting lafStyle = d.addComboStringSetting("lafStyle", false, "classic", "classicStrong", "regular", "regularStrong", "simple", "sleek", "minimal");
        SimpleBooleanSetting lafNativeWindow = d.addSimpleBooleanSetting("lafNativeWindow");
        LinkedHashMap<Long, String> fontScaleOptions = new LinkedHashMap<Long, String>();
        fontScaleOptions.put(80L, "0.8");
        fontScaleOptions.put(90L, "0.9");
        fontScaleOptions.put(100L, "Default");
        fontScaleOptions.put(110L, "1.1");
        fontScaleOptions.put(120L, "1.2");
        fontScaleOptions.put(130L, "1.3");
        fontScaleOptions.put(140L, "1.4");
        fontScaleOptions.put(150L, "1.5");
        ComboLongSetting fontScale = new ComboLongSetting((Map<Long, String>)fontScaleOptions);
        d.addLongSetting("lafFontScale", fontScale);
        JLabel info = new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.laf.info"));
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        this.addPanel(info, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1, 13);
        lafSettingsPanel.add((Component)new JLabel(Language.getString("settings.laf.lookandfeel")), gbc);
        gbc = SettingsDialog.makeGbc(1, 1, 1, 1, 17);
        lafSettingsPanel.add((Component)laf, gbc);
        gbc = SettingsDialog.makeGbc(0, 2, 4, 1);
        lafSettingsPanel.add((Component)lafInfo, gbc);
        JPanel generalOptions = new JPanel(new GridBagLayout());
        JPanel flatOptions = new JPanel(new GridBagLayout());
        JPanel hifiCustomOptions = new JPanel(new GridBagLayout());
        JPanel macOptions = new JPanel(new GridBagLayout());
        gbc = SettingsDialog.makeGbc(0, 3, 1, 1, 13);
        generalOptions.add((Component)new JLabel(Language.getString("settings.laf.font")), gbc);
        gbc = SettingsDialog.makeGbc(1, 3, 1, 1, 17);
        generalOptions.add((Component)theme, gbc);
        SettingsUtil.addLabeledComponent(generalOptions, "lafFontScale", 0, 1, 1, 17, fontScale);
        gbc = SettingsDialog.makeGbc(0, 8, 2, 1, 17);
        generalOptions.add((Component)lafNativeWindow, gbc);
        SettingsUtil.addLabeledComponent(generalOptions, "lafScroll", 0, 0, 1, 17, lafScroll);
        SettingsUtil.addSubsettings(laf, s -> !s.equals("default") && !s.equals("system") && !s.startsWith("flat"), theme, lafNativeWindow);
        generalOptions.add((Component)d.addSimpleBooleanSetting("lafErrorSound"), SettingsDialog.makeGbc(0, 9, 2, 1, 17));
        SimpleBooleanSetting styledWindow = d.addSimpleBooleanSetting("lafFlatStyledWindow");
        SettingsUtil.addStandardSetting(flatOptions, "lafFlatStyledWindow", 0, styledWindow);
        SimpleBooleanSetting embeddedMenu = d.addSimpleBooleanSetting("lafFlatEmbeddedMenu");
        SettingsUtil.addStandardSubSetting(flatOptions, "lafFlatEmbeddedMenu", 1, embeddedMenu);
        EditorStringSetting flatProperties = d.addEditorStringSetting("lafFlatProperties", 10, true, "Custom Flat Look&Feel properties:", true, "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-flatProperties.html", null));
        flatProperties.setLinkLabelListener(d.getLinkLabelListener());
        SettingsUtil.addStandardSetting(flatOptions, "lafFlatProperties", 3, flatProperties);
        FlatTabOptions selectedTabOptions = new FlatTabOptions("lafFlatTabs", d);
        flatOptions.add((Component)selectedTabOptions, SettingsDialog.makeGbc(0, 2, 3, 1, 17));
        SettingsUtil.addSubsettings(styledWindow, embeddedMenu);
        SettingsUtil.addSubsettings(laf, s -> s.startsWith("flat"), styledWindow);
        SettingsUtil.addStandardSetting(hifiCustomOptions, "lafStyle", 0, lafStyle);
        SettingsUtil.addStandardSetting(hifiCustomOptions, "lafVariant", 1, lafVariant);
        SettingsUtil.addStandardSetting(hifiCustomOptions, "lafGradient", 2, lafGradient);
        gbc = SettingsDialog.makeGbc(0, 10, 1, 1, 13);
        hifiCustomOptions.add((Component)new JLabel(Language.getString("settings.laf.colors")), gbc);
        gbc = SettingsDialog.makeGbc(1, 10, 3, 1);
        gbc.fill = 2;
        hifiCustomOptions.add((Component)foregroundColor, gbc);
        gbc = SettingsDialog.makeGbc(1, 11, 3, 1);
        gbc.fill = 2;
        hifiCustomOptions.add((Component)backgroundColor, gbc);
        SettingsUtil.addSubsettings(laf, s -> s.equals("hifiCustom"), foregroundColor, backgroundColor, lafGradient, lafStyle, lafVariant);
        SettingsUtil.addStandardSetting(macOptions, "macScreenMenuBar", 0, d.addSimpleBooleanSetting("macScreenMenuBar"));
        SettingsUtil.addStandardSetting(macOptions, "macSystemAppearance", 1, d.addSimpleBooleanSetting("macSystemAppearance"));
        JTabbedPane optionsTabs = new JTabbedPane();
        optionsTabs.addTab("General", SettingsUtil.topAlign(generalOptions, 20));
        optionsTabs.addTab("Flat", SettingsUtil.topAlign(flatOptions, 20));
        optionsTabs.addTab("HiFi Custom", SettingsUtil.topAlign(hifiCustomOptions, 20));
        optionsTabs.addTab("MacOS", SettingsUtil.topAlign(macOptions, 20));
        gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 17);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        optionsPanel.add((Component)optionsTabs, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        previewPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.laf.previewInfo")), gbc);
        gbc = SettingsDialog.makeGbc(0, 4, 1, 1);
        previewPanel.add((Component)lafPreviewButton, gbc);
    }

    private static void updateInfo(LinkLabel label, StringSetting setting) {
        String text = "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>";
        String selected = setting.getSettingValue();
        if (selected.equals("default")) {
            text = text + "The classic cross-platform Java look.";
        } else if (selected.equals("system")) {
            text = text + "This Look&Feel differs depending what OS you are using.";
        } else if (selected.startsWith("flat")) {
            text = text + "Minimalistic. Customize further below.";
        } else {
            text = text + "No window snapping (unless you enable using the native window, see [help-laf:native-window help]). ";
            if (selected.equals("hifiCustom")) {
                text = text + "Allows some basic customization here. ";
            }
            text = text + "More properties [help-laf:custom can be set] manually.";
        }
        label.setText(text);
    }

    private static class FlatTabOptions
    extends JPanel
    implements LongSetting {
        private final Map<Integer, JCheckBox> options = new HashMap<Integer, JCheckBox>();

        FlatTabOptions(String settingName, SettingsDialog settings) {
            settings.addLongSetting(settingName, this);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.makeOption(1, "selectedBackground"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
            this.add((Component)this.makeOption(2, "separators"), SettingsDialog.makeGbc(1, 1, 1, 1, 17));
            this.add((Component)this.makeOption(4, "separatorsFull"), SettingsDialog.makeGbc(1, 2, 1, 1, 17));
            this.update();
        }

        private JCheckBox makeOption(int option, String labelKey) {
            String text = Language.getString("settings.tabs.flat." + labelKey);
            String tip = Language.getString("settings.tabs.flat." + labelKey + ".tip", false);
            JCheckBox check = new JCheckBox(text);
            check.setToolTipText(SettingsUtil.addTooltipLinebreaks(tip));
            check.addItemListener(e -> this.update());
            this.options.put(option, check);
            return check;
        }

        private void update() {
        }

        @Override
        public Long getSettingValue() {
            long result = 0L;
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                result |= (long)entry.getKey().intValue();
            }
            return result;
        }

        @Override
        public Long getSettingValue(Long def) {
            return this.getSettingValue();
        }

        @Override
        public void setSettingValue(Long setting) {
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                entry.getValue().setSelected((setting & (long)entry.getKey().intValue()) != 0L);
            }
        }
    }
}

