/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.BackupManager;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.DialogComboSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.settings.FileManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MainSettings
extends SettingsPanel {
    public static TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();

    public MainSettings(SettingsDialog d) {
        JPanel startSettingsPanel = this.addTitledPanel(Language.getString("settings.section.startup"), 0);
        JPanel languagePanel = this.addTitledPanel(Language.getString("settings.section.language"), 1);
        JPanel dirPanel = this.addTitledPanel(Language.getString("settings.section.settings"), 2);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 2, 1, 17);
        startSettingsPanel.add((Component)d.addSimpleBooleanSetting("splash"), gbc);
        LinkedHashMap<Long, String> onStartDef = new LinkedHashMap<Long, String>();
        onStartDef.put(0L, Language.getString("settings.startup.option.doNothing"));
        onStartDef.put(1L, Language.getString("settings.startup.option.openConnect"));
        onStartDef.put(2L, Language.getString("settings.startup.option.connectJoinSpecified"));
        onStartDef.put(3L, Language.getString("settings.startup.option.connectJoinPrevious"));
        onStartDef.put(4L, Language.getString("settings.startup.option.connectJoinFavorites"));
        ComboLongSetting onStart = new ComboLongSetting((Map<Long, String>)onStartDef);
        d.addLongSetting("onStart", onStart);
        SettingsUtil.addLabeledComponent(startSettingsPanel, "settings.startup.onStart", 0, 1, 1, 13, onStart);
        JTextField channels = d.addSimpleStringSetting("autojoinChannel", 25, true);
        GuiUtil.installLengthLimitDocumentFilter(channels, 80000, false, new Object[0]);
        SettingsUtil.addLabeledComponent(startSettingsPanel, "settings.startup.channels", 0, 2, 1, 13, channels);
        SimpleBooleanSetting connectDialogIfMissing = d.addSimpleBooleanSetting("connectDialogIfMissing");
        onStart.addActionListener(e -> {
            boolean channelsEnabled = ((Long)onStart.getSettingValue()).equals(2L);
            channels.setEnabled(channelsEnabled);
            connectDialogIfMissing.setEnabled((Long)onStart.getSettingValue() > 1L);
        });
        SimpleBooleanSetting restoreLayout = d.addSimpleBooleanSetting("restoreLayout");
        gbc = SettingsDialog.makeGbc(0, 3, 2, 1, 17);
        startSettingsPanel.add((Component)restoreLayout, gbc);
        SimpleBooleanSetting restoreLayoutWhisper = d.addSimpleBooleanSetting("restoreLayoutWhisper");
        gbc = SettingsDialog.makeGbcSub(0, 4, 2, 1, 17);
        startSettingsPanel.add((Component)restoreLayoutWhisper, gbc);
        SettingsUtil.addSubsettings(restoreLayout, restoreLayoutWhisper);
        gbc = SettingsDialog.makeGbc(0, 5, 2, 1, 17);
        startSettingsPanel.add((Component)connectDialogIfMissing, gbc);
        SettingsUtil.addLabeledComponent(startSettingsPanel, "minimizeOnStart", 0, 6, 2, 13, d.addComboLongSetting("minimizeOnStart", 0, 1, 2));
        languagePanel.add((Component)new JLabel(Language.getString("settings.language.language")), SettingsDialog.makeGbc(0, 0, 1, 1, 13));
        ComboStringSetting languageSetting = d.addComboStringSetting("language", 0, false, MainSettings.getLanguageOptions());
        languagePanel.add((Component)languageSetting, SettingsDialog.makeGbc(1, 0, 1, 1, 17));
        languagePanel.add((Component)new LinkLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.language.info") + "<br /><br />If you would like to help with translations, check [url:https://chatty.github.io/localization.html the website].", d.getLinkLabelListener()), SettingsDialog.makeGbc(0, 1, 2, 1));
        DialogComboSetting localeSetting = new DialogComboSetting(d, () -> MainSettings.getLocaleOptions(), value -> {
            if (value.isEmpty()) {
                return "Default";
            }
            return Locale.forLanguageTag(value).getDisplayName();
        });
        d.addStringSetting("locale", localeSetting);
        SettingsUtil.addLabeledComponent(languagePanel, "locale", 0, 2, 1, 13, localeSetting, true);
        JLabel timezoneLabel = SettingsUtil.createLabel("timezone");
        languagePanel.add((Component)timezoneLabel, SettingsDialog.makeGbc(0, 3, 1, 1));
        DialogComboSetting timezoneSetting = new DialogComboSetting(d, () -> MainSettings.getTimezoneOptions(), value -> {
            TimeZone tz = DEFAULT_TIMEZONE;
            String def = " [" + Language.getString("status.default") + "]";
            if (!StringUtil.isNullOrEmpty(value)) {
                tz = TimeZone.getTimeZone(value);
                def = "";
            }
            return String.format("%s (%s)%s", tz.getID(), tz.getDisplayName(false, 0), def);
        });
        timezoneLabel.setLabelFor(timezoneSetting);
        d.addStringSetting("timezone", timezoneSetting);
        gbc = SettingsDialog.makeGbc(1, 3, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        languagePanel.add((Component)timezoneSetting, gbc);
        String dirInfo = Language.getString("settings.directory.default");
        if (Chatty.getCustomPathInfo(Chatty.PathType.SETTINGS) != null) {
            dirInfo = Language.getString("settings.directory.argument", Chatty.getCustomPathInfo(Chatty.PathType.SETTINGS));
        }
        JLabel dirLabel = new JLabel(Language.getString("settings.directory.info", dirInfo));
        dirPanel.add((Component)dirLabel, SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        JTextField dir = new JTextField(Chatty.getPath(Chatty.PathType.SETTINGS).toString(), 30);
        dirLabel.setLabelFor(dir);
        dir.setEditable(false);
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        dirPanel.add((Component)dir, gbc);
        JButton openDirButton = new JButton(Language.getString("settings.chooseFolder.button.open"));
        GuiUtil.smallButtonInsets(openDirButton);
        openDirButton.addActionListener(e -> MiscUtil.openFile(Chatty.getPath(Chatty.PathType.SETTINGS), (Component)this));
        dirPanel.add((Component)openDirButton, SettingsDialog.makeGbc(1, 1, 1, 1));
        if (Chatty.getInvalidCustomPath(Chatty.PathType.SETTINGS) != null) {
            dirPanel.add((Component)new JLabel(Language.getString("settings.directory.invalid")), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
            JTextField invalidDir = new JTextField(Chatty.getInvalidCustomPath(Chatty.PathType.SETTINGS), 30);
            invalidDir.setEditable(false);
            gbc = SettingsDialog.makeGbc(0, 3, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            dirPanel.add((Component)invalidDir, gbc);
        }
        JButton openBackupButton = new JButton(Language.getString("settings.backup.button.open"));
        openBackupButton.addActionListener(e -> {
            FileManager fm = d.settings.getFileManager();
            BackupManager mg = new BackupManager((Window)d, fm);
            mg.setModal(true);
            mg.pack();
            mg.setLocationRelativeTo(d);
            fm.setSavingPaused(true);
            mg.open();
            fm.setSavingPaused(false);
        });
        gbc = SettingsDialog.makeGbc(0, 4, 2, 1);
        dirPanel.add((Component)openBackupButton, gbc);
        dirPanel.add((Component)d.addSimpleBooleanSetting("initSettingsDialog"), SettingsDialog.makeGbc(0, 5, 2, 1, 17));
    }

    public static Map<String, String> getLanguageOptions() {
        LinkedHashMap<String, String> languageOptions = new LinkedHashMap<String, String>();
        languageOptions.put("", Language.getString("settings.language.option.defaultLanguage"));
        languageOptions.put("zh_TW", "Chinese (traditional)");
        languageOptions.put("cs", "Czech / \u010ce\u0161tina");
        languageOptions.put("nl", "Dutch / Nederlands");
        languageOptions.put("en_US", "English (US)");
        languageOptions.put("en_GB", "English (UK)");
        languageOptions.put("fi", "Finnish / Suomi");
        languageOptions.put("fr", "French / Fran\u00e7ais");
        languageOptions.put("de", "German / Deutsch");
        languageOptions.put("in", "Indonesian");
        languageOptions.put("it", "Italian / Italiano");
        languageOptions.put("ja", "Japanese / \u65e5\u672c\u8a9e");
        languageOptions.put("ko", "Korean / \ud55c\uad6d\uc5b4");
        languageOptions.put("pl", "Polish / Polski");
        languageOptions.put("pt_BR", "Portuguese (BR)");
        languageOptions.put("ru", "Russian / \u0420\u0443\u0441\u0441\u043a\u0438\u0439");
        languageOptions.put("es", "Spanish / Espa\u00f1ol");
        languageOptions.put("tr", "Turkish / T\u00fcrk");
        languageOptions.put("uk", "Ukrainian / \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430");
        return languageOptions;
    }

    public static Map<String, String> getLocaleOptions() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("", "Default");
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (Locale locale : Locale.getAvailableLocales()) {
            locales.add(locale);
        }
        Collections.sort(locales, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        for (Locale locale : locales) {
            if (locale.getDisplayName().trim().isEmpty()) continue;
            result.put(locale.toLanguageTag(), locale.getDisplayName());
        }
        return result;
    }

    private static Map<String, String> getTimezoneOptions() {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date now = new Date();
        ArrayList<TimeZone> timezones = new ArrayList<TimeZone>();
        for (String id : TimeZone.getAvailableIDs()) {
            TimeZone tz = TimeZone.getTimeZone(id);
            timezones.add(tz);
        }
        Collections.sort(timezones, new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone o1, TimeZone o2) {
                return o1.getOffset(System.currentTimeMillis()) - o2.getOffset(System.currentTimeMillis());
            }
        });
        options.put("", String.format("%s [%s]", MainSettings.formatTimezone(DEFAULT_TIMEZONE, sdf, now), Language.getString("status.default")));
        for (TimeZone tz : timezones) {
            options.put(tz.getID(), MainSettings.formatTimezone(tz, sdf, now));
        }
        return options;
    }

    private static String formatTimezone(TimeZone tz, SimpleDateFormat sdf, Date date) {
        sdf.setTimeZone(tz);
        return String.format("[%s] %s (%s)", sdf.format(date), tz.getID(), tz.getDisplayName(false, 0));
    }
}

