/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.Highlighter;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsUtil;
import chatty.lang.Language;
import chatty.util.commands.CommandSyntaxHighlighter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

public class MatchingPresets
extends LazyDialog {
    private final SettingsDialog d;
    private final ListSelector setting;

    public MatchingPresets(SettingsDialog d) {
        this.d = d;
        this.setting = d.addListSetting("matchingPresets", "Presets", 100, 250, false, true);
        this.setting.setChangeListener(value -> {
            HighlighterTester.testPresets = Highlighter.HighlightItem.makePresets(value);
        });
    }

    @Override
    public JDialog createDialog() {
        return new Dialog();
    }

    private class Dialog
    extends JDialog {
        private Dialog() {
            super(MatchingPresets.this.d);
            this.setTitle("Presets");
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            MatchingPresets.this.d;
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
            this.add((Component)new LinkLabel("<html><body style='width:340px;padding:4px;'>" + SettingsUtil.getInfo("info-matching_presets.html", null), MatchingPresets.this.d.getLinkLabelListener()), gbc);
            MatchingPresets.this.d;
            gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            MatchingPresets.this.setting.setDataFormatter(input -> input.trim());
            MatchingPresets.this.setting.setInfoLinkLabelListener(MatchingPresets.this.d.getLinkLabelListener());
            MatchingPresets.this.setting.setTester(CommandSettings.createCommandTester());
            MatchingPresets.this.setting.setSyntaxHighlighter(new CommandSyntaxHighlighter(){

                @Override
                public void update(String input) {
                    if (input.startsWith("_")) {
                        super.update(input);
                    } else {
                        super.update("");
                    }
                }
            });
            this.add((Component)MatchingPresets.this.setting, gbc);
            JButton closeButton = new JButton(Language.getString("dialog.button.close"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Dialog.this.setVisible(false);
                }
            });
            MatchingPresets.this.d;
            gbc = SettingsDialog.makeGbc(0, 5, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)closeButton, gbc);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
        }
    }
}

