/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.DeletedMessagesModeSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.Timestamp;
import chatty.util.api.StreamInfo;
import chatty.util.api.StreamInfoHistoryItem;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MessageSettings
extends SettingsPanel {
    public MessageSettings(SettingsDialog d) {
        JPanel timeoutSettingsPanel = this.addTitledPanel(Language.getString("settings.section.deletedMessages"), 0);
        JPanel otherSettingsPanel = this.addTitledPanel(Language.getString("settings.section.otherMessageSettings"), 1);
        DeletedMessagesModeSetting deletedMessagesModeSetting = new DeletedMessagesModeSetting(d);
        timeoutSettingsPanel.add((Component)deletedMessagesModeSetting, SettingsDialog.makeGbc(0, 0, 2, 1, 17));
        timeoutSettingsPanel.add((Component)d.addSimpleBooleanSetting("banDurationAppended"), SettingsDialog.makeGbcSub(0, 1, 1, 1, 17));
        timeoutSettingsPanel.add((Component)d.addSimpleBooleanSetting("banReasonAppended"), SettingsDialog.makeGbcSub(1, 1, 1, 1, 17));
        SimpleBooleanSetting timeoutMessages = d.addSimpleBooleanSetting("showBanMessages");
        timeoutSettingsPanel.add((Component)timeoutMessages, SettingsDialog.makeGbc(0, 3, 2, 1, 17));
        SimpleBooleanSetting banDuration = d.addSimpleBooleanSetting("banDurationMessage");
        timeoutSettingsPanel.add((Component)banDuration, SettingsDialog.makeGbcSub(0, 4, 1, 1, 17));
        SimpleBooleanSetting banReason = d.addSimpleBooleanSetting("banReasonMessage");
        timeoutSettingsPanel.add((Component)banReason, SettingsDialog.makeGbcSub(1, 4, 1, 1, 17));
        SimpleBooleanSetting timeoutsCombine = d.addSimpleBooleanSetting("combineBanMessages");
        timeoutSettingsPanel.add((Component)timeoutsCombine, SettingsDialog.makeGbcSub(0, 5, 1, 1, 17));
        timeoutSettingsPanel.add((Component)d.addSimpleBooleanSetting("clearChatOnChannelCleared"), SettingsDialog.makeGbc(0, 6, 2, 1, 17));
        SettingsUtil.addSubsettings(timeoutMessages, banDuration, banReason, timeoutsCombine);
        SettingsUtil.addLabeledComponent(otherSettingsPanel, "settings.otherMessageSettings.timestamp", 0, 0, 3, 17, MessageSettings.createTimestampPanel(d, "timestamp"));
        otherSettingsPanel.add((Component)d.addSimpleBooleanSetting("showModMessages"), SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        otherSettingsPanel.add((Component)d.addSimpleBooleanSetting("showJoinsParts"), SettingsDialog.makeGbc(2, 1, 2, 1, 17));
        JLabel combiningCharsLabel = new JLabel("Filter combining chars:");
        otherSettingsPanel.add((Component)combiningCharsLabel, SettingsDialog.makeGbc(0, 2, 1, 1));
        LinkedHashMap<Long, String> filterSetting = new LinkedHashMap<Long, String>();
        filterSetting.put(0L, "Off");
        filterSetting.put(1L, "Lenient");
        filterSetting.put(2L, "Strict");
        ComboLongSetting filterCombiningCharacters = new ComboLongSetting((Map<Long, String>)filterSetting);
        combiningCharsLabel.setLabelFor(filterCombiningCharacters);
        d.addLongSetting("filterCombiningCharacters", filterCombiningCharacters);
        otherSettingsPanel.add((Component)filterCombiningCharacters, SettingsDialog.makeGbc(1, 2, 1, 1));
        otherSettingsPanel.add((Component)d.addSimpleBooleanSetting("printStreamStatus"), SettingsDialog.makeGbc(0, 3, 4, 1, 17));
    }

    public static JPanel createTimestampPanel(SettingsDialog d, String setting) {
        LinkedHashMap<String, String> timestampOptions = new LinkedHashMap<String, String>();
        timestampOptions.put("off", "Off");
        timestampOptions.put("", "Empty (Space)");
        MessageSettings.addTimestampFormat(timestampOptions, "[HH:mm:ss]");
        MessageSettings.addTimestampFormat(timestampOptions, "[HH:mm]");
        MessageSettings.addTimestampFormat(timestampOptions, "HH:mm:ss");
        MessageSettings.addTimestampFormat(timestampOptions, "HH:mm");
        ComboStringSetting combo = new ComboStringSetting((Map<String, String>)timestampOptions);
        combo.setEditable(false);
        d.addStringSetting(setting, combo);
        JButton editTimestampButton = new JButton(Language.getString("dialog.button.customize"));
        GuiUtil.smallButtonInsets(editTimestampButton);
        GuiUtil.matchHeight(editTimestampButton, combo);
        editTimestampButton.addActionListener(e -> {
            String result;
            TimestampEditor editor = new TimestampEditor((Window)d, d.getLinkLabelListener());
            String preset = combo.getSettingValue();
            if (preset.equals("off") || preset.isEmpty()) {
                preset = "[HH:mm:ss]";
            }
            if ((result = editor.showDialog(preset)) != null) {
                combo.setSettingValue(result);
            }
        });
        editTimestampButton.getAccessibleContext().setAccessibleName(Language.getString("settings.otherMessageSettings.customizeTimestamp"));
        JPanel timestampPanel = new JPanel(new FlowLayout(0, 0, 0));
        timestampPanel.add(combo);
        timestampPanel.add(Box.createHorizontalStrut(5));
        timestampPanel.add(editTimestampButton);
        return timestampPanel;
    }

    public static void addTimestampFormat(Map<String, String> timestampOptions, String format) {
        int hour = DateTime.currentHour12Hour();
        String label = hour > 0 && hour < 10 ? DateTime.currentTime(format) : DateTime.format(System.currentTimeMillis() - 14400000L, new SimpleDateFormat(format));
        timestampOptions.put(format, label);
    }

    public static void main(String[] args) {
        TimestampEditor s = new TimestampEditor(null, new LinkLabelListener(){

            @Override
            public void linkClicked(String type, String ref) {
            }
        });
        s.showDialog("[yyyy-MM-dd HH:mm]");
        System.exit(0);
    }

    private static class TimestampEditor
    extends JDialog {
        private static final List<String> TIME_FORMATS = Arrays.asList("HH:mm:ss", "HH:mm", "hh:mm:ss a", "hh:mm a", "h:mm a", "hh:mm:ssa", "hh:mma", "h:mma", "");
        private static final List<String> DATE_FORMATS = Arrays.asList("yyyy-MM-dd", "MMM d", "d MMM", "dd.MM.", "");
        private static final List<String> UPTIME_FORMATS = Arrays.asList(Timestamp.UPTIME_NO_CAPTURE.toString(), "");
        private static final List<String> BEFORE = Arrays.asList("[", " [", " ");
        private static final List<String> AFTER = Arrays.asList("]", "] ", " ");
        private final JTextField value = new JTextField(10);
        private final JTextField preview = new JTextField(10);
        private final ComboStringSetting before;
        private final ComboStringSetting after;
        private final ComboStringSetting time;
        private final ComboStringSetting date;
        private final ComboStringSetting uptime;
        private final ComboLongSetting streamStatus;
        private final JButton saveButton = new JButton(Language.getString("dialog.button.save"));
        private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));
        private boolean fillInProgress;
        private boolean save;

        TimestampEditor(Window owner, LinkLabelListener linkLabelListener) {
            super(owner);
            this.setModal(true);
            this.setTitle(Language.getString("settings.otherMessageSettings.customizeTimestamp"));
            LinkedHashMap<String, String> timeFormatOptions = new LinkedHashMap<String, String>();
            timeFormatOptions.put("", "<none>");
            for (String string : TIME_FORMATS) {
                if (string.isEmpty()) continue;
                MessageSettings.addTimestampFormat(timeFormatOptions, string);
            }
            this.time = new ComboStringSetting((Map<String, String>)timeFormatOptions);
            LinkedHashMap<String, String> dateFormatOptions = new LinkedHashMap<String, String>();
            dateFormatOptions.put("", "<none>");
            for (String format : DATE_FORMATS) {
                if (format.isEmpty()) continue;
                MessageSettings.addTimestampFormat(dateFormatOptions, format);
            }
            this.date = new ComboStringSetting((Map<String, String>)dateFormatOptions);
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("", "<none>");
            linkedHashMap.put("'{|,uptime}'", "With space");
            linkedHashMap.put("'{|,uptime:t}'", "Without space");
            linkedHashMap.put("'{|,uptime:p}'", "With space (with Picnic)");
            linkedHashMap.put("'{|,uptime:tp}'", "Without space (with Picnic)");
            linkedHashMap.put("'{|,uptime:c}'", "Clock style");
            this.uptime = new ComboStringSetting((Map<String, String>)linkedHashMap);
            LinkedHashMap<String, String> beforeOptions = new LinkedHashMap<String, String>();
            beforeOptions.put("", "<none>");
            for (String string : BEFORE) {
                beforeOptions.put(string, string.replace(" ", "<space>"));
            }
            this.before = new ComboStringSetting((Map<String, String>)beforeOptions);
            LinkedHashMap<String, String> afterOptions = new LinkedHashMap<String, String>();
            afterOptions.put("", "<none>");
            for (String option : AFTER) {
                afterOptions.put(option, option.replace(" ", "<space>"));
            }
            this.after = new ComboStringSetting((Map<String, String>)afterOptions);
            LinkedHashMap<Long, String> linkedHashMap2 = new LinkedHashMap<Long, String>();
            linkedHashMap2.put(-1L, "Stream Offline");
            linkedHashMap2.put(TimeUnit.MINUTES.toMillis(8L), "Live 8 minutes");
            linkedHashMap2.put(TimeUnit.MINUTES.toMillis(50L), "Live 50 minutes");
            linkedHashMap2.put(TimeUnit.MINUTES.toMillis(62L), "Live 62 minutes");
            linkedHashMap2.put(TimeUnit.MINUTES.toMillis(70L), "Live 70 minutes");
            linkedHashMap2.put(TimeUnit.HOURS.toMillis(40L), "Live 40 hours");
            this.streamStatus = new ComboLongSetting((Map<Long, String>)linkedHashMap2);
            this.streamStatus.setSettingValue(TimeUnit.MINUTES.toMillis(70L));
            this.date.addActionListener(e -> this.formChanged());
            this.time.addActionListener(e -> this.formChanged());
            this.uptime.addActionListener(e -> this.formChanged());
            this.before.addActionListener(e -> this.formChanged());
            this.after.addActionListener(e -> this.formChanged());
            this.streamStatus.addActionListener(e -> this.updatePreview());
            this.saveButton.addActionListener(e -> {
                this.save = true;
                this.setVisible(false);
            });
            this.cancelButton.addActionListener(e -> this.setVisible(false));
            this.preview.setEditable(false);
            this.setLayout(new GridBagLayout());
            JPanel topPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.value.setFont(Font.decode("Monospaced"));
            topPanel.add((Component)this.value, gbc);
            gbc = GuiUtil.makeGbc(2, 0, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            topPanel.add((Component)this.preview, gbc);
            gbc = GuiUtil.makeGbc(0, 0, 4, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)topPanel, gbc);
            gbc = GuiUtil.makeGbc(4, 0, 1, 1);
            gbc.fill = 2;
            this.add((Component)this.streamStatus, gbc);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1, 10);
            gbc.insets = new Insets(5, 0, 0, 0);
            this.add((Component)new JLabel("Prefix"), gbc);
            ++gbc.gridx;
            this.add((Component)new JLabel("Date"), gbc);
            ++gbc.gridx;
            this.add((Component)new JLabel("Time"), gbc);
            ++gbc.gridx;
            this.add((Component)new JLabel("Stream Uptime"), gbc);
            ++gbc.gridx;
            this.add((Component)new JLabel("Suffix"), gbc);
            gbc = GuiUtil.makeGbc(0, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.before, gbc);
            gbc = GuiUtil.makeGbc(1, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.date, gbc);
            gbc = GuiUtil.makeGbc(2, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.time, gbc);
            gbc = GuiUtil.makeGbc(3, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.uptime, gbc);
            gbc = GuiUtil.makeGbc(4, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.after, gbc);
            this.add((Component)new LinkLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-timestamp.html", null), linkLabelListener), GuiUtil.makeGbc(0, 3, 5, 1, 10));
            gbc = GuiUtil.makeGbc(0, 4, 4, 1);
            gbc.fill = 2;
            this.add((Component)this.saveButton, gbc);
            gbc = GuiUtil.makeGbc(4, 4, 1, 1);
            gbc.fill = 2;
            this.add((Component)this.cancelButton, gbc);
            this.value.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.valueChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.valueChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.valueChanged();
                }
            });
            this.pack();
        }

        public String showDialog(String preset) {
            this.value.setText(preset);
            this.save = false;
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
            if (this.save) {
                return this.value.getText();
            }
            return null;
        }

        private void valueChanged() {
            this.fillFromValue();
            this.updatePreview();
        }

        private void formChanged() {
            if (!this.fillInProgress) {
                this.buildValue();
            }
        }

        private void updatePreview() {
            try {
                Timestamp format = new Timestamp(this.value.getText(), "");
                StreamInfo info = new StreamInfo("test", null);
                long uptimeDuration = (Long)this.streamStatus.getSettingValue();
                if (uptimeDuration > 0L) {
                    long testTime = System.currentTimeMillis() - 1L;
                    long startTime = testTime - uptimeDuration;
                    long startTimePicnic = startTime - 1800000L;
                    if (uptimeDuration < 600000L) {
                        startTimePicnic = startTime;
                    }
                    StreamInfoHistoryItem item = new StreamInfoHistoryItem(testTime, 0, null, null, StreamInfo.StreamType.LIVE, startTime, startTimePicnic);
                    LinkedHashMap<Long, StreamInfoHistoryItem> history = new LinkedHashMap<Long, StreamInfoHistoryItem>();
                    history.put(testTime, item);
                    info.setHistory(history);
                }
                this.preview.setText(format.make2(System.currentTimeMillis(), info));
            }
            catch (Exception ex) {
                this.preview.setText("Invalid format");
            }
        }

        private void fillFromValue() {
            this.fillInProgress = true;
            String v = this.value.getText();
            Matcher found = this.find(v);
            String foundDate = found.group(2);
            String foundTime = found.group(4);
            String foundUptime = found.group(5);
            String foundBefore = found.group(1);
            String foundAfter = found.group(6);
            this.time.setSettingValue(foundTime);
            this.date.setSettingValue(foundDate);
            this.uptime.setSettingValue(foundUptime);
            this.before.setSettingValue(foundBefore);
            this.after.setSettingValue(foundAfter);
            this.fillInProgress = false;
        }

        private void buildValue() {
            String m = "";
            if (!this.date.getSettingValue().isEmpty() && !this.time.getSettingValue().isEmpty()) {
                m = " ";
            }
            this.value.setText(this.before.getSettingValue() + this.date.getSettingValue() + m + this.time.getSettingValue() + this.uptime.getSettingValue() + this.after.getSettingValue());
        }

        private Matcher find(String haystack) {
            for (String f : this.sortFormats(DATE_FORMATS)) {
                for (String f2 : this.sortFormats(TIME_FORMATS)) {
                    for (String f3 : this.sortFormats(UPTIME_FORMATS)) {
                        Matcher m = Pattern.compile(String.format("(.*)(%s)( ?)(%s)(%s)(.*)", Pattern.quote(f), Pattern.quote(f2), f3)).matcher(haystack);
                        if (!m.matches()) continue;
                        return m;
                    }
                }
            }
            return null;
        }

        private List<String> sortFormats(List<String> formats) {
            ArrayList<String> sortedFormats = new ArrayList<String>(formats);
            Collections.sort(sortedFormats, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return -Integer.compare(o1.length(), o2.length());
                }
            });
            return sortedFormats;
        }
    }
}

