/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.RegexDocumentFilter;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.HotkeyTextField;
import chatty.gui.components.settings.LongSetting;
import chatty.gui.components.settings.MessageSettings;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;

public class ModerationSettings
extends SettingsPanel {
    public ModerationSettings(SettingsDialog d) {
        JPanel modInfoPanel = this.addTitledPanel(Language.getString("settings.section.modInfos"), 0);
        SimpleBooleanSetting showModActions = d.addSimpleBooleanSetting("showModActions");
        SimpleBooleanSetting showModActionsRestrict = d.addSimpleBooleanSetting("showModActionsRestrict");
        SettingsUtil.addSubsettings(showModActions, showModActionsRestrict);
        modInfoPanel.add((Component)showModActions, SettingsDialog.makeGbc(0, 0, 3, 1, 17));
        modInfoPanel.add((Component)showModActionsRestrict, SettingsDialog.makeGbcSub(0, 1, 3, 1, 17));
        modInfoPanel.add((Component)d.addSimpleBooleanSetting("showActionBy"), SettingsDialog.makeGbc(0, 4, 3, 1, 17));
        modInfoPanel.add((Component)d.addSimpleBooleanSetting("showAutoMod", "Show messages rejected by AutoMod", ""), SettingsDialog.makeGbc(0, 5, 3, 1, 17));
        modInfoPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>Approve/deny AutoMod messages in chat through their context menu (right-click) or the User Dialog (left-click) or <code>Extra - AutoMod</code>."), SettingsDialog.makeGbc(1, 6, 2, 1, 10));
        modInfoPanel.add((Component)d.addSimpleBooleanSetting("showLowTrustInfo"), SettingsDialog.makeGbc(0, 7, 3, 1, 17));
        modInfoPanel.add((Component)d.addSimpleBooleanSetting("showRestrictedMessages"), SettingsDialog.makeGbc(0, 8, 3, 1, 17));
        JPanel userInfo = this.addTitledPanel(Language.getString("settings.section.userDialog"), 1);
        JTabbedPane userInfoTabs = new JTabbedPane();
        JPanel userInfoGeneral = new JPanel(new GridBagLayout());
        JPanel userInfoMsg = new JPanel(new GridBagLayout());
        userInfoGeneral.add((Component)d.addSimpleBooleanSetting("closeUserDialogOnAction"), SettingsDialog.makeGbc(0, 0, 2, 1, 17));
        userInfoGeneral.add((Component)d.addSimpleBooleanSetting("openUserDialogByMouse"), SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        userInfoGeneral.add((Component)d.addSimpleBooleanSetting("reuseUserDialog"), SettingsDialog.makeGbc(0, 2, 2, 1, 17));
        HotkeyTextField banReasonsHotkey = new HotkeyTextField(12, null);
        d.addStringSetting("banReasonsHotkey", banReasonsHotkey);
        SettingsUtil.addLabeledComponent(userInfoGeneral, "banReasonsHotkey", 0, 6, 1, 13, banReasonsHotkey);
        userInfoGeneral.add((Component)SettingsUtil.createLabel("banReasonsInfo", true), SettingsDialog.makeGbc(0, 7, 2, 1));
        SettingsUtil.addLabeledComponent(userInfoMsg, "settings.otherMessageSettings.timestamp", 0, 3, 1, 13, MessageSettings.createTimestampPanel(d, "userDialogTimestamp"));
        SettingsUtil.addLabeledComponent(userInfoMsg, "settings.long.clearUserMessages.label", 0, 4, 1, 13, d.addComboLongSetting("clearUserMessages", -1, 3, 6, 12, 24));
        SettingsUtil.addLabeledComponent(userInfoMsg, "userDialogMessageLimit", 0, 5, 1, 13, d.addSimpleLongSetting("userDialogMessageLimit", 3, true));
        SettingsUtil.addLabeledComponent(userInfoMsg, "userMessagesHighlight", 0, 6, 2, 13, new HighlightOptions("userMessagesHighlight", d));
        userInfoTabs.addTab(Language.getString("settings.userInfo.tab.general"), userInfoGeneral);
        userInfoTabs.addTab(Language.getString("settings.userInfo.tab.userMessages"), userInfoMsg);
        userInfo.add((Component)userInfoTabs, SettingsDialog.makeGbcStretchHorizontal(0, 0, 1, 1));
        JPanel repeatMsgPanel = this.addTitledPanel(Language.getString("settings.section.repeatMsg"), 2);
        SimpleBooleanSetting repeatMsg = d.addSimpleBooleanSetting("repeatMsg");
        repeatMsgPanel.add((Component)repeatMsg, SettingsDialog.makeGbc(0, 0, 4, 1, 17));
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgMethod", 0, 1, 1, 13, d.addComboLongSetting("repeatMsgMethod", 1, 2));
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgSim", 2, 2, 1, 13, d.addSimpleLongSetting("repeatMsgSim", 4, true));
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgRep", 2, 3, 1, 13, d.addSimpleLongSetting("repeatMsgRep", 4, true));
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgTime", 0, 2, 1, 13, d.addSimpleLongSetting("repeatMsgTime", 4, true));
        JTextField ignoredChars = d.addSimpleStringSetting("repeatMsgIgnored", 4, true);
        ((AbstractDocument)ignoredChars.getDocument()).setDocumentFilter(TestSimilarity.IGNORED_CHARS_FILTER);
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgIgnored", 0, 3, 1, 13, ignoredChars);
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgLen", 0, 4, 1, 13, d.addSimpleLongSetting("repeatMsgLen", 4, true));
        EditorStringSetting editor = d.addEditorStringSetting("repeatMsgMatch", 10, true, "Restrict detection", false, "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-restriction-repeat.html", null));
        editor.setShowInfoByDefault(true);
        editor.setLinkLabelListener(d.getLinkLabelListener());
        SettingsUtil.addLabeledComponent(repeatMsgPanel, "repeatMsgMatch", 0, 5, 3, 13, editor, true);
        SettingsUtil.addSubsettings(repeatMsg, repeatMsgPanel.getComponents());
        JButton testSim = new JButton("Test Similarity");
        GuiUtil.smallButtonInsets(testSim);
        testSim.addActionListener(e -> new TestSimilarity((Window)d, ignoredChars.getText()).setVisible(true));
        repeatMsgPanel.add((Component)testSim, SettingsDialog.makeGbc(2, 1, 2, 1, 13));
        repeatMsgPanel.add((Component)new LinkLabel("Tip: Add <code>config:repeatedmsg</code> to e.g. [help:Highlight Highlight] list to match on detected repetition.", d.getSettingsHelpLinkLabelListener()), SettingsDialog.makeGbc(0, 6, 4, 1));
    }

    public static void main(String[] args) {
        new TestSimilarity(null, "?").setVisible(true);
    }

    private static class HighlightOptions
    extends JPanel
    implements LongSetting {
        private final Map<Integer, JCheckBox> options = new HashMap<Integer, JCheckBox>();

        HighlightOptions(String settingName, SettingsDialog settings) {
            settings.addLongSetting(settingName, this);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.makeOption(1, "currentMsg"), SettingsDialog.makeNoGapGbc(0, 1, 1, 1, 17));
            this.add((Component)this.makeOption(2, "repeatedMsg"), SettingsDialog.makeNoGapGbc(1, 1, 1, 1, 17));
            this.add((Component)this.makeOption(4, "modAction"), SettingsDialog.makeNoGapGbc(0, 2, 1, 1, 17));
            this.add((Component)this.makeOption(8, "autoMod"), SettingsDialog.makeNoGapGbc(1, 2, 1, 1, 17));
            this.add((Component)this.makeOption(16, "lowTrust"), SettingsDialog.makeNoGapGbc(0, 3, 2, 1, 17));
        }

        private JCheckBox makeOption(int option, String labelKey) {
            String text = Language.getString("settings.userMessagesHighlight." + labelKey);
            String tip = Language.getString("settings.userMessagesHighlight." + labelKey + ".tip", false);
            JCheckBox check = new JCheckBox(text);
            check.setToolTipText(SettingsUtil.addTooltipLinebreaks(tip));
            this.options.put(option, check);
            return check;
        }

        @Override
        public Long getSettingValue() {
            long result = 0L;
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                result |= (long)entry.getKey().intValue();
            }
            return result;
        }

        @Override
        public Long getSettingValue(Long def) {
            return this.getSettingValue();
        }

        @Override
        public void setSettingValue(Long setting) {
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                entry.getValue().setSelected((setting & (long)entry.getKey().intValue()) != 0L);
            }
        }
    }

    private static class TestSimilarity
    extends JDialog {
        public static DocumentFilter IGNORED_CHARS_FILTER = new RegexDocumentFilter("[^\u0000-\ud7ff\ue000-\uffff]", null);
        private static final String DEFAULT_EXAMPLE_A = "Have you already checked out Chatty's YouTube channel? Might have some useful video guides.";
        private static final String DEFAULT_EXAMPLE_B = "Chatty's YouTube channel might have some useful video guides. Have you checked it out yet?";
        private static final Map<String, String> EXAMPLES = new LinkedHashMap<String, String>();
        private final JTextArea m1;
        private final JTextArea m2;
        private final JLabel label;
        private final JTextField ignoredChars;

        public TestSimilarity(Window parent, String ignoredCharsValue) {
            super(parent);
            this.setTitle("Test Similarity");
            this.setLayout(new GridBagLayout());
            this.m1 = new JTextArea(4, 30);
            this.m2 = new JTextArea(4, 30);
            GuiUtil.resetFocusTraversalKeys(this.m1);
            GuiUtil.resetFocusTraversalKeys(this.m2);
            this.m1.setLineWrap(true);
            this.m1.setWrapStyleWord(true);
            this.m2.setLineWrap(true);
            this.m2.setWrapStyleWord(true);
            this.m1.setText(DEFAULT_EXAMPLE_A);
            this.m2.setText(DEFAULT_EXAMPLE_B);
            this.ignoredChars = new JTextField(10);
            this.ignoredChars.setText(ignoredCharsValue);
            ((AbstractDocument)this.ignoredChars.getDocument()).setDocumentFilter(IGNORED_CHARS_FILTER);
            DocumentListener listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }
            };
            this.m1.getDocument().addDocumentListener(listener);
            this.m2.getDocument().addDocumentListener(listener);
            this.ignoredChars.getDocument().addDocumentListener(listener);
            GridBagConstraints gbc = SettingsDialog.makeGbc(0, 1, 2, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)new JScrollPane(this.m1), gbc);
            gbc = SettingsDialog.makeGbc(0, 2, 2, 1);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)new JScrollPane(this.m2), gbc);
            JPanel ignorePanel = new JPanel(new FlowLayout(1, 10, 0));
            ignorePanel.add(new JLabel("Ignored characters:"));
            ignorePanel.add(this.ignoredChars);
            JButton ignoredCharsLoad = new JButton("Reset");
            ignoredCharsLoad.addActionListener(e -> this.ignoredChars.setText(ignoredCharsValue));
            JButton ignoredCharsClear = new JButton("Clear");
            ignoredCharsClear.addActionListener(e -> this.ignoredChars.setText(null));
            GuiUtil.smallButtonInsets(ignoredCharsLoad);
            GuiUtil.smallButtonInsets(ignoredCharsClear);
            ignorePanel.add(ignoredCharsLoad);
            ignorePanel.add(ignoredCharsClear);
            gbc = SettingsDialog.makeGbc(0, 0, 2, 1);
            this.add((Component)ignorePanel, gbc);
            this.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-similarity.html", null)), SettingsDialog.makeGbc(0, 5, 2, 1));
            this.label = new JLabel("Result");
            this.add((Component)this.label, SettingsDialog.makeGbc(0, 3, 2, 1));
            gbc = SettingsDialog.makeGbc(0, 4, 1, 1, 13);
            gbc.weightx = 1.0;
            this.add((Component)new JLabel("Examples:"), gbc);
            ComboStringSetting selectExample = new ComboStringSetting(EXAMPLES);
            gbc = SettingsDialog.makeGbc(1, 4, 1, 1, 17);
            gbc.weightx = 1.0;
            this.add((Component)selectExample, gbc);
            selectExample.addActionListener(e -> {
                String example = selectExample.getSettingValue();
                String[] split = example.split("\\|");
                this.m1.setText(split[0]);
                this.m2.setText(split[1]);
            });
            JButton closeButton = new JButton(Language.getString("dialog.button.close"));
            closeButton.addActionListener(e -> this.dispose());
            gbc = SettingsDialog.makeGbc(0, 6, 2, 1);
            gbc.fill = 2;
            this.add((Component)closeButton, gbc);
            this.pack();
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(parent);
            this.update();
        }

        private void update() {
            char[] ignoredCharacters = StringUtil.getCharsFromString(this.ignoredChars.getText());
            String a = StringUtil.prepareForSimilarityComparison(this.m1.getText(), ignoredCharacters);
            String b = StringUtil.prepareForSimilarityComparison(this.m2.getText(), ignoredCharacters);
            int similarity = Math.round(StringUtil.getSimilarity(a, b) * 100.0f);
            int similarity2 = Math.round(StringUtil.getSimilarity2(a, b) * 100.0f);
            int lengthSimilarity = Math.round(StringUtil.getLengthSimilarity(a, b) * 100.0f);
            if (lengthSimilarity < similarity) {
                this.label.setText(String.format("Strict: %s%%* - Lenient: %s%%", similarity, similarity2));
            } else {
                this.label.setText(String.format("Strict: %s%% - Lenient: %s%%", similarity, similarity2));
            }
        }

        static {
            EXAMPLES.put("Have you already checked out Chatty's YouTube channel? Might have some useful video guides.|Chatty's YouTube channel might have some useful video guides. Have you checked it out yet?", "Default");
            EXAMPLES.put("How is it going?|How is it going??????????", "Questionmarks");
            EXAMPLES.put("Kappa Kappa Kappa Kappa FrankerZ Kappa Kappa Kappa Kappa|Kappa Kappa Kappa FrankerZ", "Emote Repetition");
            EXAMPLES.put("aa|aaaaaaaa", "aaaaaaa");
            EXAMPLES.put("How much wood could a woodchuck chuck if a woodchuck could chuck wood?|How much wood indeed?", "Wood?");
        }
    }
}

