/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.colors.MsgColorItem;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.HighlightSettings;
import chatty.gui.components.settings.ItemColorEditor;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.StringEditor;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.StringUtil;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class MsgColorSettings
extends SettingsPanel {
    private static final String INFO_TEXT = "<html><body>Customize message colors based on Highlighting rules. [help:Message_Colors More information..]";
    private final ItemColorEditor<MsgColorItem> data;

    public MsgColorSettings(SettingsDialog d) {
        super(true);
        JPanel main = this.addTitledPanel(Language.getString("settings.section.msgColors"), 0, true);
        JPanel other = this.addTitledPanel(Language.getString("settings.section.msgColorsOther"), 1);
        SimpleBooleanSetting msgColorsEnabled = d.addSimpleBooleanSetting("msgColorsEnabled");
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        main.add((Component)msgColorsEnabled, gbc);
        this.data = new ItemColorEditor<MsgColorItem>(d, (id, foreground, foregroundEnabled, background, backgroundEnabled) -> new MsgColorItem(id, foreground, foregroundEnabled, background, backgroundEnabled), true, new LinkLabel(HighlightSettings.getMatchingHelp("msgColors"), d.getLinkLabelListener()));
        this.data.setTableEditorEditAllHandler(new TableEditor.TableEditorEditAllHandler<MsgColorItem>(){

            @Override
            public String toString(List<MsgColorItem> data) {
                StringBuilder b = new StringBuilder();
                for (MsgColorItem item : data) {
                    b.append(HtmlColors.getNamedColorString(item.getForeground()));
                    b.append(",");
                    b.append(item.getForegroundEnabled() ? "1" : "0");
                    b.append(",");
                    b.append(HtmlColors.getNamedColorString(item.getBackground()));
                    b.append(",");
                    b.append(item.getBackgroundEnabled() ? "1" : "0");
                    b.append(",");
                    b.append(item.getId());
                    b.append("\n");
                }
                return b.toString();
            }

            @Override
            public List<MsgColorItem> toData(String input) {
                ArrayList<MsgColorItem> result = new ArrayList<MsgColorItem>();
                for (String line : StringUtil.splitLines(input)) {
                    String[] split = line.split(",", 5);
                    if (split.length != 5 || split[4].isEmpty()) continue;
                    result.add(new MsgColorItem(split[4], HtmlColors.decode(split[0]), split[1].equals("1"), HtmlColors.decode(split[2]), split[3].equals("1")));
                }
                return result;
            }

            @Override
            public StringEditor getEditor() {
                return null;
            }

            @Override
            public String getEditorTitle() {
                return "Edit all entries";
            }

            @Override
            public String getEditorHelp() {
                return "Each line must contain:<br /><code>[foreground],[1/0],[background],[1/0],[match]</code><br />(<code>1</code> to enable foreground/background)";
            }
        });
        this.data.setPreferredSize(new Dimension(1, 150));
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        main.add(this.data, gbc);
        SettingsUtil.addSubsettings(msgColorsEnabled, this.data);
        LinkLabel info = new LinkLabel(INFO_TEXT, d.getSettingsHelpLinkLabelListener());
        main.add((Component)info, SettingsDialog.makeGbc(0, 2, 1, 1));
        other.add((Component)d.addSimpleBooleanSetting("msgColorsPrefer"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        other.add((Component)d.addSimpleBooleanSetting("msgColorsLinks"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        other.add((Component)d.addSimpleBooleanSetting("actionColored"), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
    }

    public void setData(List<MsgColorItem> data) {
        this.data.setData(data);
    }

    public List<MsgColorItem> getData() {
        return this.data.getData();
    }

    public void setDefaultForeground(Color color) {
        this.data.setDefaultForeground(color);
    }

    public void setDefaultBackground(Color color) {
        this.data.setDefaultBackground(color);
    }

    public void editItem(String item) {
        this.data.edit(item);
    }

    public void selectItem(String item) {
        this.data.setSelected(item);
    }
}

