/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.CompoundBooleanSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SimpleTableEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NameSettings
extends SettingsPanel {
    private final SimpleTableEditor customNamesEditor;

    public NameSettings(SettingsDialog d) {
        JPanel main = this.addTitledPanel("Names / Localized Names", 0);
        LinkedHashMap<Long, String> displayNamesModeSettings = new LinkedHashMap<Long, String>();
        displayNamesModeSettings.put(3L, "Username Only");
        displayNamesModeSettings.put(1L, "Capitalized Only");
        displayNamesModeSettings.put(2L, "Localized Only");
        displayNamesModeSettings.put(0L, "Localized+Username");
        ComboLongSetting displayNamesMode = new ComboLongSetting((Map<Long, String>)displayNamesModeSettings);
        d.addLongSetting("displayNamesMode", displayNamesMode);
        SettingsUtil.addLabeledComponent(main, "displayNamesMode", 0, 0, 2, 13, displayNamesMode);
        ComboLongSetting displayNamesModeUserlist = new ComboLongSetting((Map<Long, String>)displayNamesModeSettings);
        d.addLongSetting("displayNamesModeUserlist", displayNamesModeUserlist);
        SettingsUtil.addLabeledComponent(main, "displayNamesModeUserlist", 0, 1, 2, 13, displayNamesModeUserlist);
        main.add((Component)new JLabel("<html><body style=\"width:300px\">Note: Localized/Capitalized names in the Userlist are only available if that user said something in chat."), SettingsDialog.makeGbc(0, 2, 3, 1));
        main.add((Component)d.addSimpleBooleanSetting("capitalizedNames", "Capitalize First Letter if no display name available", "Requires a restart of Chatty to have any effect."), SettingsDialog.makeGbc(0, 3, 3, 1, 17));
        JPanel other = this.addTitledPanel("Other", 1);
        SimpleBooleanSetting mentions = d.makeSimpleBooleanSetting("mentions");
        mentions.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SimpleBooleanSetting mentionsBold = d.makeSimpleBooleanSetting("mentionsBold");
        SimpleBooleanSetting mentionsUnderline = d.makeSimpleBooleanSetting("mentionsUnderline");
        SimpleBooleanSetting mentionsColored = d.makeSimpleBooleanSetting("mentionsColored");
        other.add((Component)mentions, SettingsDialog.makeGbc(0, 0, 1, 1, 13));
        other.add((Component)mentionsBold, SettingsDialog.makeGbc(1, 0, 1, 1, 17));
        other.add((Component)mentionsUnderline, SettingsDialog.makeGbc(2, 0, 1, 1, 17));
        other.add((Component)mentionsColored, SettingsDialog.makeGbc(3, 0, 1, 1, 17));
        d.addLongSetting("mentions", new CompoundBooleanSetting(mentions, mentionsBold, mentionsUnderline, mentionsColored));
        SettingsUtil.addSubsettings(mentions, mentionsBold, mentionsUnderline, mentionsColored);
        SimpleBooleanSetting mentionsInfo = d.makeSimpleBooleanSetting("mentionsInfo");
        mentionsInfo.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        SimpleBooleanSetting mentionsBoldInfo = d.makeSimpleBooleanSetting("mentionsBold");
        SimpleBooleanSetting mentionsUnderlineInfo = d.makeSimpleBooleanSetting("mentionsUnderline");
        SimpleBooleanSetting mentionsColoredInfo = d.makeSimpleBooleanSetting("mentionsColored");
        other.add((Component)mentionsInfo, SettingsDialog.makeGbc(0, 1, 1, 1, 13));
        other.add((Component)mentionsBoldInfo, SettingsDialog.makeGbc(1, 1, 1, 1, 17));
        other.add((Component)mentionsUnderlineInfo, SettingsDialog.makeGbc(2, 1, 1, 1, 17));
        other.add((Component)mentionsColoredInfo, SettingsDialog.makeGbc(3, 1, 1, 1, 17));
        d.addLongSetting("mentionsInfo", new CompoundBooleanSetting(mentionsInfo, mentionsBoldInfo, mentionsUnderlineInfo, mentionsColoredInfo));
        SettingsUtil.addSubsettings(mentionsInfo, mentionsBoldInfo, mentionsUnderlineInfo, mentionsColoredInfo);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 2, 1, 1, 13);
        gbc.insets = new Insets(5, 5, 5, 6);
        JLabel markHoveredUserLabel = SettingsUtil.createLabel("markHoveredUser");
        ComboLongSetting markHoveredUser = d.addComboLongSetting("markHoveredUser", 0, 1, 2, 3, 4);
        markHoveredUserLabel.setLabelFor(markHoveredUser);
        other.add((Component)markHoveredUserLabel, gbc);
        other.add((Component)markHoveredUser, SettingsDialog.makeGbc(1, 2, 3, 1, 17));
        gbc = SettingsDialog.makeGbc(0, 3, 1, 1, 13);
        gbc.insets = new Insets(5, 5, 5, 6);
        JLabel mentionMessagesLabel = SettingsUtil.createLabel("mentionMessages");
        ComboLongSetting mentionMessages = d.addComboLongSetting("mentionMessages", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        mentionMessagesLabel.setLabelFor(mentionMessages);
        other.add((Component)mentionMessagesLabel, gbc);
        other.add((Component)mentionMessages, SettingsDialog.makeGbc(1, 3, 3, 1, 17));
        JPanel custom = this.addTitledPanel("Custom Names", 2, true);
        this.customNamesEditor = d.addStringMapSetting("customNames", 270, 200, "Twitch Username", "Custom Name");
        this.customNamesEditor.setKeyFilter("[^\\w]");
        gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        custom.add((Component)this.customNamesEditor, gbc);
        gbc = SettingsDialog.makeGbc(1, 0, 1, 1);
        gbc.anchor = 11;
        custom.add((Component)new JLabel("<html><body style='width:100px'>Define custom names for individual users which are displayed in the chat and userlist.<br /><br />You can also open these settings through the User ContextMenu (right-click on name in chat, <code>Miscellaneous -> Set name</code>)."), gbc);
    }

    public void editCustomName(String item) {
        this.customNamesEditor.edit(item);
    }
}

