/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.NamedColor;
import chatty.util.colors.HtmlColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.colorchooser.AbstractColorChooserPanel;

class NamedColorsPanel
extends AbstractColorChooserPanel {
    private final List<NamedColor> namedColors = HtmlColors.getNamedColors();
    private final ColorArea colorArea = new ColorArea();
    private NamedColor selectedColor = null;

    NamedColorsPanel() {
    }

    @Override
    public void updateChooser() {
        this.selectedColor = null;
        Color color = this.getColorFromModel();
        for (NamedColor namedColor : this.namedColors) {
            if (!namedColor.equals(color)) continue;
            this.selectedColor = namedColor;
            break;
        }
        this.colorArea.repaint();
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.colorArea, "Center");
        this.setPreferredSize(new Dimension(600, 300));
        this.setMinimumSize(new Dimension(600, 300));
        this.setMaximumSize(new Dimension(600, 500));
    }

    @Override
    public String getDisplayName() {
        return "Named Colors";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    private class ColorArea
    extends JComponent
    implements MouseMotionListener,
    MouseListener {
        private static final int PADDING = 2;
        private static final int MARGIN = 10;
        private static final int MARGIN_TOP = 40;
        private static final int COLS = 10;
        private static final int ROWS = 15;
        private final Font FONT = new Font("Arial", 0, 12);
        private final Font TITLE_FONT = new Font("Arial", 1, 15);
        private final Color BACKGROUND_COLOR = new Color(250, 250, 250);
        private final List<ColorToDraw> colorsToDraw = new ArrayList<ColorToDraw>();
        private ColorToDraw hoveredColor;
        private int height;
        private int width;
        private int elementWidth;
        private int elementHeight;
        private int compHeight;
        private int compWidth;

        ColorArea() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.makePositions();
        }

        private void makePositions() {
            if (this.compHeight == this.getHeight() && this.compWidth == this.getWidth()) {
                return;
            }
            this.compHeight = this.getHeight();
            this.compWidth = this.getWidth();
            int cols = 10;
            int rows = 15;
            this.colorsToDraw.clear();
            int padding = 2;
            int margin = 10;
            int marginTop = 40;
            int x = margin;
            int y = marginTop;
            this.width = this.getWidth() - (cols - 1) * padding - margin * 2;
            this.height = this.getHeight() - (rows - 1) * padding - margin - marginTop;
            this.elementWidth = this.width / cols;
            this.elementHeight = this.height / rows;
            Iterator it = NamedColorsPanel.this.namedColors.iterator();
            for (int col = 0; col < cols; ++col) {
                for (int row = 0; row < rows; ++row) {
                    if (it.hasNext()) {
                        NamedColor c = (NamedColor)it.next();
                        Rectangle r = new Rectangle(x, y, this.elementWidth, this.elementHeight);
                        this.colorsToDraw.add(new ColorToDraw(c, r));
                    }
                    y += this.elementHeight + padding;
                }
                x += this.elementWidth + padding;
                y = marginTop;
            }
        }

        private void drawColor(Graphics g, ColorToDraw color) {
            Rectangle r = color.r;
            NamedColor c = color.color;
            int x = r.x;
            int y = r.y;
            int w = r.width;
            int h = r.height;
            g.setColor(c);
            g.fillRect(x, y, w, h);
            g.setColor(Color.WHITE);
            g.drawRect(x, y, w, h);
            g.setColor(Color.DARK_GRAY);
            if (c.equals(NamedColorsPanel.this.selectedColor)) {
                g.drawRect(x, y, w, h);
                g.drawRect(x - 1, y - 1, w + 2, h + 2);
            }
        }

        private void drawHoveredColor(Graphics g) {
            if (this.hoveredColor == null) {
                return;
            }
            Rectangle r = this.hoveredColor.r;
            int x = r.x;
            int y = r.y;
            int h = r.height;
            String text = this.hoveredColor.color.getName() + " (" + this.hoveredColor.color.getRgbString() + ")";
            FontMetrics fontMetrics = g.getFontMetrics(this.FONT);
            g.setFont(this.FONT);
            int textWidth = fontMetrics.stringWidth(text);
            int textHeight = fontMetrics.getHeight();
            if (x + textWidth > this.width) {
                x -= x + textWidth - this.width;
            }
            g.setColor(Color.BLACK);
            g.fillRect(x - 5, y - h - 8, textWidth + 10, textHeight + 8);
            g.setColor(Color.WHITE);
            g.fillRect(x - 4, y - h - 7, textWidth + 8, textHeight + 6);
            g.setColor(Color.BLACK);
            g.drawString(text, x, y - h + textHeight - 7);
        }

        private void drawTitle(Graphics g) {
            FontMetrics fontMetrics = g.getFontMetrics(this.TITLE_FONT);
            g.setFont(this.TITLE_FONT);
            g.setColor(Color.BLACK);
            String text = "Click Color to select (X11 colors)";
            int textWidth = fontMetrics.stringWidth(text);
            int y = 10 + fontMetrics.getHeight();
            int x = this.getWidth() / 2 - textWidth / 2;
            g.drawString(text, x, y);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.makePositions();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.BACKGROUND_COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawTitle(g);
            for (ColorToDraw c : this.colorsToDraw) {
                this.drawColor(g, c);
            }
            this.drawHoveredColor(g);
        }

        private ColorToDraw getColorFromPoint(Point p) {
            for (ColorToDraw color : this.colorsToDraw) {
                if (!color.r.contains(p)) continue;
                return color;
            }
            return null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.hoveredColor = null;
            ColorToDraw c = this.getColorFromPoint(e.getPoint());
            if (c != null) {
                this.hoveredColor = c;
            }
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ColorToDraw c = this.getColorFromPoint(e.getPoint());
            if (c != null) {
                NamedColorsPanel.this.getColorSelectionModel().setSelectedColor(c.color);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static class ColorToDraw {
        public final NamedColor color;
        public final Rectangle r;

        ColorToDraw(NamedColor color, Rectangle r) {
            this.color = color;
            this.r = r;
        }
    }
}

