/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.ColorSettingListener;
import chatty.gui.components.settings.ColorTemplates;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.DurationSetting;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.GenericComboSetting;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.NotificationSettings;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleStringSetting;
import chatty.gui.components.settings.SliderLongSetting;
import chatty.gui.components.settings.TableEditor;
import chatty.gui.notifications.Notification;
import chatty.gui.notifications.NotificationWindow;
import chatty.lang.Language;
import chatty.util.Sound;
import chatty.util.StringUtil;
import chatty.util.colors.HtmlColors;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

class NotificationEditor
extends TableEditor<Notification> {
    private static final Map<Notification.Type, String> typeNames = new LinkedHashMap<Notification.Type, String>();
    private static final Map<Notification.State, String> status;
    private MyItemEditor editor;
    private LinkLabelListener linkLabelListener;
    private Path soundPath;
    private String[] soundFiles;

    public NotificationEditor(JDialog owner, Settings settings) {
        super(0, false);
        this.setModel(new MyTableModel());
        this.setItemEditor(() -> {
            if (this.editor == null) {
                this.editor = new MyItemEditor(owner, settings);
                this.setLinkLabelListener(this.linkLabelListener);
                this.setSoundFiles(this.soundPath, this.soundFiles);
            }
            return this.editor;
        });
        this.setRendererForColumn(0, new MyRenderer());
        this.setRendererForColumn(1, new MyRenderer());
        this.setRendererForColumn(2, new MyRenderer());
        this.setRendererForColumn(3, new MyRenderer());
        this.setRendererForColumn(4, new MyRenderer());
    }

    public void setSoundFiles(Path path, String[] fileNames) {
        if (this.editor != null) {
            this.editor.setSoundFiles(path, fileNames);
        } else {
            this.soundPath = path;
            this.soundFiles = fileNames;
        }
    }

    public void setLinkLabelListener(LinkLabelListener listener) {
        if (this.editor != null) {
            this.editor.setLinkLabelListener(listener);
        } else {
            this.linkLabelListener = listener;
        }
    }

    public void setSelected(long id) {
        for (Notification n : this.getData()) {
            if (n.id != id) continue;
            super.selectItem(n);
        }
    }

    private static String formatCooldown(int input) {
        return input == 0 || input % 60 != 0 ? input + "s" : input / 60 + "m";
    }

    static {
        for (Notification.Type type : Notification.Type.values()) {
            typeNames.put(type, type.label);
        }
        status = new LinkedHashMap<Notification.State, String>();
        for (Enum enum_ : Notification.State.values()) {
            status.put((Notification.State)enum_, ((Notification.State)enum_).label);
        }
    }

    private static class MyTableModel
    extends ListTableModel<Notification> {
        public MyTableModel() {
            super(new String[]{NotificationSettings.l("column.event"), NotificationSettings.l("column.notification"), NotificationSettings.l("column.sound"), NotificationSettings.l("column.message"), NotificationSettings.l("column.tts")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Notification p = (Notification)this.get(rowIndex);
            return p;
        }

        public Class getColumnClass(int columnIndex) {
            return Notification.class;
        }
    }

    private static class MyRenderer
    extends JLabel
    implements TableCellRenderer {
        private final int ROW_HEIGHT = this.getFontMetrics(this.getFont()).getHeight() * 2;
        private boolean rowHeightSet;

        public MyRenderer() {
            this.setFont(this.getFont().deriveFont(0));
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("error");
                return this;
            }
            Notification n = (Notification)value;
            if (column == 0) {
                this.setForeground(n.foregroundColor);
                this.setBackground(n.backgroundColor);
            } else if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            String text = "";
            switch (column) {
                case 0: {
                    String channel = n.hasChannels() ? " (" + n.serializeChannels() + ")" : "";
                    String matcher = n.hasMatcher() ? "&nbsp;" + n.getMatcherString() : "";
                    text = String.format("%s%s\n%s", n.type.label, channel, matcher);
                    break;
                }
                case 1: {
                    text = String.format("%s", n.getDesktopState());
                    break;
                }
                case 2: {
                    String cooldown = "";
                    if (n.soundCooldown > 0 || n.soundInactiveCooldown > 0) {
                        cooldown = String.format("[%s/%s]", NotificationEditor.formatCooldown(n.soundCooldown), NotificationEditor.formatCooldown(n.soundInactiveCooldown));
                    }
                    text = String.format("%s\n%s %s", n.getSoundState(), cooldown, n.soundFile == null || n.soundState == Notification.State.OFF ? "" : n.soundFile);
                    break;
                }
                case 3: {
                    text = String.format("%s%s\n%s", n.messageOverrideDefault ? "[!] " : "", n.getMessageState(), n.messageState == Notification.State.OFF ? "" : n.messageTarget);
                    break;
                }
                case 4: {
                    text = String.format("%s\n%s", n.ttsState.label, n.ttsFormat == null || n.ttsState == Notification.State.OFF ? "" : n.ttsFormat.getRaw());
                }
            }
            if (text.startsWith("Off")) {
                this.setForeground(Color.GRAY);
            }
            this.setText("<html><body style='overflow:hidden;width:1000;padding:1px'>" + text.replace("\n", "<br />"));
            if (!this.rowHeightSet) {
                table.setRowHeight(this.ROW_HEIGHT);
                this.rowHeightSet = true;
            }
            return this;
        }
    }

    private static class MyItemEditor
    implements TableEditor.ItemEditor<Notification> {
        private static final String MATCHER_HELP = "<html><body width='300px'>The Matcher allows you to match on the text of the notification. You can use the same format as for the [help-settings:Highlight Highlights] list, although some prefixes may have no effect.<br /><br />";
        private static final String TTS_FORMAT_HELP = "<html><body width='300px'>Format for the spoken message. Possible parameters: $(title), $(message), $(stream), where available $(nick)<br /><br />";
        private static final int VOLUME_MIN = 0;
        private static final int VOLUME_MAX = 100;
        private final JDialog dialog;
        private final JTabbedPane tabs = new JTabbedPane();
        private final JButton okButton = new JButton("Save");
        private final JButton cancelButton = new JButton("Cancel");
        private final JPanel options;
        private final Map<String, JCheckBox> optionsAssoc;
        private final GenericComboSetting<Notification.Type> type;
        private final GenericComboSetting<Notification.State> desktopState;
        private final GenericComboSetting<Notification.State> soundState;
        private final GenericComboSetting<Notification.State> messageState;
        private final GenericComboSetting<Notification.State> ttsState;
        private final SimpleStringSetting channels;
        private final EditorStringSetting matcher;
        private final ColorTemplates colorTemplates;
        private final ColorSetting foregroundColor;
        private final ColorSetting backgroundColor;
        private final JButton testColors;
        private final DurationSetting soundCooldown;
        private final DurationSetting soundInactiveCooldown;
        private final ComboStringSetting soundFile;
        private final SliderLongSetting volumeSlider;
        private final JButton playSound;
        private final SimpleStringSetting messageTarget;
        private final JCheckBox messageUseColor;
        private final JCheckBox messageOverrideDefault;
        private final EditorStringSetting ttsFormat;
        private JLabel description;
        private Notification current;
        private Path soundsPath;
        private boolean save;
        private NotificationWindow testNotification;

        public MyItemEditor(Window owner, final Settings settings) {
            this.dialog = new JDialog(owner);
            this.dialog.setLayout(new GridBagLayout());
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.type = new GenericComboSetting(typeNames);
            this.type.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.updateSubTypes();
                }
            });
            this.desktopState = new GenericComboSetting(status);
            this.soundState = new GenericComboSetting(status);
            this.messageState = new GenericComboSetting(status);
            this.ttsState = new GenericComboSetting(status);
            this.desktopState.addItemListener(e -> {
                this.tabs.setTitleAt(0, MyItemEditor.columnLabel("notification", this.desktopState.getSettingValue() != Notification.State.OFF));
                this.updateDesktopSettings();
            });
            this.soundState.addItemListener(e -> {
                this.tabs.setTitleAt(1, MyItemEditor.columnLabel("sound", this.soundState.getSettingValue() != Notification.State.OFF));
                this.updateSoundSettings();
            });
            this.messageState.addItemListener(e -> {
                this.tabs.setTitleAt(2, MyItemEditor.columnLabel("message", this.messageState.getSettingValue() != Notification.State.OFF));
                this.updateMessageSettings();
            });
            this.ttsState.addItemListener(e -> {
                this.tabs.setTitleAt(3, MyItemEditor.columnLabel("tts", this.ttsState.getSettingValue() != Notification.State.OFF));
                this.updateTTSSettings();
            });
            JPanel desktop = new JPanel(new GridBagLayout());
            JPanel sound = new JPanel(new GridBagLayout());
            JPanel message = new JPanel(new GridBagLayout());
            JPanel tts = new JPanel(new GridBagLayout());
            JPanel optionsPanel = new JPanel(new GridBagLayout());
            this.options = new JPanel();
            this.options.setLayout(new BoxLayout(this.options, 3));
            this.optionsAssoc = new HashMap<String, JCheckBox>();
            this.channels = new SimpleStringSetting(20, true, DataFormatter.TRIM);
            this.matcher = new EditorStringSetting(this.dialog, "Match Notification Text", 20, () -> {
                HighlighterTester matcherEditor = new HighlighterTester((Window)this.dialog, false, "notification");
                matcherEditor.setAllowEmpty(true);
                return matcherEditor;
            });
            SettingsUtil.addLabeledComponent(optionsPanel, "settings.notifications.channel", 0, 2, 1, 13, this.channels);
            SettingsUtil.addLabeledComponent(optionsPanel, "settings.notifications.textMatch", 0, 3, 1, 13, this.matcher);
            optionsPanel.add((Component)this.options, GuiUtil.makeGbc(0, 4, 2, 1, 17));
            this.foregroundColor = new ColorSetting(0, null, Language.getString("settings.general.foreground"), Language.getString("settings.general.foreground"), () -> new ColorChooser(this.dialog));
            this.backgroundColor = new ColorSetting(1, null, Language.getString("settings.general.background"), Language.getString("settings.general.background"), () -> new ColorChooser(this.dialog));
            ColorSettingListener colorChangeListener = new ColorSettingListener(){

                @Override
                public void colorUpdated() {
                    foregroundColor.setBaseColor(backgroundColor.getSettingValue());
                    backgroundColor.setBaseColor(foregroundColor.getSettingValue());
                    this.updateTestNotification();
                }
            };
            this.foregroundColor.addListener(colorChangeListener);
            this.backgroundColor.addListener(colorChangeListener);
            this.colorTemplates = new ColorTemplates(settings, "nColorPresets", new ColorSetting[]{this.foregroundColor, this.backgroundColor});
            this.colorTemplates.addPreset("Classic", new String[]{"Black", "#FFFFF0"});
            this.colorTemplates.addPreset("Highlight", new String[]{"Black", "#FFFF79"});
            this.colorTemplates.addPreset("Black", new String[]{"White", "#333333"});
            this.colorTemplates.addPreset("Violet", new String[]{"White", "BlueViolet"});
            this.colorTemplates.init();
            this.testColors = new JButton("Test Colors");
            this.testColors.addActionListener(e -> this.testNotification());
            this.soundFile = new ComboStringSetting(new String[0]);
            this.volumeSlider = new SliderLongSetting(0, 0, 100, 0);
            this.volumeSlider.setMajorTickSpacing(10);
            this.volumeSlider.setMinorTickSpacing(5);
            this.volumeSlider.setPaintTicks(true);
            this.soundCooldown = new DurationSetting(3, true);
            this.soundInactiveCooldown = new DurationSetting(3, true);
            this.messageTarget = new SimpleStringSetting(20, true, DataFormatter.TRIM);
            this.messageUseColor = new JCheckBox(Language.getString("settings.notifications.messageUseColor"));
            this.messageOverrideDefault = new JCheckBox(Language.getString("settings.notifications.messageOverrideDefault"));
            Editor.Tester tester = new Editor.Tester(){

                @Override
                public String test(Window parent, Component component, int x, int y, String value) {
                    CustomCommand command = CustomCommand.parse(value);
                    if (command.hasError()) {
                        CommandSettings.showCommandInfoPopup(component, command);
                    } else {
                        Parameters params = Parameters.create("An example chat message");
                        params.putObject("user", new User("testUser", Room.createRegular("#testChannel")));
                        params.putObject("settings", settings);
                        params.put("chan", "testchannel");
                        params.put("stream", "testchannel");
                        params.put("title", "[Message] testUser in #testchannel");
                        params.put("message", "An example chat message");
                        Parameters params2 = Parameters.create("An example chat message");
                        params2.putObject("user", null);
                        params2.putObject("settings", settings);
                        params2.put("chan", "testchannel");
                        params2.put("stream", "testchannel");
                        params2.put("title", "[Info] #testchannel");
                        params2.put("message", "An example info message");
                        GuiUtil.showNonModalMessage(parent, "Example", String.format("Triggered by chat message:<br />%s<br /><br />Triggered by info message:<br />%s", Helper.htmlspecialchars_encode(command.replace(params)), Helper.htmlspecialchars_encode(command.replace(params2))), 1, true);
                    }
                    return null;
                }
            };
            this.ttsFormat = new EditorStringSetting(this.dialog, "Text to Speech Message Format", 20, true, false, TTS_FORMAT_HELP, tester);
            SettingsUtil.addLabeledComponent(optionsPanel, "settings.notifications.event", 0, 0, 2, 13, this.type);
            this.description = new JLabel();
            GridBagConstraints gbc = GuiUtil.makeGbc(1, 1, 2, 1, 17);
            optionsPanel.add((Component)this.description, gbc);
            JLabel desktopStateLabel = new JLabel("Status:");
            desktopStateLabel.setLabelFor(this.desktopState);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1, 13);
            desktop.add((Component)desktopStateLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 2, 1, 10);
            desktop.add(this.desktopState, gbc);
            gbc = GuiUtil.makeGbc(0, 2, 3, 1, 10);
            desktop.add((Component)this.colorTemplates, gbc);
            gbc = GuiUtil.makeGbc(0, 3, 3, 1, 10);
            gbc.insets = new Insets(5, 5, 0, 5);
            desktop.add((Component)this.foregroundColor, gbc);
            gbc = GuiUtil.makeGbc(0, 4, 3, 1, 10);
            desktop.add((Component)this.backgroundColor, gbc);
            gbc = GuiUtil.makeGbc(1, 5, 2, 1, 13);
            desktop.add((Component)this.testColors, gbc);
            JLabel soundStateLabel = new JLabel("Status:");
            soundStateLabel.setLabelFor(this.soundState);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1);
            sound.add((Component)soundStateLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 3, 1);
            gbc.anchor = 17;
            sound.add(this.soundState, gbc);
            SettingsUtil.addLabeledComponent(sound, "settings.notifications.soundFile", 0, 2, 3, 13, this.soundFile);
            SettingsUtil.addLabeledComponent(sound, "settings.notifications.soundVolume", 0, 3, 3, 13, this.volumeSlider);
            SettingsUtil.addLabeledComponent(sound, "settings.notifications.soundCooldown", 0, 4, 1, 13, this.soundCooldown);
            SettingsUtil.addLabeledComponent(sound, "settings.notifications.soundPassiveCooldown", 2, 4, 1, 13, this.soundInactiveCooldown);
            this.playSound = new JButton("Test Sound");
            this.playSound.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String file = soundFile.getSettingValue();
                        if (file != null && !file.isEmpty()) {
                            long volume = volumeSlider.getSettingValue();
                            Sound.play(soundsPath.resolve(file), (float)volume, "test", -1);
                        }
                    }
                    catch (Exception ex) {
                        GuiUtil.showNonModalMessage(dialog, "Error Playing Sound", ex.toString(), 0);
                    }
                }
            });
            gbc = GuiUtil.makeGbc(2, 5, 2, 1);
            sound.add((Component)this.playSound, gbc);
            JLabel messageStateLabel = new JLabel("Status:");
            messageStateLabel.setLabelFor(this.messageState);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1);
            message.add((Component)messageStateLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 3, 1);
            gbc.anchor = 17;
            message.add(this.messageState, gbc);
            SettingsUtil.addLabeledComponent(message, "settings.notifications.messageTarget", 0, 2, 1, 13, this.messageTarget);
            gbc = GuiUtil.makeGbc(0, 3, 4, 1);
            gbc.anchor = 17;
            message.add((Component)this.messageUseColor, gbc);
            gbc = GuiUtil.makeGbc(0, 4, 4, 1);
            gbc.anchor = 17;
            message.add((Component)this.messageOverrideDefault, gbc);
            JLabel ttsStateLabel = new JLabel("Status:");
            ttsStateLabel.setLabelFor(this.ttsState);
            gbc = GuiUtil.makeGbc(0, 0, 1, 1);
            tts.add((Component)ttsStateLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 0, 3, 1);
            gbc.anchor = 17;
            tts.add(this.ttsState, gbc);
            SettingsUtil.addLabeledComponent(tts, "ttsNotificationFormat", 0, 1, 1, 17, this.ttsFormat);
            gbc = GuiUtil.makeGbc(0, 2, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)this.tabs, gbc);
            gbc = GuiUtil.makeGbc(0, 0, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)optionsPanel, gbc);
            gbc = GuiUtil.makeGbc(1, 6, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.7;
            this.dialog.add((Component)this.okButton, gbc);
            gbc = GuiUtil.makeGbc(2, 6, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.3;
            this.dialog.add((Component)this.cancelButton, gbc);
            this.tabs.addTab(MyItemEditor.columnLabel("notification", true), GuiUtil.northWrap(desktop));
            this.tabs.addTab(MyItemEditor.columnLabel("sound", true), GuiUtil.northWrap(sound));
            this.tabs.addTab(MyItemEditor.columnLabel("message", true), GuiUtil.northWrap(message));
            this.tabs.addTab(MyItemEditor.columnLabel("tts", true), GuiUtil.northWrap(tts));
            ActionListener buttonAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == okButton) {
                        save = true;
                    }
                    if (e.getSource() == okButton || e.getSource() == cancelButton) {
                        dialog.setVisible(false);
                    }
                }
            };
            this.okButton.addActionListener(buttonAction);
            this.cancelButton.addActionListener(buttonAction);
            this.dialog.pack();
        }

        private static String columnLabel(String type, boolean on) {
            if (on) {
                return Language.getString("settings.notifications.column." + type);
            }
            return String.format("%s (%s)", Language.getString("settings.notifications.column." + type), Language.getString("settings.notifications.column.off"));
        }

        private void updateSize() {
            this.dialog.pack();
        }

        private void updateSubTypes() {
            this.updateHelp();
            Notification.Type t = this.type.getSettingValue();
            this.options.removeAll();
            this.optionsAssoc.clear();
            for (Notification.TypeOption option : t.options) {
                String label = Language.getString("notification.typeOption." + option.id);
                String tip = Language.getString("notification.typeOption." + option.id + ".tip", false);
                JCheckBox checkbox = new JCheckBox(label);
                if (tip != null) {
                    checkbox.setToolTipText(SettingsUtil.addTooltipLinebreaks(tip));
                }
                checkbox.setName(option.id);
                if (this.current != null) {
                    checkbox.setSelected(this.current.options.contains(option.id));
                }
                this.options.add(checkbox);
                this.optionsAssoc.put(option.id, checkbox);
            }
            this.options.setVisible(!t.options.isEmpty());
            this.updateSize();
        }

        private void updateHelp() {
            String eventId = StringUtil.toLowerCase(this.type.getSettingValue().name());
            String eventDescription = Language.getString("notification.type." + eventId + ".tip", false);
            if (eventDescription != null) {
                this.description.setVisible(true);
                this.description.setText("<html><body style='width:" + this.matcher.getPreferredSize().width + "'>" + eventDescription);
                this.type.setToolTipText(eventDescription);
            } else {
                this.description.setVisible(false);
                this.type.setToolTipText(null);
            }
            this.matcher.setInfo("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-notification-match.html", this.type.getSettingValue().name()));
        }

        private List<String> getSubTypes() {
            ArrayList<String> result = new ArrayList<String>();
            for (String option : this.optionsAssoc.keySet()) {
                JCheckBox cb = this.optionsAssoc.get(option);
                if (!cb.isSelected()) continue;
                result.add(option);
            }
            return result;
        }

        private void updateDesktopSettings() {
            boolean enabled = this.desktopState.getSettingValue() != Notification.State.OFF;
            this.testColors.setEnabled(enabled);
        }

        private void updateSoundSettings() {
            boolean enabled = this.soundState.getSettingValue() != Notification.State.OFF;
            this.soundFile.setEnabled(enabled);
            this.soundCooldown.setEnabled(enabled);
            this.soundInactiveCooldown.setEnabled(enabled);
            this.volumeSlider.setEnabled(enabled);
            this.playSound.setEnabled(enabled);
        }

        private void updateMessageSettings() {
            boolean enabled = this.messageState.getSettingValue() != Notification.State.OFF;
            this.messageTarget.setEnabled(enabled);
            this.messageUseColor.setEnabled(enabled);
        }

        private void updateTTSSettings() {
            boolean enabled = this.ttsState.getSettingValue() != Notification.State.OFF;
            this.ttsFormat.setEnabled(enabled);
        }

        @Override
        public Notification showEditor(Notification preset, Component c, boolean edit, int column) {
            if (edit) {
                this.dialog.setTitle("Edit notification/sound");
            } else {
                this.dialog.setTitle("Add notification/sound");
            }
            if (preset != null) {
                this.current = preset;
                this.type.setSettingValue(preset.type);
                this.channels.setSettingValue(preset.serializeChannels());
                this.matcher.setSettingValue(preset.matcher);
                this.desktopState.setSettingValue(preset.desktopState);
                this.foregroundColor.setSettingValue(HtmlColors.getColorString(preset.foregroundColor));
                this.backgroundColor.setSettingValue(HtmlColors.getColorString(preset.backgroundColor));
                this.soundState.setSettingValue(preset.soundState);
                this.soundFile.setSettingValue(preset.soundFile);
                this.soundCooldown.setSettingValue(Long.valueOf(preset.soundCooldown));
                this.soundInactiveCooldown.setSettingValue(Long.valueOf(preset.soundInactiveCooldown));
                this.volumeSlider.setSettingValue(preset.soundVolume);
                this.messageState.setSettingValue(preset.messageState);
                this.messageTarget.setSettingValue(preset.messageTarget);
                this.messageUseColor.setSelected(preset.messageUseColor);
                this.messageOverrideDefault.setSelected(preset.messageOverrideDefault);
                this.ttsState.setSettingValue(preset.ttsState);
                this.ttsFormat.setSettingValue(preset.ttsFormat != null ? preset.ttsFormat.getRaw() : "");
                this.updateSubTypes();
            } else {
                this.current = null;
                this.type.setSelectedIndex(0);
                this.channels.setSettingValue("");
                this.matcher.setSettingValue(null);
                this.desktopState.setSettingValue(Notification.State.ALWAYS);
                this.foregroundColor.setSettingValue("black");
                this.backgroundColor.setSettingValue(HtmlColors.getColorString(new Color(255, 255, 240)));
                this.soundState.setSettingValue(Notification.State.OFF);
                this.soundFile.setSelectedIndex(0);
                this.volumeSlider.setSettingValue(20L);
                this.soundCooldown.setSettingValue(0L);
                this.soundInactiveCooldown.setSettingValue(0L);
                this.messageState.setSettingValue(Notification.State.OFF);
                this.messageTarget.setSettingValue(null);
                this.messageUseColor.setSelected(false);
                this.messageOverrideDefault.setSelected(false);
                this.ttsState.setSettingValue(Notification.State.OFF);
                this.ttsFormat.setSettingValue("$(title) $(message)");
                this.updateSubTypes();
                this.create();
            }
            this.tabs.setSelectedIndex(Math.max(column - 1, 0));
            this.colorTemplates.selectDefault();
            this.save = false;
            this.dialog.setLocationRelativeTo(c);
            this.dialog.setVisible(true);
            this.clearTestNotification();
            if (this.save) {
                return this.create();
            }
            return null;
        }

        private Notification create() {
            Notification.Type type = this.type.getSettingValue();
            Color foreground = HtmlColors.decode(this.foregroundColor.getSettingValue());
            Color background = HtmlColors.decode(this.backgroundColor.getSettingValue());
            Notification.Builder b = new Notification.Builder(type);
            b.setDesktopEnabled(this.desktopState.getSettingValue());
            b.setSoundEnabled(this.soundState.getSettingValue());
            b.setMessageEnabled(this.messageState.getSettingValue());
            b.setTTSEnabled(this.ttsState.getSettingValue());
            b.setForeground(foreground);
            b.setBackground(background);
            b.setSoundFile(this.soundFile.getSettingValue());
            b.setVolume(this.volumeSlider.getSettingValue());
            b.setSoundCooldown(this.soundCooldown.getSettingValue(0L).intValue());
            b.setSoundInactiveCooldown(this.soundInactiveCooldown.getSettingValue(0L).intValue());
            b.setChannels(this.channels.getSettingValue());
            b.setMatcher(this.matcher.getSettingValue());
            b.setOptions(this.getSubTypes());
            b.setMessageTarget(this.messageTarget.getSettingValue());
            b.setMessageUseColor(this.messageUseColor.isSelected());
            b.setMessageOverrideDefault(this.messageOverrideDefault.isSelected());
            b.setTTSFormat(this.ttsFormat.getSettingValue());
            this.current = new Notification(b);
            return this.current;
        }

        public void setSoundFiles(Path path, String[] names) {
            this.soundFile.removeAllItems();
            this.soundFile.add((String)null, "<None>");
            for (String name : names) {
                this.soundFile.add(name);
            }
            this.soundsPath = path;
        }

        private void testNotification() {
            NotificationWindow w = new NotificationWindow("[Test] " + this.type.getSettingValue().label + " Colors", "Nice color you got there, would be a shame if it was to be used for a notification.", this.foregroundColor.getSettingValueAsColor(), this.backgroundColor.getSettingValueAsColor(), null);
            w.setLocation(this.dialog.getLocation());
            w.setTimeout(30000);
            w.show();
            if (this.testNotification != null) {
                NotificationWindow toClose = this.testNotification;
                SwingUtilities.invokeLater(() -> toClose.close());
            }
            this.testNotification = w;
        }

        private void clearTestNotification() {
            if (this.testNotification != null) {
                this.testNotification.close();
                this.testNotification = null;
            }
        }

        private void updateTestNotification() {
            if (this.testNotification != null && this.testNotification.isVisible()) {
                this.testNotification();
            }
        }

        public void setLinkLabelListener(LinkLabelListener listener) {
            this.matcher.setLinkLabelListener(listener);
        }
    }
}

