/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.DialogComboSetting;
import chatty.gui.components.settings.DurationSetting;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.NotificationEditor;
import chatty.gui.components.settings.PathSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SliderLongSetting;
import chatty.gui.notifications.Notification;
import chatty.lang.Language;
import chatty.util.Debugging;
import chatty.util.Sound;
import chatty.util.StringUtil;
import chatty.util.commands.CustomCommand;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class NotificationSettings
extends SettingsPanel {
    public static final long NOTIFICATION_TYPE_OFF = -1L;
    public static final long NOTIFICATION_TYPE_CUSTOM = 0L;
    public static final long NOTIFICATION_TYPE_TRAY = 1L;
    public static final long NOTIFICATION_TYPE_COMMAND = 2L;
    private final ComboLongSetting nType;
    private final ComboLongSetting nScreen;
    private final ComboLongSetting nPosition;
    private final DurationSetting nDisplayTime;
    private final DurationSetting nMaxDisplayTime;
    private final JCheckBox userActivity;
    private final EditorStringSetting nCommand;
    private final PathSetting soundsPath;
    private final ComboStringSetting soundFiles;
    private final JLabel filesResult = new JLabel();
    private final NotificationEditor editor;

    public NotificationSettings(final SettingsDialog d, Settings settings) {
        super(true);
        this.editor = new NotificationEditor(d, settings);
        this.editor.setLinkLabelListener(d.getSettingsHelpLinkLabelListener());
        JPanel notificationSettings = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 4, 1, 17);
        gbc.insets = new Insets(10, 5, 4, 5);
        LinkedHashMap<Long, String> nTypeOptions = new LinkedHashMap<Long, String>();
        nTypeOptions.put(-1L, "Off");
        nTypeOptions.put(0L, "Chatty Notifications");
        nTypeOptions.put(1L, "Tray Notifications (OS dependant)");
        nTypeOptions.put(2L, "Run OS Command");
        this.nType = new ComboLongSetting((Map<Long, String>)nTypeOptions);
        this.nType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NotificationSettings.this.updateSettingsState();
            }
        });
        d.addLongSetting("nType", this.nType);
        notificationSettings.add((Component)this.nType, gbc);
        notificationSettings.add((Component)new JLabel("Position:"), SettingsDialog.makeGbc(0, 1, 1, 1, 13));
        LinkedHashMap<Long, String> nPositionOptions = new LinkedHashMap<Long, String>();
        nPositionOptions.put(0L, "Top-Left");
        nPositionOptions.put(1L, "Top-Right");
        nPositionOptions.put(2L, "Bottom-Left");
        nPositionOptions.put(3L, "Bottom-Right");
        this.nPosition = new ComboLongSetting((Map<Long, String>)nPositionOptions);
        d.addLongSetting("nPosition", this.nPosition);
        gbc = SettingsDialog.makeGbc(1, 1, 1, 1, 17);
        notificationSettings.add((Component)this.nPosition, gbc);
        notificationSettings.add((Component)new JLabel("Screen:"), SettingsDialog.makeGbc(0, 2, 1, 1, 13));
        LinkedHashMap<Long, String> nScreenOptions = new LinkedHashMap<Long, String>();
        nScreenOptions.put(-1L, "Auto");
        nScreenOptions.put(0L, "1");
        nScreenOptions.put(1L, "2");
        nScreenOptions.put(2L, "3");
        nScreenOptions.put(3L, "4");
        this.nScreen = new ComboLongSetting((Map<Long, String>)nScreenOptions);
        d.addLongSetting("nScreen", this.nScreen);
        notificationSettings.add((Component)this.nScreen, SettingsDialog.makeGbc(1, 2, 1, 1, 17));
        notificationSettings.add((Component)new JLabel("Display Time:"), SettingsDialog.makeGbc(2, 1, 1, 1, 13));
        this.nDisplayTime = new DurationSetting(3, true);
        d.addLongSetting("nDisplayTime", this.nDisplayTime);
        notificationSettings.add((Component)this.nDisplayTime, SettingsDialog.makeGbc(3, 1, 1, 1, 17));
        this.userActivity = d.addSimpleBooleanSetting("nActivity", "No User Activity:", "Display longer unless the mouse was recently moved");
        notificationSettings.add((Component)this.userActivity, SettingsDialog.makeGbc(2, 2, 1, 1, 13));
        this.nMaxDisplayTime = new DurationSetting(3, true);
        d.addLongSetting("nMaxDisplayTime", this.nMaxDisplayTime);
        notificationSettings.add((Component)this.nMaxDisplayTime, SettingsDialog.makeGbc(3, 2, 1, 1, 17));
        notificationSettings.add((Component)d.addSimpleBooleanSetting("nKeepOpenOnHover"), SettingsDialog.makeGbc(2, 3, 2, 1, 17));
        notificationSettings.add((Component)new JLabel("Command:"), SettingsDialog.makeGbc(0, 4, 1, 1, 13));
        this.nCommand = d.addEditorStringSetting("nCommand", 20, true, "Edit system command (recommended for advanced users only, read help)", false, "<html><body style='width: 400px;'><p>Enter a command/program with parameters, which will be executed as a new process on your system (so please be careful with this, especially considering the <code>$(message)</code> comes directly from Twitch Chat, so the program you call must be able to handle that safely).</p><p>You can use the following replacements: <code>$(title), $(message), $(chan)</code></p><p><em>Tip:</em> Add quotes around replacements, as they may contain spaces. Use <code>\\\"</code> to escape quotes, to include them as their actual character. Quotes in the replacements are escaped automatically.</p><p>For example to run 'notify-send' to show a native notification on Linux: <code>notify-send \"$(title)\" \"$(message)\"</code></p><p>To view the output of executed commands (for example to debug if it doesn't work as expected) you can open &lt;Extra - Debug window&gt;.</p><p>Use the \"Test\" button to execute the current command with some example data.</p>", new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                String result = GuiUtil.showCommandNotification(value, "Example Title", "Example \"message\" for this test notification", "#example_channel");
                JOptionPane.showMessageDialog(component, result);
                return null;
            }
        });
        notificationSettings.add((Component)this.nCommand, SettingsDialog.makeGbc(1, 4, 3, 1, 17));
        JPanel soundSettings = new JPanel(new GridBagLayout());
        gbc = SettingsDialog.makeGbc(0, 0, 3, 1, 17);
        SimpleBooleanSetting soundsEnabled = d.addSimpleBooleanSetting("sounds", "Enable sounds", "Use this to enable/disable all sounds.");
        soundSettings.add((Component)soundsEnabled, gbc);
        gbc = SettingsDialog.makeGbc(0, 1, 3, 1, 17);
        gbc.insets = new Insets(8, 10, 2, 6);
        soundSettings.add((Component)new JLabel("Chatty looks for sound files (.wav) in this folder:"), gbc);
        gbc = SettingsDialog.makeGbc(0, 2, 3, 1);
        gbc.insets = new Insets(3, 10, 3, 8);
        PathSetting path = new PathSetting(d, Chatty.getDefaultPath(Chatty.PathType.SOUND).toString());
        d.addStringSetting("soundsPath", path);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        soundSettings.add((Component)path, gbc);
        this.soundsPath = path;
        path.setPathChangeListener(p -> this.scanFiles(false));
        gbc = SettingsDialog.makeGbc(1, 3, 1, 1, 13);
        JButton rescanButton = new JButton("Rescan folder");
        GuiUtil.smallButtonInsets(rescanButton);
        rescanButton.addActionListener(e -> this.scanFiles(true));
        rescanButton.setActionCommand("scanFolder");
        soundSettings.add((Component)rescanButton, gbc);
        gbc = SettingsDialog.makeGbc(0, 3, 1, 1, 13);
        gbc.weightx = 1.0;
        soundSettings.add((Component)this.filesResult, gbc);
        JPanel devicePanel = new JPanel();
        devicePanel.add(new JLabel("Output Device: "));
        DialogComboSetting device = new DialogComboSetting(d, () -> {
            HashMap<String, String> devicePresets = new HashMap<String, String>();
            devicePresets.put("", "<default>");
            for (String dev : Sound.getDeviceNames()) {
                devicePresets.put(dev, dev);
            }
            return devicePresets;
        }, value -> {
            if (value.isEmpty()) {
                return "<default>";
            }
            return value;
        });
        device.addSettingChangeListener(s -> Sound.setDeviceName(s.getSettingValue()));
        d.addStringSetting("soundDevice", device);
        devicePanel.add(device);
        gbc = SettingsDialog.makeGbc(0, 4, 2, 1);
        soundSettings.add((Component)devicePanel, gbc);
        JPanel soundTestPanel = new JPanel(new GridBagLayout());
        soundTestPanel.setBorder(BorderFactory.createTitledBorder("Test sounds / Output Device"));
        final SliderLongSetting volumeSlider = new SliderLongSetting(0, 0, 100, 0);
        volumeSlider.setMajorTickSpacing(10);
        volumeSlider.setMinorTickSpacing(5);
        volumeSlider.setPaintTicks(true);
        volumeSlider.setSettingValue(50L);
        this.soundFiles = new ComboStringSetting(new String[0]);
        JButton playSound = new JButton("Play");
        playSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String file = NotificationSettings.this.soundFiles.getSettingValue();
                    if (file != null && !file.isEmpty()) {
                        long volume = volumeSlider.getSettingValue();
                        Sound.play(NotificationSettings.this.soundsPath.getCurrentPath().resolve(file), (float)volume, "test", -1);
                    }
                }
                catch (Exception ex) {
                    GuiUtil.showNonModalMessage(d, "Error Playing Sound", ex.toString(), 0);
                }
            }
        });
        soundTestPanel.add((Component)new JLabel("File:"), SettingsDialog.makeGbc(0, 0, 1, 1, 13));
        soundTestPanel.add((Component)this.soundFiles, SettingsDialog.makeGbc(1, 0, 1, 1, 17));
        soundTestPanel.add((Component)new JLabel("Volume:"), SettingsDialog.makeGbc(0, 1, 1, 1, 13));
        soundTestPanel.add((Component)playSound, SettingsDialog.makeGbc(2, 0, 1, 1, 17));
        soundTestPanel.add((Component)volumeSlider, SettingsDialog.makeGbc(1, 1, 2, 1, 17));
        gbc = SettingsDialog.makeGbc(0, 10, 3, 1);
        gbc.insets = new Insets(20, 20, 5, 20);
        gbc.fill = 2;
        soundSettings.add((Component)soundTestPanel, gbc);
        JPanel soundCommandPanel = new JPanel(new GridBagLayout());
        soundCommandPanel.setBorder(BorderFactory.createTitledBorder("Sound OS Command (replaces \"Output Device\")"));
        SimpleBooleanSetting soundCommandEnabled = d.addSimpleBooleanSetting("soundCommandEnabled");
        soundCommandPanel.add((Component)soundCommandEnabled, SettingsDialog.makeGbc(0, 0, 1, 1));
        EditorStringSetting soundCommand = d.addEditorStringSetting("soundCommand", 20, true, "Edit system command (recommended for advanced users only, read help)", false, "<html><body style='width: 400px;'><p>Enter a command/program with parameters, which will be executed as a new process on your system.</p><p>You can use the following replacements: <code>$(file)</code> (absolute path), <code>$(volume)</code> (0-100)</p><p><em>Tip:</em> Add quotes around replacements, as they may contain spaces. Use <code>\\\"</code> to escape quotes, to include them as their actual character. Quotes in the replacements are escaped automatically.</p><p><em>Tip:</em> Make sure the program you run actually exits after the sound has finished playing.</p><p>For example using VLC Player: <code>\"C:\\\\Program Files\\\\VideoLAN\\\\VLC\\\\vlc.exe\" -Idummy --play-and-exit --gain=$calc($(volume)/100) \"$(file)\"</code></p><p>To view the output of executed commands (for example to debug if it doesn't work as expected) you can open &lt;Extra - Debug window&gt;.</p><p>The \"Test\" button will run the current command with the sound file and volume selected in the \"Test sounds\" section.</p>", new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                String result = "No sound played, no file found";
                String file = NotificationSettings.this.soundFiles.getSettingValue();
                if (file != null && !file.isEmpty()) {
                    CustomCommand command = CustomCommand.parse(value);
                    long volume = volumeSlider.getSettingValue();
                    result = Sound.get().runCommand(command, NotificationSettings.this.soundsPath.getCurrentPath().resolve(file), volume);
                }
                JOptionPane.showMessageDialog(component, result);
                return null;
            }
        });
        soundCommandPanel.add((Component)soundCommand, SettingsDialog.makeGbcSub(0, 1, 1, 1, 17));
        Runnable updateSoundCommand = () -> Sound.setCommand(soundCommandEnabled.isSelected(), soundCommand.getSettingValue());
        soundCommandEnabled.addItemListener(e -> updateSoundCommand.run());
        soundCommand.setChangeListener(e -> updateSoundCommand.run());
        SettingsUtil.addSubsettings(soundCommandEnabled, soundCommand);
        gbc = SettingsDialog.makeGbc(0, 11, 3, 1);
        gbc.insets = new Insets(20, 20, 5, 20);
        gbc.fill = 2;
        soundSettings.add((Component)soundCommandPanel, gbc);
        soundSettings.add((Component)new JLabel("<html><body width='300px'>Wav files that probably work are uncompressed PCM, 8-48kHz, 8/16bit (e.g. exported in Audacity as WAV Signed 16-bit PCM). If the file plays silent (but the default ones work), try making the sound longer (for example add some silence)."), SettingsDialog.makeGbc(0, 6, 2, 1));
        JPanel notificationsPanel = this.addTitledPanel(Language.getString("settings.page.notifications"), 0, true);
        JTabbedPane tabs = new JTabbedPane();
        gbc = GuiUtil.makeGbc(0, 0, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        notificationsPanel.add((Component)tabs, gbc);
        this.editor.setPreferredSize(new Dimension(10, 260));
        tabs.add(NotificationSettings.l("tab.events"), this.editor);
        tabs.setToolTipTextAt(0, NotificationSettings.l("tab.events.tip"));
        tabs.add(NotificationSettings.l("tab.notificationSettingsOff"), GuiUtil.northWrap(notificationSettings));
        tabs.add(NotificationSettings.l("tab.soundSettingsOff"), GuiUtil.northWrap(soundSettings));
        this.nType.addActionListener(e -> {
            if ((Long)this.nType.getSettingValue() != -1L) {
                tabs.setTitleAt(1, NotificationSettings.l("tab.notificationSettings"));
            } else {
                tabs.setTitleAt(1, NotificationSettings.l("tab.notificationSettingsOff"));
            }
        });
        soundsEnabled.addItemListener(e -> {
            if (soundsEnabled.isSelected()) {
                tabs.setTitleAt(2, NotificationSettings.l("tab.soundSettings"));
            } else {
                tabs.setTitleAt(2, NotificationSettings.l("tab.soundSettingsOff"));
            }
        });
        notificationsPanel.add((Component)d.addSimpleBooleanSetting("nHideOnStart"), SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        notificationsPanel.add((Component)d.addSimpleBooleanSetting("nInfoMsgEnabled"), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
        gbc = SettingsDialog.makeGbcStretchHorizontal(1, 2, 1, 1);
        gbc.insets = new Insets(5, 3, 5, 30);
        notificationsPanel.add((Component)d.addSimpleStringSetting("nInfoMsgTarget", 5, true), gbc);
        String tip = StringUtil.randomString(new String[]{"Tip: Double-click on Sound column to directly open on the 'Sound' tab.", "Tip: Right-click on Chatty notifications to join associated channel.", "Tip: Left-click on Chatty notifications to close them."});
        GuiUtil.makeGbc(0, 1, 2, 1, 17);
        notificationsPanel.add((Component)new JLabel(tip), SettingsDialog.makeGbc(0, 3, 2, 1, 17));
        this.add((Component)new LinkLabel("Followed Streams setting moved to [settings:LIVE_STREAMS Live Streams Settings]", d.getLinkLabelListener()), this.getGbc(10));
        this.updateSettingsState();
    }

    protected static String l(String id) {
        return Language.getString("settings.notifications." + id);
    }

    private void updateSettingsState() {
        boolean enabled = ((Long)this.nType.getSettingValue()).equals(0L);
        boolean cmdEnabled = ((Long)this.nType.getSettingValue()).equals(2L);
        this.nPosition.setEnabled(enabled);
        this.nScreen.setEnabled(enabled);
        this.nDisplayTime.setEnabled(enabled);
        this.nMaxDisplayTime.setEnabled(enabled);
        this.userActivity.setEnabled(enabled);
        this.nCommand.setEnabled(cmdEnabled);
    }

    protected void setData(List<Notification> data) {
        this.editor.setData(data);
    }

    protected List<Notification> getData() {
        return this.editor.getData();
    }

    protected void scanFiles(boolean showMessage) {
        Path path = this.soundsPath.getCurrentPath();
        if (path == null) {
            if (showMessage) {
                JOptionPane.showMessageDialog(this, "Invalid sound folder");
            }
            this.editor.setSoundFiles(Chatty.getPath(Chatty.PathType.SETTINGS), new String[0]);
            this.filesResult.setText("Error");
            return;
        }
        Debugging.println("scan Files " + path);
        File file = path.toFile();
        File[] files = file.listFiles(new WavFilenameFilter());
        String resultText = "";
        String warningText = "";
        if (files == null) {
            resultText = "Error scanning folder.";
            this.editor.setSoundFiles(path, new String[0]);
        } else {
            resultText = files.length == 0 ? "No sound files found." : files.length + " sound files found.";
            Object[] fileNames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileNames[i] = files[i].getName();
            }
            Arrays.sort(fileNames);
            this.editor.setSoundFiles(path, (String[])fileNames);
            this.soundFiles.clear();
            for (Object fileName : fileNames) {
                this.soundFiles.add(fileName);
            }
        }
        if (showMessage) {
            JOptionPane.showMessageDialog(this, resultText + warningText);
        }
        this.filesResult.setText(resultText);
    }

    public void selectItem(long id) {
        this.editor.setSelected(id);
    }

    private static class WavFilenameFilter
    implements FilenameFilter {
        private WavFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".wav");
        }
    }

    private class MyButtonListener
    implements ActionListener {
        private MyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!e.getActionCommand().equals("openFolder") && e.getActionCommand().equals("scanFolder")) {
                NotificationSettings.this.scanFiles(true);
            }
        }
    }
}

