/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.PathSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OtherSettings
extends SettingsPanel {
    private static final String INFO = "<html><body style='width:300px'>The following settings disable Hardware Acceleration for Chatty, which may resolve display issues. You have to restart Chatty for changes to take effect.";
    private static final String INFO_WRITER = "<html><body style='width:300px'><p>Add one file per line to write Stream Status of a stream into: </p><p><code>&nbsp;&lt;streamname&gt; &lt;filename&gt; [online|offline] &lt;content&gt;</code> <p>You can define whether to write the info if the stream is online or offline (online if omitted). The <code>&lt;content&gt;</code> can contain the following codes, which will be replaced:</p><ul><li><code>%title</code> - The stream title</li><li><code>%game</code> - The game being played</li><li><code>%viewers</code> - The viewercount</li><li><code>%followers</code> / <code>%subscribers</code> - The follower/subscriber count (only when Follower/Subscriber List is open)</li><li><code>%viewersf</code> / <code>%followersf</code> / <code>%subscribersf</code> - Formatted numbers (e.g. 1,342)</li></ul><p>Example:</p><p><code> joshimuz status.txt %title %game (%viewers)<br /> joshimuz status.txt offline Stream offline</code></p>";

    public OtherSettings(SettingsDialog d) {
        JPanel graphics = this.addTitledPanel("Graphic Settings", 0);
        JPanel updates = this.addTitledPanel("Updates", 1);
        JPanel other = this.addTitledPanel("Other", 2);
        JPanel paths = this.addTitledPanel("Paths", 3);
        graphics.add((Component)new JLabel(INFO), SettingsDialog.makeGbc(0, 0, 2, 1));
        graphics.add((Component)d.addSimpleBooleanSetting("nod3d", "Disable Direct3D", ""), SettingsDialog.makeGbc(0, 1, 1, 1));
        graphics.add((Component)d.addSimpleBooleanSetting("noddraw", "Disable DirectDraw", ""), SettingsDialog.makeGbc(1, 1, 1, 1));
        SettingsUtil.addLabeledComponent(graphics, "uiScale", 0, 2, 1, 13, d.addComboLongSetting("uiScale", 0, 100, 125, 150, 175, 200));
        JLabel info = new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'><em>Note:</em> You can manually check for updates via the 'Help' menu even if you have automatic checks disabled.");
        updates.add((Component)info, SettingsDialog.makeGbc(0, 0, 1, 1));
        SimpleBooleanSetting versionCheck = d.addSimpleBooleanSetting("checkNewVersion", "Automatically check for new version", "Automatically check for a new version every few days and output a message if a new one is available.");
        updates.add((Component)versionCheck, SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        SimpleBooleanSetting versionCheckBeta = d.addSimpleBooleanSetting("checkNewBeta", "Include beta versions", "In addition to full releases, also inform about new betas.");
        updates.add((Component)versionCheckBeta, SettingsDialog.makeGbcSub(0, 2, 1, 1, 17));
        versionCheckBeta.setEnabled(false);
        versionCheck.addItemListener(e -> versionCheckBeta.setEnabled(versionCheck.isEnabled() && versionCheck.isSelected()));
        versionCheck.setEnabled(false);
        versionCheck.setToolTipText("Feature disabled in this distributed version.");
        other.add((Component)d.addSimpleBooleanSetting("newsAutoRequest", "Check for important announcements", "Automatically checks for announcements about Chatty"), SettingsDialog.makeGbc(0, 5, 3, 1, 17));
        other.add((Component)d.addSimpleBooleanSetting("enableStatusWriter", "Write Stream Status:", ""), SettingsDialog.makeGbc(0, 6, 2, 1));
        other.add((Component)d.addEditorStringSetting("statusWriter", 20, true, "Write Stream Status:", true, INFO_WRITER), SettingsDialog.makeGbc(2, 6, 1, 1));
        SettingsUtil.addLabeledComponent(other, "titleAddition", 0, 8, 2, 17, d.addSimpleStringSetting("titleAddition", 10, true));
        other.add((Component)d.addSimpleBooleanSetting("abSaveOnChange", "Save Addressbook immediately after changing entries", "Save immediately after updating addressbook (including changes via commands)"), SettingsDialog.makeGbc(0, 9, 3, 1, 17));
        JPanel pronouns = new JPanel(new FlowLayout(1, 0, 0));
        SimpleBooleanSetting pronouns1 = d.addSimpleBooleanSetting("pronouns", "Display pronouns in User Dialog", "Click on a user in chat to open User Dialog, the pronoun (if available) will be shown in the title next to the username");
        pronouns.add(pronouns1);
        pronouns.add(new LinkLabel("(based on [url:https://pr.alejo.io pr.alejo.io])", d.getLinkLabelListener()));
        other.add((Component)pronouns, SettingsDialog.makeGbc(0, 10, 3, 1, 17));
        SimpleBooleanSetting pronouns2 = d.addSimpleBooleanSetting("pronounsChat", "Display pronouns in chat (may not immediately show for all users)", "Will work best in chats with a small amount of users. May not show up on the first message of a user.");
        other.add((Component)pronouns2, SettingsDialog.makeGbcSub(0, 11, 3, 1, 17));
        SettingsUtil.addSubsettings(pronouns1, pronouns2);
        PathSetting cachePath = new PathSetting(d, Chatty.getDefaultPath(Chatty.PathType.CACHE).toString());
        d.addStringSetting("cachePath", cachePath);
        SettingsUtil.addLabeledComponent(paths, "cachePath", 0, 0, 1, 12, cachePath, true);
        PathSetting imgPath = new PathSetting(d, Chatty.getDefaultPath(Chatty.PathType.IMAGE).toString());
        d.addStringSetting("imgPath", imgPath);
        SettingsUtil.addLabeledComponent(paths, "imgPath", 0, 1, 1, 12, imgPath, true);
        PathSetting exportPath = new PathSetting(d, Chatty.getDefaultPath(Chatty.PathType.EXPORT).toString());
        d.addStringSetting("exportPath", exportPath);
        SettingsUtil.addLabeledComponent(paths, "exportPath", 0, 2, 1, 12, exportPath, true);
    }
}

