/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.gui.GuiUtil;
import chatty.gui.components.settings.StringSetting;
import chatty.lang.Language;
import chatty.util.MiscUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathSetting
extends JPanel
implements StringSetting {
    private final JTextField display = new JTextField(20);
    private final JButton changeButton = new JButton(Language.getString("settings.chooseFolder.button.change"));
    private final JButton resetButton = new JButton(Language.getString("settings.chooseFolder.button.default"));
    private final JButton openButton = new JButton(Language.getString("settings.chooseFolder.button.open"));
    private String value;
    private final String defaultPath;
    private final Component parentComponent;
    private PathChangeListener listener;

    public PathSetting(final Component parentComponent, String defaultPath) {
        this.defaultPath = defaultPath;
        this.parentComponent = parentComponent;
        this.display.setEditable(false);
        GuiUtil.smallButtonInsets(this.changeButton);
        GuiUtil.smallButtonInsets(this.resetButton);
        GuiUtil.smallButtonInsets(this.openButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        this.add((Component)this.display, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        this.add((Component)this.changeButton, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.add((Component)this.resetButton, gbc);
        gbc.gridx = 2;
        gbc.insets.left += 6;
        this.add((Component)this.openButton, gbc);
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == PathSetting.this.changeButton) {
                    PathSetting.this.chooseDirectory();
                } else if (e.getSource() == PathSetting.this.resetButton) {
                    PathSetting.this.setSettingValue("");
                } else if (e.getSource() == PathSetting.this.openButton) {
                    Path path = PathSetting.this.getCurrentPath();
                    if (path == null) {
                        path = Chatty.getPath(Chatty.PathType.SETTINGS);
                    }
                    MiscUtil.openFile(path.toFile(), parentComponent);
                }
            }
        };
        this.changeButton.addActionListener(buttonAction);
        this.resetButton.addActionListener(buttonAction);
        this.openButton.addActionListener(buttonAction);
    }

    @Override
    public String getSettingValue() {
        return this.value;
    }

    @Override
    public void setSettingValue(String value) {
        if (this.value == null || !this.value.equals(value)) {
            this.value = value;
            if (this.listener != null) {
                this.listener.pathChanged(this.getCurrentPath());
            }
        }
        String isInvalid = this.getCurrentPath() == null ? "[invalid]" : "";
        String isDefault = value.isEmpty() ? "[" + Language.getString("settings.chooseFolder.default") + "] " : "";
        this.display.setText(isDefault + isInvalid + this.getCurrentPathValue());
    }

    public String getCurrentPathValue() {
        if (this.value.isEmpty()) {
            return this.defaultPath;
        }
        return this.value;
    }

    public Path getCurrentPath() {
        try {
            return Paths.get(this.getCurrentPathValue(), new String[0]);
        }
        catch (InvalidPathException ex) {
            return null;
        }
    }

    public void setPathChangeListener(PathChangeListener listener) {
        this.listener = listener;
    }

    private void chooseDirectory() {
        Path path = this.getCurrentPath();
        if (path == null) {
            path = Chatty.getPath(Chatty.PathType.SETTINGS);
        }
        JFileChooser chooser = new JFileChooser(path.toFile());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(1);
        if (chooser.showDialog(this.parentComponent, Language.getString("settings.chooseFolder")) == 0) {
            this.setSettingValue(chooser.getSelectedFile().getPath());
        }
    }

    public static interface PathChangeListener {
        public void pathChanged(Path var1);
    }
}

