/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.GenericComboSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.lang.Language;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class PresetsComboSetting<E>
extends JPanel {
    private final GenericComboSetting<E> combo = new GenericComboSetting();
    private final Settings settings;
    private final Editor settingEditor;
    private final JTextField customValueInput = new JTextField();
    private final GridBagConstraints customInputGbc;
    private final String settingName;
    private final Function<String, E> stringToValue;
    private final Function<E, String> valueToString;
    private final String defaultLabel;
    private final String customValueLabel;
    private final boolean customInputEnabled;
    private final boolean shortcuts;
    private final int[] codes = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
    private final Set<ActionListener> listeners = new HashSet<ActionListener>();
    private boolean isUpdating;

    public PresetsComboSetting(Window parent, Settings settings, String settingName, Function<String, E> stringToValue, final Function<E, String> valueToString, final String defaultLabel, String customValueLabel, boolean shortcuts) {
        this.settings = settings;
        this.settingName = settingName;
        this.stringToValue = stringToValue;
        this.valueToString = valueToString;
        this.defaultLabel = defaultLabel;
        this.customValueLabel = customValueLabel;
        this.shortcuts = shortcuts;
        this.customInputEnabled = customValueLabel != null;
        this.setLayout(new GridBagLayout());
        JButton editButton = new JButton();
        editButton.setIcon(new ImageIcon(SettingsDialog.class.getResource("edit.png")));
        editButton.setMargin(new Insets(0, 2, 0, 2));
        editButton.addActionListener(e -> this.editPresets());
        this.settingEditor = new Editor(parent);
        this.settingEditor.setAllowEmpty(true);
        this.settingEditor.setAllowLinebreaks(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(this.combo, gbc);
        gbc.gridx = 1;
        gbc.fill = 3;
        this.add((Component)editButton, gbc);
        this.customInputGbc = new GridBagConstraints();
        this.customInputGbc.gridx = 0;
        this.customInputGbc.gridy = 1;
        this.customInputGbc.gridwidth = 2;
        this.customInputGbc.fill = 2;
        this.add((Component)this.customValueInput, this.customInputGbc);
        this.combo.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                String text;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                if (index == -1 && value != null && (text = (String)valueToString.apply(((GenericComboSetting.Entry)value).value)) != null && !text.isEmpty()) {
                    this.setText(text);
                }
                return this;
            }
        });
        this.combo.addActionListener(e -> {
            if (this.customInputEnabled && this.combo.getItemCount() > 1 && this.combo.getSelectedIndex() == this.combo.getItemCount() - 1) {
                this.addCustomInput();
            } else {
                this.removeCustomInput();
            }
            if (!this.isUpdating) {
                this.listeners.forEach(l -> l.actionPerformed(e));
            }
        });
        this.combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!PresetsComboSetting.this.combo.isPopupVisible()) {
                    return;
                }
                for (int i = 0; i < PresetsComboSetting.this.codes.length; ++i) {
                    if (PresetsComboSetting.this.codes[i] != e.getKeyCode()) continue;
                    int indexToSelect = i;
                    if (defaultLabel != null) {
                        // empty if block
                    }
                    int indexToCheck = ++indexToSelect;
                    if (PresetsComboSetting.this.customInputEnabled) {
                        ++indexToCheck;
                    }
                    if (PresetsComboSetting.this.combo.getItemCount() > indexToCheck) {
                        PresetsComboSetting.this.combo.setPopupVisible(false);
                        PresetsComboSetting.this.combo.setSelectedIndex(indexToSelect);
                    }
                    e.consume();
                }
                if (e.getKeyCode() == 67 && PresetsComboSetting.this.customInputEnabled) {
                    PresetsComboSetting.this.combo.setSelectedIndex(PresetsComboSetting.this.combo.getItemCount() - 1);
                    e.consume();
                }
            }
        });
        this.customValueInput.addActionListener(e -> KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent());
        this.customValueInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    PresetsComboSetting.this.combo.requestFocusInWindow();
                    PresetsComboSetting.this.combo.setPopupVisible(true);
                    PresetsComboSetting.this.combo.setSelectedIndex(PresetsComboSetting.this.combo.getItemCount() - 2);
                }
            }
        });
    }

    public void init() {
        this.updatePresetsFromSettings();
        this.reset();
    }

    private void editPresets() {
        String currentPresets = this.settings.getString(this.settingName);
        String editedPresets = this.settingEditor.showDialog(Language.getString("settings.editor." + this.settingName), currentPresets, null);
        if (editedPresets != null) {
            this.settings.setString(this.settingName, editedPresets);
            this.updatePresetsFromSettings();
        }
    }

    public void updatePresetsFromSettings() {
        this.isUpdating = true;
        E selectedBefore = this.getSelectedValue();
        String values = this.settings.getString(this.settingName);
        String[] split = values.split("\n");
        this.combo.removeAllItems();
        if (this.defaultLabel != null) {
            this.combo.add(this.stringToValue.apply(null), this.defaultLabel);
        }
        for (int i = 0; i < split.length; ++i) {
            if (split[i].trim().isEmpty()) continue;
            String shortcut = "-";
            if (this.codes.length > i) {
                shortcut = KeyEvent.getKeyText(this.codes[i]);
            }
            E value = this.stringToValue.apply(split[i]);
            String shortcutLabel = "";
            if (this.shortcuts) {
                shortcutLabel = "[" + shortcut + "] ";
            }
            this.combo.add(value, shortcutLabel + this.valueToString.apply(value));
        }
        if (this.customInputEnabled) {
            this.combo.add(this.stringToValue.apply(""), "[C] " + this.customValueLabel);
        }
        if (selectedBefore != null) {
            this.setSelectedValue(selectedBefore);
        }
        this.isUpdating = false;
    }

    public E getSelectedValue() {
        int index = this.combo.getSelectedIndex();
        if (index == 0 && this.customInputEnabled || index == -1) {
            return null;
        }
        if (this.customInputEnabled && index == this.combo.getItemCount() - 1) {
            return this.stringToValue.apply(this.customValueInput.getText());
        }
        return this.combo.getSettingValue();
    }

    public void setSelectedValue(E value) {
        this.isUpdating = true;
        if (!this.combo.containsValue(value)) {
            this.combo.add(value, this.valueToString.apply(value));
        }
        this.combo.setSettingValue(value);
        this.isUpdating = false;
    }

    private void reset() {
        this.isUpdating = true;
        if (this.combo.getItemCount() > 0) {
            this.combo.setSelectedIndex(0);
        }
        this.isUpdating = false;
    }

    private void addCustomInput() {
        this.add((Component)this.customValueInput, this.customInputGbc);
        this.revalidate();
        this.customValueInput.requestFocusInWindow();
        this.customValueInput.setSelectionStart(0);
        this.customValueInput.setSelectionEnd(this.customValueInput.getText().length());
    }

    private void removeCustomInput() {
        this.remove(this.customValueInput);
        this.revalidate();
    }

    public void addChangeListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Settings settings = new Settings("", null);
            settings.addString("testSetting", "1\n2\n3");
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            PresetsComboSetting<Long> settingPanel = new PresetsComboSetting<Long>(frame, settings, "testSetting", s -> {
                if (s == null) {
                    return -2L;
                }
                if (s.isEmpty()) {
                    return -1L;
                }
                return Long.valueOf(s);
            }, v -> String.valueOf(v), "Relatively wide default label", "Custom value", false);
            settingPanel.init();
            frame.add(settingPanel, "Center");
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }
}

