/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.routing.RoutingTargetSettings;
import chatty.gui.components.settings.HighlightSettings;
import chatty.gui.components.settings.HighlighterTester;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.RoutingSettingsTable;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RoutingSettings
extends SettingsPanel {
    private final RoutingSettingsTable<RoutingTargetSettings> table;
    private final ListSelector items;

    public RoutingSettings(SettingsDialog d) {
        super(true);
        this.table = new RoutingSettingsTable(d, new JLabel(""));
        this.table.setPreferredSize(new Dimension(10, 150));
        JPanel main = this.addTitledPanel("Custom Tabs Routing", 0, true);
        JPanel settings = this.addTitledPanel("Custom Tabs Settings", 1, true);
        this.items = d.addListSetting("routing", "Custom Tab Routing", 220, 190, true, true);
        this.items.setInfo(HighlightSettings.getMatchingHelp("routing"));
        this.items.setInfoLinkLabelListener(d.getLinkLabelListener());
        this.items.setEditor(() -> {
            HighlighterTester tester = new HighlighterTester((Window)d, false, "routing");
            tester.setLinkLabelListener(d.getLinkLabelListener());
            return tester;
        });
        this.items.setDataFormatter(input -> input.trim());
        main.add((Component)d.addSimpleBooleanSetting("routingMulti"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        GridBagConstraints gbc = SettingsDialog.makeGbcStretchHorizontal(0, 1, 1, 1);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        main.add((Component)this.items, gbc);
        gbc = SettingsDialog.makeGbcStretchHorizontal(0, 0, 1, 1);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        settings.add(this.table, gbc);
    }

    public void setData(List<RoutingTargetSettings> data) {
        this.table.setData(data);
    }

    public List<RoutingTargetSettings> getData() {
        return this.table.getData();
    }

    public void selectItem(String item) {
        this.items.setSelected(item);
    }

    public void selectItems(Collection<String> selectItems) {
        this.items.setSelected(selectItems);
    }
}

