/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.RegexDocumentFilter;
import chatty.gui.components.routing.RoutingTargetSettings;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.FileUtil;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class RoutingSettingsTable<T extends RoutingTargetSettings>
extends TableEditor<RoutingTargetSettings> {
    private static final int NAME_COLUMN = 0;
    private static final int SETTINGS_COLUMN = 1;
    private static final int LOG_COLUMN = 2;
    private final MyTableModel<T> data = new MyTableModel();
    private MyItemEditor<T> editor;

    public RoutingSettingsTable(JDialog owner, Component info) {
        super(0, false);
        this.setModel(this.data);
        this.setItemEditor(() -> {
            if (this.editor == null) {
                this.editor = new MyItemEditor(owner, info);
            }
            return this.editor;
        });
        this.setFixedColumnWidth(0, 180);
    }

    public static Map<Long, String> makeChannelLogoValues() {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        result.put(0L, "Off");
        for (int i = 12; i <= 30; i += 2) {
            result.put(Long.valueOf(i), i + "px");
        }
        return result;
    }

    public static Map<Long, String> makeChannelNameValues() {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>();
        result.put(0L, "Off");
        result.put(100L, "Show fully");
        for (int i = 4; i <= 30; i += 2) {
            result.put(Long.valueOf(i), String.format("Shorten to %d characters", i));
        }
        return result;
    }

    private static class MyTableModel<T extends RoutingTargetSettings>
    extends ListTableModel<RoutingTargetSettings> {
        public MyTableModel() {
            super(new String[]{"Name", "Settings", "Log file"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RoutingTargetSettings entry = (RoutingTargetSettings)this.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.getName();
                }
                case 1: {
                    return entry.makeSettingsInfo();
                }
                case 2: {
                    return entry.getFullLogFilename();
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return String.class;
        }
    }

    public static class MyItemEditor<T extends RoutingTargetSettings>
    implements TableEditor.ItemEditor<RoutingTargetSettings> {
        private static final String HTML_PREFIX = "<html><body style='width:200px;'>";
        private final JDialog dialog;
        private final JTextField name = new JTextField(10);
        private final JCheckBox logEnabled = new JCheckBox(Language.getString("settings.customTabSettings.logEnabled"));
        private final JTextField logFile = new JTextField(10);
        private final ComboLongSetting openOnMessage;
        private final ComboLongSetting channelLogo;
        private final ComboLongSetting showChannelName;
        private final JCheckBox exclusive;
        private final JRadioButton multiChannelAll = new JRadioButton();
        private final JRadioButton multiChannelSep = new JRadioButton();
        private final JRadioButton multiChannelSepAndAll = new JRadioButton();
        private final JCheckBox channelFixed = new JCheckBox();
        private final JButton ok = new JButton("Done");
        private final JButton cancel = new JButton("Cancel");
        boolean save;

        public MyItemEditor(JDialog owner, Component info) {
            this.dialog = new JDialog(owner);
            this.dialog.setTitle("Edit Item");
            this.dialog.setModal(true);
            ButtonGroup multiChannelGroup = new ButtonGroup();
            multiChannelGroup.add(this.multiChannelAll);
            multiChannelGroup.add(this.multiChannelSep);
            multiChannelGroup.add(this.multiChannelSepAndAll);
            SettingsUtil.setTextAndTooltip(this.multiChannelAll, "settings.customTabSettings.multiChannelAll");
            SettingsUtil.setTextAndTooltip(this.multiChannelSep, "settings.customTabSettings.multiChannelSep");
            SettingsUtil.setTextAndTooltip(this.multiChannelSepAndAll, "settings.customTabSettings.multiChannelSepAndAll");
            SettingsUtil.setTextAndTooltip(this.channelFixed, "settings.customTabSettings.channelFixed");
            ((AbstractDocument)this.logFile.getDocument()).setDocumentFilter(new RegexDocumentFilter(FileUtil.ILLEGAL_FILENAME_CHARACTERS_PATTERN.pattern(), this.logFile));
            this.name.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateButtons();
                }
            });
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ok) {
                        dialog.setVisible(false);
                        save = true;
                    } else if (e.getSource() == cancel) {
                        dialog.setVisible(false);
                    }
                }
            };
            this.ok.addActionListener(listener);
            this.cancel.addActionListener(listener);
            this.dialog.setLayout(new GridBagLayout());
            this.dialog.add((Component)new JLabel("Name:"), GuiUtil.makeGbc(0, 0, 1, 1));
            GridBagConstraints gbc = GuiUtil.makeGbc(1, 0, 2, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)this.name, gbc);
            JPanel generalPanel = new JPanel(new GridBagLayout());
            generalPanel.setBorder(BorderFactory.createTitledBorder("General"));
            this.openOnMessage = new ComboLongSetting(RoutingTargetSettings.getOpenOnMessageValues());
            this.channelLogo = new ComboLongSetting(RoutingSettingsTable.makeChannelLogoValues());
            this.showChannelName = new ComboLongSetting(RoutingSettingsTable.makeChannelNameValues());
            this.exclusive = new JCheckBox("Exclusive");
            generalPanel.add((Component)this.openOnMessage, GuiUtil.makeGbc(1, 1, 2, 1, 17));
            SettingsUtil.addLabeledComponent(generalPanel, "settings.label.routingTargets.channelLogo", 1, 2, 1, 17, this.channelLogo);
            SettingsUtil.addLabeledComponent(generalPanel, "settings.label.routingTargets.showChannelName", 1, 3, 1, 17, this.showChannelName);
            JPanel multiChannelPanel = new JPanel(new GridBagLayout());
            multiChannelPanel.setBorder(BorderFactory.createTitledBorder("Show messages by channel"));
            gbc = SettingsDialog.makeGbcCloser(0, 0, 2, 1, 17);
            multiChannelPanel.add((Component)this.multiChannelAll, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 1, 2, 1, 17);
            multiChannelPanel.add((Component)this.multiChannelSep, gbc);
            gbc = SettingsDialog.makeGbcCloser(0, 2, 2, 1, 17);
            multiChannelPanel.add((Component)this.multiChannelSepAndAll, gbc);
            gbc = SettingsDialog.makeGbcSub(0, 3, 2, 1, 17);
            multiChannelPanel.add((Component)this.channelFixed, gbc);
            gbc = SettingsDialog.makeGbc(0, 4, 2, 1, 10);
            multiChannelPanel.add((Component)new JLabel("<html><body style='width:200px;'>Switch channels through the context menu. Changing this setting only applies to new messages."), gbc);
            SettingsUtil.addSubsettings(new JRadioButton[]{this.multiChannelSep, this.multiChannelSepAndAll}, this.channelFixed);
            JPanel logPanel = new JPanel(new GridBagLayout());
            logPanel.setBorder(BorderFactory.createTitledBorder("Log to file"));
            gbc = GuiUtil.makeGbc(0, 0, 4, 1, 17);
            logPanel.add((Component)this.logEnabled, gbc);
            JLabel logFileLabel = SettingsUtil.createLabel("settings.customTabSettings.logFile");
            logFileLabel.setLabelFor(this.logFile);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1, 17);
            logPanel.add((Component)logFileLabel, gbc);
            gbc = GuiUtil.makeGbc(1, 1, 1, 1, 17);
            gbc.insets = new Insets(5, 0, 5, 0);
            logPanel.add((Component)new JLabel("customTab-"), gbc);
            gbc = GuiUtil.makeGbc(2, 1, 1, 1, 17);
            gbc.insets = new Insets(5, 2, 5, 2);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            logPanel.add((Component)this.logFile, gbc);
            gbc = GuiUtil.makeGbc(3, 1, 1, 1, 17);
            gbc.insets = new Insets(5, 0, 5, 5);
            logPanel.add((Component)new JLabel(".log"), gbc);
            gbc = GuiUtil.makeGbc(0, 2, 4, 1, 17);
            logPanel.add((Component)new JLabel(HTML_PREFIX + Language.getString("settings.customTabSettings.logInfo")), gbc);
            gbc = GuiUtil.makeGbc(0, 6, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)generalPanel, gbc);
            gbc = GuiUtil.makeGbc(0, 7, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)multiChannelPanel, gbc);
            gbc = GuiUtil.makeGbc(0, 8, 3, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)logPanel, gbc);
            if (info != null) {
                gbc = GuiUtil.makeGbc(0, 10, 3, 1, 10);
                gbc.weightx = 1.0;
                this.dialog.add(info, gbc);
            }
            gbc = GuiUtil.makeGbc(1, 11, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.dialog.add((Component)this.ok, gbc);
            gbc = GuiUtil.makeGbc(2, 11, 1, 1);
            this.dialog.add((Component)this.cancel, gbc);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }

        @Override
        public RoutingTargetSettings showEditor(RoutingTargetSettings preset, Component c, boolean edit, int column) {
            if (edit) {
                this.dialog.setTitle("Edit item");
            } else {
                this.dialog.setTitle("Add item");
            }
            this.dialog.setLocationRelativeTo(c);
            if (preset != null) {
                this.name.setText(preset.getName());
                this.openOnMessage.setSettingValue(Long.valueOf(preset.openOnMessage));
                this.channelLogo.setSettingValue(Long.valueOf(preset.channelLogo));
                this.showChannelName.setSettingValue(Long.valueOf(preset.showChannelName));
                this.exclusive.setSelected(preset.exclusive);
                this.logEnabled.setSelected(preset.logEnabled);
                this.logFile.setText(preset.getRawLogFilename());
                if (StringUtil.isNullOrEmpty(preset.getRawLogFilename())) {
                    this.logFile.setText(preset.getName());
                }
                switch (preset.multiChannel) {
                    case 0: {
                        this.multiChannelAll.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.multiChannelSep.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.multiChannelSepAndAll.setSelected(true);
                    }
                }
                this.channelFixed.setSelected(preset.channelFixed);
            } else {
                this.name.setText(null);
                this.openOnMessage.setSettingValue(1L);
                this.channelLogo.setSettingValue(22L);
                this.showChannelName.setSettingValue(0L);
                this.exclusive.setSelected(false);
                this.logEnabled.setSelected(false);
                this.logFile.setText(null);
                this.multiChannelAll.setSelected(true);
                this.channelFixed.setSelected(false);
            }
            this.name.requestFocusInWindow();
            this.updateButtons();
            this.save = false;
            this.dialog.setVisible(true);
            if (!this.name.getText().isEmpty() && this.save) {
                return new RoutingTargetSettings(this.name.getText(), ((Long)this.openOnMessage.getSettingValue()).intValue(), this.exclusive.isSelected(), this.logEnabled.isSelected(), this.logFile.getText(), this.getMultiChannelValue(), this.channelFixed.isSelected(), preset != null ? preset.showAll : false, ((Long)this.channelLogo.getSettingValue()).intValue(), ((Long)this.showChannelName.getSettingValue()).intValue());
            }
            return null;
        }

        private int getMultiChannelValue() {
            if (this.multiChannelSep.isSelected()) {
                return 1;
            }
            if (this.multiChannelSepAndAll.isSelected()) {
                return 2;
            }
            return 0;
        }

        private void updateButtons() {
            boolean enabled = !this.name.getText().isEmpty();
            this.ok.setEnabled(enabled);
        }
    }
}

