/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.AdvancedSettings;
import chatty.gui.components.settings.BooleanSetting;
import chatty.gui.components.settings.ChatSettings;
import chatty.gui.components.settings.ColorSettings;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.CompletionSettings;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.EmoteSettings;
import chatty.gui.components.settings.FilterSettings;
import chatty.gui.components.settings.FontSettings;
import chatty.gui.components.settings.HighlightSettings;
import chatty.gui.components.settings.HistorySettings;
import chatty.gui.components.settings.HotkeyPanel;
import chatty.gui.components.settings.HotkeySettings;
import chatty.gui.components.settings.IgnoreSettings;
import chatty.gui.components.settings.ImageSettings;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.ListSetting;
import chatty.gui.components.settings.LiveStreamsSettings;
import chatty.gui.components.settings.LogSettings;
import chatty.gui.components.settings.LongSetting;
import chatty.gui.components.settings.LookSettings;
import chatty.gui.components.settings.MainSettings;
import chatty.gui.components.settings.MapSetting;
import chatty.gui.components.settings.MatchingPresets;
import chatty.gui.components.settings.MessageSettings;
import chatty.gui.components.settings.ModerationSettings;
import chatty.gui.components.settings.MsgColorSettings;
import chatty.gui.components.settings.NameSettings;
import chatty.gui.components.settings.NotificationSettings;
import chatty.gui.components.settings.OtherSettings;
import chatty.gui.components.settings.RoutingSettings;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SharedChatSettings;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SimpleLongSetting;
import chatty.gui.components.settings.SimpleSettings;
import chatty.gui.components.settings.SimpleStringSetting;
import chatty.gui.components.settings.SimpleTableEditor;
import chatty.gui.components.settings.StreamSettings;
import chatty.gui.components.settings.StringEditor;
import chatty.gui.components.settings.StringSetting;
import chatty.gui.components.settings.TabSettings;
import chatty.gui.components.settings.TableEditor;
import chatty.gui.components.settings.TextToSpeechSettings;
import chatty.gui.components.settings.Tree;
import chatty.gui.components.settings.UsercolorSettings;
import chatty.gui.components.settings.WindowSettings;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.util.Sound;
import chatty.util.StringUtil;
import chatty.util.api.TokenInfo;
import chatty.util.api.usericons.Usericon;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.colors.HtmlColors;
import chatty.util.hotkeys.Hotkey;
import chatty.util.settings.Settings;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class SettingsDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(SettingsDialog.class.getName());
    private static SettingsDialog INSTANCE;
    private final JButton ok = new JButton(Language.getString("dialog.button.save"));
    private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
    private final Set<String> restartRequiredDef = new HashSet<String>(Arrays.asList("ffz", "nod3d", "noddraw", "userlistWidth", "userlistMinWidth", "userlistEnabled", "capitalizedNames", "correctlyCapitalizedNames", "inputFont", "bttvEmotes", "botNamesBTTV", "botNamesFFZ", "ffzEvent", "seventv", "logPath", "logTimestamp", "logSplit", "logSubdirectories", "logLockFiles", "logMessageTemplate", "laf", "lafTheme", "lafFontScale", "language", "timezone", "locale", "userDialogMessageLimit", "cachePath", "imgPath", "exportPath", "webp", "inputLimitsEnabled", "chatInsertTop"));
    private final Set<String> reconnectRequiredDef = new HashSet<String>(Arrays.asList("membershipEnabled"));
    private boolean restartRequired = false;
    private boolean reconnectRequired = false;
    protected boolean lafPreviewed;
    private Dimension autoSetSize;
    private static final String RESTART_REQUIRED_INFO;
    private static final String RECONNECT_REQUIRED_INFO = "<html><body style='width: 280px'>One or more settings you have changed require you to reconnect to have any effect.";
    private final HashMap<String, StringSetting> stringSettings = new HashMap();
    private final HashMap<String, LongSetting> longSettings = new HashMap();
    private final HashMap<String, BooleanSetting> booleanSettings = new HashMap();
    private final HashMap<String, ListSetting> listSettings = new HashMap();
    private final HashMap<String, MapSetting> mapSettings = new HashMap();
    private final Map<Page, SettingsPanel> panels = new LinkedHashMap<Page, SettingsPanel>();
    final Settings settings;
    private final MainGui owner;
    private final MatchingPresets matchingPresets;
    private Page currentlyShown;
    private final CardLayout cardManager;
    private final JPanel cards;
    private final JTree selection;
    private final LinkLabelListener settingsHelpLinkLabelListener;
    private static final Map<Page, List<Page>> MENU;
    private final Color searchHighlightColor = ColorCorrectionNew.offset(this.getBackground(), 0.8f);
    private final Map<Component, State> stateBeforeSearch = new HashMap<Component, State>();

    public static void get(MainGui g, Consumer<SettingsDialog> action) {
        if (INSTANCE == null) {
            if (action == null) {
                INSTANCE = new SettingsDialog(g, g.getSettings());
            } else {
                SwingUtilities.invokeLater(() -> {
                    g.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                    g.getGlassPane().setVisible(true);
                    long start = System.currentTimeMillis();
                    INSTANCE = new SettingsDialog(g, g.getSettings());
                    System.out.println("Settings init: " + (System.currentTimeMillis() - start));
                    g.getGlassPane().setCursor(Cursor.getDefaultCursor());
                    g.getGlassPane().setVisible(false);
                    action.accept(INSTANCE);
                });
            }
        } else {
            action.accept(INSTANCE);
        }
    }

    public SettingsDialog(final MainGui owner, Settings settings) {
        super(owner, Language.getString("settings.title"), true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.cancel();
            }
        });
        this.settingsHelpLinkLabelListener = new LinkLabelListener(){

            @Override
            public void linkClicked(String type, String ref) {
                owner.openHelp("help-settings.html", ref);
            }
        };
        this.owner = owner;
        this.settings = settings;
        this.setLayout(new GridBagLayout());
        this.selection = Tree.createTree(MENU, this.searchHighlightColor);
        this.selection.setSelectionRow(0);
        this.selection.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane selectionScroll = new JScrollPane(this.selection);
        selectionScroll.setBorder(BorderFactory.createEmptyBorder());
        selectionScroll.setMinimumSize(selectionScroll.getPreferredSize());
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.insets = new Insets(10, 10, 10, 3);
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)selectionScroll, gbc);
        this.cardManager = new CardLayout();
        this.cards = new JPanel(this.cardManager){

            @Override
            public void add(Component comp, Object constraints) {
                JScrollPane scroll = new JScrollPane(comp);
                scroll.setBorder(BorderFactory.createEmptyBorder());
                super.add((Component)scroll, constraints);
            }
        };
        this.panels.put(Page.MAIN, new MainSettings(this));
        this.panels.put(Page.HOTKEYS, new HotkeySettings(this));
        this.panels.put(Page.MESSAGES, new MessageSettings(this));
        this.panels.put(Page.MODERATION, new ModerationSettings(this));
        this.panels.put(Page.EMOTES, new EmoteSettings(this));
        this.panels.put(Page.USERICONS, new ImageSettings(this));
        this.panels.put(Page.LOOK, new LookSettings(this));
        this.panels.put(Page.FONTS, new FontSettings(this));
        this.panels.put(Page.CHATCOLORS, new ColorSettings(this, settings));
        this.panels.put(Page.HIGHLIGHT, new HighlightSettings(this));
        this.panels.put(Page.IGNORE, new IgnoreSettings(this));
        this.panels.put(Page.FILTER, new FilterSettings(this));
        this.panels.put(Page.CUSTOM_TABS, new RoutingSettings(this));
        this.panels.put(Page.SHARED_CHAT, new SharedChatSettings(this));
        this.panels.put(Page.MSGCOLORS, new MsgColorSettings(this));
        this.panels.put(Page.HISTORY, new HistorySettings(this));
        this.panels.put(Page.NOTIFICATIONS, new NotificationSettings(this, settings));
        this.panels.put(Page.TTS, new TextToSpeechSettings(this));
        this.panels.put(Page.LIVE_STREAMS, new LiveStreamsSettings(this));
        this.panels.put(Page.USERCOLORS, new UsercolorSettings(this));
        this.panels.put(Page.LOGGING, new LogSettings(this));
        this.panels.put(Page.WINDOW, new WindowSettings(this));
        this.panels.put(Page.TABS, new TabSettings(this));
        this.panels.put(Page.COMMANDS, new CommandSettings(this));
        this.panels.put(Page.OTHER, new OtherSettings(this));
        this.panels.put(Page.ADVANCED, new AdvancedSettings(this));
        this.panels.put(Page.COMPLETION, new CompletionSettings(this));
        this.panels.put(Page.CHAT, new ChatSettings(this));
        this.panels.put(Page.NAMES, new NameSettings(this));
        this.panels.put(Page.STREAM, new StreamSettings(this));
        this.panels.put(Page.SIMPLE, new SimpleSettings(this));
        for (Map.Entry<Page, SettingsPanel> entry : this.panels.entrySet()) {
            this.cards.add((Component)entry.getValue(), entry.getKey().name);
        }
        this.matchingPresets = new MatchingPresets(this);
        this.currentlyShown = Page.MAIN;
        this.selection.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.selection.getLastSelectedPathComponent();
            if (node != null) {
                this.showPanel((Page)((Object)((Object)node.getUserObject())));
            }
        });
        gbc = SettingsDialog.makeGbc(1, 0, 3, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.cards, gbc);
        gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 10, 0, 0);
        this.add((Component)new LinkLabel("[maeh:muh Help]", new LinkLabelListener(){

            @Override
            public void linkClicked(String type, String ref) {
                if (SettingsDialog.this.currentlyShown == Page.COMMANDS) {
                    owner.openHelp("help-custom_commands.html", "");
                } else {
                    owner.openHelp("help-settings.html", ((SettingsDialog)SettingsDialog.this).currentlyShown.name);
                }
            }
        }), gbc);
        JPanel searchPanel = new JPanel(new FlowLayout(0, 4, 0));
        JTextField searchField = new JTextField(10);
        GuiUtil.addChangeListener(searchField.getDocument(), e -> this.search(searchField.getText()));
        JLabel searchLabel = new JLabel(Language.getString("settings.search"));
        searchLabel.setLabelFor(searchField);
        JButton resetSearchButton = new JButton(Language.getString("settings.resetSearch"));
        GuiUtil.smallButtonInsets(resetSearchButton);
        resetSearchButton.addActionListener(e -> searchField.setText(""));
        searchPanel.add(searchLabel);
        searchPanel.add(searchField);
        searchPanel.add(resetSearchButton);
        gbc = SettingsDialog.makeGbc(1, 2, 1, 1);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 10, 0, 0);
        this.add((Component)searchPanel, gbc);
        this.ok.setMnemonic(83);
        gbc = SettingsDialog.makeGbc(2, 2, 1, 1);
        gbc.anchor = 13;
        gbc.insets = new Insets(4, 3, 8, 8);
        gbc.ipadx = 16;
        gbc.ipady = 4;
        GuiUtil.smallButtonInsets(this.ok);
        this.add((Component)this.ok, gbc);
        this.cancel.setMnemonic(67);
        gbc = SettingsDialog.makeGbc(3, 2, 1, 1);
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 3, 8, 8);
        gbc.ipadx = 16;
        gbc.ipady = 4;
        GuiUtil.smallButtonInsets(this.cancel);
        this.add((Component)this.cancel, gbc);
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        this.pack();
    }

    private <T> T getPanel(Class<T> c) {
        for (SettingsPanel panel : this.panels.values()) {
            if (!panel.getClass().equals(c)) continue;
            return c.cast(panel);
        }
        return null;
    }

    public void showSettings() {
        this.showSettings(null, null);
    }

    public void showSettings(String action, Object parameter) {
        this.loadSettings();
        this.getPanel(LiveStreamsSettings.class).setUserReadPermission(this.settings.getList("scopes").contains(TokenInfo.Scope.FOLLOWS.scope));
        if (action != null) {
            this.editDirectly(action, parameter);
        }
        this.stuffBasedOnPanel();
        this.selection.requestFocusInWindow();
        if (this.autoSetSize == null || this.autoSetSize.equals(this.getSize())) {
            this.pack();
            Rectangle screenBounds = GuiUtil.getEffectiveScreenBounds(this);
            if (this.getHeight() > screenBounds.height) {
                this.setSize(this.getWidth() + 50, screenBounds.height);
            }
            if (this.getWidth() > screenBounds.width) {
                this.setSize(screenBounds.width, this.getHeight());
            }
            GuiUtil.setLocationRelativeTo(this, this.owner);
            this.autoSetSize = this.getSize(this.autoSetSize);
        }
        this.lafPreviewed = false;
        this.setVisible(true);
    }

    private void stuffBasedOnPanel() {
        switch (this.currentlyShown) {
            case HOTKEYS: 
            case TTS: {
                this.owner.hotkeyManager.setEnabled(false);
            }
        }
    }

    private void editDirectly(final String action, final Object parameter) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (action.equals("editUsercolorItem")) {
                    SettingsDialog.this.showPanel(Page.USERCOLORS);
                    ((UsercolorSettings)SettingsDialog.this.getPanel(UsercolorSettings.class)).editItem((String)parameter);
                } else if (action.equals("editCustomNameItem")) {
                    SettingsDialog.this.showPanel(Page.NAMES);
                    ((NameSettings)SettingsDialog.this.getPanel(NameSettings.class)).editCustomName((String)parameter);
                } else if (action.equals("addUsericonOfBadgeType")) {
                    SettingsDialog.this.showPanel(Page.USERICONS);
                    Usericon icon = (Usericon)parameter;
                    ((ImageSettings)SettingsDialog.this.getPanel(ImageSettings.class)).addUsericonOfBadgeType(icon.type, icon.badgeType.toString());
                } else if (action.equals("addUsericonOfBadgeTypeAllVariants")) {
                    SettingsDialog.this.showPanel(Page.USERICONS);
                    Usericon icon = (Usericon)parameter;
                    ((ImageSettings)SettingsDialog.this.getPanel(ImageSettings.class)).addUsericonOfBadgeType(icon.type, icon.badgeType.id);
                } else if (action.equals("selectHighlight")) {
                    SettingsDialog.this.showPanel(Page.HIGHLIGHT);
                    Collection data = (Collection)parameter;
                    ((HighlightSettings)SettingsDialog.this.getPanel(HighlightSettings.class)).selectItems(data);
                } else if (action.equals("selectIgnore")) {
                    SettingsDialog.this.showPanel(Page.IGNORE);
                    Collection data = (Collection)parameter;
                    ((IgnoreSettings)SettingsDialog.this.getPanel(IgnoreSettings.class)).selectItems(data);
                } else if (action.equals("selectMsgColor")) {
                    SettingsDialog.this.showPanel(Page.MSGCOLORS);
                    ((MsgColorSettings)SettingsDialog.this.getPanel(MsgColorSettings.class)).selectItem((String)parameter);
                } else if (action.equals("selectRouting")) {
                    SettingsDialog.this.showPanel(Page.CUSTOM_TABS);
                    Collection data = (Collection)parameter;
                    ((RoutingSettings)SettingsDialog.this.getPanel(RoutingSettings.class)).selectItems(data);
                } else if (action.equals("selectNotification")) {
                    SettingsDialog.this.showPanel(Page.NOTIFICATIONS);
                    long id = Long.parseLong((String)parameter);
                    ((NotificationSettings)SettingsDialog.this.getPanel(NotificationSettings.class)).selectItem(id);
                } else if (action.equals("show")) {
                    SettingsDialog.this.showPage((String)parameter);
                } else if (action.equals("editHotkey")) {
                    SettingsDialog.this.showPanel(Page.HOTKEYS);
                    ((HotkeySettings)SettingsDialog.this.getPanel(HotkeySettings.class)).edit((String)parameter);
                }
            }
        });
    }

    public void showPage(String page) {
        try {
            this.showPanel(Page.valueOf(page));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warning("Invalid settings page: " + page);
        }
    }

    private void showPanel(Page page) {
        this.cardManager.show(this.cards, page.name);
        this.currentlyShown = page;
        Tree.setSelected(this.selection, (Object)page);
        this.stuffBasedOnPanel();
    }

    private void loadSettings() {
        this.loadStringSettings();
        this.loadNumericSettings();
        this.loadBooleanSettings();
        this.loadListSettings();
        this.loadMapSettings();
        this.updateBackgroundColor();
        this.getPanel(UsercolorSettings.class).setData(this.owner.getUsercolorData());
        this.getPanel(MsgColorSettings.class).setData(this.owner.getMsgColorData());
        this.getPanel(ImageSettings.class).setData(this.owner.getUsericonData());
        this.getPanel(ImageSettings.class).setHiddenBadgesData(this.owner.getHiddenBadgesData());
        this.getPanel(ImageSettings.class).setTwitchBadgeTypes(this.owner.getTwitchBadgeTypes());
        this.getPanel(HotkeySettings.class).setData(this.owner.hotkeyManager.getActionsMap(), this.owner.hotkeyManager.getDescriptionsMap(), this.owner.hotkeyManager.getData(), this.owner.hotkeyManager.globalHotkeysAvailable());
        this.getPanel(NotificationSettings.class).setData(this.owner.getNotificationData());
        this.getPanel(EmoteSettings.class).setData(this.owner.localEmotes.getData());
        this.getPanel(RoutingSettings.class).setData(this.owner.routingManager.getData());
    }

    public void updateBackgroundColor() {
        Color foreground = HtmlColors.decode(this.getStringSetting("foregroundColor"));
        this.getPanel(MsgColorSettings.class).setDefaultForeground(foreground);
        Color background = HtmlColors.decode(this.getStringSetting("backgroundColor"));
        this.getPanel(UsercolorSettings.class).setDefaultBackground(background);
        this.getPanel(MsgColorSettings.class).setDefaultBackground(background);
    }

    private void loadStringSettings() {
        for (String settingName : this.stringSettings.keySet()) {
            StringSetting setting = this.stringSettings.get(settingName);
            String value = this.settings.getString(settingName);
            setting.setSettingValue(value);
        }
    }

    private void loadNumericSettings() {
        for (String settingName : this.longSettings.keySet()) {
            LongSetting setting = this.longSettings.get(settingName);
            Long value = this.settings.getLong(settingName);
            setting.setSettingValue(value);
        }
    }

    private void loadBooleanSettings() {
        for (String settingName : this.booleanSettings.keySet()) {
            BooleanSetting setting = this.booleanSettings.get(settingName);
            Boolean value = this.settings.getBoolean(settingName);
            setting.setSettingValue(value);
        }
    }

    private void loadListSettings() {
        for (String settingName : this.listSettings.keySet()) {
            ListSetting setting = this.listSettings.get(settingName);
            List data = this.settings.getList(settingName);
            setting.setSettingValue(data);
        }
    }

    private void loadMapSettings() {
        for (String settingName : this.mapSettings.keySet()) {
            MapSetting setting = this.mapSettings.get(settingName);
            Map data = this.settings.getMap(settingName);
            setting.setSettingValue(data);
        }
    }

    private void saveSettings() {
        Object[] options;
        int result;
        this.restartRequired = false;
        this.reconnectRequired = false;
        this.saveStringSettings();
        this.saveBooleanSettings();
        this.saveIntegerSettings();
        this.saveListSettings();
        this.saveMapSettings();
        this.owner.setUsercolorData(this.getPanel(UsercolorSettings.class).getData());
        this.owner.setMsgColorData(this.getPanel(MsgColorSettings.class).getData());
        this.owner.setUsericonData(this.getPanel(ImageSettings.class).getData());
        this.owner.setHiddenBadgesData(this.getPanel(ImageSettings.class).getHiddenBadgesData());
        this.owner.hotkeyManager.setData(this.getPanel(HotkeySettings.class).getData());
        this.owner.setNotificationData(this.getPanel(NotificationSettings.class).getData());
        this.owner.localEmotes.setData(this.getPanel(EmoteSettings.class).getData());
        this.owner.routingManager.setData(this.getPanel(RoutingSettings.class).getData());
        if (this.restartRequired) {
            JOptionPane.showMessageDialog(this, RESTART_REQUIRED_INFO, "Info", 1);
        }
        if (this.reconnectRequired && (result = JOptionPane.showOptionDialog(this, RECONNECT_REQUIRED_INFO, "Reconect?", 2, 1, null, options = new String[]{"Reconnect now", "Reconnect manually"}, null)) == 0) {
            this.owner.reconnect();
        }
    }

    private void saveStringSettings() {
        for (String settingName : this.stringSettings.keySet()) {
            StringSetting setting;
            String value;
            if (this.settings.setString(settingName, value = (setting = this.stringSettings.get(settingName)).getSettingValue()) != 5) continue;
            this.changed(settingName);
        }
    }

    private void saveBooleanSettings() {
        for (String settingName : this.booleanSettings.keySet()) {
            BooleanSetting setting;
            if (this.settings.setBoolean(settingName, (setting = this.booleanSettings.get(settingName)).getSettingValue()) != 5) continue;
            this.changed(settingName);
        }
    }

    private void saveIntegerSettings() {
        for (String settingName : this.longSettings.keySet()) {
            LongSetting setting = this.longSettings.get(settingName);
            Long value = setting.getSettingValue();
            if (value != null) {
                if (this.settings.setLong(settingName, setting.getSettingValue()) != 5) continue;
                this.changed(settingName);
                continue;
            }
            LOGGER.warning("Invalid number format for setting " + settingName);
        }
    }

    private void changed(String settingName) {
        if (this.restartRequiredDef.contains(settingName) || this.lafPreviewed) {
            this.restartRequired = true;
            this.reconnectRequired = false;
        }
        if (this.reconnectRequiredDef.contains(settingName) && !this.restartRequired) {
            this.reconnectRequired = true;
        }
    }

    private void saveListSettings() {
        for (String settingName : this.listSettings.keySet()) {
            ListSetting setting = this.listSettings.get(settingName);
            this.settings.putList(settingName, setting.getSettingValue());
            this.settings.setSettingChanged(settingName);
        }
    }

    private void saveMapSettings() {
        for (String settingName : this.mapSettings.keySet()) {
            MapSetting setting;
            boolean changed = this.settings.putMap(settingName, (setting = this.mapSettings.get(settingName)).getSettingValue());
            if (!changed) continue;
            this.settings.setSettingChanged(settingName);
        }
    }

    protected void showMatchingPresets() {
        this.matchingPresets.show(this);
    }

    protected static GridBagConstraints makeGbc(int x, int y, int w, int h) {
        return SettingsDialog.makeGbc(x, y, w, h, 10);
    }

    protected static GridBagConstraints makeGbc(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(4, 5, 4, 5);
        gbc.anchor = anchor;
        return gbc;
    }

    protected static GridBagConstraints makeNoGapGbc(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = anchor;
        return gbc;
    }

    protected static GridBagConstraints makeGbcCloser(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(1, 5, 1, 5);
        gbc.anchor = anchor;
        return gbc;
    }

    protected static GridBagConstraints makeGbcSub(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(1, 18, 2, 5);
        gbc.anchor = anchor;
        return gbc;
    }

    protected static GridBagConstraints makeGbcSub2(int x, int y, int w, int h, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(3, 18, 3, 5);
        gbc.anchor = anchor;
        return gbc;
    }

    protected static GridBagConstraints makeGbcStretchHorizontal(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        return gbc;
    }

    protected void addBooleanSetting(String name, BooleanSetting setting) {
        this.booleanSettings.put(name, setting);
    }

    public Boolean getBooleanSettingValue(String name) {
        if (this.booleanSettings.containsKey(name)) {
            return this.booleanSettings.get(name).getSettingValue();
        }
        return null;
    }

    protected SimpleBooleanSetting addSimpleBooleanSetting(String name) {
        return this.addSimpleBooleanSetting(name, Language.getString("settings.boolean." + name), Language.getString("settings.boolean." + name + ".tip", false));
    }

    protected SimpleBooleanSetting addSimpleBooleanSetting(String name, String description, String tooltipText) {
        SimpleBooleanSetting result = this.makeSimpleBooleanSetting(description, tooltipText);
        this.booleanSettings.put(name, result);
        return result;
    }

    protected SimpleBooleanSetting makeSimpleBooleanSetting(String labelName) {
        return this.makeSimpleBooleanSetting(Language.getString("settings.label." + labelName), Language.getString("settings.label." + labelName + ".tip", false));
    }

    protected SimpleBooleanSetting makeSimpleBooleanSetting(String description, String tooltipText) {
        tooltipText = SettingsUtil.addTooltipLinebreaks(tooltipText);
        return new SimpleBooleanSetting(description, tooltipText);
    }

    protected void setBooleanSetting(String name, Boolean value) {
        if (this.booleanSettings.containsKey(name)) {
            this.booleanSettings.get(name).setSettingValue(value);
        }
    }

    protected Boolean getBooleanSetting(String name) {
        if (this.booleanSettings.containsKey(name)) {
            return this.booleanSettings.get(name).getSettingValue();
        }
        return null;
    }

    protected ComboStringSetting addComboStringSetting(String name, boolean editable, String ... choices) {
        LinkedHashMap<String, String> localizedChoices = new LinkedHashMap<String, String>();
        for (String choice : choices) {
            String label = Language.getString("settings.string." + name + ".option." + choice, false);
            if (label != null) {
                localizedChoices.put(choice, label);
                continue;
            }
            localizedChoices.put(choice, choice);
        }
        ComboStringSetting result = new ComboStringSetting((Map<String, String>)localizedChoices);
        result.setEditable(editable);
        this.stringSettings.put(name, result);
        return result;
    }

    protected ComboStringSetting addComboStringSetting(String name, int size, boolean editable, Map<String, String> choices) {
        ComboStringSetting result = new ComboStringSetting(choices);
        result.setEditable(editable);
        this.stringSettings.put(name, result);
        return result;
    }

    protected StringSetting addStringSetting(String settingName, StringSetting setting) {
        this.stringSettings.put(settingName, setting);
        return setting;
    }

    protected JTextField addSimpleStringSetting(String settingName, int size, boolean editable) {
        return this.addSimpleStringSetting(settingName, size, editable, null);
    }

    protected JTextField addSimpleStringSetting(String settingName, int size, boolean editable, DataFormatter<String> formatter) {
        SimpleStringSetting s = new SimpleStringSetting(size, editable, formatter);
        this.addStringSetting(settingName, s);
        return s;
    }

    protected EditorStringSetting addEditorStringSetting(String settingName, int size, boolean editable, String title, boolean linebreaks, String info) {
        return this.addEditorStringSetting(settingName, size, editable, title, linebreaks, info, null);
    }

    protected EditorStringSetting addEditorStringSetting(String settingName, int size, boolean editable, String title, boolean linebreaks, String info, Editor.Tester tester) {
        EditorStringSetting s = new EditorStringSetting(this, title, size, true, linebreaks, info, tester);
        this.addStringSetting(settingName, s);
        return s;
    }

    protected HotkeyPanel addHotkeyPanel(String actionId, Hotkey.Type type) {
        return this.getPanel(HotkeySettings.class).createHotkeyPanel(actionId, type);
    }

    protected void setStringSetting(String name, String value) {
        if (this.stringSettings.containsKey(name)) {
            this.stringSettings.get(name).setSettingValue(value);
        }
    }

    public String getStringSetting(String name) {
        if (this.stringSettings.containsKey(name)) {
            return this.stringSettings.get(name).getSettingValue();
        }
        return null;
    }

    protected JTextField addSimpleLongSetting(String name, int size, boolean editable) {
        SimpleLongSetting result = new SimpleLongSetting(size, editable);
        this.addLongSetting(name, result);
        return result;
    }

    protected ComboLongSetting addComboLongSetting(String name, int ... choices) {
        return this.addComboLongSetting(name, false, choices);
    }

    protected ComboLongSetting addComboLongSetting(String name, boolean editable, int ... choices) {
        LinkedHashMap<Long, String> localizedChoices = new LinkedHashMap<Long, String>();
        int[] nArray = choices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer choice = nArray[i];
            String label = Language.getString("settings.long." + name + ".option." + choice, false);
            if (label == null) {
                label = String.valueOf(choice);
            }
            localizedChoices.put((long)choice, label);
        }
        ComboLongSetting result = new ComboLongSetting((Map<Long, String>)localizedChoices);
        result.setEditable(editable);
        result.setToolTipText(SettingsUtil.addTooltipLinebreaks(Language.getString("settings.long." + name + ".tip", false)));
        this.longSettings.put(name, result);
        return result;
    }

    protected void addLongSetting(String settingName, LongSetting setting) {
        this.longSettings.put(settingName, setting);
    }

    protected void setLongSetting(String name, Long value) {
        if (this.longSettings.containsKey(name)) {
            this.longSettings.get(name).setSettingValue(value);
        }
    }

    public Long getLongSetting(String name) {
        if (this.longSettings.containsKey(name)) {
            return this.longSettings.get(name).getSettingValue();
        }
        return null;
    }

    protected ListSelector addListSetting(String name, String title, int width, int height, boolean manualSorting, boolean alphabeticSorting) {
        ListSelector result = new ListSelector(this, title, manualSorting, alphabeticSorting);
        result.setPreferredSize(new Dimension(width, height));
        this.listSettings.put(name, result);
        return result;
    }

    protected void addMapSetting(String name, MapSetting setting) {
        this.mapSettings.put(name, setting);
    }

    protected SimpleTableEditor<String> addStringMapSetting(String name, int width, int height, String keyLabel, String valueLabel) {
        SimpleTableEditor<String> table = new SimpleTableEditor<String>((JDialog)this, String.class, keyLabel, valueLabel){

            @Override
            protected String valueFromString(String input) {
                return input;
            }
        };
        table.setPreferredSize(new Dimension(width, height));
        this.mapSettings.put(name, table);
        return table;
    }

    protected SimpleTableEditor<Long> addLongMapSetting(String name, int width, int height, String keyLabel, String valueLabel) {
        SimpleTableEditor<Long> table = new SimpleTableEditor<Long>((JDialog)this, Long.class, keyLabel, valueLabel){

            @Override
            protected Long valueFromString(String input) {
                try {
                    return Long.valueOf(input);
                }
                catch (NumberFormatException ex) {
                    return 0L;
                }
            }
        };
        table.setValueFilter("[^0-9]");
        table.setPreferredSize(new Dimension(width, height));
        table.setTableEditorEditAllHandler(new TableEditor.TableEditorEditAllHandler<SimpleTableEditor.MapItem<Long>>(){
            private final Pattern PARSE_LINE = Pattern.compile("(.*) (-?[0-9]+)");

            @Override
            public String toString(List<SimpleTableEditor.MapItem<Long>> data) {
                StringBuilder b = new StringBuilder();
                for (SimpleTableEditor.MapItem<Long> entry : data) {
                    b.append(entry.key).append(" ").append(entry.value).append("\n");
                }
                return b.toString();
            }

            @Override
            public List<SimpleTableEditor.MapItem<Long>> toData(String input) {
                String[] split;
                ArrayList<SimpleTableEditor.MapItem<Long>> result = new ArrayList<SimpleTableEditor.MapItem<Long>>();
                for (String line : split = StringUtil.splitLines(input)) {
                    Matcher m = this.PARSE_LINE.matcher(line);
                    if (!m.matches()) continue;
                    try {
                        result.add(new SimpleTableEditor.MapItem<Long>(m.group(1), Long.valueOf(m.group(2))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return result;
            }

            @Override
            public StringEditor getEditor() {
                return null;
            }

            @Override
            public String getEditorTitle() {
                return "Edit all entries";
            }

            @Override
            public String getEditorHelp() {
                return null;
            }
        });
        this.mapSettings.put(name, table);
        return table;
    }

    protected void clearHistory() {
        this.owner.clearHistory();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.save();
        } else if (e.getSource() == this.cancel) {
            this.cancel();
        }
    }

    private void save() {
        this.saveSettings();
        this.close();
    }

    private void cancel() {
        Sound.setDeviceName(this.settings.getString("soundDevice"));
        Sound.setCommand(this.settings.getBoolean("soundCommandEnabled"), this.settings.getString("soundCommand"));
        if (this.lafPreviewed) {
            LaF.setLookAndFeel(LaF.LaFSettings.fromSettings(this.settings));
            LaF.updateLookAndFeel();
        }
        this.close();
    }

    private void close() {
        this.owner.hotkeyManager.setEnabled(true);
        this.setVisible(false);
        this.dispose();
    }

    protected LinkLabelListener getLinkLabelListener() {
        return this.owner.getLinkLabelListener();
    }

    protected LinkLabelListener getSettingsHelpLinkLabelListener() {
        return this.settingsHelpLinkLabelListener;
    }

    private void search(String search) {
        this.resetSearchHighlights();
        if (search != null && search.length() > 2) {
            search = StringUtil.toLowerCase(search);
            for (Map.Entry<Page, SettingsPanel> panel : this.panels.entrySet()) {
                int numResults = this.search2(search, panel.getValue());
                if (numResults <= 0) continue;
                ((Tree.HighlightTreeCellRenderer)this.selection.getCellRenderer()).setHighlight((Object)panel.getKey(), true);
            }
        }
        this.selection.repaint();
    }

    private void addSearchHighlight(Component comp) {
        if (this.stateBeforeSearch.containsKey(comp)) {
            return;
        }
        JComponent component = (JComponent)comp;
        Color color = comp.isBackgroundSet() ? comp.getBackground() : null;
        this.stateBeforeSearch.put(comp, new State(color, component.isOpaque()));
        if (!component.isOpaque()) {
            component.setOpaque(true);
        }
        comp.setBackground(this.searchHighlightColor);
    }

    private void resetSearchHighlights() {
        for (Page page : this.panels.keySet()) {
            ((Tree.HighlightTreeCellRenderer)this.selection.getCellRenderer()).setHighlight((Object)page, false);
        }
        for (Map.Entry entry : this.stateBeforeSearch.entrySet()) {
            Component comp = (Component)entry.getKey();
            if (comp instanceof JTabbedPane) {
                JTabbedPane tabs = (JTabbedPane)comp;
                for (int i = 0; i < tabs.getTabCount(); ++i) {
                    tabs.setBackgroundAt(i, null);
                }
                continue;
            }
            JComponent component = (JComponent)entry.getKey();
            component.setBackground(((State)entry.getValue()).color);
            component.setOpaque(((State)entry.getValue()).opaque);
        }
        this.stateBeforeSearch.clear();
    }

    private int search2(String search, Container container) {
        int numResults = 0;
        for (Component comp : container.getComponents()) {
            int subResults = 0;
            if (comp instanceof Container && !(comp instanceof JList) && !(comp instanceof JTable)) {
                subResults = this.search2(search, (Container)comp);
            }
            if (subResults > 0 && comp instanceof JTabbedPane) {
                JTabbedPane tabs = (JTabbedPane)comp;
                boolean highlighted = false;
                for (int i = 0; i < tabs.getTabCount(); ++i) {
                    for (Component hl : this.stateBeforeSearch.keySet()) {
                        if (!SwingUtilities.isDescendingFrom(hl, tabs.getComponentAt(i))) continue;
                        tabs.setBackgroundAt(i, this.searchHighlightColor);
                        highlighted = true;
                    }
                }
                if (highlighted) {
                    this.stateBeforeSearch.put(tabs, null);
                }
            }
            if (this.checkSearchComponent(comp, search)) {
                ++numResults;
                this.addSearchHighlight(comp);
            }
            numResults += subResults;
        }
        return numResults;
    }

    private boolean checkSearchComponent(Component comp, String search) {
        if (comp instanceof JLabel) {
            if (this.checkSearchText(((JLabel)comp).getText(), search)) {
                return true;
            }
            if (this.checkSearchText(((JLabel)comp).getToolTipText(), search)) {
                return true;
            }
        }
        if (comp instanceof JEditorPane && this.checkSearchText(((JEditorPane)comp).getText(), search)) {
            return true;
        }
        if (comp instanceof JCheckBox) {
            if (this.checkSearchText(((JCheckBox)comp).getText(), search)) {
                return true;
            }
            if (this.checkSearchText(((JCheckBox)comp).getToolTipText(), search)) {
                return true;
            }
        }
        return comp instanceof JButton && this.checkSearchText(((JButton)comp).getText(), search);
    }

    private boolean checkSearchText(String text, String search) {
        if (text == null || search == null) {
            return false;
        }
        return StringUtil.toLowerCase(text).contains(search);
    }

    static {
        RESTART_REQUIRED_INFO = "<html><body style='width: 280px'>" + Language.getString("settings.restartRequired");
        MENU = new LinkedHashMap<Page, List<Page>>();
        MENU.put(Page.MAIN, Arrays.asList(new Page[0]));
        MENU.put(Page.LOOK, Arrays.asList(Page.CHATCOLORS, Page.MSGCOLORS, Page.USERCOLORS, Page.USERICONS, Page.EMOTES, Page.FONTS));
        MENU.put(Page.CHAT, Arrays.asList(Page.MESSAGES, Page.MODERATION, Page.NAMES, Page.HIGHLIGHT, Page.IGNORE, Page.FILTER, Page.CUSTOM_TABS, Page.LOGGING, Page.SHARED_CHAT));
        MENU.put(Page.WINDOW, Arrays.asList(Page.TABS, Page.NOTIFICATIONS, Page.TTS, Page.LIVE_STREAMS));
        MENU.put(Page.OTHER, Arrays.asList(Page.COMMANDS, Page.ADVANCED, Page.COMPLETION, Page.HISTORY, Page.STREAM, Page.HOTKEYS));
        MENU.put(Page.SIMPLE, Arrays.asList(new Page[0]));
    }

    public static enum Page {
        MAIN("Main", Language.getString("settings.page.main")),
        MESSAGES("Messages", Language.getString("settings.page.messages")),
        EMOTES("Emoticons", Language.getString("settings.page.emoticons")),
        USERICONS("Usericons", Language.getString("settings.page.usericons")),
        LOOK("Look", Language.getString("settings.page.look")),
        FONTS("Fonts", Language.getString("settings.page.fonts")),
        CHATCOLORS("Chat Colors", Language.getString("settings.page.chatColors")),
        MSGCOLORS("Message Colors", Language.getString("settings.page.msgColors")),
        HIGHLIGHT("Highlight", Language.getString("settings.page.highlight")),
        IGNORE("Ignore", Language.getString("settings.page.ignore")),
        FILTER("Filter", Language.getString("settings.page.filter")),
        CUSTOM_TABS("Custom Tabs", Language.getString("settings.page.customTabs")),
        SHARED_CHAT("Shared Chat", Language.getString("settings.page.sharedChat")),
        HISTORY("History", Language.getString("settings.page.history")),
        NOTIFICATIONS("Notifications", Language.getString("settings.page.notifications")),
        TTS("TTS", Language.getString("settings.page.tts")),
        LIVE_STREAMS("Live Streams", Language.getString("settings.page.liveStreams")),
        USERCOLORS("Usercolors", Language.getString("settings.page.usercolors")),
        LOGGING("Log to file", Language.getString("settings.page.logging")),
        WINDOW("Window", Language.getString("settings.page.window")),
        TABS("Tabs", Language.getString("settings.page.tabs")),
        COMMANDS("Commands", Language.getString("settings.page.commands")),
        OTHER("Other", Language.getString("settings.page.other")),
        ADVANCED("Advanced", Language.getString("settings.page.advanced")),
        HOTKEYS("Hotkeys", Language.getString("settings.page.hotkeys")),
        COMPLETION("TAB Completion", Language.getString("settings.page.completion")),
        CHAT("Chat", Language.getString("settings.page.chat")),
        NAMES("Names", Language.getString("settings.page.names")),
        MODERATION("Moderation", Language.getString("settings.page.moderation")),
        STREAM("Stream", Language.getString("settings.page.stream")),
        SIMPLE("Simple Settings", Language.getString("settings.page.simple"));

        public final String name;
        public final String displayName;

        private Page(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static class State {
        private final Color color;
        private final boolean opaque;

        public State(Color color, boolean opaque) {
            this.color = color;
            this.opaque = opaque;
        }
    }
}

