/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

public class SettingsUtil {
    private static final Border PADDING = BorderFactory.createEmptyBorder(5, 5, 5, 5);

    public static void addSubsettings(JCheckBox control, Component ... subs) {
        control.addItemListener(e -> {
            for (Component sub : subs) {
                if (sub == control) continue;
                sub.setEnabled(control.isSelected() && control.isEnabled());
            }
        });
        control.addPropertyChangeListener("enabled", e -> {
            for (Component sub : subs) {
                if (sub == control) continue;
                sub.setEnabled(control.isSelected() && control.isEnabled());
            }
        });
        for (Component sub : subs) {
            if (sub == control) continue;
            sub.setEnabled(false);
        }
    }

    public static void addSubsettings(JRadioButton[] radioButtons, Component ... subs) {
        Runnable update = () -> {
            boolean enabled = false;
            for (JRadioButton button : radioButtons) {
                if (!button.isSelected() || !button.isEnabled()) continue;
                enabled = true;
                break;
            }
            for (Component comp : subs) {
                if (Arrays.asList(radioButtons).contains(comp)) continue;
                comp.setEnabled(enabled);
            }
        };
        for (JRadioButton button : radioButtons) {
            button.addItemListener(e -> update.run());
        }
        for (JRadioButton button : radioButtons) {
            button.addPropertyChangeListener("enabled", e -> update.run());
        }
        update.run();
    }

    public static void addSubsettings(ComboStringSetting control, Function<String, Boolean> req, Component ... subs) {
        control.addSettingChangeListener(c -> {
            String selected = control.getSettingValue();
            for (Component sub : subs) {
                sub.setEnabled((Boolean)req.apply(selected));
            }
        });
        for (Component sub : subs) {
            sub.setEnabled(false);
        }
    }

    public static void addSubsettings(ComboLongSetting control, Function<Long, Boolean> req, Component ... subs) {
        control.addSettingChangeListener(c -> {
            Long selected = (Long)control.getSettingValue();
            for (Component sub : subs) {
                sub.setEnabled((Boolean)req.apply(selected));
            }
        });
        for (Component sub : subs) {
            sub.setEnabled(false);
        }
    }

    public static String addTooltipLinebreaks(String tooltipText) {
        if (tooltipText != null && !tooltipText.isEmpty()) {
            tooltipText = "<html><body>" + StringUtil.addLinebreaks(tooltipText, 70, true);
        }
        return tooltipText;
    }

    public static JPanel createStandardGapPanel() {
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout(1, 5, 4));
        return result;
    }

    public static String removeHtmlConditions(String input, String type) {
        input = input.replaceAll(String.format("(?s)<!--#START:(?!%1$s(?!\\w+))\\w+#-->(.*?)<!--#END:(?!%1$s(?!\\w+))\\w+#-->", type), "");
        input = input.replaceAll(String.format("(?s)<!--#START:!%1$s#-->(.*?)<!--#END:!%1$s#-->", type), "");
        return input;
    }

    public static String getInfo(String file, String type) {
        String html = StringUtil.stringFromInputStream(SettingsUtil.class.getResourceAsStream(file));
        if (type != null) {
            return SettingsUtil.removeHtmlConditions(html, type);
        }
        return html;
    }

    public static JLabel createLabel(String settingName) {
        return SettingsUtil.createLabel(settingName, false);
    }

    public static JLabel createLabel(String settingName, boolean info) {
        String baseKey = "settings.label." + settingName;
        if (settingName.contains(".")) {
            baseKey = settingName;
        }
        String text = Language.getString(baseKey);
        String tip = Language.getString(baseKey + ".tip", false);
        JLabel label = info ? new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + text) : new JLabel(text);
        label.setToolTipText(SettingsUtil.addTooltipLinebreaks(tip));
        return label;
    }

    public static void addLabeledComponent(JPanel panel, String labelSettingName, int x, int y, int w, int labelAlign, JComponent component) {
        SettingsUtil.addLabeledComponent(panel, labelSettingName, x, y, w, labelAlign, component, false);
    }

    public static void addLabeledComponent(JPanel panel, String labelSettingName, int x, int y, int w, int labelAlign, JComponent component, boolean stretchComponent) {
        SettingsUtil.addLabeledComponent(panel, labelSettingName, x, y, w, labelAlign, component, stretchComponent, false);
    }

    public static void addLabeledComponent(JPanel panel, String labelSettingName, int x, int y, int w, int labelAlign, JComponent component, boolean stretchComponent, boolean sub) {
        JLabel label = SettingsUtil.createLabel(labelSettingName);
        label.setLabelFor(component);
        panel.add((Component)label, SettingsDialog.makeGbcSub(x, y, 1, 1, labelAlign));
        GridBagConstraints gbc = SettingsDialog.makeGbc(x + 1, y, w, 1, 17);
        if (stretchComponent) {
            gbc.fill = 1;
        }
        panel.add((Component)component, gbc);
    }

    public static void setTextAndTooltip(AbstractButton button, String langKey) {
        button.setText(Language.getString(langKey));
        button.setToolTipText(SettingsUtil.addTooltipLinebreaks(Language.getString(langKey + ".tip")));
    }

    public static void addStandardSetting(JPanel panel, String name, int y, JComponent component) {
        SettingsUtil.addStandardSetting(panel, name, y, component, false);
    }

    public static void addStandardSubSetting(JPanel panel, String name, int y, JComponent component) {
        SettingsUtil.addStandardSetting(panel, name, y, component, true);
    }

    public static void addStandardSetting(JPanel panel, String name, int y, JComponent component, boolean sub) {
        if (component instanceof JCheckBox) {
            if (sub) {
                panel.add((Component)component, SettingsDialog.makeGbcSub(0, y, 2, 1, 17));
            } else {
                panel.add((Component)component, SettingsDialog.makeGbc(0, y, 2, 1, 17));
            }
        } else {
            SettingsUtil.addLabeledComponent(panel, name, 0, y, 1, 13, component, false, sub);
        }
    }

    public static JPanel createPanel(String settingName, JComponent ... settingComponent) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.insets = new Insets(0, 0, 0, gbc.insets.right);
        panel.add((Component)SettingsUtil.createLabel(settingName), gbc);
        gbc = SettingsDialog.makeGbc(1, 0, 1, 1);
        gbc.insets = new Insets(0, gbc.insets.left, 0, 0);
        for (JComponent comp : settingComponent) {
            panel.add((Component)comp, gbc);
            ++gbc.gridx;
        }
        return panel;
    }

    public static JPanel topAlign(JPanel panel, int y) {
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, y, 1, 1, 17);
        gbc.weighty = 1.0;
        panel.add((Component)new JLabel(), gbc);
        panel.setBorder(PADDING);
        return panel;
    }
}

