/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.RegexDocumentFilter;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.MapSetting;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;

public abstract class SimpleTableEditor<T>
extends TableEditor<MapItem<T>>
implements MapSetting<String, T> {
    private final MyTableModel<T> data;
    private MyItemEditor editor;
    private DocumentFilter keyFilter;
    private DocumentFilter valueFilter;

    public SimpleTableEditor(JDialog owner, Class<T> valueClass, String keyLabel, String valueLabel) {
        super(1, false);
        this.data = new MyTableModel<T>(valueClass, keyLabel, valueLabel);
        this.setModel(this.data);
        this.setItemEditor(() -> {
            if (this.editor == null) {
                this.editor = new MyItemEditor(owner, keyLabel, valueLabel);
                this.editor.setKeyFilter(this.keyFilter);
                this.editor.setValueFilter(this.valueFilter);
            }
            return this.editor;
        });
    }

    public void edit(String item) {
        MapItem<T> preset = new MapItem<T>(item, this.valueFromString(""));
        int index = this.data.indexOf(preset);
        if (index == -1) {
            this.addItem(preset);
        } else {
            this.editItem(index);
        }
    }

    protected abstract T valueFromString(String var1);

    public void setKeyFilter(String p) {
        this.keyFilter = new RegexDocumentFilter(p, this);
        if (this.editor != null) {
            this.editor.setKeyFilter(this.keyFilter);
        }
    }

    public void setValueFilter(String p) {
        this.valueFilter = new RegexDocumentFilter(p, this);
        if (this.editor != null) {
            this.editor.setValueFilter(this.valueFilter);
        }
    }

    public void setValueDocumentFilter(DocumentFilter filter) {
        this.valueFilter = filter;
        if (this.editor != null) {
            this.editor.setValueFilter(filter);
        }
    }

    @Override
    public Map<String, T> getSettingValue() {
        HashMap map = new HashMap();
        for (MapItem item : this.data.getData()) {
            map.put(item.key, item.value);
        }
        return map;
    }

    @Override
    public void setSettingValue(Map<String, T> values) {
        this.data.clear();
        ArrayList<MapItem<T>> items = new ArrayList<MapItem<T>>();
        for (String key : values.keySet()) {
            items.add(new MapItem<T>(key, values.get(key)));
        }
        this.setData(items);
    }

    private boolean hasKey(String key) {
        for (MapItem item : this.data.getData()) {
            if (!item.key.equals(key)) continue;
            return true;
        }
        return false;
    }

    private static class MyTableModel<T>
    extends ListTableModel<MapItem<T>> {
        private Class<T> valueClass;

        public MyTableModel(Class<T> valueClass, String keyLabel, String valueLabel) {
            super(new String[]{keyLabel, valueLabel});
            this.valueClass = valueClass;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((MapItem)this.get((int)rowIndex)).key;
            }
            return ((MapItem)this.get((int)rowIndex)).value;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            return this.valueClass;
        }
    }

    static class MapItem<T> {
        public final String key;
        public final T value;

        public MapItem(String key, T value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapItem other = (MapItem)obj;
            return Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.key);
            return hash;
        }
    }

    private class MyItemEditor
    implements TableEditor.ItemEditor<MapItem<T>> {
        private final JDialog dialog;
        private final JTextField key = new JTextField(20);
        private final JTextField value = new JTextField();
        private final JButton ok = new JButton(Language.getString("dialog.button.save"));
        private final JButton cancel = new JButton(Language.getString("dialog.button.cancel"));
        private String presetKey;
        private boolean save;

        public MyItemEditor(JDialog owner, String keyLabel, String valueLabel) {
            this.dialog = new JDialog(owner);
            this.dialog.setTitle("Edit Item");
            this.dialog.setModal(true);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    MyItemEditor.this.updateButtons();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    MyItemEditor.this.updateButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    MyItemEditor.this.updateButtons();
                }
            };
            GuiUtil.installEscapeCloseOperation(this.dialog);
            this.key.getDocument().addDocumentListener(documentListener);
            this.value.getDocument().addDocumentListener(documentListener);
            this.key.addActionListener(e -> this.save());
            this.value.addActionListener(e -> this.save());
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == MyItemEditor.this.ok) {
                        MyItemEditor.this.save();
                    } else if (e.getSource() == MyItemEditor.this.cancel) {
                        MyItemEditor.this.dialog.setVisible(false);
                    }
                }
            };
            this.ok.addActionListener(listener);
            this.cancel.addActionListener(listener);
            this.dialog.setLayout(new GridBagLayout());
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
            this.dialog.add((Component)new JLabel(keyLabel + ":"), gbc);
            gbc = GuiUtil.makeGbc(1, 0, 2, 1);
            gbc.fill = 2;
            this.dialog.add((Component)this.key, gbc);
            gbc = GuiUtil.makeGbc(0, 1, 1, 1);
            this.dialog.add((Component)new JLabel(valueLabel + ":"), gbc);
            gbc = GuiUtil.makeGbc(1, 1, 2, 1);
            gbc.fill = 2;
            this.dialog.add((Component)this.value, gbc);
            gbc = GuiUtil.makeGbc(1, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.dialog.add((Component)this.ok, gbc);
            this.ok.setMnemonic(83);
            gbc = GuiUtil.makeGbc(2, 2, 1, 1);
            this.dialog.add((Component)this.cancel, gbc);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }

        private void save() {
            if (!this.getKey().equals(this.presetKey) && SimpleTableEditor.this.hasKey(this.getKey())) {
                JOptionPane.showMessageDialog(this.dialog, "An item with the key '" + this.getKey() + "' already exists");
            } else {
                this.dialog.setVisible(false);
                this.save = true;
            }
        }

        @Override
        public MapItem<T> showEditor(MapItem<T> preset, Component c, boolean edit, int column) {
            this.save = false;
            if (edit) {
                this.dialog.setTitle("Edit item");
            } else {
                this.dialog.setTitle("Add item");
            }
            this.dialog.setLocationRelativeTo(c);
            if (preset != null) {
                this.key.setText(preset.key);
                this.value.setText(String.valueOf(preset.value));
                this.presetKey = preset.key;
            } else {
                this.key.setText(null);
                this.value.setText(null);
                this.presetKey = null;
            }
            if (column == 0 || preset == null) {
                this.key.requestFocusInWindow();
            } else if (column == 1) {
                this.value.requestFocusInWindow();
            }
            this.updateButtons();
            this.dialog.setVisible(true);
            if (this.save) {
                return new MapItem(this.getKey(), SimpleTableEditor.this.valueFromString(this.value.getText()));
            }
            return null;
        }

        private String getKey() {
            return this.key.getText();
        }

        private void updateButtons() {
            boolean enabled = !this.getKey().isEmpty() && !this.value.getText().isEmpty();
            this.ok.setEnabled(enabled);
        }

        public void setKeyFilter(DocumentFilter keyFilter) {
            this.setFilter(this.key, keyFilter);
        }

        public void setValueFilter(DocumentFilter valueFilter) {
            this.setFilter(this.value, valueFilter);
        }

        private void setFilter(JTextField textField, DocumentFilter filter) {
            if (filter instanceof RegexDocumentFilter) {
                filter = new RegexDocumentFilter(((RegexDocumentFilter)filter).getRegex(), textField);
            }
            ((AbstractDocument)textField.getDocument()).setDocumentFilter(filter);
        }
    }
}

