/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.LongSetting;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderLongSetting
extends JPanel
implements LongSetting {
    private final JSlider slider;
    private long value = 0L;
    private final JLabel valueLabel;
    private static final String LABEL_PREFIX = "<html><body style='width: 30px;text-align: right;border: 1px solid #AAAAAA;margin-left: 4px;padding-right: 2px;'>";

    public SliderLongSetting(int orientation, int min, int max, int presetValue) {
        this.slider = new JSlider(orientation, min, max, presetValue);
        this.value = presetValue;
        this.valueLabel = new JLabel(LABEL_PREFIX);
        this.valueLabel.setMinimumSize(this.valueLabel.getPreferredSize());
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderLongSetting.this.value = SliderLongSetting.this.slider.getValue();
                SliderLongSetting.this.updateLabel();
            }
        });
        this.add(this.slider);
        this.add(this.valueLabel);
    }

    @Override
    public Long getSettingValue() {
        return this.value;
    }

    @Override
    public Long getSettingValue(Long def) {
        return this.value;
    }

    @Override
    public void setSettingValue(Long value) {
        this.slider.setValue(value.intValue());
        this.value = value;
        this.updateLabel();
    }

    private void updateLabel() {
        this.valueLabel.setText(LABEL_PREFIX + new Long(this.value).toString());
    }

    public void setMajorTickSpacing(int value) {
        this.slider.setMajorTickSpacing(value);
    }

    public void setMinorTickSpacing(int value) {
        this.slider.setMinorTickSpacing(value);
    }

    public void setPaintLabels(boolean value) {
        this.slider.setPaintLabels(value);
    }

    public void setPaintTicks(boolean value) {
        this.slider.setPaintTicks(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.slider.setEnabled(enabled);
    }

    public void addChangeListener(ChangeListener l) {
        this.slider.addChangeListener(l);
    }
}

