/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Helper;
import chatty.gui.GuiUtil;
import chatty.gui.components.settings.CommandSettings;
import chatty.gui.components.settings.DataFormatter;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.EditorStringSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.api.StreamCategory;
import chatty.util.api.StreamInfo;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.Component;
import java.awt.Window;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StreamSettings
extends SettingsPanel {
    public StreamSettings(final SettingsDialog d) {
        Editor.Tester tester = new Editor.Tester(){

            @Override
            public String test(Window parent, Component component, int x, int y, String value) {
                CustomCommand command = CustomCommand.parse(value);
                if (command.hasError()) {
                    CommandSettings.showCommandInfoPopup(component, command);
                } else {
                    StreamInfo streamInfo = new StreamInfo("channel", null);
                    streamInfo.set("Interesting Stream Title!", new StreamCategory("id", "Game"), 123, Instant.now().minus(2L, ChronoUnit.HOURS).toEpochMilli(), StreamInfo.StreamType.LIVE);
                    Parameters params = Parameters.create("");
                    params.putObject("streamInfo", streamInfo);
                    params.put("added", "highlight" + (d.getBooleanSetting("streamHighlightMarker") != false ? "/marker" : ""));
                    params.put("addedmarker", "true");
                    params.put("chan", "#channel");
                    params.put("uptime", "1h 57m 30s");
                    params.put("timestamp", DateTime.fullDateTime());
                    params.put("comment", "(Funny jump in th..)");
                    params.put("rawcomment", "Funny jump in the first level");
                    params.put("fullcomment", "(Funny jump in the first level)");
                    String localCommand = command.replace(params);
                    params.put("chatuser", "Username");
                    params.put("comment", "([Username] Funny jum..)");
                    params.put("fullcomment", "([Username] Funny jump in the first level)");
                    String chatCommand = command.replace(params);
                    params.put("added", "highlight");
                    params.remove("addedmarker");
                    params.remove("comment");
                    params.remove("fullcomment");
                    params.remove("rawcomment");
                    String withoutComment = command.replace(params);
                    params.put("uptime", "Stream Time N/A");
                    streamInfo.setOffline();
                    streamInfo.setOffline();
                    String offlineStream = command.replace(params);
                    GuiUtil.showNonModalMessage(parent, "Example", String.format("Triggered by chat command:<br />%s<br /><br />Triggered by local command:<br />%s<br /><br />Without comment, no marker:<br />%s<br /><br />Offline stream, no marker:<br />%s", Helper.htmlspecialchars_encode(chatCommand), Helper.htmlspecialchars_encode(localCommand), Helper.htmlspecialchars_encode(withoutComment), Helper.htmlspecialchars_encode(offlineStream)), 1, true);
                }
                return null;
            }
        };
        JPanel hlPanel = this.addTitledPanel(Language.getString("settings.section.streamHighlights"), 0);
        hlPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.streamHighlights.info")), SettingsDialog.makeGbc(0, 0, 2, 1));
        hlPanel.add((Component)d.addSimpleBooleanSetting("streamHighlightMarker"), SettingsDialog.makeGbc(0, 1, 2, 1, 17));
        hlPanel.add((Component)d.addSimpleBooleanSetting("streamHighlightExtra"), SettingsDialog.makeGbc(0, 2, 2, 1, 17));
        SimpleBooleanSetting customEnabled = d.addSimpleBooleanSetting("streamHighlightCustomEnabled");
        hlPanel.add((Component)customEnabled, SettingsDialog.makeGbc(0, 3, 2, 1, 17));
        EditorStringSetting customOutput = d.addEditorStringSetting("streamHighlightCustom", 30, true, Language.getString("settings.streamHighlights.customOutput"), false, "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-streamhighlightmsg.html", null), tester);
        customOutput.setLinkLabelListener(d.getLinkLabelListener());
        hlPanel.add((Component)customOutput, SettingsDialog.makeGbc(0, 4, 2, 1, 17));
        SettingsUtil.addSubsettings(customEnabled, customOutput);
        SettingsUtil.addLabeledComponent(hlPanel, "streamHighlightCooldown", 0, 5, 2, 17, d.addComboLongSetting("streamHighlightCooldown", true, 0, 5, 10, 15, 20, 25, 30, 60, 120));
        JPanel commandPanel = this.addTitledPanel(Language.getString("settings.section.streamHighlightsCommand"), 1);
        commandPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + Language.getString("settings.streamHighlights.matchInfo")), SettingsDialog.makeGbc(0, 2, 2, 1));
        commandPanel.add((Component)new JLabel(Language.getString("settings.streamHighlights.channel")), SettingsDialog.makeGbc(0, 3, 1, 1, 17));
        commandPanel.add((Component)d.addSimpleStringSetting("streamHighlightChannel", 20, true, DataFormatter.TRIM), SettingsDialog.makeGbc(1, 3, 1, 1, 17));
        commandPanel.add((Component)new JLabel(Language.getString("settings.streamHighlights.command")), SettingsDialog.makeGbc(0, 4, 1, 1, 17));
        commandPanel.add((Component)d.addSimpleStringSetting("streamHighlightCommand", 20, true, DataFormatter.TRIM), SettingsDialog.makeGbc(1, 4, 1, 1, 17));
        LinkedHashMap<String, String> presets = new LinkedHashMap<String, String>();
        presets.put("", "Nobody");
        presets.put("status:bm", "Moderators");
        presets.put("status:bmv", "Moderators/VIPs");
        presets.put("status:bmvs", "Moderators/VIPs/Subscribers");
        commandPanel.add((Component)new JLabel(Language.getString("settings.streamHighlights.match")), SettingsDialog.makeGbc(0, 5, 1, 1, 17));
        commandPanel.add((Component)d.addComboStringSetting("streamHighlightMatch", 20, false, presets), SettingsDialog.makeGbc(1, 5, 1, 1, 17));
        SimpleBooleanSetting respondWithMessage = d.addSimpleBooleanSetting("streamHighlightChannelRespond");
        commandPanel.add((Component)respondWithMessage, SettingsDialog.makeGbc(0, 6, 2, 1, 17));
        EditorStringSetting responseMsg = d.addEditorStringSetting("streamHighlightResponseMsg", 30, true, Language.getString("settings.streamHighlights.responseMsg"), false, "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-streamhighlightmsg.html", null), tester);
        responseMsg.setLinkLabelListener(d.getLinkLabelListener());
        commandPanel.add((Component)responseMsg, SettingsDialog.makeGbc(0, 7, 2, 1, 17));
        SettingsUtil.addSubsettings(respondWithMessage, responseMsg);
    }
}

