/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.Channels;
import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ColorChooser;
import chatty.gui.components.settings.ColorSetting;
import chatty.gui.components.settings.ComboLongSetting;
import chatty.gui.components.settings.ComboStringSetting;
import chatty.gui.components.settings.LazyDialog;
import chatty.gui.components.settings.LongSetting;
import chatty.gui.components.settings.MapSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.SimpleTableEditor;
import chatty.gui.components.settings.TableEditor;
import chatty.lang.Language;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;

public class TabSettings
extends SettingsPanel {
    public TabSettings(SettingsDialog d) {
        JPanel main = this.addTitledPanel(Language.getString("settings.section.tabs"), 0);
        JPanel infoPanel = this.addTitledPanel("Tab Info", 1);
        JPanel popout = this.addTitledPanel("Popout", 2);
        JTabbedPane mainTabs = new JTabbedPane();
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 17);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        main.add((Component)mainTabs, gbc);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel layoutPanel = new JPanel(new GridBagLayout());
        JPanel orderPanel = new JPanel(new GridBagLayout());
        mainTabs.addTab(Language.getString("settings.tabs.tab.behavior"), SettingsUtil.topAlign(mainPanel, 20));
        mainTabs.addTab(Language.getString("settings.tabs.tab.layout"), SettingsUtil.topAlign(layoutPanel, 20));
        mainTabs.addTab(Language.getString("settings.tabs.tab.order"), SettingsUtil.topAlign(orderPanel, 20));
        orderPanel.add((Component)new JLabel(Language.getString("settings.tabs.order")), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("normal", Language.getString("settings.tabs.option.normal"));
        options.put("alphabetical", Language.getString("settings.tabs.option.alphabetical"));
        orderPanel.add((Component)d.addComboStringSetting("tabOrder", 1, false, options), SettingsDialog.makeGbc(1, 0, 3, 1, 17));
        TabsPos tabsPos = new TabsPos(d);
        TabsPrefixPos channelPrefix = new TabsPrefixPos(d, "#", tabsPos.getSetting());
        TabsPrefixPos whisperPrefix = new TabsPrefixPos(d, "$", tabsPos.getSetting());
        TabsPrefixPos dialogsPrefix = new TabsPrefixPos(d, "-", tabsPos.getSetting());
        TabsPrefixPos customTabsPrefix = new TabsPrefixPos(d, "'", tabsPos.getSetting());
        SettingsUtil.addLabeledComponent(orderPanel, "settings.tabsOrder.channel", 0, 1, 3, 17, channelPrefix);
        SettingsUtil.addLabeledComponent(orderPanel, "settings.tabsOrder.whisper", 0, 2, 3, 17, whisperPrefix);
        SettingsUtil.addLabeledComponent(orderPanel, "settings.tabsOrder.dialogs", 0, 3, 3, 17, dialogsPrefix);
        SettingsUtil.addLabeledComponent(orderPanel, "settings.tabsOrder.customTabs", 0, 4, 3, 17, customTabsPrefix);
        JButton tabsPosButton = new JButton("Advanced Tabs Order");
        GuiUtil.smallButtonInsets(tabsPosButton);
        tabsPosButton.addActionListener(e -> tabsPos.show(this));
        tabsPos.setChangeListener(data -> {
            channelPrefix.update((Map<String, Long>)data);
            whisperPrefix.update((Map<String, Long>)data);
            dialogsPrefix.update((Map<String, Long>)data);
            customTabsPrefix.update((Map<String, Long>)data);
        });
        orderPanel.add((Component)tabsPosButton, SettingsDialog.makeGbc(0, 5, 1, 1, 17));
        orderPanel.add((Component)d.addSimpleBooleanSetting("tabsAutoSort"), SettingsDialog.makeGbc(0, 6, 2, 1, 17));
        orderPanel.add((Component)new JLabel("<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>Tab order applies when opening new tabs and when tabs are resorted. Tabs can always be moved manually via drag&amp;drop, however they may not keep their position when reopened or resorted."), SettingsDialog.makeGbc(0, 10, 2, 1, 10));
        mainPanel.add((Component)SettingsUtil.createLabel("settings.string.tabsOpen"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        mainPanel.add((Component)d.addComboStringSetting("tabsOpen", false, "main", "active", "active2", "activeChan"), SettingsDialog.makeGbc(1, 1, 3, 1, 17));
        mainPanel.add((Component)d.addSimpleBooleanSetting("tabsCloseMMB"), SettingsDialog.makeGbc(0, 2, 2, 1, 17));
        mainPanel.add((Component)d.addSimpleBooleanSetting("tabsCloseSwitchToPrev"), SettingsDialog.makeGbc(0, 3, 2, 1, 17));
        HashMap<String, String> tabPlacementOptions = new HashMap<String, String>();
        tabPlacementOptions.put("top", Language.getString("settings.tabs.option.top"));
        tabPlacementOptions.put("left", Language.getString("settings.tabs.option.left"));
        tabPlacementOptions.put("bottom", Language.getString("settings.tabs.option.bottom"));
        tabPlacementOptions.put("right", Language.getString("settings.tabs.option.right"));
        ComboStringSetting tabPlacementSetting = new ComboStringSetting((Map<String, String>)tabPlacementOptions);
        d.addStringSetting("tabsPlacement", tabPlacementSetting);
        layoutPanel.add((Component)new JLabel(Language.getString("settings.tabs.placement")), SettingsDialog.makeGbc(0, 3, 1, 1, 17));
        layoutPanel.add((Component)tabPlacementSetting, SettingsDialog.makeGbc(1, 3, 3, 1, 17));
        HashMap<String, String> tabLayoutOptions = new HashMap<String, String>();
        tabLayoutOptions.put("wrap", Language.getString("settings.tabs.option.wrap"));
        tabLayoutOptions.put("scroll", Language.getString("settings.tabs.option.scroll"));
        ComboStringSetting tabLayoutSetting = new ComboStringSetting((Map<String, String>)tabLayoutOptions);
        d.addStringSetting("tabsLayout", tabLayoutSetting);
        layoutPanel.add((Component)new JLabel(Language.getString("settings.tabs.layout")), SettingsDialog.makeGbc(0, 4, 1, 1, 17));
        layoutPanel.add((Component)tabLayoutSetting, SettingsDialog.makeGbc(1, 4, 3, 1, 17));
        SettingsUtil.addLabeledComponent(layoutPanel, "tabsMaxWidth", 0, 5, 3, 17, d.addSimpleLongSetting("tabsMaxWidth", 3, true));
        layoutPanel.add((Component)d.addSimpleBooleanSetting("tabsHideIfSingle"), SettingsDialog.makeGbc(0, 6, 3, 1));
        mainPanel.add((Component)d.addSimpleBooleanSetting("tabsCloseEmpty"), SettingsDialog.makeGbc(0, 6, 4, 1, 17));
        SimpleBooleanSetting scroll = d.addSimpleBooleanSetting("tabsMwheelScrolling");
        SimpleBooleanSetting scroll2 = d.addSimpleBooleanSetting("tabsMwheelScrollingAnywhere");
        mainPanel.add((Component)scroll, SettingsDialog.makeGbc(0, 7, 4, 1, 17));
        gbc = SettingsDialog.makeGbcSub(0, 8, 4, 1, 18);
        mainPanel.add((Component)scroll2, gbc);
        SettingsUtil.addSubsettings(scroll, scroll2);
        JTabbedPane infoPanelTabs = new JTabbedPane();
        infoPanelTabs.addTab("Live Stream", new TabInfoOptions("tabsLive", d));
        infoPanelTabs.addTab("New Stream Status", new TabInfoOptions("tabsStatus", d));
        infoPanelTabs.addTab("New Message", new TabInfoOptions("tabsMessage", d));
        infoPanelTabs.addTab("New Highlight", new TabInfoOptions("tabsHighlight", d));
        infoPanelTabs.addTab("Active Channel", new TabInfoOptions("tabsActive", d));
        gbc = SettingsDialog.makeGbc(0, 0, 1, 1, 17);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        infoPanel.add((Component)infoPanelTabs, gbc);
        infoPanel.add((Component)d.addSimpleBooleanSetting("tabsChanTitles"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        popout.add((Component)d.addSimpleBooleanSetting("popoutSaveAttributes", "Restore location/size", "Save and restore the location and size of popout dialogs during the same session"), SettingsDialog.makeGbc(0, 0, 1, 1));
        popout.add((Component)d.addSimpleBooleanSetting("popoutCloseLastChannel", "Close popout when only channel", "Automatically close a popout if the last channel in the main window is closed"), SettingsDialog.makeGbc(1, 0, 1, 1));
        popout.add((Component)SettingsUtil.createLabel("tabsPopoutDrag"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
        popout.add((Component)d.addComboLongSetting("tabsPopoutDrag", 0, 1, 2), SettingsDialog.makeGbc(1, 1, 1, 1, 17));
        popout.add((Component)SettingsUtil.createLabel("popoutClose"), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
        popout.add((Component)d.addComboStringSetting("popoutClose", false, "ask", "close", "move"), SettingsDialog.makeGbc(1, 2, 1, 1, 17));
        popout.add((Component)new JLabel(Language.getString("popoutClose.keyTip")), SettingsDialog.makeGbc(0, 3, 2, 1, 17));
    }

    public static String tabPosLabel(String value) {
        if (value.equals("-")) {
            return String.format("%s (-)", Language.getString("settings.tabsOrder.dialogs").replace(":", ""));
        }
        if (value.equals("#")) {
            return String.format("%s (#)", Language.getString("settings.tabsOrder.channel").replace(":", ""));
        }
        if (value.equals("$")) {
            return String.format("%s ($)", Language.getString("settings.tabsOrder.whisper").replace(":", ""));
        }
        if (value.equals("'")) {
            return String.format("%s (')", Language.getString("settings.tabsOrder.customTabs").replace(":", ""));
        }
        if (value.equals("-nochannel-")) {
            return String.format("\"%s\" tab", Language.getString("tabs.noChannel"));
        }
        return value;
    }

    private static class TabsPos
    extends LazyDialog {
        private static final String INFO = "<html><head><style>code { font-size: 1em; }</style></head><body style='width:320px;'>" + SettingsUtil.getInfo("info-tabs_order.html", null);
        private final SettingsDialog d;
        private final SimpleTableEditor<Long> editor;
        private Consumer<Map<String, Long>> changeListener;

        private TabsPos(SettingsDialog d) {
            this.d = d;
            this.editor = d.addLongMapSetting("tabsPos", 300, 200, "Tab Name", "Position Value");
            this.editor.setValueFilter("[^0-9-]");
            this.editor.setTableEditorListener(new TableEditor.TableEditorListener<SimpleTableEditor.MapItem<Long>>(){

                @Override
                public void itemAdded(SimpleTableEditor.MapItem<Long> item) {
                    this.informChangeListener(editor.getSettingValue());
                }

                @Override
                public void itemRemoved(SimpleTableEditor.MapItem<Long> item) {
                    this.informChangeListener(editor.getSettingValue());
                }

                @Override
                public void itemEdited(SimpleTableEditor.MapItem<Long> oldItem, SimpleTableEditor.MapItem<Long> newItem) {
                    this.informChangeListener(editor.getSettingValue());
                }

                @Override
                public void allItemsChanged(List<SimpleTableEditor.MapItem<Long>> newItems) {
                    this.informChangeListener(editor.getSettingValue());
                }

                @Override
                public void refreshData() {
                }

                @Override
                public void itemsSet() {
                    this.informChangeListener(editor.getSettingValue());
                }
            });
        }

        @Override
        public JDialog createDialog() {
            return new Dialog();
        }

        private void informChangeListener(Map<String, Long> items) {
            if (this.changeListener != null) {
                this.changeListener.accept(items);
            }
        }

        public void setChangeListener(Consumer<Map<String, Long>> listener) {
            this.changeListener = listener;
        }

        private MapSetting<String, Long> getSetting() {
            return this.editor;
        }

        private class Dialog
        extends JDialog {
            private Dialog() {
                super(TabsPos.this.d);
                this.setDefaultCloseOperation(1);
                this.setLayout(new GridBagLayout());
                this.setTitle("Advanced Tabs Order");
                TabsPos.this.d;
                GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
                this.add((Component)new JLabel(INFO), gbc);
                TabsPos.this.d;
                gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                TabsPos.this.editor.setRendererForColumn(0, new TabsPosRenderer());
                TabsPos.this.editor.setRendererForColumn(1, new TabsPosRenderer());
                TabsPos.this.editor.getSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(1, SortOrder.ASCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING)));
                this.add((Component)TabsPos.this.editor, gbc);
                TabsPos.this.d;
                gbc = SettingsDialog.makeGbc(0, 2, 1, 1);
                gbc.fill = 1;
                gbc.weightx = 1.0;
                JButton closeButton = new JButton("Close");
                this.add((Component)closeButton, gbc);
                closeButton.addActionListener(e -> this.setVisible(false));
                this.pack();
                this.setMinimumSize(this.getPreferredSize());
            }
        }
    }

    private static class TabsPrefixPos
    extends JPanel {
        private final SettingsDialog d;
        private final ComboLongSetting setting;
        private final String prefix;

        private TabsPrefixPos(SettingsDialog d, String prefix, MapSetting<String, Long> mapSetting) {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.d = d;
            this.prefix = prefix;
            HashMap<Long, String> items = new HashMap<Long, String>();
            items.put(-1L, "Before Default Location (-1)");
            items.put(0L, "Default Location (0)");
            items.put(1L, "After Default Location (1)");
            this.setting = new ComboLongSetting((Map<Long, String>)items);
            this.setting.addItemListener(e -> {
                Map<String, Long> data = mapSetting.getSettingValue();
                Long pos = this.setting.getSettingValue(0L);
                if (!pos.equals(data.get(prefix)) && (pos != 0L || data.containsKey(prefix))) {
                    data.put(prefix, pos);
                    mapSetting.setSettingValue(data);
                }
            });
            this.add(this.setting);
        }

        public void update(Map<String, Long> items) {
            this.setting.setSettingValue(items.getOrDefault(this.prefix, 0L));
        }
    }

    private static class TabInfoOptions
    extends JPanel
    implements LongSetting {
        private final Map<Integer, JCheckBox> options = new HashMap<Integer, JCheckBox>();
        private final ColorSetting customColor;
        private final Set<Integer> COLOR_OPTIONS = new HashSet<Integer>(Arrays.asList(4, 8, 16, 32, 128));

        TabInfoOptions(String settingName, SettingsDialog settings) {
            settings.addLongSetting(settingName, this);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.makeOption(1, "bold"), SettingsDialog.makeGbc(0, 1, 1, 1, 17));
            this.add((Component)this.makeOption(2, "italic"), SettingsDialog.makeGbc(1, 1, 1, 1, 17));
            this.add((Component)this.makeOption(4, "color1"), SettingsDialog.makeGbc(0, 2, 1, 1, 17));
            this.add((Component)this.makeOption(8, "color2"), SettingsDialog.makeGbc(1, 2, 1, 1, 17));
            this.add((Component)this.makeOption(64, "asterisk"), SettingsDialog.makeGbc(1, 0, 1, 1, 17));
            this.add((Component)this.makeOption(16, "dot1"), SettingsDialog.makeGbc(2, 1, 1, 1, 17));
            this.add((Component)this.makeOption(32, "dot2"), SettingsDialog.makeGbc(2, 2, 1, 1, 17));
            this.add((Component)this.makeOption(128, "line"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
            this.add((Component)this.makeOption(256, "customColor"), SettingsDialog.makeGbc(0, 3, 2, 1, 17));
            this.customColor = new ColorSetting(0, null, "Custom Color", " ", () -> new ColorChooser(settings));
            this.customColor.setUseBaseColor(false);
            this.add((Component)this.customColor, SettingsDialog.makeGbc(2, 3, 1, 1, 17));
            this.update();
        }

        private JCheckBox makeOption(int option, String labelKey) {
            String text = Language.getString("settings.tabs." + labelKey);
            String tip = Language.getString("settings.tabs." + labelKey + ".tip", false);
            JCheckBox check = new JCheckBox(text);
            check.setToolTipText(SettingsUtil.addTooltipLinebreaks(tip));
            check.addItemListener(e -> this.update());
            this.options.put(option, check);
            return check;
        }

        private void update() {
            boolean colorSettingSelected = false;
            String colorLabel = null;
            for (Integer option : this.options.keySet()) {
                JCheckBox check;
                if (!this.COLOR_OPTIONS.contains(option) || !(check = this.options.get(option)).isSelected()) continue;
                colorSettingSelected = true;
                if (colorLabel != null) {
                    colorLabel = Language.getString("settings.tabs.customColorSeveral");
                    continue;
                }
                colorLabel = check.getText();
            }
            JCheckBox customColorCheck = this.options.get(256);
            customColorCheck.setEnabled(colorSettingSelected);
            this.customColor.setEnabled(customColorCheck.isEnabled() && customColorCheck.isSelected());
            this.customColor.setPreviewText(this.customColor.isEnabled() ? colorLabel : "");
        }

        @Override
        public Long getSettingValue() {
            long result = 0L;
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                result |= (long)entry.getKey().intValue();
            }
            result = Channels.DockChannelContainer.encodeColor(this.customColor.getSettingValueAsColor(), result, 16);
            return result;
        }

        @Override
        public Long getSettingValue(Long def) {
            return this.getSettingValue();
        }

        @Override
        public void setSettingValue(Long setting) {
            for (Map.Entry<Integer, JCheckBox> entry : this.options.entrySet()) {
                entry.getValue().setSelected((setting & (long)entry.getKey().intValue()) != 0L);
            }
            Color color = Channels.DockChannelContainer.decodeColor(setting, 16);
            this.customColor.setSettingValue(HtmlColors.getNamedColorString(color));
        }
    }

    private static class TabsPosRenderer
    extends DefaultTableCellRenderer {
        private TabsPosRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText(null);
                return;
            }
            if (value instanceof String) {
                this.setText(TabSettings.tabPosLabel((String)value));
            } else if (Objects.equals(value, 0L)) {
                this.setText("0 (Default)");
            } else {
                this.setText(String.valueOf(value));
            }
        }
    }
}

