/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.ListSelector;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.StringEditor;
import chatty.lang.Language;
import chatty.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class TableEditor<T>
extends JPanel {
    private static final Dimension BUTTON_SIZE = new Dimension(27, 27);
    public static final int SORTING_MODE_MANUAL = 0;
    public static final int SORTING_MODE_SORTED = 1;
    private static final String BUTTON_ADD_TIP = Language.getString("settings.listSelector.button.add.tip");
    private static final String BUTTON_REMOVE_TIP = Language.getString("settings.listSelector.button.remove.tip");
    private static final String BUTTON_EDIT_TIP = Language.getString("settings.listSelector.button.edit.tip");
    private static final String BUTTON_UP_TIP = Language.getString("settings.listSelector.button.moveUp.tip");
    private static final String BUTTON_DOWN_TIP = Language.getString("settings.listSelector.button.moveDown.tip");
    private final ButtonAction buttonActionListener = new ButtonAction();
    private final JTable table;
    private ListTableModel<T> data;
    private ItemEditor<T> editor;
    private Supplier<ItemEditor<T>> editorCreator;
    private TableRowSorter<ListTableModel<T>> sorter;
    private int sortingMode;
    private boolean currentlyFiltering;
    private String search = "";
    private long searchTime = 0L;
    private int searchColumn;
    private final Timer searchTimer;
    private final JButton add = new JButton();
    private final JButton remove = new JButton();
    private final JButton edit = new JButton();
    private final JButton moveUp = new JButton();
    private final JButton moveDown = new JButton();
    private final JButton refresh = new JButton();
    private final JButton editAll = new JButton();
    private final JTextField filterInput = new JTextField();
    private TableEditorListener<T> listener;
    private TableContextMenu<T> contextMenu;
    private TableEditorEditAllHandler<T> editAllHandler;
    private StringEditor allEditor;

    public TableEditor(int sortingMode, boolean refreshButton) {
        this.sortingMode = sortingMode;
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableEditor.this.updateButtons();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TableEditor.this.isEnabled() && e.getClickCount() == 2) {
                    TableEditor.this.editSelectedItem();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (TableEditor.this.isEnabled()) {
                    TableEditor.this.selectRowAt(e.getPoint());
                    TableEditor.this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TableEditor.this.isEnabled()) {
                    TableEditor.this.popupMenu(e);
                }
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "removeItems");
        this.table.getActionMap().put("removeItems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableEditor.this.removeSelected();
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "editItems");
        this.table.getActionMap().put("editItems", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableEditor.this.editSelectedItem();
            }
        });
        GuiUtil.resetFocusTraversalKeys(this.table);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TableEditor.this.search(e.getKeyChar());
            }
        });
        this.searchTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableEditor.this.checkResetSearch();
            }
        });
        this.searchTimer.setRepeats(true);
        this.configureButton(this.add, "list-add.png", BUTTON_ADD_TIP);
        this.configureButton(this.edit, "edit.png", BUTTON_EDIT_TIP);
        this.configureButton(this.remove, "list-remove.png", BUTTON_REMOVE_TIP);
        this.configureButton(this.moveUp, "go-up.png", BUTTON_UP_TIP);
        this.configureButton(this.moveDown, "go-down.png", BUTTON_DOWN_TIP);
        this.configureButton(this.refresh, "view-refresh.png", "Refresh data");
        this.configureButton(this.editAll, "edit-all.png", Language.getString("settings.listSelector.button.editAll.tip"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = this.makeGbc(0, 0, 2, 8);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), gbc);
        if (sortingMode == 1) {
            gbc = this.makeGbc(0, 8, 1, 1);
            gbc.insets = new Insets(0, 2, 0, 1);
            JLabel filterInputLabel = new JLabel("Filter: ");
            filterInputLabel.setLabelFor(this.filterInput);
            this.add((Component)filterInputLabel, gbc);
            gbc = this.makeGbc(1, 8, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.filterInput, gbc);
            this.filterInput.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TableEditor.this.updateFiltering();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TableEditor.this.updateFiltering();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TableEditor.this.updateFiltering();
                }
            });
        }
        gbc = this.makeGbc(2, 0, 1, 1);
        this.add((Component)this.add, gbc);
        gbc = this.makeGbc(2, 1, 1, 1);
        this.add((Component)this.remove, gbc);
        gbc = this.makeGbc(2, 2, 1, 1);
        this.add((Component)this.edit, gbc);
        if (sortingMode == 0) {
            gbc = this.makeGbc(2, 3, 1, 1);
            this.add((Component)this.moveUp, gbc);
            gbc = this.makeGbc(2, 4, 1, 1);
            this.add((Component)this.moveDown, gbc);
        }
        if (refreshButton) {
            gbc = this.makeGbc(2, 5, 1, 1);
            this.add((Component)this.refresh, gbc);
        }
        gbc = this.makeGbc(2, 6, 1, 1);
        this.add((Component)this.editAll, gbc);
        this.editAll.setVisible(false);
        this.updateButtons();
    }

    protected final void setModel(ListTableModel<T> model) {
        this.data = model;
        this.table.setModel(model);
        if (this.sortingMode == 1) {
            this.sorter = new TableRowSorter<ListTableModel<T>>(model);
            this.sorter.setSortsOnUpdates(true);
            this.table.setRowSorter(this.sorter);
            this.sorter.toggleSortOrder(0);
        }
    }

    protected final void setDefaultRenderer(Class cellClass, TableCellRenderer renderer) {
        this.table.setDefaultRenderer(cellClass, renderer);
    }

    protected final void setRendererForColumn(int column, TableCellRenderer renderer) {
        this.table.getColumnModel().getColumn(column).setCellRenderer(renderer);
    }

    protected final void setFixedColumnWidth(int column, int size) {
        this.table.getColumnModel().getColumn(column).setMaxWidth(size);
        this.table.getColumnModel().getColumn(column).setMinWidth(size);
    }

    protected final void setColumnWidth(int column, int size) {
        this.table.getColumnModel().getColumn(column).setPreferredWidth(size);
    }

    public TableRowSorter<ListTableModel<T>> getSorter() {
        return this.sorter;
    }

    public void setData(List<T> data) {
        this.data.setData(data);
        this.updateButtons();
        if (this.listener != null) {
            this.listener.itemsSet();
        }
    }

    public List<T> getData() {
        return this.data.getData();
    }

    public void setItemEditor(Supplier<ItemEditor<T>> editorCreator) {
        this.editorCreator = editorCreator;
    }

    private ItemEditor<T> getEditor() {
        if (this.editor == null) {
            this.editor = this.editorCreator.get();
        }
        return this.editor;
    }

    public final void setPopupMenu(TableContextMenu<T> menu) {
        this.contextMenu = menu;
    }

    public final void setTableEditorListener(TableEditorListener<T> listener) {
        this.listener = listener;
    }

    public final void setTableEditorEditAllHandler(TableEditorEditAllHandler<T> handler) {
        this.editAllHandler = handler;
        this.editAll.setVisible(handler != null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateButtons();
        this.table.setEnabled(enabled);
        this.table.setFocusable(enabled);
        this.table.setOpaque(enabled);
        this.table.setShowGrid(enabled);
    }

    private void popupMenu(MouseEvent e) {
        int modelIndex;
        if (this.contextMenu != null && e.isPopupTrigger() && (modelIndex = this.indexToModel(this.table.getSelectedRow())) != -1) {
            T entry = this.data.get(modelIndex);
            this.contextMenu.showMenu(entry, this.table, e.getX(), e.getY());
        }
    }

    private void selectRowAt(Point p) {
        int row = this.table.rowAtPoint(p);
        if (row != -1) {
            this.setRowSelected(row);
        }
    }

    private GridBagConstraints makeGbc(int x, int y, int w, int h) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        return gbc;
    }

    private void updateFiltering() {
        String filterText = this.filterInput.getText();
        RowFilter rf = null;
        try {
            rf = RowFilter.regexFilter("(?ui)" + Pattern.quote(filterText), new int[0]);
        }
        catch (PatternSyntaxException ex) {
            return;
        }
        this.currentlyFiltering = rf != null && !filterText.isEmpty();
        this.sorter.setRowFilter(rf);
        this.scrollToSelection();
        this.updateButtons();
    }

    private void configureButton(JButton button, String icon, String tooltip) {
        button.setIcon(new ImageIcon(ListSelector.class.getResource(icon)));
        button.setToolTipText(tooltip);
        button.setPreferredSize(BUTTON_SIZE);
        button.setSize(BUTTON_SIZE);
        button.setMaximumSize(BUTTON_SIZE);
        button.setMinimumSize(BUTTON_SIZE);
        button.addActionListener(this.buttonActionListener);
    }

    private void updateButtons() {
        boolean enabled = this.table.getSelectedRowCount() == 1 && this.isEnabled();
        this.add.setEnabled(this.isEnabled());
        this.remove.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.moveUp.setEnabled(enabled);
        this.moveDown.setEnabled(enabled);
        if (this.currentlyFiltering) {
            this.add.setEnabled(false);
            this.edit.setEnabled(false);
            this.moveUp.setEnabled(false);
            this.moveDown.setEnabled(false);
        }
        this.editAll.setEnabled(!this.currentlyFiltering);
        if (enabled) {
            String item = this.getSelectedRowText();
            if (item != null) {
                this.remove.setToolTipText(BUTTON_REMOVE_TIP + ": " + item);
                this.edit.setToolTipText(BUTTON_EDIT_TIP + ": " + item);
                this.moveUp.setToolTipText(BUTTON_UP_TIP + ": " + item);
                this.moveDown.setToolTipText(BUTTON_DOWN_TIP + ": " + item);
            } else {
                this.remove.setToolTipText(BUTTON_REMOVE_TIP);
                this.edit.setToolTipText(BUTTON_EDIT_TIP);
                this.moveUp.setToolTipText(BUTTON_UP_TIP);
                this.moveDown.setToolTipText(BUTTON_DOWN_TIP);
            }
        }
    }

    private void setRowSelected(int viewIndex) {
        this.table.getSelectionModel().setSelectionInterval(viewIndex, viewIndex);
        this.scrollToRow(viewIndex);
    }

    private String getSelectedRowText() {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            return null;
        }
        int modelIndex = this.indexToModel(index);
        if (modelIndex == -1) {
            return null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (int column = 0; column < this.data.getColumnCount(); ++column) {
            String part = String.valueOf(this.data.getValueAt(modelIndex, column));
            if (parts.contains(part)) continue;
            parts.add(part);
        }
        return StringUtil.join(parts, ", ");
    }

    private void scrollToSelection() {
        int index = this.table.getSelectedRow();
        this.scrollToRow(index);
    }

    private void scrollToRow(int index) {
        if (index != -1) {
            this.table.scrollRectToVisible(this.table.getCellRect(index, 0, true));
        }
    }

    protected void addItem(T preset) {
        T result = this.getEditor().showEditor(preset, this, false, -1);
        if (result != null) {
            if (this.data.contains(result)) {
                Object[] options = new String[]{"Don't save", "Edit again"};
                int r = JOptionPane.showOptionDialog(this, "Another item with the same name is already in the list.", "Duplicate item", 0, 3, null, options, null);
                if (r == 1) {
                    this.addItem(result);
                }
            } else {
                int selectedIndex = this.table.getSelectedRow();
                int modelIndex = this.indexToModel(selectedIndex);
                if (modelIndex != -1) {
                    this.data.insert(modelIndex, result);
                    this.setRowSelected(this.indexToView(modelIndex));
                } else {
                    this.data.insert(0, result);
                    this.setRowSelected(this.indexToView(0));
                }
                if (this.listener != null) {
                    this.listener.itemAdded(result);
                }
            }
        }
    }

    private void editSelectedItem() {
        this.editItem(-1, null);
    }

    protected void editItem(int modelIndex) {
        this.editItem(modelIndex, null);
    }

    protected void editItem(int modelIndex, T preset) {
        T result;
        if (modelIndex == -1 && (modelIndex = this.indexToModel(this.table.getSelectedRow())) == -1) {
            return;
        }
        this.setRowSelected(this.indexToView(modelIndex));
        if (preset == null) {
            preset = this.data.get(modelIndex);
        }
        if ((result = this.getEditor().showEditor(preset, this, true, this.table.getSelectedColumn())) != null) {
            int present = this.data.indexOf(result);
            if (present != -1 && present != modelIndex) {
                Object[] options = new String[]{"Don't save", "Edit again"};
                int r = JOptionPane.showOptionDialog(this, "Another item with the same name is already in the list.", "Duplicate item", 0, 3, null, options, "Replace");
                if (r == 1) {
                    this.editItem(modelIndex, result);
                }
            } else {
                this.data.set(modelIndex, result);
                if (this.listener != null) {
                    this.listener.itemEdited(preset, result);
                }
            }
        }
        this.setRowSelected(this.indexToView(modelIndex));
    }

    protected void selectItem(int modelIndex) {
        this.setRowSelected(this.indexToView(modelIndex));
    }

    protected void selectItem(T item) {
        int index = this.data.indexOf(item);
        if (index != -1) {
            this.selectItem(index);
        }
    }

    protected void removeSelected() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        int viewIndex = this.table.getSelectedRow();
        int modelIndex = this.indexToModel(viewIndex);
        if (modelIndex == -1) {
            return;
        }
        T removedItem = this.data.remove(modelIndex);
        if (this.table.getRowCount() > viewIndex) {
            this.setRowSelected(viewIndex);
        } else if (viewIndex - 1 >= 0 && this.table.getRowCount() > viewIndex - 1) {
            this.setRowSelected(viewIndex - 1);
        }
        this.updateButtons();
        if (this.listener != null) {
            this.listener.itemRemoved(removedItem);
        }
    }

    protected void moveUpSelected() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex > -1) {
            int index = this.data.moveUp(this.indexToModel(selectedIndex));
            this.setRowSelected(this.indexToView(index));
        }
    }

    protected void moveDownSelected() {
        int selectedIndex = this.table.getSelectedRow();
        if (selectedIndex > -1) {
            int index = this.data.moveDown(this.indexToModel(selectedIndex));
            this.setRowSelected(this.indexToView(index));
        }
    }

    protected void editAll() {
        String result;
        if (this.editAllHandler == null) {
            return;
        }
        String preset = this.editAllHandler.toString(this.data.getData());
        if (this.allEditor == null) {
            this.allEditor = this.editAllHandler.getEditor();
        }
        if (this.allEditor == null) {
            Editor defaultEditor = new Editor(SwingUtilities.getWindowAncestor(this));
            defaultEditor.setAllowLinebreaks(true);
            defaultEditor.setAllowEmpty(true);
            this.allEditor = defaultEditor;
        }
        if ((result = this.allEditor.showDialog(this.editAllHandler.getEditorTitle(), preset, this.editAllHandler.getEditorHelp())) != null) {
            List<T> changedEntries = this.editAllHandler.toData(result);
            if (changedEntries != null) {
                if (this.listener != null) {
                    this.listener.allItemsChanged(changedEntries);
                }
                this.data.setData(changedEntries);
            } else {
                JOptionPane.showMessageDialog(this, "Input invalid, no entries changed");
            }
        }
    }

    private int indexToModel(int index) {
        if (index == -1) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    private int indexToView(int index) {
        return this.table.convertRowIndexToView(index);
    }

    private void search(char input) {
        if (input == '\b') {
            this.resetSearch();
            return;
        }
        if (!Character.isLetterOrDigit(input) && input != '_' && input != '#') {
            return;
        }
        int column = this.data.getSearchColumn(this.table.getSelectedColumn());
        if (column == -1) {
            return;
        }
        if (column != this.searchColumn) {
            this.resetSearch();
        }
        String pressed = String.valueOf(input);
        this.search = this.search + StringUtil.toLowerCase(pressed);
        this.searchColumn = column;
        this.searchTime = System.currentTimeMillis();
        this.table.getColumnModel().getColumn(column).setHeaderValue("[" + this.search + "]");
        this.table.getTableHeader().repaint();
        if (!this.searchTimer.isRunning()) {
            this.searchTimer.start();
        }
        for (int i = 0; i < this.data.getRowCount(); ++i) {
            String item = StringUtil.toLowerCase(this.data.getSearchValueAt(i, column));
            if (item.startsWith(this.search)) {
                this.setRowSelected(this.indexToView(i));
                return;
            }
            if (!item.contains(this.search)) continue;
            this.setRowSelected(this.indexToView(i));
        }
    }

    private void checkResetSearch() {
        if (System.currentTimeMillis() - this.searchTime > 3000L) {
            this.resetSearch();
        }
    }

    private void resetSearch() {
        if (this.searchColumn != -1) {
            String originalValue = this.data.getColumnName(this.searchColumn);
            this.table.getColumnModel().getColumn(this.searchColumn).setHeaderValue(originalValue);
            this.table.getTableHeader().repaint();
        }
        this.searchColumn = -1;
        this.search = "";
        this.searchTimer.stop();
    }

    public static interface TableEditorListener<T> {
        public void itemAdded(T var1);

        public void itemRemoved(T var1);

        public void itemEdited(T var1, T var2);

        public void allItemsChanged(List<T> var1);

        public void itemsSet();

        public void refreshData();
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TableEditor.this.moveUp) {
                TableEditor.this.moveUpSelected();
            } else if (e.getSource() == TableEditor.this.moveDown) {
                TableEditor.this.moveDownSelected();
            } else if (e.getSource() == TableEditor.this.remove) {
                TableEditor.this.removeSelected();
            } else if (e.getSource() == TableEditor.this.edit) {
                TableEditor.this.editSelectedItem();
            } else if (e.getSource() == TableEditor.this.add) {
                TableEditor.this.addItem(null);
            } else if (e.getSource() == TableEditor.this.refresh) {
                if (TableEditor.this.listener != null) {
                    TableEditor.this.listener.refreshData();
                }
            } else if (e.getSource() == TableEditor.this.editAll) {
                TableEditor.this.editAll();
            }
        }
    }

    public static interface ItemEditor<T> {
        public T showEditor(T var1, Component var2, boolean var3, int var4);
    }

    public static abstract class TableContextMenu<T>
    extends JPopupMenu {
        public abstract void showMenu(T var1, Component var2, int var3, int var4);
    }

    public static interface TableEditorEditAllHandler<T> {
        public String toString(List<T> var1);

        public List<T> toData(String var1);

        public StringEditor getEditor();

        public String getEditorTitle();

        public String getEditorHelp();
    }
}

