/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.HotkeyPanel;
import chatty.gui.components.settings.MapSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SliderLongSetting;
import chatty.lang.Language;
import chatty.util.BatchAction;
import chatty.util.hotkeys.Hotkey;
import chatty.util.tts.SpeakRequest;
import chatty.util.tts.TextToSpeech;
import chatty.util.tts.VoiceInfo;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;

public class TextToSpeechSettings
extends SettingsPanel {
    private final SettingsDialog d;
    private final VoiceSelection voiceSelection;
    private final SliderLongSetting volumeSlider;
    private final SliderLongSetting rateSlider;
    private final SliderLongSetting pitchSlider;
    int hotkeyCount;

    public TextToSpeechSettings(SettingsDialog d) {
        this.d = d;
        JPanel main = this.addTitledPanel(Language.getString("settings.section.tts"), 0, true);
        JPanel chat = this.addTitledPanel(Language.getString("settings.section.chat"), 1, true);
        JPanel hotkeys = this.addTitledPanel(Language.getString("settings.section.ttsHotkeys"), 2, true);
        main.add((Component)d.addSimpleBooleanSetting("ttsEnabled"), SettingsDialog.makeGbc(0, 0, 1, 1));
        this.voiceSelection = new VoiceSelection(d);
        GuiUtil.installEscapeCloseOperation(this.voiceSelection);
        d.addMapSetting("ttsVoice", this.voiceSelection);
        JButton selectVoiceButton = new JButton("Select Voice");
        selectVoiceButton.addActionListener(e -> this.voiceSelection.showDialog());
        main.add((Component)selectVoiceButton, SettingsDialog.makeGbc(0, 10, 1, 1));
        this.volumeSlider = new SliderLongSetting(0, 0, 100, 80);
        d.addLongSetting("ttsVolume", this.volumeSlider);
        SettingsUtil.addLabeledComponent(main, "ttsVolume", 0, 1, 1, 13, this.volumeSlider);
        this.volumeSlider.addChangeListener(l -> this.ttsTest());
        this.rateSlider = new SliderLongSetting(0, 50, 300, 100);
        d.addLongSetting("ttsRate", this.rateSlider);
        SettingsUtil.addLabeledComponent(main, "ttsRate", 0, 2, 1, 13, this.rateSlider);
        this.rateSlider.addChangeListener(l -> this.ttsTest());
        this.pitchSlider = new SliderLongSetting(0, -100, 100, 0);
        d.addLongSetting("ttsPitch", this.pitchSlider);
        SettingsUtil.addLabeledComponent(main, "ttsPitch", 0, 3, 1, 13, this.pitchSlider);
        this.pitchSlider.addChangeListener(l -> this.ttsTest());
        chat.add((Component)d.addSimpleBooleanSetting("ttsReadMessages"), SettingsDialog.makeGbc(0, 0, 1, 1, 17));
        chat.add((Component)d.addSimpleBooleanSetting("ttsIgnoreEmoteOnly"), SettingsDialog.makeGbcSub(0, 1, 1, 1, 17));
        this.addHotkeyPanel(hotkeys, "tts.on");
        this.addHotkeyPanel(hotkeys, "tts.off");
        this.addHotkeyPanel(hotkeys, "tts.pause");
        this.addHotkeyPanel(hotkeys, "tts.resume");
        this.addHotkeyPanel(hotkeys, "tts.skipForwards");
        this.addHotkeyPanel(hotkeys, "tts.skipBackwards");
        this.addHotkeyPanel(hotkeys, "tts.clearQueue");
        SliderLongSetting hotkeysVolumeSlider = new SliderLongSetting(0, 0, 100, 80);
        d.addLongSetting("ttsHotkeysVolume", hotkeysVolumeSlider);
        SettingsUtil.addLabeledComponent(hotkeys, "ttsHotkeysVolume", 0, 30, 1, 13, hotkeysVolumeSlider);
    }

    private void addHotkeyPanel(JPanel base, String actionId) {
        HotkeyPanel hotkeyPanel = this.d.addHotkeyPanel(actionId, Hotkey.Type.GLOBAL);
        SettingsUtil.addLabeledComponent(base, "settings.label.hotkey." + actionId, 0, this.hotkeyCount++, 1, 13, hotkeyPanel);
    }

    private void ttsTest() {
        if (!this.isShowing()) {
            return;
        }
        BatchAction.queue(this, 1000L, true, true, () -> {
            TextToSpeech tts = TextToSpeech.get(this.d.settings);
            tts.speak("This is a test message", (String)this.voiceSelection.getSettingValue().get(tts.getProviderId()), this.volumeSlider.getSettingValue().intValue(), this.rateSlider.getSettingValue().intValue(), this.pitchSlider.getSettingValue().intValue(), SpeakRequest.Mode.STOP_SAY_DIRECTLY);
        });
    }

    private class VoiceSelection
    extends JDialog
    implements MapSetting {
        private Map data;
        private final JList<VoiceInfo> list;
        private final DefaultListModel<VoiceInfo> listData;

        public VoiceSelection(SettingsDialog d) {
            super(d);
            this.setModal(true);
            this.setTitle("Available Voices");
            this.listData = new DefaultListModel();
            this.list = new JList<VoiceInfo>(this.listData);
            this.list.addListSelectionListener(l -> TextToSpeechSettings.this.ttsTest());
            JButton okButton = new JButton(Language.getString("dialog.button.ok"));
            okButton.addActionListener(e -> this.setVisible(false));
            this.add(this.list, "Center");
            this.add((Component)okButton, "South");
        }

        public void showDialog() {
            if (this.list.getSelectedValue() == null) {
                String providerId = TextToSpeech.get(((TextToSpeechSettings)TextToSpeechSettings.this).d.settings).getProviderId();
                List<VoiceInfo> voiceInfo = TextToSpeech.get(((TextToSpeechSettings)TextToSpeechSettings.this).d.settings).getAvailableVoices();
                this.listData.clear();
                voiceInfo.forEach(v -> this.listData.addElement((VoiceInfo)v));
                String selectedVoiceName = (String)this.data.get(providerId);
                this.list.setSelectedValue(new VoiceInfo(selectedVoiceName, null, null), true);
            }
            this.pack();
            this.setLocationRelativeTo(this.getParent());
            this.setVisible(true);
        }

        public Map getSettingValue() {
            VoiceInfo selectedVoice = this.list.getSelectedValue();
            if (selectedVoice != null) {
                this.data.put(TextToSpeech.get(((TextToSpeechSettings)TextToSpeechSettings.this).d.settings).getProviderId(), selectedVoice.name);
            }
            return this.data;
        }

        public void setSettingValue(Map value) {
            this.data = new HashMap(value);
        }
    }
}

