/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.components.settings.SettingsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Tree {
    public static JTree createTree(Map<SettingsDialog.Page, List<SettingsDialog.Page>> nodes, Color highlightColor) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (SettingsDialog.Page parent : nodes.keySet()) {
            DefaultMutableTreeNode category = new DefaultMutableTreeNode((Object)parent);
            root.add(category);
            List<SettingsDialog.Page> subNodes = nodes.get((Object)parent);
            for (SettingsDialog.Page child : subNodes) {
                category.add(new DefaultMutableTreeNode((Object)child));
            }
        }
        final JTree tree = new JTree(root);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(false);
        HighlightTreeCellRenderer renderer = new HighlightTreeCellRenderer(highlightColor);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        tree.setCellRenderer(renderer);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getClosestRowForLocation(e.getX(), e.getY());
                if (row != -1) {
                    tree.setSelectionRow(row);
                }
            }
        });
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                throw new ExpandVetoException(event);
            }
        });
        return tree;
    }

    public static void setSelected(JTree tree, Object object) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (node.getUserObject() == null || !node.getUserObject().equals(object)) continue;
            tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public static class HighlightTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private final Border BORDER = BorderFactory.createEmptyBorder(0, 3, 0, 1);
        private final Set<Object> highlighted = new HashSet<Object>();
        private final Color highlightColor;

        private HighlightTreeCellRenderer(Color highlightColor) {
            this.highlightColor = highlightColor;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                label.setBorder(this.BORDER);
                if (value instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (this.highlighted.contains(userObject) && !sel) {
                        label.setBackground(this.highlightColor);
                        label.setOpaque(true);
                    } else {
                        label.setBackground(null);
                        label.setOpaque(false);
                    }
                }
            }
            return c;
        }

        public void setHighlight(Object o, boolean highlight) {
            if (highlight) {
                this.highlighted.add(o);
            } else {
                this.highlighted.remove(o);
            }
        }
    }
}

