/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.NamedColor;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class UsercolorBackgroundPreview
extends JDialog {
    private int column = 0;

    public UsercolorBackgroundPreview(Window parent) {
        super(parent);
        this.setTitle("Usercolor Correction Preview");
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 2, 1, 1);
        this.add(main, gbc, 0);
        this.add(main, gbc, 38);
        this.add(main, gbc, 89);
        this.add((Component)new JScrollPane(main), "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 100, 600));
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void add(JPanel main, GridBagConstraints gbc, int threshold) {
        gbc.gridx = this.column++;
        gbc.gridy = 0;
        List<NamedColor> colors = HtmlColors.getNamedColors();
        for (int i = 0; i < colors.size(); i += 4) {
            Color bgColor = colors.get(i);
            for (int j = 0; j < colors.size(); j += 4) {
                Color fgColor = colors.get(j);
                int difference = Math.abs(ColorCorrectionNew.getLightnessDifference(fgColor, bgColor));
                if (difference >= 90) continue;
                Color actualBgColor = bgColor;
                Color actualFgColor = fgColor;
                if (difference < threshold && ColorCorrectionNew.getLightnessDifferenceAbs(fgColor, actualBgColor = ColorCorrectionNew.getLightness(actualFgColor) > 128 ? Color.BLACK : Color.WHITE) < difference) {
                    actualBgColor = bgColor;
                }
                JLabel label = UsercolorBackgroundPreview.createLabel("Test", actualFgColor, actualBgColor);
                label.setToolTipText(String.valueOf(difference));
                main.add((Component)label, gbc);
                ++gbc.gridy;
            }
        }
    }

    private static JLabel createLabel(String text, Color foreground, Color background) {
        JLabel label = new JLabel(text);
        label.setForeground(foreground);
        label.setBackground(background);
        label.setOpaque(true);
        return label;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new UsercolorBackgroundPreview(null).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                System.exit(0);
            }
        }));
    }
}

