/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.GuiUtil;
import chatty.gui.NamedColor;
import chatty.lang.Language;
import chatty.util.colors.ColorCorrection;
import chatty.util.colors.ColorCorrector;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class UsercolorCorrectionPreview
extends JDialog {
    public UsercolorCorrectionPreview(Window parent, Color background) {
        super(parent);
        this.setTitle("Usercolor Correction Preview");
        boolean darkBg = ColorCorrection.isDarkColor(background);
        JPanel main = new JPanel(new GridBagLayout());
        main.setBackground(background);
        int column = 1;
        for (String type : ColorCorrector.ACTIVE_TYPES) {
            String label = Language.getString("settings.string.nickColorCorrection.option." + type);
            main.add((Component)UsercolorCorrectionPreview.createLabel(label, darkBg ? Color.WHITE : Color.BLACK), GuiUtil.makeGbc(column, 0, 1, 1));
            ++column;
        }
        int row = 1;
        for (NamedColor color : HtmlColors.getNamedColors()) {
            int diff = ColorCorrection.getBrightnessDifference(color, background);
            if (Math.abs(diff) > 100) continue;
            main.add((Component)UsercolorCorrectionPreview.createLabel(color.getName(), color), GuiUtil.makeGbc(0, row, 1, 1));
            column = 1;
            for (String type : ColorCorrector.ACTIVE_TYPES) {
                Color correctedColor = ColorCorrector.get(type).correctColor(color, background);
                String label = HtmlColors.getColorString(correctedColor);
                if (correctedColor.equals(color)) {
                    label = "Unchanged";
                }
                main.add((Component)UsercolorCorrectionPreview.createLabel(label, correctedColor), GuiUtil.makeGbc(column, row, 1, 1));
                ++column;
            }
            ++row;
        }
        this.add((Component)new JScrollPane(main), "Center");
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 100, 600));
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private static JLabel createLabel(String text, Color foreground) {
        JLabel label = new JLabel(text);
        label.setForeground(foreground);
        return label;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new UsercolorCorrectionPreview(null, new Color(250, 250, 250)).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                System.exit(0);
            }
        }));
    }
}

