/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.gui.colors.UsercolorItem;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.settings.ItemColorEditor;
import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.components.settings.SettingsPanel;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.settings.SimpleBooleanSetting;
import chatty.gui.components.settings.UsercolorCorrectionPreview;
import chatty.lang.Language;
import chatty.util.colors.ColorCorrector;
import chatty.util.colors.HtmlColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class UsercolorSettings
extends SettingsPanel {
    private static final String INFO_TEXT = "<html><body style='width:105px'>" + SettingsUtil.getInfo("info-usercolors.html", null);
    private final ItemColorEditor<UsercolorItem> data;
    private Color defaultBackgroundColor;

    public UsercolorSettings(SettingsDialog d) {
        super(true);
        JPanel customPanel = this.addTitledPanel("Custom Usercolors", 0, true);
        JPanel otherPanel = this.addTitledPanel(Language.getString("settings.section.usercolorsOther"), 1);
        GridBagConstraints gbc = SettingsDialog.makeGbc(0, 0, 1, 1);
        gbc.anchor = 17;
        SimpleBooleanSetting usercolorsEnabled = d.addSimpleBooleanSetting("customUsercolors", "Enable custom usercolors", "");
        customPanel.add((Component)usercolorsEnabled, gbc);
        this.data = new ItemColorEditor<UsercolorItem>(d, (id, color, enabled, bg, bgEnabled) -> new UsercolorItem(id, color), false, null);
        this.data.setRendererForColumn(0, new ItemIdRenderer());
        this.data.setPreferredSize(new Dimension(1, 150));
        gbc = SettingsDialog.makeGbc(0, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        customPanel.add(this.data, gbc);
        SettingsUtil.addSubsettings(usercolorsEnabled, this.data);
        LinkLabel info = new LinkLabel(INFO_TEXT, d.getSettingsHelpLinkLabelListener());
        customPanel.add((Component)info, SettingsDialog.makeGbc(1, 1, 1, 1));
        otherPanel.add((Component)new JLabel(Language.getString("settings.string.nickColorCorrection")), SettingsDialog.makeGbc(0, 0, 1, 1, 13));
        String[] colorCorrectionTypes = new String[ColorCorrector.TYPES.keySet().size()];
        ColorCorrector.TYPES.keySet().toArray(colorCorrectionTypes);
        otherPanel.add((Component)d.addComboStringSetting("nickColorCorrection", false, colorCorrectionTypes), SettingsDialog.makeGbc(1, 0, 1, 1));
        JButton colorCorrectionPreview = new JButton("Preview");
        colorCorrectionPreview.addActionListener(e -> new UsercolorCorrectionPreview((Window)d, this.defaultBackgroundColor));
        otherPanel.add((Component)colorCorrectionPreview, SettingsDialog.makeGbc(2, 0, 1, 1));
        otherPanel.add((Component)SettingsUtil.createLabel("nickColorBackground"), SettingsDialog.makeGbc(0, 1, 1, 1, 13));
        otherPanel.add((Component)d.addComboLongSetting("nickColorBackground", 0, 1, 2), SettingsDialog.makeGbc(1, 1, 2, 1, 17));
        SimpleBooleanSetting coloredNamesInUserlist = d.addSimpleBooleanSetting("displayColoredNamesInUserlist", Language.getString("settings.label.displayColoredNamesInUserlist"), null);
        otherPanel.add((Component)coloredNamesInUserlist, SettingsDialog.makeGbc(0, 2, 2, 1, 17));
    }

    public void setData(List<UsercolorItem> data) {
        this.data.setData(data);
    }

    public List<UsercolorItem> getData() {
        return this.data.getData();
    }

    public void setDefaultBackground(Color color) {
        this.data.setDefaultBackground(color);
        this.defaultBackgroundColor = color;
    }

    public void editItem(String item) {
        this.data.edit(item);
    }

    public static class ItemIdRenderer
    extends JLabel
    implements TableCellRenderer {
        public ItemIdRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setToolTipText("error");
                return this;
            }
            UsercolorItem item = (UsercolorItem)value;
            this.setFont(table.getFont());
            if (item.type == -1) {
                this.setText(item.id + " (error)");
                this.setForeground(Color.RED);
            } else {
                this.setText(item.id);
                this.setForeground(table.getForeground());
            }
            if (item.type == 1) {
                this.setToolTipText(HtmlColors.getColorString(item.idColor));
            } else {
                this.setToolTipText(null);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

