/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.settings;

import chatty.Chatty;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.GenericComboSetting;
import chatty.gui.components.settings.ListTableModel;
import chatty.gui.components.settings.TableEditor;
import chatty.util.MiscUtil;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;

class UsericonEditor
extends TableEditor<Usericon> {
    private static final Map<Usericon.Type, String> typeNames = new LinkedHashMap<Usericon.Type, String>();
    private MyItemEditor editor;
    private Set<String> types;

    public UsericonEditor(JDialog owner, LinkLabelListener linkLabelListener) {
        super(0, false);
        this.setModel(new MyTableModel());
        this.setItemEditor(() -> {
            if (this.editor == null) {
                this.editor = new MyItemEditor(owner, linkLabelListener);
                this.editor.setTwitchBadgeTypes(this.types);
            }
            return this.editor;
        });
        this.setRendererForColumn(1, new IdRenderer(this.getForeground()));
        this.setRendererForColumn(2, new ImageRenderer(this));
        this.setRendererForColumn(3, new ChannelRenderer(this.getForeground()));
    }

    public void setTwitchBadgeTypes(Set<String> types) {
        if (this.editor != null) {
            this.editor.setTwitchBadgeTypes(types);
        } else {
            this.types = types;
        }
    }

    public void addUsericonOfBadgeType(Usericon.Type type, String idVersion) {
        Usericon usericon = UsericonFactory.createCustomIcon(type, idVersion, "", "", "", "");
        this.addItem(usericon);
    }

    private static String getTypeName(Usericon.Type type) {
        return type.label;
    }

    static {
        typeNames.put(Usericon.Type.ADDON, "Addon");
        typeNames.put(Usericon.Type.MOD, "Moderator");
        typeNames.put(Usericon.Type.VIP, "VIP");
        typeNames.put(Usericon.Type.SUB, "Subscriber");
        typeNames.put(Usericon.Type.BROADCASTER, "Broadcaster");
        typeNames.put(Usericon.Type.BOT, "Bot");
        typeNames.put(Usericon.Type.TWITCH, "Other (Twitch)");
        typeNames.put(Usericon.Type.OTHER, "Other (Third-Party)");
        typeNames.put(Usericon.Type.HL, "Highlighted (by points)");
        typeNames.put(Usericon.Type.FIRSTMSG, "First Message in Channel");
        typeNames.put(Usericon.Type.ALL, "All Types");
        typeNames.put(Usericon.Type.TURBO, "Turbo");
        typeNames.put(Usericon.Type.PRIME, "Prime");
        typeNames.put(Usericon.Type.BITS, "Bits");
        typeNames.put(Usericon.Type.ADMIN, "Admin");
        typeNames.put(Usericon.Type.STAFF, "Staff");
        typeNames.put(Usericon.Type.GLOBAL_MOD, "Global Moderator");
    }

    private static class MyTableModel
    extends ListTableModel<Usericon> {
        public MyTableModel() {
            super(new String[]{"Type", "Restriction", "Image", "Channel"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Usericon icon = (Usericon)this.get(rowIndex);
            if (columnIndex == 0) {
                if (icon.type == Usericon.Type.TWITCH) {
                    return "[" + icon.getIdAndVersion() + "]";
                }
                if (!icon.badgeType.isEmpty()) {
                    return UsericonEditor.getTypeName(icon.type) + " [" + icon.badgeType + "]";
                }
                return UsericonEditor.getTypeName(icon.type);
            }
            if (columnIndex == 1) {
                return icon;
            }
            if (columnIndex == 2) {
                return icon;
            }
            if (columnIndex == 3) {
                return icon;
            }
            return null;
        }

        @Override
        public int getSearchColumn(int column) {
            return 1;
        }

        @Override
        public String getSearchValueAt(int row, int column) {
            return ((Usericon)this.get((int)row)).restriction;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex >= 1) {
                return Usericon.class;
            }
            if (columnIndex == 2) {
                return ImageIcon.class;
            }
            return String.class;
        }
    }

    private static class IdRenderer
    extends DefaultTableCellRenderer {
        private final Color defaultColor;

        IdRenderer(Color defaultColor) {
            this.defaultColor = defaultColor;
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText(null);
                return;
            }
            Usericon icon = (Usericon)value;
            if (icon.matchType == Usericon.MatchType.UNDEFINED) {
                this.setText(icon.restriction + " (error)");
                this.setForeground(Color.red);
            } else {
                this.setText(icon.restrictionValue + (icon.first ? " (first)" : "") + (icon.stop ? " (stop)" : "") + (!icon.badgeTypeRestriction.isEmpty() ? " [" + icon.badgeTypeRestriction.toString() + "]" : ""));
                this.setForeground(this.defaultColor);
            }
        }
    }

    private static class ImageRenderer
    extends DefaultTableCellRenderer {
        private final JComponent comp;

        ImageRenderer(JComponent comp) {
            this.setHorizontalAlignment(0);
            this.comp = comp;
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setIcon(null);
                this.setText(null);
                return;
            }
            Usericon icon = (Usericon)value;
            if (icon.fileName != null && icon.fileName.startsWith("$")) {
                this.setIcon(null);
                if (icon.fileName.equalsIgnoreCase("$default")) {
                    this.setText("Default badge");
                } else {
                    this.setText(icon.fileName.substring(1));
                }
            } else if (icon.removeBadge) {
                this.setIcon(null);
                this.setText("No image");
            } else {
                this.setIcon(icon.getIcon(1.0f, 0, (oldImage, newImage, sizeChanged) -> this.comp.repaint()).getImageIcon());
                this.setText(null);
            }
        }
    }

    private static class ChannelRenderer
    extends DefaultTableCellRenderer {
        private final Color defaultColor;

        ChannelRenderer(Color defaultColor) {
            this.defaultColor = defaultColor;
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText(null);
                return;
            }
            Usericon icon = (Usericon)value;
            if (!icon.channelRestriction.isEmpty() && icon.channel.isEmpty()) {
                this.setText(icon.channelRestriction + " (error)");
                this.setForeground(Color.red);
            } else {
                this.setText((icon.channelInverse ? "NOT " : "") + icon.channel);
                this.setForeground(this.defaultColor);
            }
        }
    }

    private static class MyItemEditor
    implements TableEditor.ItemEditor<Usericon> {
        private static final String HELP = "<html><body style='width:220px;'>Define which badge to target and what image to replace it with. [help-settings:CustomUsericons More Information..]";
        private static final String ERROR_LOADING_IMAGE = "Error loading image.";
        private final JDialog dialog;
        private final GenericComboSetting<String> fileName;
        private final GenericComboSetting<Usericon.Type> type;
        private final JTextField restriction = new JTextField(16);
        private final JTextField stream = new JTextField();
        private final JTextField position = new JTextField();
        private final GenericComboSetting<String> idVersion;
        private final JButton okButton = new JButton("Done");
        private final JButton cancelButton = new JButton("Cancel");
        private final JButton openDir = new JButton("Open dir");
        private final JButton scanDir = new JButton("Rescan");
        private final JPanel folderPanel;
        private final JLabel scanResult = new JLabel("Error loading image.");
        private final JLabel preview = new JLabel();
        private boolean save;
        private Usericon currentIcon;

        public MyItemEditor(Window owner, LinkLabelListener linkLabelListener) {
            this.dialog = new JDialog(owner);
            this.dialog.setLayout(new GridBagLayout());
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.type = new GenericComboSetting(typeNames);
            this.type.setToolTipText("Choosing a type other than Addon replaces the corresponding default icon.");
            this.type.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (type.getSettingValue() == Usericon.Type.TWITCH || type.getSettingValue() == Usericon.Type.OTHER) {
                        idVersion.setEnabled(true);
                    } else {
                        idVersion.setEnabled(false);
                        idVersion.setSettingValue("");
                    }
                }
            });
            this.idVersion = new GenericComboSetting();
            this.idVersion.setEditable(true);
            this.fileName = new GenericComboSetting();
            this.fileName.setEditable(true);
            this.fileName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("comboBoxChanged")) {
                        this.update();
                    }
                }
            });
            this.dialog.add((Component)new LinkLabel(HELP, linkLabelListener), GuiUtil.makeGbc(0, 0, 3, 1));
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 3, 1);
            gbc.fill = 2;
            this.dialog.add((Component)this.createMainPanel(), gbc);
            this.folderPanel = this.createFolderPanel();
            this.folderPanel.setVisible(false);
            gbc = GuiUtil.makeGbc(0, 2, 3, 1);
            gbc.fill = 2;
            this.dialog.add((Component)this.folderPanel, gbc);
            gbc = GuiUtil.makeGbc(0, 6, 1, 1);
            this.dialog.add((Component)new JLabel(), gbc);
            gbc = GuiUtil.makeGbc(1, 6, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.7;
            this.dialog.add((Component)this.okButton, gbc);
            gbc = GuiUtil.makeGbc(2, 6, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 0.3;
            this.dialog.add((Component)this.cancelButton, gbc);
            ActionListener buttonAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == okButton) {
                        save = true;
                    }
                    if (e.getSource() == okButton || e.getSource() == cancelButton) {
                        dialog.setVisible(false);
                    } else if (e.getSource() == openDir) {
                        MiscUtil.openFile(Chatty.getPathCreate(Chatty.PathType.IMAGE).toFile(), (Component)dialog);
                    } else if (e.getSource() == scanDir) {
                        this.scanFiles();
                    }
                }
            };
            this.okButton.addActionListener(buttonAction);
            this.cancelButton.addActionListener(buttonAction);
            this.openDir.addActionListener(buttonAction);
            this.scanDir.addActionListener(buttonAction);
            this.dialog.pack();
        }

        private JPanel createFolderPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Image Source"));
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 3, 1, 17);
            panel.add((Component)new JLabel("Chatty looks for image files (.png) in this folder:  "), gbc);
            gbc = GuiUtil.makeGbc(0, 1, 3, 1);
            JTextField path = new JTextField(Chatty.getPath(Chatty.PathType.IMAGE).toString());
            path.setEditable(false);
            path.setPreferredSize(new Dimension(0, path.getPreferredSize().height));
            gbc.fill = 2;
            gbc.weightx = 1.0;
            panel.add((Component)path, gbc);
            gbc = GuiUtil.makeGbc(0, 2, 1, 1);
            gbc.fill = 2;
            gbc.weightx = 1.0;
            panel.add((Component)this.scanResult, gbc);
            GuiUtil.smallButtonInsets(this.scanDir);
            gbc = GuiUtil.makeGbc(1, 2, 1, 1);
            panel.add((Component)this.scanDir, gbc);
            GuiUtil.smallButtonInsets(this.openDir);
            gbc = GuiUtil.makeGbc(2, 2, 1, 1);
            panel.add((Component)this.openDir, gbc);
            return panel;
        }

        private JPanel createMainPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("Type:"), GuiUtil.makeGbc(0, 1, 1, 1));
            GridBagConstraints gbc = GuiUtil.makeGbc(1, 1, 2, 1, 17);
            gbc.fill = 2;
            panel.add(this.type, gbc);
            panel.add((Component)new JLabel("ID/Version:"), GuiUtil.makeGbc(0, 2, 1, 1));
            gbc = GuiUtil.makeGbc(1, 2, 2, 1, 17);
            gbc.fill = 2;
            panel.add(this.idVersion, gbc);
            panel.add((Component)new JLabel("Restriction:"), GuiUtil.makeGbc(0, 3, 1, 1));
            gbc = GuiUtil.makeGbc(1, 3, 2, 1, 17);
            gbc.fill = 2;
            panel.add((Component)this.restriction, gbc);
            panel.add((Component)new JLabel("Channel:"), GuiUtil.makeGbc(0, 4, 1, 1));
            gbc = GuiUtil.makeGbc(1, 4, 2, 1, 17);
            gbc.fill = 2;
            panel.add((Component)this.stream, gbc);
            panel.add((Component)new JLabel("Position:"), GuiUtil.makeGbc(0, 5, 1, 1));
            gbc = GuiUtil.makeGbc(1, 5, 2, 1, 17);
            gbc.fill = 2;
            panel.add((Component)this.position, gbc);
            panel.add((Component)new JLabel("Image File:"), GuiUtil.makeGbc(0, 6, 1, 1));
            gbc = GuiUtil.makeGbc(1, 6, 2, 1, 17);
            gbc.fill = 2;
            panel.add(this.fileName, gbc);
            panel.add((Component)new JLabel("Preview:"), GuiUtil.makeGbc(0, 7, 1, 1));
            gbc = GuiUtil.makeGbc(1, 7, 1, 1, 17);
            panel.add((Component)this.preview, gbc);
            final JToggleButton sourceInfoButton = new JToggleButton("Image Folder");
            sourceInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    folderPanel.setVisible(sourceInfoButton.isSelected());
                    this.updateSize();
                }
            });
            GuiUtil.smallButtonInsets(sourceInfoButton);
            gbc = GuiUtil.makeGbc(2, 7, 1, 1);
            panel.add((Component)sourceInfoButton, gbc);
            return panel;
        }

        private void update() {
            this.createIcon(true);
            this.updatePreview();
            this.updateOkButton();
        }

        private void createIcon(boolean preview) {
            String file = this.fileName.getSettingValue();
            this.currentIcon = preview ? UsericonFactory.createCustomIcon(Usericon.Type.UNDEFINED, null, null, file, null, null) : (this.type.getSettingValue() != null ? UsericonFactory.createCustomIcon(this.type.getSettingValue(), this.idVersion.getSettingValue(), this.restriction.getText(), file, this.stream.getText(), this.position.getText()) : null);
        }

        private void updateOkButton() {
            this.okButton.setEnabled(this.currentIcon != null && this.type.getSettingValue() != null);
        }

        private void updatePreview() {
            this.preview.setText(null);
            this.preview.setIcon(null);
            if (this.currentIcon == null) {
                this.preview.setText("No image.");
            } else if (this.currentIcon.removeBadge) {
                this.preview.setText("No image.");
            } else if (this.currentIcon.fileName.startsWith("$")) {
                this.preview.setText("Ref image.");
            } else {
                ImageIcon image = this.currentIcon.getIcon(1.0f, 0, (oldImage, newImage, sizeChanged) -> this.preview.repaint()).getImageIcon();
                this.preview.setIcon(image);
                this.preview.setText(image.getIconWidth() + "x" + image.getIconHeight());
            }
            this.updateSize();
        }

        private void updateSize() {
            this.dialog.pack();
        }

        @Override
        public Usericon showEditor(Usericon preset, Component c, boolean edit, int column) {
            this.scanFiles();
            if (edit) {
                this.dialog.setTitle("Edit item");
            } else {
                this.dialog.setTitle("Add item");
            }
            if (preset != null) {
                this.restriction.setText(preset.restriction);
                this.type.setSettingValue(preset.type);
                this.idVersion.setSettingValue(preset.getIdAndVersion());
                this.fileName.setSettingValue(preset.fileName);
                this.stream.setText(preset.channelRestriction);
                this.position.setText(preset.positionValue);
                this.currentIcon = preset;
            } else {
                this.restriction.setText(null);
                this.type.setSelectedIndex(0);
                this.idVersion.setSettingValue(null);
                this.fileName.setSelectedIndex(0);
                this.stream.setText(null);
                this.position.setText(null);
                this.currentIcon = null;
            }
            this.update();
            this.save = false;
            this.dialog.setLocationRelativeTo(c);
            this.dialog.setVisible(true);
            if (this.save) {
                this.createIcon(false);
                return this.currentIcon;
            }
            return null;
        }

        private void scanFiles() {
            File file = Chatty.getPath(Chatty.PathType.IMAGE).toFile();
            File[] files = file.listFiles(new ImageFilenameFilter());
            String resultText = "";
            Object selected = this.fileName.getSelectedItem();
            this.fileName.removeAllItems();
            this.fileName.add("", "<no image>");
            this.fileName.add("$default", "$default");
            if (files == null) {
                resultText = "Error scanning folder.";
            } else {
                resultText = files.length == 0 ? "No files found." : files.length + " files found.";
                Object[] fileNames = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    fileNames[i] = files[i].getName();
                }
                Arrays.sort(fileNames);
                for (Object item : fileNames) {
                    this.fileName.add((String)item);
                }
            }
            this.fileName.setSelectedItem(selected);
            this.scanResult.setText(resultText);
        }

        public void setTwitchBadgeTypes(Set<String> types) {
            this.idVersion.clear();
            for (String type : types) {
                this.idVersion.add(type);
            }
        }
    }

    private static class ImageFilenameFilter
    implements FilenameFilter {
        private ImageFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".png");
        }
    }
}

