/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.srl;

import chatty.gui.TwitchUrl;
import chatty.gui.UrlOpener;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.RaceContextMenu;
import chatty.gui.components.settings.ListTableModel;
import chatty.util.DateTime;
import chatty.util.colors.HtmlColors;
import chatty.util.srl.Race;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class RacesTable
extends JTable {
    private static final int UPDATE_DELAY = 30000;
    private final RacesTableListener listener;
    private final MyTableModel races = new MyTableModel();
    private final ContextMenuListener contextMenuListener;

    public RacesTable(RacesTableListener listener) {
        this.listener = listener;
        this.contextMenuListener = new MyContextMenuListener();
        this.addMouseListener(new MyMouseListener());
        this.setModel(this.races);
        this.setRowSorter(new MySorter(this.races));
        this.setFillsViewportHeight(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().getColumn(2).setMaxWidth(100);
        this.getColumnModel().getColumn(3).setMaxWidth(50);
        this.getColumnModel().getColumn(4).setMaxWidth(40);
        this.getColumnModel().getColumn(2).setCellRenderer(new StateRenderer());
        Timer timer = new Timer(30000, new Updater());
        timer.setRepeats(true);
        timer.start();
    }

    public void setData(Collection<Race> data) {
        this.races.setData(data);
    }

    public Race getSelectedRace() {
        int selected = this.getSelectedRow();
        if (selected == -1) {
            return null;
        }
        return (Race)this.races.get(this.convertRowIndexToModel(selected));
    }

    public static interface RacesTableListener {
        public void openRace(Race var1);
    }

    private static class MyTableModel
    extends ListTableModel<Race> {
        public MyTableModel() {
            super(new String[]{"Game", "Goal", "State", "Time", "Entrants"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Race r = (Race)this.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return r.game;
                }
                case 2: {
                    return r.statetext;
                }
                case 1: {
                    return r.goal;
                }
                case 4: {
                    return r.getEntrants().size();
                }
                case 3: {
                    return this.formatTime(r.time);
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            if (c == 4) {
                return Integer.class;
            }
            return String.class;
        }

        private String formatTime(long time) {
            if (time > 0L) {
                return DateTime.agoClock(time, false);
            }
            return "-";
        }

        public void updateTimes() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.fireTableCellUpdated(i, 3);
            }
        }
    }

    private class MyContextMenuListener
    extends ContextMenuAdapter {
        private MyContextMenuListener() {
        }

        @Override
        public void menuItemClicked(ActionEvent e) {
            Race selectedRace = RacesTable.this.getSelectedRace();
            if (selectedRace == null) {
                return;
            }
            if (e.getActionCommand().equals("raceInfo")) {
                RacesTable.this.listener.openRace(selectedRace);
            } else if (e.getActionCommand().equals("srlRacePage")) {
                String url = TwitchUrl.makeSrlRaceLink(selectedRace.id);
                UrlOpener.openUrlPrompt(RacesTable.this, url, true);
            } else if (e.getActionCommand().equals("speedruntv")) {
                String url = TwitchUrl.makeSrtRaceLink(selectedRace.id);
                UrlOpener.openUrlPrompt(RacesTable.this, url, true);
            } else if (e.getActionCommand().equals("joinSrlChannel")) {
                String url = TwitchUrl.makeSrlIrcLink(selectedRace.id);
                UrlOpener.openUrlPrompt(RacesTable.this, url, true);
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Race selectedRace;
            if (e.getClickCount() == 2 && (selectedRace = RacesTable.this.getSelectedRace()) != null) {
                RacesTable.this.listener.openRace(selectedRace);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.selectClicked(e);
            this.openContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.openContextMenu(e);
        }

        private void openContextMenu(MouseEvent e) {
            Race selectedRace;
            if (e.isPopupTrigger() && (selectedRace = RacesTable.this.getSelectedRace()) != null) {
                RaceContextMenu m = new RaceContextMenu(selectedRace, RacesTable.this.contextMenuListener, false);
                m.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void selectClicked(MouseEvent e) {
            int clickedRow = RacesTable.this.rowAtPoint(e.getPoint());
            if (clickedRow != -1) {
                RacesTable.this.setRowSelectionInterval(clickedRow, clickedRow);
            }
        }
    }

    private static class MySorter
    extends TableRowSorter<MyTableModel> {
        public MySorter(MyTableModel model) {
            super(model);
        }

        @Override
        public void toggleSortOrder(int column) {
            List<RowSorter.SortKey> sortKeys = this.getSortKeys();
            if (sortKeys.size() > 0 && sortKeys.get(0).getSortOrder() == SortOrder.DESCENDING) {
                this.setSortKeys(null);
                return;
            }
            super.toggleSortOrder(column);
        }
    }

    private static class StateRenderer
    extends DefaultTableCellRenderer {
        private static final Color OPEN = new Color(60, 200, 10);
        private static final Color ENDED = Color.RED;
        private static final Color COMPLETE = HtmlColors.getNamedColor("BlueViolet");

        private StateRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            String state = (String)value;
            if (state.equals("Entry Open")) {
                this.setForeground(OPEN);
            } else if (state.equals("Race ended")) {
                this.setForeground(ENDED);
            } else if (state.equals("Complete") || state.equals("Race Over")) {
                this.setForeground(COMPLETE);
            } else {
                this.setForeground(Color.BLACK);
            }
            this.setText(state);
        }
    }

    private class Updater
    implements ActionListener {
        private Updater() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RacesTable.this.races.updateTimes();
        }
    }
}

