/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.srl;

import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.srl.SRLRace;
import chatty.gui.components.srl.SRLRaceFinder;
import chatty.gui.components.srl.SRLRaces;
import chatty.util.DateTime;
import chatty.util.srl.Race;
import chatty.util.srl.SpeedrunsLive;
import chatty.util.srl.SpeedrunsLiveListener;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SRL {
    private static final int UPDATE_DELAY = 4000;
    private static final int AUTO_UPDATE_DELAY = 120000;
    private static final int DATA_STALE_DELAY = 30000;
    private final Window parent;
    private final SRLRaces racesDialog;
    private final SRLRace raceInfo;
    private final SRLRaceFinder raceFinder;
    private final SpeedrunsLive srl;
    private Collection<Race> currentRaces;
    private long lastReceived;
    private boolean loading;
    private long lastError;
    private String errorMessage;
    private String entrantToSearch;

    public SRL(Window parent, SpeedrunsLive srl, ContextMenuListener contextMenuListener) {
        this.srl = srl;
        this.parent = parent;
        this.racesDialog = new SRLRaces(parent, this);
        this.raceInfo = new SRLRace(parent, contextMenuListener);
        this.raceFinder = new SRLRaceFinder(parent, this);
        this.raceFinder.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SRL.this.cancelSearch();
            }
        });
        Timer timer = new Timer(4000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRL.this.update();
            }
        });
        timer.setRepeats(true);
        timer.start();
        srl.addListener(new MySpeedrunsLiveListener());
    }

    public void openRaceList() {
        if (this.isDataStale()) {
            this.reload();
        }
        this.racesDialog.setLocationRelativeTo(this.parent);
        this.racesDialog.showDialog();
    }

    public void searchRaceWithEntrant(String stream) {
        this.entrantToSearch = stream;
        this.raceFinder.setLocationRelativeTo(this.parent);
        this.raceFinder.open(stream);
        if (this.isDataStale()) {
            this.reload();
        } else {
            this.searchRaceWithEntrant(this.currentRaces);
        }
    }

    private void searchRaceWithEntrant(Collection<Race> races) {
        if (this.entrantToSearch != null) {
            Collection<Race> foundRaces = SRL.findRaces(this.entrantToSearch, races);
            if (foundRaces.size() == 1 && !this.raceInfo.isVisible()) {
                this.raceFinder.close();
                this.openRaceInfo(foundRaces.iterator().next());
            } else {
                this.raceFinder.setFoundRaces(foundRaces);
            }
            this.entrantToSearch = null;
        }
    }

    private void cancelSearch() {
        this.entrantToSearch = null;
    }

    protected void openRaceInfo(Race race) {
        if (!this.raceInfo.isVisible()) {
            if (this.racesDialog.isVisible()) {
                this.raceInfo.setLocationRelativeTo(this.racesDialog);
            } else {
                this.raceInfo.setLocationRelativeTo(this.parent);
            }
        }
        this.raceInfo.open(race);
    }

    protected boolean isAutoUpdating() {
        return this.raceInfo.isVisible();
    }

    protected boolean isOpen(Race race) {
        return this.raceInfo.isVisible() && race.equals(this.raceInfo.getRace());
    }

    private void update() {
        if (this.loading) {
            this.racesDialog.setStatusText("Loading..");
        } else {
            String infoText = "";
            long ago = System.currentTimeMillis() - this.lastReceived;
            long errorAgo = System.currentTimeMillis() - this.lastError;
            if (this.lastReceived > 0L) {
                infoText = infoText + "Last updated: " + DateTime.duration(ago, 1, 0, new DateTime.Formatting[0]) + " ago";
            }
            if (this.isAutoUpdating()) {
                infoText = infoText + " (auto updating)";
                if (ago > 120000L && (this.lastError == -1L || errorAgo > 120000L)) {
                    this.reload();
                    return;
                }
            }
            if (this.lastError != -1L) {
                infoText = infoText + String.format(" [%s ago: %s]", DateTime.duration(errorAgo, 2, 0, new DateTime.Formatting[0]), this.errorMessage);
            }
            this.racesDialog.setStatusText(infoText);
        }
    }

    private boolean isDataStale() {
        return System.currentTimeMillis() - this.lastReceived > 30000L;
    }

    protected void reload() {
        this.setLoading(true);
        this.srl.requestRaces();
    }

    private void setLoading(boolean loading) {
        this.racesDialog.setLoading(loading);
        this.raceFinder.setLoading(loading);
        this.loading = loading;
        this.update();
    }

    public void setRaces(List<Race> newRaces) {
        this.currentRaces = newRaces;
        this.lastError = -1L;
        this.racesDialog.setRaces(newRaces);
        this.raceInfo.update(newRaces);
        this.lastReceived = System.currentTimeMillis();
        this.setLoading(false);
        this.searchRaceWithEntrant(newRaces);
    }

    protected void requestError(String description) {
        this.lastError = System.currentTimeMillis();
        this.errorMessage = description;
        this.raceInfo.error();
        this.raceFinder.error();
        this.setLoading(false);
    }

    public static final Collection<Race> findRaces(String stream, Collection<Race> races) {
        ArrayList<Race> result = new ArrayList<Race>();
        for (Race r : races) {
            for (Race.Entrant e : r.getEntrants()) {
                if (!stream.equalsIgnoreCase(e.twitch)) continue;
                result.add(r);
            }
        }
        return result;
    }

    public static final String findSrlName(String stream, Race race) {
        for (Race.Entrant entrant : race.getEntrants()) {
            if (!stream.equalsIgnoreCase(entrant.twitch)) continue;
            return entrant.name;
        }
        return null;
    }

    private class MySpeedrunsLiveListener
    implements SpeedrunsLiveListener {
        private MySpeedrunsLiveListener() {
        }

        @Override
        public void racesReceived(final List<Race> newRaces) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SRL.this.setRaces(newRaces);
                }
            });
        }

        @Override
        public void error(final String description) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SRL.this.requestError(description);
                }
            });
        }
    }
}

