/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.srl;

import chatty.gui.GuiUtil;
import chatty.gui.LinkListener;
import chatty.gui.TwitchUrl;
import chatty.gui.UrlOpener;
import chatty.gui.components.ExtendedTextPane;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.RaceContextMenu;
import chatty.gui.components.menus.RaceEntrantContextMenu;
import chatty.gui.components.settings.ListTableModel;
import chatty.util.DateTime;
import chatty.util.colors.HtmlColors;
import chatty.util.srl.Race;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SRLRace
extends JDialog {
    private static final int UPDATE_DELAY = 500;
    private final LinkLabel id;
    private final JLabel state = new JLabel();
    private final JTextField game = new JTextField();
    private final ExtendedTextPane goal = new ExtendedTextPane();
    private final JTable entrantsTable = new JTable();
    private final JLabel time = new JLabel();
    private final ContextMenuListener streamsContextMenuListener;
    private final ContextMenuListener raceContextMenuListener;
    private long timeStarted;
    private Race currentRace;
    private final MyTableModel entrants = new MyTableModel();

    public SRLRace(Window parent, ContextMenuListener streamsContextMenuListener) {
        super(parent);
        this.streamsContextMenuListener = streamsContextMenuListener;
        this.raceContextMenuListener = new RaceContextMenuListener();
        Timer timer = new Timer(500, new UpdateTimer());
        timer.setRepeats(true);
        timer.start();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = GuiUtil.makeGbc(1, 0, 1, 1, 13);
        this.id = new LinkLabel("", new MyLinkLabelListener());
        this.id.addMouseListener(new ContextMenuOpener());
        gbc.weightx = 0.5;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.id, gbc);
        gbc = GuiUtil.makeGbc(0, 4, 2, 1, 17);
        this.add((Component)this.state, gbc);
        gbc = GuiUtil.makeGbc(1, 4, 1, 1, 13);
        this.add((Component)this.time, gbc);
        gbc = GuiUtil.makeGbc(0, 0, 1, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel("Game:"), gbc);
        gbc = GuiUtil.makeGbc(0, 1, 2, 1, 17);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.game.setEditable(false);
        this.add((Component)this.game, gbc);
        gbc = GuiUtil.makeGbc(0, 2, 1, 1, 17);
        gbc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)new JLabel("Goal:"), gbc);
        gbc = GuiUtil.makeGbc(0, 3, 2, 1, 17);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.goal.setEditable(false);
        this.goal.setBackground(this.game.getBackground());
        this.goal.setBorder(this.game.getBorder());
        this.goal.setLinkListener(new MyLinkListener());
        this.goal.setMargin(this.game.getMargin());
        this.add((Component)this.goal, gbc);
        this.entrantsTable.setModel(this.entrants);
        this.entrantsTable.setFillsViewportHeight(true);
        this.entrantsTable.addMouseListener(new MouseClicks());
        TableRowSorter<MyTableModel> sorter = new TableRowSorter<MyTableModel>(this.entrants);
        this.entrantsTable.setRowSorter(sorter);
        TableColumnModel columns = this.entrantsTable.getColumnModel();
        columns.getColumn(0).setMaxWidth(40);
        columns.getColumn(2).setMaxWidth(80);
        columns.getColumn(3).setMinWidth(70);
        columns.getColumn(3).setMaxWidth(120);
        columns.getColumn(4).setMinWidth(40);
        columns.getColumn(4).setMaxWidth(40);
        sorter.setComparator(0, new PlaceSorter());
        columns.getColumn(0).setCellRenderer(new PlaceRenderer());
        columns.getColumn(3).setCellRenderer(new StateRenderer());
        gbc = GuiUtil.makeGbc(0, 5, 2, 1, 17);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.entrantsTable), gbc);
        this.setPreferredSize(new Dimension(350, 410));
        this.setSize(new Dimension(340, 410));
        this.setMinimumSize(new Dimension(200, 300));
    }

    public void open(Race race) {
        this.setRace(race);
        this.setVisible(true);
    }

    public void setRace(Race race) {
        this.currentRace = race;
        this.state.setText(race.statetext + " (" + race.getEntrants().size() + " entrants)");
        this.game.setText(race.game);
        this.goal.setText(race.goal);
        this.entrants.setData(race.getEntrants());
        this.id.setText("[srl:" + race.id + " #srl-" + race.id + "]");
        this.timeStarted = race.time;
        this.update();
        this.setTitle("Race: " + race.game + " [" + race.statetext + "]");
    }

    public void update(List<Race> races) {
        if (this.currentRace == null) {
            return;
        }
        if (races.contains(this.currentRace)) {
            this.setRace(races.get(races.indexOf(this.currentRace)));
        }
    }

    public void error() {
        if (this.currentRace != null) {
            this.setTitle("(error) " + this.currentRace.game);
        }
    }

    public Race getRace() {
        return this.currentRace;
    }

    private void update() {
        if (this.timeStarted > 0L && this.currentRace.state == 3) {
            this.time.setText(DateTime.agoClock(this.timeStarted, true));
        } else {
            this.time.setText("");
        }
    }

    private List<Race.Entrant> getSelectedEntrants() {
        int[] selected = this.entrantsTable.getSelectedRows();
        ArrayList<Race.Entrant> selectedEntrants = new ArrayList<Race.Entrant>();
        for (int i : selected) {
            selectedEntrants.add((Race.Entrant)this.entrants.get(this.entrantsTable.convertRowIndexToModel(i)));
        }
        return selectedEntrants;
    }

    private static class MyTableModel
    extends ListTableModel<Race.Entrant> {
        public MyTableModel() {
            super(new String[]{"Place", "Name", "Time", "State", "Points"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Race.Entrant e = (Race.Entrant)this.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return e;
                }
                case 1: {
                    return e.name;
                }
                case 2: {
                    return this.formatTime(e.time);
                }
                case 3: {
                    return e;
                }
                case 4: {
                    return e.points;
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            if (c == 4) {
                return Integer.class;
            }
            if (c == 0 || c == 3) {
                return Race.Entrant.class;
            }
            return String.class;
        }

        private String getPlace(Race.Entrant e) {
            if (e.time > 0L) {
                return String.valueOf(e.place);
            }
            return "-";
        }

        private String formatTime(long time) {
            if (time > 0L) {
                return DateTime.durationClock(time, true);
            }
            return "-";
        }
    }

    private class RaceContextMenuListener
    extends ContextMenuAdapter {
        private RaceContextMenuListener() {
        }

        @Override
        public void menuItemClicked(ActionEvent e) {
            Race selectedRace = SRLRace.this.currentRace;
            if (selectedRace == null) {
                return;
            }
            if (e.getActionCommand().equals("srlRacePage")) {
                String url = TwitchUrl.makeSrlRaceLink(selectedRace.id);
                UrlOpener.openUrlPrompt(SRLRace.this, url, true);
            } else if (e.getActionCommand().equals("speedruntv")) {
                String url = TwitchUrl.makeSrtRaceLink(selectedRace.id);
                UrlOpener.openUrlPrompt(SRLRace.this, url, true);
            } else if (e.getActionCommand().equals("joinSrlChannel")) {
                String url = TwitchUrl.makeSrlIrcLink(selectedRace.id);
                UrlOpener.openUrlPrompt(SRLRace.this, url, true);
            }
        }
    }

    private class UpdateTimer
    implements ActionListener {
        private UpdateTimer() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SRLRace.this.update();
        }
    }

    private class MyLinkLabelListener
    implements LinkLabelListener {
        private MyLinkLabelListener() {
        }

        @Override
        public void linkClicked(String type, String ref) {
            UrlOpener.openUrlPrompt(SRLRace.this, TwitchUrl.makeSrlRaceLink(ref));
        }
    }

    private class ContextMenuOpener
    extends MouseAdapter {
        private ContextMenuOpener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.openContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.openContextMenu(e);
        }

        private void openContextMenu(MouseEvent e) {
            if (e.isPopupTrigger() && SRLRace.this.currentRace != null) {
                RaceContextMenu m = new RaceContextMenu(SRLRace.this.currentRace, SRLRace.this.raceContextMenuListener, true);
                m.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyLinkListener
    implements LinkListener {
        private MyLinkListener() {
        }

        @Override
        public void linkClicked(String url) {
            UrlOpener.openUrlPrompt(SRLRace.this, url);
        }
    }

    private class MouseClicks
    extends MouseAdapter {
        private MouseClicks() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.selectClicked(e);
            this.openContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.openContextMenu(e);
        }

        private void openContextMenu(MouseEvent e) {
            List selectedEntrants;
            if (e.isPopupTrigger() && !(selectedEntrants = SRLRace.this.getSelectedEntrants()).isEmpty()) {
                RaceEntrantContextMenu m = new RaceEntrantContextMenu(selectedEntrants, SRLRace.this.streamsContextMenuListener);
                m.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void selectClicked(MouseEvent e) {
            int clickedRow = SRLRace.this.entrantsTable.rowAtPoint(e.getPoint());
            if (clickedRow != -1 && !SRLRace.this.entrantsTable.isRowSelected(clickedRow)) {
                SRLRace.this.entrantsTable.setRowSelectionInterval(clickedRow, clickedRow);
            }
        }
    }

    private static class PlaceSorter
    implements Comparator<Race.Entrant> {
        private PlaceSorter() {
        }

        @Override
        public int compare(Race.Entrant o1, Race.Entrant o2) {
            return o1.compareTo(o2);
        }
    }

    private static class PlaceRenderer
    extends DefaultTableCellRenderer {
        private PlaceRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            Race.Entrant e = (Race.Entrant)value;
            if (e.time > 0L) {
                this.setText(String.valueOf(e.place));
            } else {
                this.setText("-");
            }
            this.setToolTipText(e.message);
        }
    }

    private static class StateRenderer
    extends DefaultTableCellRenderer {
        private static final Color DEFAULT = Color.BLACK;
        private static final Color FORFEIT = Color.RED;
        private static final Color ENTERED = new Color(120, 120, 120);
        private static final Color FINISHED = HtmlColors.getNamedColor("BlueViolet");

        private StateRenderer() {
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            Race.Entrant e = (Race.Entrant)value;
            String state = e.statetext;
            if (state.equals("Forfeit") || state.equals("Disqualified")) {
                this.setForeground(FORFEIT);
            } else if (state.equals("Entered")) {
                this.setForeground(ENTERED);
            } else if (state.equals("Finished")) {
                this.setForeground(FINISHED);
            } else {
                this.setForeground(DEFAULT);
            }
            this.setText(state + (e.message.isEmpty() ? "" : " [..]"));
            this.setToolTipText(e.message);
        }
    }
}

