/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.srl;

import chatty.gui.GuiUtil;
import chatty.gui.components.srl.RacesTable;
import chatty.gui.components.srl.SRL;
import chatty.util.srl.Race;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SRLRaceFinder
extends JDialog {
    private final RacesTable selection;
    private final JLabel infoLabel = new JLabel();
    private final JButton cancelButton = new JButton("Close");
    private final SRL srl;
    private String currentStream;

    public SRLRaceFinder(Window parent, final SRL srl) {
        super(parent);
        this.srl = srl;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.infoLabel, GuiUtil.makeGbc(0, 0, 1, 1, 10));
        this.selection = new RacesTable(new RacesTable.RacesTableListener(){

            @Override
            public void openRace(Race race) {
                srl.openRaceInfo(race);
            }
        });
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 1, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.selection), gbc);
        gbc = GuiUtil.makeGbc(0, 2, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.cancelButton, gbc);
        this.cancelButton.setMnemonic(67);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRLRaceFinder.this.setVisible(false);
            }
        });
        Dimension defaultSize = new Dimension(400, 200);
        this.setPreferredSize(defaultSize);
        this.setSize(defaultSize);
    }

    public void open(String stream) {
        this.setTitle("Races with " + stream + " - SpeedRunsLive");
        this.currentStream = stream;
        this.selection.setData(null);
        this.setVisible(true);
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.infoLabel.setText("Loading..");
        }
    }

    protected void error() {
        this.infoLabel.setText("Error loading races.");
    }

    public void setFoundRaces(Collection<Race> races) {
        String srlName;
        String info = "Found " + races.size() + " race" + (races.size() == 1 ? "" : "s") + " with " + this.currentStream;
        if (races.size() > 0 && (srlName = SRL.findSrlName(this.currentStream, races.iterator().next())) != null && !srlName.equalsIgnoreCase(this.currentStream)) {
            info = info + " (" + srlName + ")";
        }
        if (races.size() == 1 && this.srl.isOpen(races.iterator().next())) {
            info = info + " (already open)";
        }
        this.infoLabel.setText(info);
        this.selection.setData(races);
    }

    public void close() {
        this.setVisible(false);
    }
}

