/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.srl;

import chatty.gui.GuiUtil;
import chatty.gui.components.srl.RacesTable;
import chatty.gui.components.srl.SRL;
import chatty.util.srl.Race;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SRLRaces
extends JDialog {
    private final RacesTable table;
    private final SRL srl;
    private final JLabel info = new JLabel();
    private final JButton reloadButton = new JButton("reload");

    public SRLRaces(Window owner, final SRL srl) {
        super(owner);
        this.setTitle("SpeedRunsLive");
        this.srl = srl;
        this.table = new RacesTable(new RacesTable.RacesTableListener(){

            @Override
            public void openRace(Race race) {
                srl.openRaceInfo(race);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        this.add((Component)this.info, gbc);
        gbc = GuiUtil.makeGbc(1, 0, 1, 1);
        GuiUtil.smallButtonInsets(this.reloadButton);
        this.reloadButton.setIcon(new ImageIcon(SRLRaces.class.getResource("view-refresh.png")));
        this.add((Component)this.reloadButton, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 2, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)new JScrollPane(this.table), gbc);
        ButtonAction buttonAction = new ButtonAction();
        this.reloadButton.addActionListener(buttonAction);
        this.setPreferredSize(new Dimension(600, 400));
        this.pack();
    }

    protected void setStatusText(String text) {
        this.info.setText(text);
    }

    protected void setLoading(boolean loading) {
        this.reloadButton.setEnabled(!loading);
    }

    public void setRaces(List<Race> newRaces) {
        this.table.setData(newRaces);
        this.setTitle(newRaces.size() + " Races - SpeedRunsLive");
        this.setLoading(false);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SRLRaces.this.reloadButton) {
                SRLRaces.this.srl.reload();
            }
        }
    }
}

