/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.tabs;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DraggableTabbedPane
extends JTabbedPane {
    private static final int DRAG_STARTED_THRESHOLD = 100;
    private boolean dragging;
    private int draggedTabIndex;
    private Image draggedTabImage;
    private int draggedTabImageHeight;
    private Point mouseLocation;
    private boolean canDrag;
    private long dragStarted;

    public DraggableTabbedPane() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int tabIndex;
                if (!DraggableTabbedPane.this.canDrag) {
                    return;
                }
                if (DraggableTabbedPane.this.dragStarted == 0L) {
                    DraggableTabbedPane.this.dragStarted = System.currentTimeMillis();
                }
                DraggableTabbedPane.this.mouseLocation = e.getPoint();
                if (!DraggableTabbedPane.this.dragging && (tabIndex = DraggableTabbedPane.this.getIndexForPoint(e.getPoint())) >= 0) {
                    DraggableTabbedPane.this.draggedTabIndex = tabIndex;
                    Rectangle bounds = DraggableTabbedPane.this.getBoundsAt(tabIndex);
                    BufferedImage totalImage = new BufferedImage(DraggableTabbedPane.this.getWidth(), DraggableTabbedPane.this.getHeight(), 2);
                    Graphics totalGraphics = ((Image)totalImage).getGraphics();
                    totalGraphics.setClip(bounds);
                    DraggableTabbedPane.this.setDoubleBuffered(false);
                    DraggableTabbedPane.this.paintComponent(totalGraphics);
                    DraggableTabbedPane.this.draggedTabImageHeight = bounds.height;
                    DraggableTabbedPane.this.draggedTabImage = new BufferedImage(bounds.width, bounds.height, 2);
                    Graphics g = DraggableTabbedPane.this.draggedTabImage.getGraphics();
                    g.drawImage(totalImage, 0, 0, bounds.width, bounds.height, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, DraggableTabbedPane.this);
                    DraggableTabbedPane.this.dragging = true;
                }
                DraggableTabbedPane.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DraggableTabbedPane.this.dragStarted = 0L;
                DraggableTabbedPane.this.canDrag = SwingUtilities.isLeftMouseButton(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int dropOnIndex;
                if (DraggableTabbedPane.this.dragging && DraggableTabbedPane.this.dragStartedThreshold() && (dropOnIndex = DraggableTabbedPane.this.getDropIndexForPoint(e.getPoint())) >= 0) {
                    DraggableTabbedPane.this.moveTab(DraggableTabbedPane.this.draggedTabIndex, dropOnIndex);
                }
                DraggableTabbedPane.this.dragging = false;
                DraggableTabbedPane.this.draggedTabImage = null;
                DraggableTabbedPane.this.dragStarted = 0L;
                DraggableTabbedPane.this.repaint();
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DraggableTabbedPane.this.dragging = false;
                DraggableTabbedPane.this.dragStarted = 0L;
                DraggableTabbedPane.this.repaint();
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dragging && this.mouseLocation != null && this.draggedTabImage != null && this.dragStartedThreshold()) {
            g.drawImage(this.draggedTabImage, this.mouseLocation.x, this.mouseLocation.y - this.draggedTabImageHeight / 2, this);
            int tabIndex = this.getDropIndexForPoint(this.mouseLocation);
            if (tabIndex >= 0 && tabIndex != this.draggedTabIndex && tabIndex != this.draggedTabIndex + 1) {
                boolean drawBeforeTab = true;
                if (tabIndex >= this.getTabCount()) {
                    tabIndex = this.getTabCount() - 1;
                    drawBeforeTab = false;
                }
                Rectangle bounds = this.getUI().getTabBounds(this, tabIndex);
                if (drawBeforeTab) {
                    g.fillRect(bounds.x, bounds.y, 3, bounds.height);
                } else {
                    g.fillRect(bounds.x + bounds.width - 3, bounds.y, 3, bounds.height);
                }
            }
        }
    }

    private long dragStartedAgo() {
        if (this.dragStarted == 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.dragStarted;
    }

    private boolean dragStartedThreshold() {
        return this.dragStartedAgo() > 100L;
    }

    private void moveTab(int from, int to) {
        if (from == to) {
            return;
        }
        Component comp = this.getComponentAt(from);
        String title = this.getTitleAt(from);
        String toolTip = this.getToolTipTextAt(from);
        Icon icon = this.getIconAt(from);
        Component tabComp = this.getTabComponentAt(from);
        this.removeTabAt(from);
        if (from < to) {
            --to;
        }
        this.insertTab(title, icon, comp, toolTip, to);
        this.setTabComponentAt(to, tabComp);
        this.setSelectedComponent(comp);
    }

    private int getIndexForPoint(Point p) {
        return this.indexAtLocation(p.x, p.y);
    }

    private int getDropIndexForPoint(Point p) {
        int index = this.getIndexForPoint(p);
        if (index >= 0) {
            Rectangle bounds = this.getBoundsAt(index);
            if (p.x < bounds.x + bounds.width / 2) {
                return index;
            }
            return index + 1;
        }
        Rectangle bounds = this.getBoundsAt(this.getTabCount() - 1);
        bounds.width += 30;
        if (bounds.contains(p)) {
            return this.getTabCount();
        }
        return -1;
    }
}

