/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.tabs;

import chatty.gui.components.tabs.DraggableTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class Tabs
extends JPanel {
    private final JTabbedPane tabs = new DraggableTabbedPane();
    private Component firstComp;
    private boolean mouseWheelScrolling = true;
    private boolean mouseWheelScrollingAnywhere = false;
    private TabOrder order = TabOrder.INSERTION;
    private JPopupMenu popupMenu;

    public Tabs() {
        this.setLayout(new BorderLayout());
        this.tabs.setOpaque(false);
        this.tabs.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (Tabs.this.mouseWheelScrolling) {
                    int index = Tabs.this.tabs.indexAtLocation(e.getX(), e.getY());
                    if (Tabs.this.mouseWheelScrollingAnywhere || index != -1 || Tabs.this.isNearLastTab(e.getPoint())) {
                        if (e.getWheelRotation() < 0) {
                            Tabs.this.setSelectedPrevious();
                        } else if (e.getWheelRotation() > 0) {
                            Tabs.this.setSelectedNext();
                        }
                    }
                }
            }
        });
        this.tabs.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Tabs.this.openPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Tabs.this.openPopupMenu(e);
            }
        });
    }

    private void openPopupMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.popupMenu == null) {
            return;
        }
        int index = this.tabs.indexAtLocation(e.getX(), e.getY());
        if (this.tabs.getSelectedIndex() == index) {
            this.popupMenu.show(this.tabs, e.getX(), e.getY());
        }
    }

    private boolean isNearLastTab(Point p) {
        Rectangle bounds = this.tabs.getBoundsAt(this.tabs.getTabCount() - 1);
        bounds.width += 99999;
        return bounds.contains(p);
    }

    public void setMouseWheelScrollingEnabled(boolean enabled) {
        this.mouseWheelScrolling = enabled;
    }

    public void setMouseWheelScrollingAnywhereEnabled(boolean enabled) {
        this.mouseWheelScrollingAnywhere = enabled;
    }

    public void setTabPlacement(String location) {
        this.tabs.setTabPlacement(this.getTabPlacementValue(location));
    }

    private int getTabPlacementValue(String location) {
        switch (location) {
            case "top": {
                return 1;
            }
            case "bottom": {
                return 3;
            }
            case "left": {
                return 2;
            }
            case "right": {
                return 4;
            }
        }
        return 1;
    }

    public void setTabLayoutPolicy(String type) {
        this.tabs.setTabLayoutPolicy(this.getTabLayoutPolicyValue(type));
    }

    private int getTabLayoutPolicyValue(String type) {
        switch (type) {
            case "wrap": {
                return 0;
            }
            case "scroll": {
                return 1;
            }
        }
        return 0;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popupMenu = menu;
    }

    public void addTab(Component comp) {
        if (this.tabs.getTabCount() == 0) {
            if (this.firstComp == null) {
                this.add(comp, "Center");
                this.firstComp = comp;
                this.validate();
                this.repaint();
            } else {
                this.remove(this.firstComp);
                this.add((Component)this.tabs, "Center");
                this.appendTab(this.firstComp);
                this.appendTab(comp);
                this.firstComp = null;
            }
        } else {
            this.appendTab(comp);
        }
    }

    public void removeTab(Component comp) {
        if (this.tabs.getTabCount() == 0) {
            if (this.firstComp == null || this.firstComp != comp) {
                return;
            }
            super.remove(this.firstComp);
            this.firstComp = null;
            this.validate();
            this.repaint();
            return;
        }
        this.tabs.remove(comp);
        if (this.tabs.getTabCount() == 1) {
            if (this.firstComp != this.tabs.getSelectedComponent()) {
                this.firstComp = this.tabs.getSelectedComponent();
            }
            this.tabs.remove(this.firstComp);
            this.add(this.firstComp, "Center");
            super.remove(this.tabs);
        }
    }

    public int getTabCount() {
        if (this.tabs.getTabCount() > 0) {
            return this.tabs.getTabCount();
        }
        if (this.firstComp != null) {
            return 1;
        }
        return 0;
    }

    private void appendTab(Component comp) {
        String title = comp.getName();
        int insertAt = this.findInsertPosition(title);
        this.tabs.insertTab(title, null, comp, title, insertAt);
    }

    private int findInsertPosition(String newTabName) {
        if (this.order == TabOrder.ALPHABETIC) {
            for (int i = 0; i < this.tabs.getTabCount(); ++i) {
                if (newTabName.compareToIgnoreCase(this.tabs.getTitleAt(i)) >= 0) continue;
                return i;
            }
        }
        return this.tabs.getTabCount();
    }

    public void addChangeListener(ChangeListener listener) {
        this.tabs.addChangeListener(listener);
    }

    public Component getSelectedComponent() {
        if (this.firstComp != null) {
            return this.firstComp;
        }
        return this.tabs.getSelectedComponent();
    }

    public int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    public void setSelectedComponent(Component c) {
        if (this.tabs.indexOfComponent(c) != -1) {
            this.tabs.setSelectedComponent(c);
        }
    }

    public void setSelectedNext() {
        int count;
        int index = this.tabs.getSelectedIndex();
        if (index + 1 < (count = this.tabs.getTabCount())) {
            this.tabs.setSelectedIndex(index + 1);
        } else if (count > 0) {
            this.tabs.setSelectedIndex(0);
        }
    }

    public void setSelectedPrevious() {
        int index = this.tabs.getSelectedIndex();
        int count = this.tabs.getTabCount();
        if (count > 0) {
            if (index - 1 >= 0) {
                this.tabs.setSelectedIndex(index - 1);
            } else {
                this.tabs.setSelectedIndex(count - 1);
            }
        }
    }

    public void setForegroundAt(int index, Color foreground) {
        this.tabs.setForegroundAt(index, foreground);
    }

    public void setForegroundForComponent(Component comp, Color foreground) {
        int index = this.tabs.indexOfComponent(comp);
        if (index != -1) {
            this.tabs.setForegroundAt(index, foreground);
        }
    }

    public void setTitleForComponent(Component comp, String title, String tooltip) {
        int index = this.tabs.indexOfComponent(comp);
        if (index != -1) {
            this.tabs.setTitleAt(index, title);
            this.tabs.setToolTipTextAt(index, tooltip);
            if (title.startsWith("#")) {
                this.tabs.getAccessibleContext().setAccessibleName("Channel " + title.substring(1));
                this.tabs.getAccessibleContext().setAccessibleDescription("");
            }
        }
    }

    public void setOrder(TabOrder order) {
        this.order = order;
    }

    public Collection<Component> getComponents(Component c, int direction) {
        ArrayList<Component> result = new ArrayList<Component>();
        int index = this.tabs.indexOfComponent(c);
        if (index != -1) {
            int i;
            if (direction == 1 || direction == 0) {
                for (i = index + 1; i < this.getTabCount(); ++i) {
                    result.add(this.tabs.getComponentAt(i));
                }
            }
            if (direction == -1 || direction == 0) {
                for (i = index - 1; i >= 0; --i) {
                    result.add(this.tabs.getComponentAt(i));
                }
            }
        }
        return result;
    }

    public Collection<Component> getAllComponents() {
        ArrayList<Component> result = new ArrayList<Component>();
        if (this.firstComp != null) {
            result.add(this.firstComp);
        } else {
            for (int i = 0; i < this.getTabCount(); ++i) {
                result.add(this.tabs.getComponentAt(i));
            }
        }
        return result;
    }

    public static enum TabOrder {
        INSERTION,
        ALPHABETIC;

    }
}

