/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.User;
import chatty.gui.components.textpane.InfoMessage;

public class AutoModMessage
extends InfoMessage {
    public final User user;
    public final String msgId;
    public final String message;
    private final int msgStart;
    private final int msgEnd;

    public AutoModMessage(User user, String message, String id) {
        super(InfoMessage.Type.INFO, AutoModMessage.makeText(user, message));
        this.user = user;
        this.msgId = id;
        this.message = message;
        this.msgStart = this.text.length() - message.length();
        this.msgEnd = this.text.length();
    }

    public AutoModMessage(AutoModMessage other) {
        super(other);
        this.user = other.user;
        this.msgId = other.msgId;
        this.message = other.message;
        this.msgStart = other.msgStart;
        this.msgEnd = other.msgEnd;
    }

    @Override
    public AutoModMessage copy() {
        return new AutoModMessage(this);
    }

    @Override
    public int getMsgStart() {
        return this.msgStart;
    }

    @Override
    public int getMsgEnd() {
        return this.msgEnd;
    }

    private static String makeText(User user, String message) {
        return String.format("[AutoMod] <%s> %s", user.getDisplayNick(), message);
    }
}

