/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.Chatty;
import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.gui.LinkListener;
import chatty.gui.MainGui;
import chatty.gui.MouseClickedListener;
import chatty.gui.StyleServer;
import chatty.gui.UrlOpener;
import chatty.gui.UserListener;
import chatty.gui.components.Channel;
import chatty.gui.components.ChannelEditBox;
import chatty.gui.components.SimplePopup;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.textpane.AutoModMessage;
import chatty.gui.components.textpane.FixSelection;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.components.textpane.LinkController;
import chatty.gui.components.textpane.Message;
import chatty.gui.components.textpane.ModLogInfo;
import chatty.gui.components.textpane.MyDocument;
import chatty.gui.components.textpane.MyEditorKit;
import chatty.gui.components.textpane.MyIconView;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.gui.components.textpane.NoScrollCaret;
import chatty.gui.components.textpane.UserMessage;
import chatty.gui.components.textpane.UserNotice;
import chatty.gui.components.textpane.Util;
import chatty.gui.components.userinfo.UserNotes;
import chatty.gui.emoji.EmojiUtil;
import chatty.gui.transparency.TransparencyComponent;
import chatty.util.ChattyMisc;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.MiscUtil;
import chatty.util.Pair;
import chatty.util.RepeatMsgHelper;
import chatty.util.ReplyManager;
import chatty.util.RingBuffer;
import chatty.util.StringUtil;
import chatty.util.Timestamp;
import chatty.util.api.CachedImage;
import chatty.util.api.CheerEmoticon;
import chatty.util.api.Emoticon;
import chatty.util.api.Emoticons;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import chatty.util.api.eventsub.payloads.SuspiciousMessagePayload;
import chatty.util.api.usericons.Usericon;
import chatty.util.api.usericons.UsericonFactory;
import chatty.util.api.usericons.UsericonManager;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.colors.ColorCorrector;
import chatty.util.colors.HtmlColors;
import chatty.util.irc.IrcBadges;
import chatty.util.irc.MsgTags;
import chatty.util.irc.UserTagsUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class ChannelTextPane
extends JTextPane
implements LinkListener,
CachedImage.CachedImageUser,
TransparencyComponent {
    private static final Logger LOGGER = Logger.getLogger(ChannelTextPane.class.getName());
    private static final ImageIcon REPLY_ICON = new ImageIcon(MainGui.class.getResource("reply.png"));
    private static final ImageIcon NO_CHAT_ICON = new ImageIcon(MainGui.class.getResource("no_chat.png"));
    private final DefaultStyledDocument doc;
    private static AtomicLong idCounter = new AtomicLong();
    private static final Color BACKGROUND_COLOR = new Color(250, 250, 250);
    private String compactMode = null;
    private long compactModeStart = 0L;
    private int compactModeLength = 0;
    private static final int MAX_COMPACTMODE_LENGTH = 10;
    private static final int MAX_COMPACTMODE_TIME = 30000;
    private static final int MAX_BAN_MESSAGE_COMBINE_TIME = 10000;
    private static final int BUFFER_SIZE_MIN = 10;
    private static final int BUFFER_SIZE_MAX = 10000;
    private static final Matcher urlMatcher = Helper.getUrlPattern().matcher("");
    public MainGui main;
    private Channel channel;
    protected LinkController linkController = new LinkController();
    private final StyleServer styleServer;
    private final RingBuffer<MentionCheck> lastUsers = new RingBuffer(300);
    protected static User hoveredUser;
    private boolean newlineRequired = false;
    private static final long DELETED_MESSAGES_KEEP = 0L;
    protected final Styles styles = new Styles();
    private final ScrollManager scrollManager;
    public final LineSelection lineSelection;
    private int messageTimeout = -1;
    private final MyEditorKit kit;
    private final boolean insertTop;
    private final Timer updateTimer;
    public final Type type;
    private final Map<User, SuspiciousMessagePayload> pendingLowTrustInfoCache = new HashMap<User, SuspiciousMessagePayload>();
    private int transparency;
    private final List<ModLogInfo> cachedModLogInfo = new ArrayList<ModLogInfo>();
    private static final int MOD_ACTION_WAIT = 1000;
    private Element lastSearchPos = null;
    boolean even = false;
    private int fCount = 0;
    private final Random fRand = new Random();
    private long fSeed;
    private final int MAX_TEXT_LENGTH = 2000;
    private int lengthSinceNewline = 0;
    private SimplePopup linePopup;

    public ChannelTextPane(MainGui main, StyleServer styleServer, final Type type, boolean startAtBottom, boolean insertTop) {
        this.getAccessibleContext().setAccessibleName("Chat Output");
        this.getAccessibleContext().setAccessibleDescription("");
        this.lineSelection = new LineSelection(main.getUserListener());
        this.styleServer = styleServer;
        this.main = main;
        this.type = type;
        this.setBackground(BACKGROUND_COLOR);
        this.addMouseListener(this.linkController);
        this.addMouseMotionListener(this.linkController);
        this.linkController.setType(type);
        this.linkController.addUserListener(main.getUserListener());
        this.linkController.addUserListener(this.lineSelection);
        this.linkController.setUserHoverListener(user -> this.setHoveredUser((User)user));
        this.linkController.setLinkListener(this);
        this.linkController.setMainGui(main);
        this.scrollManager = new ScrollManager();
        this.addMouseListener(this.scrollManager);
        this.addMouseMotionListener(this.scrollManager);
        this.kit = new MyEditorKit(startAtBottom && !insertTop);
        this.insertTop = insertTop;
        this.setEditorKit(this.kit);
        this.setDocument(new MyDocument());
        this.doc = (DefaultStyledDocument)this.getStyledDocument();
        this.setEditable(false);
        NoScrollCaret caret = new NoScrollCaret();
        caret.setUpdatePolicy(1);
        this.setCaret(caret);
        this.styles.setStyles();
        this.updateTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (type == Type.STREAM_CHAT) {
                    ChannelTextPane.this.removeOldLines();
                }
                ChannelTextPane.this.removeAbandonedModLogInfo();
            }
        });
        this.updateTimer.setRepeats(true);
        this.updateTimer.start();
        FixSelection.install(this);
    }

    public void cleanUp() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        this.scrollManager.cleanUp();
        this.linkController.cleanUp();
        this.kit.clearImages();
    }

    public void setMessageTimeout(int seconds) {
        this.messageTimeout = seconds;
    }

    public void setContextMenuListener(ContextMenuListener listener) {
        this.linkController.setContextMenuListener(listener);
    }

    public void setMouseClickedListener(MouseClickedListener listener) {
        this.linkController.setMouseClickedListener(listener);
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.linkController.setChannel(channel);
    }

    private void setHoveredUser(User user) {
        int mode = this.styles.getInt(Setting.HIGHLIGHT_HOVERED_USER);
        if (mode == 0) {
            if (hoveredUser != null) {
                hoveredUser = null;
                this.repaint();
            }
        } else if (user != hoveredUser) {
            hoveredUser = user;
            this.repaint();
        }
    }

    @Override
    public void setTransparent(int transparency) {
        if (this.transparency == transparency) {
            return;
        }
        this.transparency = transparency;
        this.refreshStyles();
        this.updateCustomColorTransparency();
        if (this.channel != null) {
            if (transparency == 0) {
                this.channel.restoreInput();
            } else {
                this.channel.hideInput();
            }
        }
    }

    private Color transparency(Color input) {
        if (this.transparency <= 0) {
            return input;
        }
        int alpha = (int)(255.0 * (1.0 - (double)this.transparency / 100.0));
        return new Color(input.getRed(), input.getGreen(), input.getBlue(), alpha);
    }

    @Override
    public void iconLoaded(Image oldImage, Image newImage, boolean sizeChanged) {
        this.kit.changeImage(oldImage, newImage);
        boolean repainted = false;
        if (!sizeChanged) {
            repainted = this.repaintImage(newImage);
        }
        if (!repainted) {
            ((MyDocument)this.doc).refresh();
            if (Debugging.isEnabled("gifd", "gifd2")) {
                Debugging.println("Refresh");
            }
        }
        this.scrollDownIfNecessary();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x10) != 0 && !Debugging.isEnabled("gif1")) {
            if (!this.isShowing()) {
                return false;
            }
            boolean imageToRepaintStillPresent = this.repaintImage(img);
            if (Debugging.isEnabled("gifd") || Debugging.isEnabled("gifd2") && !imageToRepaintStillPresent) {
                Debugging.println(String.format("FRAMEBITS (%s) %d,%d,%d,%d %d %s", img, x, y, w, h, Debugging.millisecondsElapsed("gifd"), imageToRepaintStillPresent));
            }
            return imageToRepaintStillPresent;
        }
        return super.imageUpdate(img, infoflags, x, y, w, h);
    }

    private boolean repaintImage(Image image) {
        Collection<MyIconView> set = this.kit.getByImage(image);
        boolean anyVisible = false;
        if (set != null && !set.isEmpty()) {
            Rectangle r = new Rectangle();
            for (MyIconView v : set) {
                if (!Debugging.isEnabled("gift") && v.shouldCheckVisibility()) {
                    SwingUtilities.invokeLater(() -> this.checkViewVisibility(v));
                }
                if (!v.getShouldRepaint()) continue;
                v.getRectangle(r);
                this.repaint(r);
                anyVisible = true;
            }
        }
        return anyVisible;
    }

    private void checkViewVisibility(MyIconView v) {
        try {
            boolean northOfVisibleRect;
            Rectangle viewRect = this.modelToView(v.getStartOffset());
            boolean bl = northOfVisibleRect = viewRect != null && viewRect.y + v.getAdjustedHeight() < this.getVisibleRect().y;
            if (Debugging.isEnabled("gifd4")) {
                Debugging.println("Check " + (viewRect.y + v.getAdjustedHeight()) + " < " + this.getVisibleRect().y);
                if (northOfVisibleRect) {
                    Debugging.println("Stop " + v);
                }
            }
            if (northOfVisibleRect) {
                v.setDontRepaint();
                this.kit.debug();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void remove(int start, int len) throws BadLocationException {
        Debugging.edt();
        int startLine = this.doc.getDefaultRootElement().getElementIndex(start);
        int endLine = this.doc.getDefaultRootElement().getElementIndex(start + len);
        Set<Long> before = Util.getImageIds(this.doc, startLine, endLine);
        this.doc.remove(start, len);
        if (!before.isEmpty()) {
            Set<Long> after = Util.getImageIds(this.doc, startLine, endLine);
            if (Debugging.isEnabled("gifd", "gifd2")) {
                Debugging.println(String.format("Removed %d+%d (Before: %s After: %s)", start, len, before, after));
            }
            before.removeAll(after);
            for (long id : before) {
                this.kit.clearImage(id);
            }
        }
    }

    public void printMessage(Message message) {
        if (message instanceof UserMessage) {
            this.printUserMessage((UserMessage)message);
        }
    }

    private void printUsernotice(UserNotice message, MutableAttributeSet style) {
        MutableAttributeSet announcementStyle;
        boolean isAnnouncement;
        MutableAttributeSet userStyle;
        this.closeCompactMode();
        this.printTimestamp(style);
        this.printChannelIcon(null, message.localUser);
        this.printSharedInfo(message.user, message.localUser, message.tags);
        if (message.user.getName().isEmpty()) {
            userStyle = style;
        } else {
            userStyle = this.styles.user(message.user, style);
            userStyle.addAttribute((Object)Attribute.IS_USER_MESSAGE, true);
            this.lastUsers.add(new MentionCheck(message.user));
        }
        boolean bl = isAnnouncement = message.tags != null && message.tags.isValue("msg-id", "announcement");
        if (isAnnouncement && (announcementStyle = this.styles.announcement(message.user, message.tags)) != null) {
            this.print("*", announcementStyle);
        }
        String text = String.format("[%s] %s", message.type, message.infoText);
        int offset = text.length();
        this.printSpecials(message.user, text, userStyle, message.highlightMatches);
        if (!StringUtil.isNullOrEmpty(message.attachedMessage)) {
            boolean showBrackets;
            boolean bl2 = showBrackets = !isAnnouncement;
            if (showBrackets) {
                this.print(" [", style);
                offset += 2;
            }
            boolean ignoreLinks = !isAnnouncement;
            List<Highlighter.Match> highlightMatches = Highlighter.Match.shiftMatchList(message.highlightMatches, -offset);
            this.printSpecialsNormal(message.attachedMessage, message.user, style, message.emotes, ignoreLinks, false, highlightMatches, null, null, message.tags);
            if (showBrackets) {
                this.print("]", style);
            }
        }
        this.finishLine();
    }

    private void printAutoModMessage(AutoModMessage message, AttributeSet style) {
        this.closeCompactMode();
        this.printTimestamp(style);
        this.printChannelIcon(null, message.localUser);
        MutableAttributeSet userStyle = this.styles.user(message.user, style);
        userStyle.addAttribute((Object)Attribute.ID_AUTOMOD, message.msgId);
        String startText = "[AutoMod] <" + message.user.getDisplayNick() + "> ";
        this.printSpecials(message.user, startText, userStyle, message.highlightMatches);
        this.printSpecialsInfo(message.message, style, Highlighter.Match.shiftMatchList(message.highlightMatches, -startText.length()), message.tags);
        this.finishLine();
    }

    private void printUserMessage(UserMessage message) {
        SuspiciousMessagePayload pendingLowTrust;
        int repeatMsg;
        User user = message.user;
        boolean ignored = message.ignored_compact;
        if (ignored) {
            this.printCompact("IGNORED", user);
            return;
        }
        Color color = message.color;
        boolean action = message.action;
        String text = message.text;
        Emoticons.TagEmotes emotes = message.emotes;
        boolean highlighted = message.highlighted;
        if (message.whisper && message.action) {
            color = StyleConstants.getForeground(this.styles.info());
            highlighted = true;
        }
        Color background = null;
        if (message.backgroundColor != null) {
            background = message.backgroundColor;
        } else if (message.highlighted) {
            background = MyStyleConstants.getHighlightBackground(this.styles.paragraph());
        }
        this.closeCompactMode();
        MutableAttributeSet style = highlighted ? this.styles.highlight(color) : this.styles.standard(color);
        this.printTimestamp(style, message.historicTimeStamp);
        String hypeChatText = message.tags.getHypeChatAmountText();
        if (hypeChatText != null) {
            this.print(" " + hypeChatText + " ", this.styles.hypeChat(style, message.tags));
            this.print(" ", style);
        }
        this.printUser(user, message.localUser, action, message.whisper, message.msgId, background, message.tags);
        if (!highlighted && color == null && action && this.styles.isEnabled(Setting.ACTION_COLORED)) {
            style = this.styles.standard(user.getDisplayColor());
        }
        this.print(" ", style);
        this.printSpecialsNormal(text, user, style, emotes, false, message.bits > 0, message.highlightMatches, message.replaceMatches, message.replacement, message.tags);
        if (message.highlighted) {
            this.setLineHighlighted(this.getCurrentParagraphOffset(), message.highlightSource);
        }
        this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.IGNORE_SOURCE, message.ignoreSource);
        this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.ROUTING_SOURCE, message.routingSource);
        if (message.backgroundColor != null || message.color != null) {
            this.setCustomColor(this.getCurrentParagraphOffset(), message.backgroundColor, message.colorSource);
        }
        this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.LINE_ID, message.lineId);
        this.finishLine();
        String powerUpInfo = message.tags.getPowerUpInfo();
        if (powerUpInfo != null) {
            this.changeInfo(this.getLastLine(this.doc), attributes -> attributes.addAttribute((Object)Attribute.POWER_UP_INFO, powerUpInfo));
        }
        if ((repeatMsg = RepeatMsgHelper.getRepeatMsg(message.tags)) > 1) {
            this.changeInfo(this.getLastLine(this.doc), attributes -> attributes.addAttribute((Object)Attribute.REPEAT_MESSAGE_COUNT, repeatMsg));
        }
        if ((pendingLowTrust = this.pendingLowTrustInfoCache.remove(user)) != null) {
            this.printLowTrustInfo(user, pendingLowTrust);
        }
        this.lastUsers.add(new MentionCheck(user));
    }

    public void printInfoMessage(InfoMessage message) {
        if (message.msgType == InfoMessage.Type.APPEND) {
            this.appendToMessage(message);
            return;
        }
        MutableAttributeSet style = message.highlighted ? this.styles.highlight(message.color) : this.styles.info(message.color);
        if (message instanceof ModLogInfo) {
            boolean success;
            ModLogInfo modLogInfo = (ModLogInfo)message;
            if (modLogInfo.showActionBy && !(success = this.printModLogInfo(modLogInfo))) {
                this.cachedModLogInfo.add(modLogInfo);
            }
            if (!message.isHidden()) {
                this.printInfoMessage2(message, style);
            }
        } else if (message instanceof UserNotice) {
            this.printUsernotice((UserNotice)message, style);
            if (message.objectId != null) {
                this.setObjectId(this.getCurrentParagraphOffset(), message.objectId);
            }
        } else if (message instanceof AutoModMessage) {
            this.printAutoModMessage((AutoModMessage)message, style);
        } else {
            this.printInfoMessage2(message, style);
            String command = message.makeCommand();
            if (command != null) {
                this.setLineCommand(this.getCurrentParagraphOffset(), command);
            }
            if (message.objectId != null) {
                this.setObjectId(this.getCurrentParagraphOffset(), message.objectId);
            }
            this.replayModLogInfo();
        }
        if (!message.isHidden()) {
            if (message.highlighted) {
                this.setLineHighlighted(this.getCurrentParagraphOffset(), message.highlightSource);
            }
            this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.IGNORE_SOURCE, message.ignoreSource);
            this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.ROUTING_SOURCE, message.routingSource);
            if (message.bgColor != null || message.color != null) {
                this.setCustomColor(this.getCurrentParagraphOffset(), message.bgColor, message.colorSource);
            }
            this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.LINE_ID, message.lineId);
            if (message.localUser != null) {
                this.setParagraphAttribute(this.getCurrentParagraphOffset(), Attribute.LOCAL_USER, message.localUser);
            }
        }
    }

    private void printInfoMessage2(InfoMessage message, AttributeSet style) {
        this.closeCompactMode();
        this.printTimestamp(style);
        this.printChannelIcon(null, message.localUser);
        this.printSpecialsInfo(message.text, style, message.highlightMatches, message.tags);
        for (MsgTags.Link link : message.getAppendedLinks()) {
            this.print(" ", style);
            this.print(link.label, this.styles.generalLink(style, link));
        }
        this.finishLine();
    }

    private void appendToMessage(InfoMessage message) {
        if (message.objectId == null) {
            return;
        }
        Element line = this.findLineBy(element -> element.getAttributes().containsAttribute((Object)Attribute.OBJECT_ID, message.objectId));
        if (line != null) {
            this.changeInfo(line, attributes -> attributes.addAttribute((Object)Attribute.INFO_TEXT, message.text));
        }
    }

    private void replayModLogInfo() {
        this.removeAbandonedModLogInfo();
        if (this.cachedModLogInfo.isEmpty()) {
            return;
        }
        Debugging.println("modlog", "ModLog Replay %s", this.cachedModLogInfo);
        Iterator<ModLogInfo> it = this.cachedModLogInfo.iterator();
        while (it.hasNext()) {
            ModLogInfo info = it.next();
            boolean success = this.printModLogInfo(info);
            if (!success) continue;
            it.remove();
        }
        Debugging.println("modlog", "ModLog Replay After %s", this.cachedModLogInfo);
    }

    private void removeAbandonedModLogInfo() {
        if (this.cachedModLogInfo.isEmpty()) {
            return;
        }
        Iterator<ModLogInfo> it = this.cachedModLogInfo.iterator();
        ArrayList<ModLogInfo> print = new ArrayList<ModLogInfo>();
        while (it.hasNext()) {
            ModLogInfo info = it.next();
            if (info.age() <= 1000L) continue;
            Debugging.println("modlog", "ModLogAction Abandoned: %s", info);
            it.remove();
            if (!info.isHidden()) continue;
            print.add(info);
        }
        if (this.channel != null && Helper.isRegularChannelStrict(this.channel.getChannel())) {
            for (ModLogInfo info : print) {
                this.main.printAbandonedModLogInfo(info);
            }
        }
    }

    private boolean printModLogInfo(ModLogInfo info) {
        String command = info.makeCommand().trim();
        Debugging.println("modlog", "ModLog Command: %s", command);
        for (Element line : this.iterateLines()) {
            if (info.isBanCommand()) {
                if (!line.getAttributes().containsAttribute((Object)Attribute.COMMAND, command)) continue;
                Element infoElement = ChannelTextPane.getElementContainingAttributeKey(line, (Object)Attribute.IS_APPENDED_INFO);
                if (infoElement == null) {
                    Debugging.println("modlog", "ModLog: No info", new Object[0]);
                    return true;
                }
                long updated = (Long)infoElement.getAttributes().getAttribute((Object)Attribute.APPENDED_INFO_UPDATED);
                if (System.currentTimeMillis() - updated > 1000L) {
                    Debugging.println("modlog", "ModLog: Appended too old", new Object[0]);
                    return false;
                }
                this.changeInfo(line, attributes -> {
                    this.addBy(attributes, info.data.created_by);
                    if (info.getReason() != null) {
                        attributes.addAttribute((Object)Attribute.ACTION_REASON, info.getReason());
                    }
                });
                return true;
            }
            if (info.isAutoModAction()) {
                Element userElement = ChannelTextPane.getUserElementFromLine(line, false);
                if (userElement == null) continue;
                String msgId = ((ModActionPayload.AutoModMessageUpdate)info.data.action).getMsgId();
                if (!userElement.getAttributes().containsAttribute((Object)Attribute.ID_AUTOMOD, msgId)) continue;
                this.changeInfo(line, attr -> {
                    String existing = (String)attr.getAttribute((Object)Attribute.AUTOMOD_ACTION);
                    String action = "approved";
                    if (info.data.type == ModActionPayload.Type.AUTOMOD_DENIED) {
                        action = "denied";
                    }
                    String infoText = StringUtil.append(existing, ", ", action + "/@" + info.data.created_by);
                    attr.addAttribute((Object)Attribute.AUTOMOD_ACTION, infoText);
                });
                return true;
            }
            if (this.getTimeAgo(line) > 1000L) {
                Debugging.println("modlog", "ModLog: Line too old", new Object[0]);
                return false;
            }
            if (!line.getAttributes().containsAttribute((Object)Attribute.COMMAND, command)) continue;
            this.changeInfo(line, attributes -> this.addBy(attributes, info.data.created_by));
            return true;
        }
        Debugging.println("modlog", "ModLog: Gave up", new Object[0]);
        return false;
    }

    private void addBy(MutableAttributeSet attributes, String byName) {
        List old = (List)attributes.getAttribute((Object)Attribute.ACTION_BY);
        ArrayList<String> changed = old != null ? new ArrayList(old) : new ArrayList<String>();
        changed.remove(byName);
        changed.add(byName);
        attributes.addAttribute((Object)Attribute.ACTION_BY, changed);
    }

    private long getTimeAgo(Element element) {
        Long timestamp = (Long)element.getAttributes().getAttribute((Object)Attribute.TIMESTAMP);
        if (timestamp != null) {
            return System.currentTimeMillis() - timestamp;
        }
        return Long.MAX_VALUE;
    }

    private static Element getElementContainingAttributeKey(Element parent, Object key) {
        for (int i = 0; i < parent.getElementCount(); ++i) {
            Element element = parent.getElement(i);
            if (!element.getAttributes().isDefined(key)) continue;
            return element;
        }
        return null;
    }

    private void increasePreviousBanMessage(Element line, long duration, String reason) {
        this.changeInfo(line, attributes -> {
            Integer count = (Integer)attributes.getAttribute((Object)Attribute.BAN_MESSAGE_COUNT);
            if (count == null) {
                count = 2;
            } else {
                Integer n = count;
                count = count + 1;
            }
            attributes.addAttribute((Object)Attribute.BAN_MESSAGE_COUNT, count);
        });
    }

    private void changeInfo(Element line, InfoChanger changer) {
        try {
            SuspiciousMessagePayload lowTrustData;
            List actionBy;
            String actionReason;
            String infoText;
            String autoModAction;
            Integer banCount;
            Integer repeatMsgCount;
            SimpleAttributeSet attributes;
            Element infoElement = ChannelTextPane.getElementContainingAttributeKey(line, (Object)Attribute.IS_APPENDED_INFO);
            boolean isNew = false;
            if (infoElement == null) {
                infoElement = line.getElement(line.getElementCount() - 1);
                attributes = new SimpleAttributeSet(this.styles.info());
                isNew = true;
            } else {
                attributes = new SimpleAttributeSet(infoElement.getAttributes());
            }
            changer.changeInfo(attributes);
            attributes.addAttribute((Object)Attribute.IS_APPENDED_INFO, true);
            attributes.addAttribute((Object)Attribute.APPENDED_INFO_UPDATED, System.currentTimeMillis());
            if (!isNew) {
                int start = infoElement.getStartOffset();
                int length = infoElement.getEndOffset() - infoElement.getStartOffset();
                this.doc.remove(start, length);
            }
            String text = "";
            String powerUpInfo = (String)attributes.getAttribute((Object)Attribute.POWER_UP_INFO);
            if (!StringUtil.isNullOrEmpty(powerUpInfo)) {
                text = StringUtil.append(text, " ", "[" + powerUpInfo + "]");
            }
            if ((repeatMsgCount = (Integer)attributes.getAttribute((Object)Attribute.REPEAT_MESSAGE_COUNT)) != null && repeatMsgCount > 1) {
                text = text + String.format("(x%d)", repeatMsgCount);
            }
            if ((banCount = (Integer)attributes.getAttribute((Object)Attribute.BAN_MESSAGE_COUNT)) != null && banCount > 1) {
                text = text + String.format("(%d)", banCount);
            }
            if (!StringUtil.isNullOrEmpty(autoModAction = (String)attributes.getAttribute((Object)Attribute.AUTOMOD_ACTION))) {
                text = StringUtil.append(text, " ", "(" + autoModAction + ")");
            }
            if ((infoText = (String)attributes.getAttribute((Object)Attribute.INFO_TEXT)) != null && !infoText.isEmpty()) {
                text = StringUtil.append(text, " ", infoText);
            }
            if (!StringUtil.isNullOrEmpty(actionReason = (String)attributes.getAttribute((Object)Attribute.ACTION_REASON)) && this.styles.isEnabled(Setting.BAN_REASON_APPENDED)) {
                text = StringUtil.append(text, " ", "[" + actionReason + "]");
            }
            if ((actionBy = (List)attributes.getAttribute((Object)Attribute.ACTION_BY)) != null) {
                text = StringUtil.append(text, " ", "(@" + StringUtil.join(actionBy, ", ") + ")");
            }
            if ((lowTrustData = (SuspiciousMessagePayload)attributes.getAttribute((Object)Attribute.LOW_TRUST_INFO)) != null) {
                text = StringUtil.append(text, " ", "(" + lowTrustData.makeInfo() + ")");
            }
            int insertStart = infoElement.getEndOffset();
            if (this.getElementText(infoElement).contains("\n")) {
                --insertStart;
            }
            this.doc.insertString(insertStart, " " + text, attributes);
        }
        catch (BadLocationException ex) {
            LOGGER.warning("Bad location: " + ex);
        }
        this.scrollDownIfNecessary();
    }

    private String getElementText(Element element) {
        try {
            return this.doc.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
        }
        catch (BadLocationException ex) {
            LOGGER.warning("Bad location");
            return "";
        }
    }

    public void printLowTrustInfo(User user, SuspiciousMessagePayload data) {
        for (Userline userLine : this.getUserLines(user)) {
            String elementId = ChannelTextPane.getIdFromElement(userLine.userElement);
            if (elementId == null || !elementId.equals(data.aboutMessageId)) continue;
            this.changeInfo(userLine.line, attributes -> attributes.addAttribute((Object)Attribute.LOW_TRUST_INFO, data));
            return;
        }
        this.pendingLowTrustInfoCache.put(user, data);
    }

    private Element findPreviousBanMessage(User user, String newMessage) {
        for (Element line : this.iterateLines()) {
            AttributeSet attr;
            if (this.isLineFromUserAndId(line, user, null, true)) {
                return null;
            }
            Element firstElement = line.getElement(0);
            if (firstElement == null || !(attr = firstElement.getAttributes()).containsAttribute((Object)Attribute.IS_BAN_MESSAGE, user) || this.getTimeAgo(firstElement) >= 10000L) continue;
            if (attr.getAttribute((Object)Attribute.BAN_MESSAGE).equals(newMessage)) {
                return line;
            }
            return null;
        }
        return null;
    }

    public void userBanned(User user, long duration, String reason, String targetMsgId) {
        String banInfo;
        if (this.styles.isEnabled(Setting.SHOW_BANMESSAGES)) {
            banInfo = Helper.makeBanInfo(duration, reason, this.styles.isEnabled(Setting.BAN_DURATION_MESSAGE), this.styles.isEnabled(Setting.BAN_REASON_MESSAGE), false);
            String message = "has been banned";
            if (duration > 0L) {
                message = "has been timed out";
            }
            if (duration == -2L) {
                message = "had a message deleted";
            }
            if (!StringUtil.isNullOrEmpty(targetMsgId)) {
                message = message + " (single message)";
            }
            if (!banInfo.isEmpty()) {
                message = message + " " + banInfo;
            }
            Element prevMessage = null;
            if (this.styles.isEnabled(Setting.COMBINE_BAN_MESSAGES)) {
                prevMessage = this.findPreviousBanMessage(user, message);
            }
            if (prevMessage != null) {
                this.increasePreviousBanMessage(prevMessage, duration, reason);
            } else {
                this.closeCompactMode();
                this.printTimestamp(this.styles.banMessage(user, message));
                this.print(user.getCustomNick(), this.styles.user(user, this.styles.info()));
                this.print(" " + message, this.styles.info());
                this.finishLine();
            }
        }
        banInfo = Helper.makeBanInfo(duration, reason, this.styles.isEnabled(Setting.BAN_DURATION_APPENDED), this.styles.isEnabled(Setting.BAN_REASON_APPENDED), true);
        int mode = this.styles.getInt(Setting.DELETED_MESSAGES_MODE);
        boolean delete = (long)mode < 0L;
        boolean first = true;
        for (Userline l : this.getUserLines(user)) {
            boolean msgIdMatches = targetMsgId == null || targetMsgId.equals(ChannelTextPane.getIdFromElement(l.userElement));
            boolean isAutoModMessage = Util.hasAttributeKey(l.userElement, (Object)Attribute.ID_AUTOMOD);
            boolean isUserMessage = Util.hasAttributeKeyValue(l.userElement, (Object)Attribute.IS_USER_MESSAGE, true);
            if (!msgIdMatches || !isAutoModMessage && !isUserMessage) continue;
            if (delete) {
                this.deleteMessage(l.line);
            } else {
                this.strikeThroughMessage(l.line, mode);
            }
            if (!first) continue;
            this.setBanInfo(l.line, banInfo);
            this.setLineCommand(l.line.getStartOffset(), Helper.makeBanCommand(user, duration, targetMsgId));
            this.replayModLogInfo();
            first = false;
        }
    }

    private void setBanInfo(Element line, String info) {
        Element firstElement = line.getElement(0);
        if (firstElement != null && this.getTimeAgo(firstElement) > 60000L) {
            info = info + "*";
        }
        String info2 = info;
        this.changeInfo(line, attributes -> attributes.addAttribute((Object)Attribute.INFO_TEXT, info2));
    }

    private List<Userline> getUserLines(User searchUser) {
        ArrayList<Userline> result = new ArrayList<Userline>();
        for (Element line : this.iterateLines()) {
            Element userElement = ChannelTextPane.getUserElementFromLine(line, false);
            if (userElement == null) continue;
            User foundUser = (User)userElement.getAttributes().getAttribute((Object)Attribute.USER);
            if (searchUser != null && foundUser != searchUser) continue;
            result.add(new Userline(searchUser, userElement, line));
        }
        return result;
    }

    private ArrayList<Integer> getLinesFromUser(User user, String id, boolean onlyUserMessages) {
        Element root = this.doc.getDefaultRootElement();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < root.getElementCount(); ++i) {
            Element line = root.getElement(i);
            if (!this.isLineFromUserAndId(line, user, id, onlyUserMessages)) continue;
            result.add(i);
        }
        return result;
    }

    private Element findLineBy(Function<Element, Boolean> test) {
        for (Element line : this.iterateLines()) {
            if (!test.apply(line).booleanValue()) continue;
            return line;
        }
        return null;
    }

    private void applyToLines(Consumer<Element> worker) {
        for (Element line : this.iterateLines()) {
            worker.accept(line);
        }
    }

    private Iterable<Element> iterateLines() {
        final Element root = this.doc.getDefaultRootElement();
        return new AbstractList<Element>(){

            @Override
            public Element get(int index) {
                if (ChannelTextPane.this.insertTop) {
                    return root.getElement(index);
                }
                return root.getElement(this.size() - 1 - index);
            }

            @Override
            public int size() {
                return root.getElementCount();
            }
        };
    }

    private boolean isMessageLine(Element line) {
        return ChannelTextPane.getUserFromLine(line) != null;
    }

    public static User getUserFromLine(Element line) {
        return ChannelTextPane.getUserFromElement(ChannelTextPane.getUserElementFromLine(line, true), true);
    }

    public static Element getUserElementFromLine(Element line, boolean onlyUserMessage) {
        for (int i = 0; i < line.getElementCount(); ++i) {
            Element element = line.getElement(i);
            User elementUser = ChannelTextPane.getUserFromElement(element, onlyUserMessage);
            if (elementUser == null) continue;
            return element;
        }
        return null;
    }

    private boolean isLineFromUserAndId(Element line, User user, String id, boolean onlyUserMessages) {
        Element element = ChannelTextPane.getUserElementFromLine(line, onlyUserMessages);
        User elementUser = ChannelTextPane.getUserFromElement(element, onlyUserMessages);
        return elementUser == user && (id == null || id.equals(ChannelTextPane.getIdFromElement(element)));
    }

    private static User getUserFromElement(Element element, boolean onlyUserMessage) {
        if (element != null) {
            User elementUser = (User)element.getAttributes().getAttribute((Object)Attribute.USER);
            Boolean isMessage = (Boolean)element.getAttributes().getAttribute((Object)Attribute.IS_USER_MESSAGE);
            if (!onlyUserMessage || isMessage != null && isMessage.booleanValue()) {
                return elementUser;
            }
        }
        return null;
    }

    public static String getIdFromElement(Element element) {
        if (element != null) {
            return (String)element.getAttributes().getAttribute((Object)Attribute.MSG_ID);
        }
        return null;
    }

    private void strikeThroughMessage(Element elementToRemove, int maxLength) {
        if (this.isLineDeleted(elementToRemove)) {
            return;
        }
        int[] offsets = Util.getMessageOffsets(elementToRemove);
        if (offsets.length != 2) {
            return;
        }
        int lineStart = elementToRemove.getStartOffset();
        int msgStart = offsets[0];
        int msgEnd = offsets[1];
        int msgLength = msgEnd - msgStart;
        if (maxLength > 0 && msgLength > maxLength) {
            try {
                int removedStart = msgStart + maxLength;
                int removedLength = msgLength - maxLength;
                this.remove(removedStart, removedLength);
                msgEnd = removedStart;
                this.doc.insertString(removedStart, "..", this.styles.info());
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad location");
            }
        }
        this.doc.setCharacterAttributes(lineStart, msgEnd - lineStart, this.styles.deleted(), false);
        this.setLineDeleted(lineStart);
    }

    private void deleteMessage(Element elementToRemove) {
        if (this.isLineDeleted(elementToRemove)) {
            return;
        }
        int[] messageOffsets = Util.getMessageOffsets(elementToRemove);
        if (messageOffsets.length == 2) {
            int msgStart = messageOffsets[0];
            int msgEnd = messageOffsets[1];
            try {
                this.remove(msgStart, msgEnd - msgStart);
                this.doc.insertString(msgStart, "<message deleted>", this.styles.info());
                this.setLineDeleted(msgStart);
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad location: " + msgStart + "-" + msgEnd + " " + ex.getLocalizedMessage());
            }
        }
    }

    private boolean isLineDeleted(Element line) {
        return line.getAttributes().containsAttribute((Object)Attribute.DELETED_LINE, true);
    }

    private void setLineDeleted(int offset) {
        this.doc.setParagraphAttributes(offset, 1, this.styles.deletedLine(), false);
    }

    private void setLineCommand(int offset, String command) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute((Object)Attribute.COMMAND, command);
        this.doc.setParagraphAttributes(offset, 1, attr, false);
    }

    private void setObjectId(int offset, Object id) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute((Object)Attribute.OBJECT_ID, id);
        this.doc.setParagraphAttributes(offset, 1, attr, false);
    }

    private void setVariableLineAttributes(int offset, boolean even, boolean updateTimestamp) {
        this.doc.setParagraphAttributes(offset, 1, this.styles.variableLineAttributes(even, updateTimestamp), false);
    }

    private void setLineHighlighted(int offset, Object source) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute((Object)Attribute.HIGHLIGHT_LINE, true);
        attr.addAttribute((Object)Attribute.HIGHLIGHT_SOURCE, source);
        this.doc.setParagraphAttributes(offset, 1, attr, false);
    }

    private void setParagraphAttribute(int offset, Attribute attribute, Object source) {
        if (source != null) {
            SimpleAttributeSet attr = new SimpleAttributeSet();
            attr.addAttribute((Object)attribute, source);
            this.doc.setParagraphAttributes(offset, 1, attr, false);
        }
    }

    private int getCurrentParagraphOffset() {
        return this.insertTop ? 0 : this.doc.getLength();
    }

    private void setCustomColor(int offset, Color backgroundColor, Object source) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        if (backgroundColor != null) {
            attr.addAttribute((Object)Attribute.CUSTOM_BACKGROUND, backgroundColor);
            attr.addAttribute((Object)Attribute.CUSTOM_BACKGROUND_ORIG, backgroundColor);
        }
        attr.addAttribute((Object)Attribute.CUSTOM_COLOR_SOURCE, source);
        this.doc.setParagraphAttributes(offset, 1, attr, false);
    }

    private void updateCustomColorTransparency() {
        this.applyToLines(line -> {
            Color origColor = (Color)line.getAttributes().getAttribute((Object)Attribute.CUSTOM_BACKGROUND_ORIG);
            if (origColor != null) {
                SimpleAttributeSet attr = new SimpleAttributeSet();
                attr.addAttribute((Object)Attribute.CUSTOM_BACKGROUND, this.transparency(origColor));
                this.doc.setParagraphAttributes(line.getStartOffset(), 1, attr, false);
            }
        });
    }

    public void selectPreviousUser() {
        this.lineSelection.move(-1);
    }

    public void selectNextUser() {
        this.lineSelection.move(1);
    }

    public void selectNextUserExitAtBottom() {
        this.lineSelection.move(1, true);
    }

    public void exitUserSelection() {
        this.lineSelection.disable();
    }

    public void toggleUserSelection() {
        this.lineSelection.toggleLineSelection();
    }

    public User getSelectedUser() {
        return this.lineSelection.getSelectedUser();
    }

    private boolean doesLineExist(Object line) {
        int count = this.doc.getDefaultRootElement().getElementCount();
        for (int i = 0; i < count; ++i) {
            if (this.doc.getDefaultRootElement().getElement(i) != line) continue;
            return true;
        }
        return false;
    }

    public boolean search(String searchText) {
        if (searchText == null || searchText.isEmpty()) {
            return false;
        }
        this.clearSearchResult();
        if (this.lastSearchPos != null && !this.doesLineExist(this.lastSearchPos)) {
            this.lastSearchPos = null;
        }
        boolean startSearch = this.lastSearchPos == null;
        searchText = StringUtil.toLowerCase(searchText);
        for (Element element : this.iterateLines()) {
            if (element == this.lastSearchPos) {
                startSearch = true;
                this.lastSearchPos = null;
                continue;
            }
            if (!startSearch) continue;
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset() - 1;
            int length = endOffset - startOffset;
            try {
                String text = this.doc.getText(startOffset, length);
                if (StringUtil.toLowerCase(text).contains(searchText)) {
                    this.doc.setCharacterAttributes(startOffset, length, this.styles.searchResult(false), false);
                    this.scrollManager.cancelScrollDownRequest();
                    this.scrollManager.scrollToOffset(startOffset);
                    this.lastSearchPos = element;
                    break;
                }
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad location");
            }
            this.lastSearchPos = null;
        }
        if (this.lastSearchPos == null) {
            this.scrollManager.scrollDown();
            return false;
        }
        return true;
    }

    public void resetSearch() {
        this.clearSearchResult();
        this.lastSearchPos = null;
    }

    private void clearSearchResult() {
        this.doc.setCharacterAttributes(0, this.doc.getLength(), this.styles.clearSearchResult(), false);
    }

    private void printUser(User user, User localUser, boolean action, boolean whisper, String msgId, Color background, MsgTags tags) {
        String notes;
        MutableAttributeSet style;
        String userName = user.hasCustomNickSet() ? user.getCustomNick() : (this.styles.namesMode() == 3L ? user.getName() : (this.styles.namesMode() != 1L || user.hasRegularDisplayNick() ? user.getDisplayNick() : user.getName()));
        if (tags.isRestrictedMessage()) {
            style = new SimpleAttributeSet();
            StyleConstants.setIcon(style, ChannelTextPane.addSpaceToIcon(NO_CHAT_ICON));
            style.addAttribute((Object)Attribute.IS_RESTRICTED, true);
            this.print("'", style);
        }
        if (this.styles.isEnabled(Setting.USERICONS_ENABLED)) {
            this.printUserIcons(user, localUser, tags);
        } else {
            userName = user.getModeSymbol() + userName;
        }
        if (user.hasCategory("rainbow")) {
            this.printRainbowUser(user, userName, action, SpecialColor.RAINBOW, msgId);
        } else if (user.hasCategory("golden")) {
            this.printRainbowUser(user, userName, action, SpecialColor.GOLD, msgId);
        } else {
            style = this.styles.messageUser(user, msgId, background);
            if (whisper) {
                if (action) {
                    this.print(">>[" + userName + "]", style);
                } else {
                    this.print("-[" + userName + "]-", style);
                }
            } else if (action) {
                this.print("* " + userName, style);
            } else {
                this.print(userName, style);
            }
        }
        String addition = null;
        if (!user.hasRegularDisplayNick() && !user.hasCustomNickSet() && this.styles.namesMode() == 0L) {
            addition = user.getName();
        }
        if ((notes = UserNotes.instance().getNotesForChat(user)) != null) {
            addition = StringUtil.append(addition, ", ", notes);
        }
        if (addition != null) {
            MutableAttributeSet style2 = this.styles.messageUser(user, msgId, background);
            StyleConstants.setBold(style2, false);
            int fontSize = StyleConstants.getFontSize(style2) - 2;
            if (fontSize <= 0) {
                fontSize = StyleConstants.getFontSize(style2);
            }
            StyleConstants.setFontSize(style2, fontSize);
            this.print(" (" + addition + ")", style2);
        }
        if (!action && !whisper) {
            this.print(":", this.styles.messageUser(user, msgId, background));
        }
    }

    private void printRainbowUser(User user, String userName, boolean action, SpecialColor type, String id) {
        SimpleAttributeSet userStyle = new SimpleAttributeSet(this.styles.nick());
        userStyle.addAttribute((Object)Attribute.IS_USER_MESSAGE, true);
        userStyle.addAttribute((Object)Attribute.USER, user);
        if (id != null) {
            userStyle.addAttribute((Object)Attribute.MSG_ID, id);
        }
        int length = userName.length();
        if (action) {
            this.print("* ", this.styles.nick());
        }
        for (int i = 0; i < length; ++i) {
            Color c = type == SpecialColor.RAINBOW ? this.makeRainbowColor(i, length) : this.makeGoldColor(i, length);
            StyleConstants.setForeground(userStyle, c);
            this.print(userName.substring(i, i + 1), userStyle);
        }
    }

    private Color makeRainbowColor(int i, int length) {
        double step = Math.PI * 2 / (double)length;
        double delta = 2.0943951023931953;
        int r = (int)(Math.cos((double)i * step + 0.0 * delta) * 127.5 + 127.5);
        int g = (int)(Math.cos((double)i * step + 1.0 * delta) * 127.5 + 127.5);
        int b = (int)(Math.cos((double)i * step + 2.0 * delta) * 110.0 + 110.0);
        return new Color(r, g, b);
    }

    private Color makeGoldColor(int i, int length) {
        double step = Math.PI * 2 / (double)length;
        double delta = 3.6128315516282616;
        int r = 255;
        int g = (int)(Math.cos((double)i * step + 1.0 * delta) * 42.0 + 195.0);
        int b = 0;
        return new Color(r, g, b);
    }

    private void printUserIcons(User user, User localUser, MsgTags tags) {
        if (tags != null && tags.isSharedChatActive()) {
            this.printChannelIcon(user, localUser);
            this.printSharedInfo(user, localUser, tags);
        } else {
            this.printUsericonsDefault(user, localUser, tags, this.styles.getInt(Setting.CHANNEL_LOGO_SIZE));
        }
    }

    private void printUsericonsDefault(User user, User localUser, MsgTags tags, int channelLogoSize) {
        if (user == null) {
            return;
        }
        boolean botBadgeEnabled = this.styles.isEnabled(Setting.BOT_BADGE_ENABLED);
        List<Usericon> badges = user.getBadges(botBadgeEnabled, tags, localUser, channelLogoSize);
        if (badges == null || channelLogoSize < 1 || badges.isEmpty() || badges.iterator().next().type != Usericon.Type.CHANNEL_LOGO) {
            boolean channelIconFailed = channelLogoSize > 0;
            this.printChannelName(user, channelIconFailed);
        }
        if (badges != null) {
            for (Usericon badge : badges) {
                if (badge.removeBadge) continue;
                this.print(badge.getSymbol(), this.styles.makeIconStyle(badge, user, null, false));
                if (badge.type != Usericon.Type.CHANNEL_LOGO || channelLogoSize <= 0) continue;
                this.printChannelName(user, false);
            }
        }
    }

    private void printChannelIcon(User user, User localUser) {
        if (user == null) {
            user = localUser;
        }
        if (user != null && user.getUsericonManager() != null) {
            Usericon icon = user.getUsericonManager().getChannelIcon(user.getChannel(), this.styles.getInt(Setting.CHANNEL_LOGO_SIZE));
            if (icon != null) {
                this.print(icon.getSymbol(), this.styles.makeIconStyle(icon, user, null, false));
            }
            boolean channelIconFailed = this.styles.getInt(Setting.CHANNEL_LOGO_SIZE) > 0 && icon == null;
            this.printChannelName(user, channelIconFailed);
        }
    }

    private void printChannelName(User user, boolean forced) {
        int settingValue = this.styles.getInt(Setting.SHOW_CHANNEL_NAME);
        if (user != null && (settingValue > 0 || forced)) {
            if (forced && settingValue == 0) {
                settingValue = 30;
            }
            this.print(String.format("[%s] ", StringUtil.shortenTo(user.getChannel(), settingValue)), this.styles.standard());
        }
    }

    private void printSharedInfo(User user, User localUser, MsgTags tags) {
        if (tags != null && tags.isSharedChatActive()) {
            Usericon icon;
            String logoChannel = null;
            if (tags.isSharedMessage()) {
                logoChannel = tags.getSourceChannel();
            } else if (this.styles.isEnabled(Setting.SHARED_LOGO_ALWAYS)) {
                logoChannel = user.getChannel();
            }
            if (logoChannel != null && this.styles.getInt(Setting.SHARED_LOGO_SIZE) > 0 && (icon = user.getUsericonManager().getSourceChannelIcon(logoChannel, tags.getId(), this.styles.getInt(Setting.SHARED_LOGO_SIZE))) != null) {
                this.print(icon.getSymbol(), this.styles.makeIconStyle(icon, null, Arrays.asList(logoChannel), false));
            }
        }
        if (tags != null && tags.isSharedMessage()) {
            boolean botBadgeEnabled;
            List<Usericon> badges;
            int settingValue = this.styles.getInt(Setting.SHARED_BADGES);
            ArrayList<Usericon> sharedBadges = new ArrayList<Usericon>();
            User sourceUser = null;
            if (settingValue > 0) {
                IrcBadges sourceBadges = IrcBadges.parse(tags.get("source-badges"));
                sourceUser = new User(user.getName(), Room.createRegular(tags.getSourceChannel() != null ? tags.getSourceChannel() : user.getChannel()));
                sourceUser.setTwitchBadges(sourceBadges);
                UserTagsUtil.updateUserBadgeInfo(sourceUser, tags, true);
                badges = user.getUsericonManager().getBadges(sourceBadges, sourceUser, localUser, false, tags, 0);
                if (badges != null) {
                    for (Usericon badge : badges) {
                        boolean selectBadges;
                        boolean bl = selectBadges = settingValue == 1 || settingValue >= 10 ? Arrays.asList("moderator", "lead_moderator", "broadcaster", "staff", "subscriber", "vip").contains(badge.badgeType.id) : true;
                        if (badge.removeBadge || !selectBadges) continue;
                        if (this.styles.getInt(Setting.SHARED_BADGES) >= 10) {
                            sharedBadges.add(badge);
                            continue;
                        }
                        this.print(badge.getSymbol(), this.styles.makeIconStyle(badge, sourceUser, null, false));
                    }
                }
            }
            if (settingValue < 10 || tags.getSourceChannel() == null) {
                this.print("|", this.styles.standard());
            }
            if ((badges = user.getBadges(botBadgeEnabled = this.styles.isEnabled(Setting.BOT_BADGE_ENABLED), tags, localUser, 0)) != null) {
                List<String> sharedOnlyStream = Arrays.asList(tags.getSourceChannel());
                List<String> bothStreams = Arrays.asList(user.getChannel(), tags.getSourceChannel());
                HashSet<Usericon> hasSharedDuplicate = new HashSet<Usericon>();
                for (Usericon badge : badges) {
                    boolean removed = sharedBadges.removeIf(b -> b.badgeType != null && b.badgeType.id.equals(badge.badgeType.id));
                    if (!removed) continue;
                    hasSharedDuplicate.add(badge);
                }
                HashSet<Usericon> isSharedOnly = new HashSet<Usericon>();
                for (Usericon sharedBadge : sharedBadges) {
                    if (Arrays.asList("moderator", "lead_moderator", "broadcaster", "staff", "vip").contains(sharedBadge.badgeType.id) || badges.isEmpty()) {
                        badges.add(0, sharedBadge);
                    } else {
                        badges.add(1, sharedBadge);
                    }
                    isSharedOnly.add(sharedBadge);
                }
                for (Usericon badge : badges) {
                    if (badge.removeBadge) continue;
                    List<String> sharedInfo = null;
                    User badgeUser = user;
                    if (isSharedOnly.contains(badge)) {
                        sharedInfo = sharedOnlyStream;
                        badgeUser = sourceUser;
                    } else if (hasSharedDuplicate.contains(badge)) {
                        sharedInfo = bothStreams;
                    }
                    this.print(badge.getSymbol(), this.styles.makeIconStyle(badge, badgeUser, sharedInfo, settingValue == 11 && isSharedOnly.contains(badge)));
                }
            }
        } else {
            this.printUsericonsDefault(user, localUser, tags, 0);
        }
    }

    private void clearSomeChat() {
        boolean failsafe;
        int count = this.doc.getDefaultRootElement().getElementCount();
        int max = this.styles.bufferSize();
        boolean regularRequirement = !this.scrollManager.fixedChat && this.scrollManager.isScrollPositionNearEnd() && count > max;
        boolean bl = failsafe = count > max * 2;
        if (regularRequirement || failsafe) {
            this.removeFirstLines(2);
        }
    }

    public void removeFirstLines(int amount) {
        int endOffset;
        if (amount < 1) {
            amount = 1;
        }
        if (this.doc.getDefaultRootElement().getElementCount() == 0) {
            return;
        }
        int firstElementIndex = this.insertTop ? this.doc.getDefaultRootElement().getElementCount() - amount : 0;
        int lastElementIndex = this.insertTop ? this.doc.getDefaultRootElement().getElementCount() - 1 : amount - 1;
        Element firstToRemove = this.doc.getDefaultRootElement().getElement(firstElementIndex);
        Element lastToRemove = this.doc.getDefaultRootElement().getElement(lastElementIndex);
        for (int i = firstElementIndex; i <= lastElementIndex; ++i) {
            this.clearImages(this.doc.getDefaultRootElement().getElement(i));
        }
        int startOffset = firstToRemove.getStartOffset() - 1;
        if (startOffset < 0) {
            startOffset = 0;
        }
        if ((endOffset = lastToRemove.getEndOffset()) > this.doc.getLength()) {
            endOffset = this.doc.getLength();
        }
        try {
            this.doc.remove(startOffset, endOffset - startOffset);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeOldLines() {
        if (this.messageTimeout > 0) {
            Element paragraph = this.doc.getDefaultRootElement().getElement(this.insertTop ? this.doc.getDefaultRootElement().getElementCount() - 1 : 0);
            if (this.doc.getLength() > 1 && this.getTimeAgo(paragraph) > (long)(this.messageTimeout * 1000)) {
                if (this.doc.getDefaultRootElement().getElementCount() > 1) {
                    this.doc.removeElement(paragraph);
                } else {
                    this.clearAll();
                }
                this.scrollDownIfNecessary();
                this.resetNewlineRequired();
            }
        }
    }

    public void clearAll() {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.resetNewlineRequired();
            this.kit.clearImages();
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ChannelTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void clearImages(Element element) {
        Long imageId = (Long)element.getAttributes().getAttribute((Object)Attribute.IMAGE_ID);
        if (imageId != null) {
            this.kit.clearImage(imageId);
        }
        if (!element.isLeaf()) {
            for (int i = 0; i < element.getElementCount(); ++i) {
                this.clearImages(element.getElement(i));
            }
        }
    }

    private void resetNewlineRequired() {
        if (this.doc.getLength() == 0) {
            this.newlineRequired = false;
        }
    }

    public void printCompact(String type, User user) {
        String seperator = ", ";
        if (this.startCompactMode(type)) {
            this.printTimestamp(this.styles.compact());
            this.print(type + ": ", this.styles.compact());
            seperator = "";
        }
        this.print(seperator, this.styles.compact());
        this.print(user.getCustomNick(), this.styles.user(user, this.styles.compact()));
        ++this.compactModeLength;
        if (this.compactModeLength >= 10) {
            this.closeCompactMode();
        }
    }

    private boolean startCompactMode(String type) {
        long timePassed = System.currentTimeMillis() - this.compactModeStart;
        if (timePassed > 30000L) {
            this.closeCompactMode();
        }
        if (!type.equals(this.compactMode)) {
            this.closeCompactMode();
        }
        if (this.compactMode == null) {
            this.compactMode = type;
            this.compactModeStart = System.currentTimeMillis();
            this.compactModeLength = 0;
            return true;
        }
        return false;
    }

    protected void closeCompactMode() {
        if (this.compactMode != null) {
            this.finishLine();
            this.compactMode = null;
        }
    }

    protected void finishLine() {
        this.newlineRequired = true;
        this.lineSelection.onLineAdded(this.getLastLine(this.doc));
        this.even = !this.even;
        this.setVariableLineAttributes(this.insertTop ? 0 : this.doc.getLength() - 1, this.even, true);
        if (Debugging.isEnabled("insertTop")) {
            Debugging.println("====");
            for (Element line : this.iterateLines()) {
                Debugging.println(Util.debugContents(line));
            }
        }
    }

    public void printLine(String line) {
        this.printLine(line, this.styles.info());
    }

    private void printLine(String line, MutableAttributeSet style) {
        this.closeCompactMode();
        this.printTimestamp(style);
        this.print(line, style);
        this.finishLine();
    }

    private void printSpecialsInfo(String text, AttributeSet style, List<Highlighter.Match> highlightMatches, MsgTags tags) {
        TreeMap<Integer, Integer> ranges = new TreeMap<Integer, Integer>();
        HashMap<Integer, MutableAttributeSet> rangesStyle = new HashMap<Integer, MutableAttributeSet>();
        this.findSpecialLinks(ranges, rangesStyle, tags, style);
        this.findLinks(text, ranges, rangesStyle, this.styles.isEnabled(Setting.LINKS_CUSTOM_COLOR) ? style : this.styles.info());
        if (this.styles.isEnabled(Setting.MENTIONS_INFO)) {
            this.findMentions(text, ranges, rangesStyle, style, Setting.MENTIONS_INFO);
        }
        this.printSpecials(null, text, style, ranges, rangesStyle, highlightMatches);
    }

    protected void printSpecialsNormal(String text, User user, MutableAttributeSet style, Emoticons.TagEmotes emotes, boolean ignoreLinks, boolean containsBits, List<Highlighter.Match> highlightMatches, List<Highlighter.Match> replacements, String replacement, MsgTags tags) {
        TreeMap<Integer, Integer> ranges = new TreeMap<Integer, Integer>();
        HashMap<Integer, MutableAttributeSet> rangesStyle = new HashMap<Integer, MutableAttributeSet>();
        if (tags != null && tags.isReply() && text.startsWith("@")) {
            Pair<User, String> replyData = this.getReplyData(tags);
            if (replyData.value != null) {
                ranges.put(0, 0);
                rangesStyle.put(0, this.styles.reply((String)replyData.value, tags.getReplyParentMsgId()));
            }
        }
        this.applyReplacements(text, replacements, replacement, ranges, rangesStyle);
        if (!ignoreLinks) {
            this.findLinks(text, ranges, rangesStyle, this.styles.isEnabled(Setting.LINKS_CUSTOM_COLOR) ? style : this.styles.standard());
        }
        if (this.styles.isEnabled(Setting.EMOTICONS_ENABLED)) {
            this.findEmoticons(text, user, ranges, rangesStyle, emotes, tags != null && tags.hasGigantifiedEmote());
            if (containsBits) {
                this.findBits(this.main.emoticons.getCheerEmotes(), text, ranges, rangesStyle, user);
            }
        }
        if (this.styles.isEnabled(Setting.MENTIONS)) {
            this.findMentions(text, ranges, rangesStyle, style, Setting.MENTIONS);
        }
        this.printSpecials(user, text, style, ranges, rangesStyle, highlightMatches);
    }

    private void printSpecials(User user, String text, AttributeSet style, List<Highlighter.Match> highlightMatches) {
        this.printSpecials(user, text, style, new TreeMap<Integer, Integer>(), new HashMap<Integer, MutableAttributeSet>(), highlightMatches);
    }

    private void printSpecials(User user, String text, AttributeSet style, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, List<Highlighter.Match> highlightMatches) {
        int lastPrintedPos = 0;
        for (Map.Entry<Integer, Integer> range : ranges.entrySet()) {
            AttributeSet rangeStyle;
            int start = range.getKey();
            int end = range.getValue();
            if (start < lastPrintedPos) continue;
            if (start > lastPrintedPos) {
                this.specialPrint(user, text, lastPrintedPos, start, style, highlightMatches);
            }
            if ((rangeStyle = (AttributeSet)rangesStyle.get(start)).containsAttribute((Object)Attribute.IS_REPLACEMENT, true)) {
                String rangeText = (String)rangeStyle.getAttribute((Object)Attribute.REPLACED_WITH);
                if (!rangeText.isEmpty()) {
                    this.print(rangeText, rangeStyle);
                }
            } else if (this.styles.isEnabled(Setting.HIGHLIGHT_MATCHES_ALL) && StyleConstants.getIcon(rangeStyle) == null) {
                this.specialPrint(user, text, start, end + 1, rangeStyle, highlightMatches);
            } else {
                this.print(text.substring(start, end + 1), rangeStyle);
            }
            lastPrintedPos = end + 1;
        }
        if (lastPrintedPos < text.length()) {
            this.specialPrint(user, text, lastPrintedPos, text.length(), style, highlightMatches);
        }
    }

    private void specialPrint(User user, String text, int start, int end, AttributeSet style, List<Highlighter.Match> highlightMatches) {
        if (highlightMatches != null) {
            for (Highlighter.Match m : highlightMatches) {
                String processed;
                int to;
                if (m.start >= end || m.end <= start) continue;
                int from = m.start;
                if (from < start) {
                    from = start;
                }
                if ((to = m.end) > end) {
                    to = end;
                }
                if (from > start) {
                    processed = this.processText(user, text.substring(start, from));
                    this.print(processed, style);
                }
                processed = this.processText(user, text.substring(from, to));
                SimpleAttributeSet styleCopy = new SimpleAttributeSet(style);
                styleCopy.addAttribute((Object)Attribute.HIGHLIGHT_WORD, true);
                this.print(processed, styleCopy);
                start = to;
            }
        }
        if (start < end) {
            this.print(this.processText(user, text.substring(start, end)), style);
        }
    }

    private String processText(User user, String text) {
        String prev;
        String result = Helper.htmlspecialchars_decode(text);
        result = StringUtil.removeDuplicateWhitespace(result);
        result = Helper.removeEmojiVariationSelector(result);
        int filterMode = this.styles.getInt(Setting.FILTER_COMBINING_CHARACTERS);
        if (filterMode > 0 && !(prev = result).equals(result = Helper.filterCombiningCharacters(result, "****", filterMode))) {
            LOGGER.info("Filtered combining characters from message by " + user + " [result: " + result + "]");
        }
        return result;
    }

    private void applyReplacements(String text, List<Highlighter.Match> matches, String replacement, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        if (matches != null) {
            if (StringUtil.isNullOrEmpty(replacement)) {
                replacement = "..";
            } else if (replacement.equals("none")) {
                replacement = "";
            }
            for (Highlighter.Match m : matches) {
                if (this.inRanges(m.start, ranges) || this.inRanges(m.end, ranges)) continue;
                ranges.put(m.start, m.end - 1);
                String replacedText = text.substring(m.start, m.end);
                rangesStyle.put(m.start, this.styles.replacement(replacedText, replacement));
            }
        }
    }

    private void findLinks(String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, AttributeSet baseStyle) {
        urlMatcher.reset(text);
        while (urlMatcher.find()) {
            int start = urlMatcher.start();
            int end = urlMatcher.end() - 1;
            if (this.inRanges(start, ranges) || this.inRanges(end, ranges)) continue;
            String foundUrl = urlMatcher.group();
            if (foundUrl.endsWith(")") && !foundUrl.contains("(")) {
                foundUrl = foundUrl.substring(0, foundUrl.length() - 1);
                --end;
            }
            if (!this.checkUrl(foundUrl)) continue;
            ranges.put(start, end);
            if (!foundUrl.startsWith("http")) {
                foundUrl = "http://" + foundUrl;
            }
            rangesStyle.put(start, this.styles.url(foundUrl, baseStyle));
        }
    }

    private void findSpecialLinks(TreeMap<Integer, Integer> ranges, HashMap<Integer, MutableAttributeSet> rangesStyle, MsgTags tags, AttributeSet baseStyle) {
        if (tags == null) {
            return;
        }
        List<MsgTags.Link> links = tags.getLinks();
        if (links == null) {
            return;
        }
        for (MsgTags.Link link : links) {
            if (link.startIndex == -1 || link.endIndex == -1 || this.inRanges(link.startIndex, ranges) || this.inRanges(link.endIndex, ranges)) continue;
            ranges.put(link.startIndex, link.endIndex);
            rangesStyle.put(link.startIndex, this.styles.generalLink(baseStyle, link));
        }
    }

    private void findMentions(String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, AttributeSet baseStyle, Setting setting) {
        HashSet<User> alreadyChecked = new HashSet<User>();
        for (MentionCheck check : this.lastUsers.getItems()) {
            if (alreadyChecked.contains(check.user)) continue;
            alreadyChecked.add(check.user);
            Matcher m = check.matcher.reset(text);
            while (m.find()) {
                int start = m.start();
                int end = m.end() - 1;
                if (this.inRanges(start, ranges) || this.inRanges(end, ranges)) continue;
                ranges.put(start, end);
                rangesStyle.put(start, this.styles.mention(check.user, baseStyle, setting));
            }
        }
    }

    private Pair<User, String> getReplyData(MsgTags tags) {
        User user = null;
        String replyMsgText = tags.getReplyUserMsg();
        if (replyMsgText == null) {
            replyMsgText = ReplyManager.getFirstUserMsg(tags.getReplyParentMsgId());
        }
        if (replyMsgText == null) {
            String msgId = tags.getReplyParentMsgId();
            HashSet<User> alreadyChecked = new HashSet<User>();
            for (MentionCheck check : this.lastUsers.getItems()) {
                if (alreadyChecked.contains(check.user)) continue;
                alreadyChecked.add(check.user);
                String msg = check.user.getMessageText(msgId);
                if (msg == null) continue;
                replyMsgText = String.format("<%s> %s", check.user.getDisplayNick(), msg);
                user = check.user;
                break;
            }
        }
        return new Pair<Object, String>(user, replyMsgText);
    }

    public int getRand(int bound) {
        long seed = System.currentTimeMillis() / 20000L;
        if (seed != this.fSeed) {
            this.fRand.setSeed(seed);
            this.fSeed = seed;
        }
        return this.fRand.nextInt(bound);
    }

    private void findEmoticons(String text, User user, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, Emoticons.TagEmotes tagEmotes, boolean gigantified) {
        Set<String> accessToSets = user.isLocalUser() ? this.main.emoticons.getLocalEmotesets() : null;
        this.findEmoticons(user, this.main.emoticons.getCustomEmotes(), text, ranges, rangesStyle, accessToSets);
        if (Debugging.isEnabled("emoji2") || EmojiUtil.mightContainEmoji(text)) {
            this.findEmoticons(user, this.main.emoticons.getEmoji(), text, ranges, rangesStyle);
        }
        if (tagEmotes != null) {
            HashMap<String, Emoticon> emoticonsById = this.main.emoticons.getEmoticonsById();
            this.addTwitchTagsEmoticons(user, emoticonsById, text, ranges, rangesStyle, tagEmotes, gigantified);
        }
        if (user.isLocalUser()) {
            this.findEmoticons(this.main.emoticons.getUsableGlobalTwitchEmotes(), text, ranges, rangesStyle);
            this.findEmoticons(this.main.emoticons.getUsableFollowerEmotes(user.getStream()), text, ranges, rangesStyle);
            this.findEmoticons(this.main.emoticons.getSmilies(), text, ranges, rangesStyle);
        }
        Set<Emoticon> channelEmotes = this.main.emoticons.getEmoticonsByStream(user.getStream());
        this.findEmoticons(channelEmotes, text, ranges, rangesStyle);
        if (user.isLocalUser()) {
            this.findEmoticons(this.main.emoticons.getUsableGlobalOtherEmotes(), text, ranges, rangesStyle);
        } else {
            Set<Emoticon> emoticons;
            if (tagEmotes == null) {
                emoticons = this.main.emoticons.getGlobalTwitchEmotes();
                this.findEmoticons(emoticons, text, ranges, rangesStyle);
            }
            emoticons = this.main.emoticons.getOtherGlobalEmotes();
            this.findEmoticons(emoticons, text, ranges, rangesStyle);
        }
        ChattyMisc.CombinedEmotesInfo cei = ChattyMisc.getCombinedEmotesInfo();
        if (!cei.isEmpty()) {
            int baseStart = -1;
            int lastEnd = -1;
            HashMap<Integer, Integer> changes = new HashMap<Integer, Integer>();
            HashMap<Integer, MutableAttributeSet> styleChanges = new HashMap<Integer, MutableAttributeSet>();
            ArrayList<Emoticon> emotes = new ArrayList<Emoticon>();
            Iterator<Map.Entry<Integer, Integer>> rangesIt = ranges.entrySet().iterator();
            while (rangesIt.hasNext()) {
                Map.Entry<Integer, Integer> range = rangesIt.next();
                int start = range.getKey();
                int end = range.getValue();
                MutableAttributeSet style = rangesStyle.get(start);
                CachedImage image = (CachedImage)style.getAttribute((Object)Attribute.EMOTICON);
                if (image == null) continue;
                Emoticon cEmote = (Emoticon)image.getObject();
                if ((cei.containsCode(cEmote.code) || cEmote.isZeroWidth()) && !emotes.isEmpty() && lastEnd + 2 == start) {
                    changes.put(baseStart, end);
                    rangesIt.remove();
                } else {
                    if (emotes.size() > 1) {
                        Emoticon emote = this.main.emoticons.getCombinedEmote(emotes, this.styles.emoticonImageType());
                        styleChanges.put(baseStart, this.styles.emoticon(emote, false));
                    }
                    emotes.clear();
                    baseStart = start;
                }
                if (!emotes.contains(image.getObject())) {
                    emotes.add((Emoticon)image.getObject());
                }
                lastEnd = end;
            }
            if (emotes.size() > 1) {
                Emoticon emote = this.main.emoticons.getCombinedEmote(emotes, this.styles.emoticonImageType());
                styleChanges.put(baseStart, this.styles.emoticon(emote, false));
            }
            for (Map.Entry entry : changes.entrySet()) {
                ranges.put((Integer)entry.getKey(), (Integer)entry.getValue());
            }
            for (Map.Entry entry : styleChanges.entrySet()) {
                rangesStyle.put((Integer)entry.getKey(), (MutableAttributeSet)entry.getValue());
            }
        }
    }

    private void addTwitchTagsEmoticons(User user, Map<String, Emoticon> emoticons, String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, Emoticons.TagEmotes emotesDef, boolean gigantified) {
        if (emotesDef == null) {
            return;
        }
        Map<Integer, Emoticons.TagEmote> def = emotesDef.emotes;
        int lastIndex = emotesDef.getLargestIndex();
        int offset = 0;
        for (int i = 0; i < text.length(); i += Character.charCount(text.codePointAt(i))) {
            int currentIndex = i - offset;
            if (def.containsKey(currentIndex)) {
                Emoticons.TagEmote emoteData = def.get(currentIndex);
                String id = emoteData.id;
                int start = i;
                int end = emoteData.end + offset;
                Emoticon emoticon = null;
                Emoticon customEmote = this.main.emoticons.getCustomEmoteById(id);
                emoticon = customEmote != null && customEmote.allowedForStream(user.getStream()) ? customEmote : emoticons.get(id);
                if (end < text.length()) {
                    if (emoticon == null) {
                        String code = text.substring(start, end + 1);
                        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.TWITCH, code);
                        b.setStringId(id);
                        b.setEmoteset("");
                        emoticon = b.build();
                        this.main.emoticons.addTempEmoticon(emoticon);
                    }
                    if (!this.main.emoticons.isEmoteIgnored(emoticon, 1)) {
                        this.addEmoticon(emoticon, start, end, ranges, rangesStyle, gigantified && currentIndex == lastIndex);
                    }
                }
            }
            offset += Character.charCount(text.codePointAt(i)) - 1;
        }
    }

    private void findEmoticons(Set<Emoticon> emoticons, String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        this.findEmoticons(null, emoticons, text, ranges, rangesStyle);
    }

    private void findEmoticons(User user, Set<Emoticon> emoticons, String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        this.findEmoticons(user, emoticons, text, ranges, rangesStyle, null);
    }

    private void findEmoticons(User user, Set<Emoticon> emoticons, String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, Set<String> accessToSets) {
        for (Emoticon emoticon : emoticons) {
            if (!emoticon.matchesUser(user, accessToSets) || this.main.emoticons.isEmoteIgnored(emoticon, 1)) continue;
            Matcher m = emoticon.getMatcher(text);
            while (m.find()) {
                int start = m.start();
                int end = m.end() - 1;
                boolean textEmoji = emoticon.type == Emoticon.Type.EMOJI && m.group().endsWith("\ufe0e");
                if (textEmoji) continue;
                this.addEmoticon(emoticon, start, end, ranges, rangesStyle, false);
            }
        }
    }

    private void findBits(Set<CheerEmoticon> emotes, String text, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, User user) {
        for (CheerEmoticon emote : emotes) {
            if (!emote.matchesUser(user, null)) continue;
            Matcher m = emote.getMatcher(text);
            while (m.find()) {
                int start = m.start();
                int end = m.end() - 1;
                try {
                    int bits = Integer.parseInt(m.group(1));
                    int bitsLength = m.group(1).length();
                    if (bits < emote.min_bits) continue;
                    boolean ignored = this.main.emoticons.isEmoteIgnored(emote, 1);
                    if (!ignored && this.addEmoticon(emote, start, end - bitsLength, ranges, rangesStyle, false)) {
                        this.addFormattedText(emote.color, end - bitsLength + 1, end, ranges, rangesStyle);
                        continue;
                    }
                    this.addFormattedText(emote.color, start, end, ranges, rangesStyle);
                }
                catch (NumberFormatException ex) {
                    System.out.println("Error parsing cheer: " + ex);
                }
            }
        }
    }

    private boolean addEmoticon(Emoticon emoticon, int start, int end, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle, boolean gigantified) {
        if (!this.inRanges(start, ranges) && !this.inRanges(end, ranges)) {
            ranges.put(start, end);
            MutableAttributeSet attr = this.styles.emoticon(emoticon, gigantified);
            attr.addAttribute("start", start);
            rangesStyle.put(start, attr);
            return true;
        }
        return false;
    }

    private void addFormattedText(Color color, int start, int end, Map<Integer, Integer> ranges, Map<Integer, MutableAttributeSet> rangesStyle) {
        if (!this.inRanges(start, ranges) && !this.inRanges(end, ranges)) {
            ranges.put(start, end);
            MutableAttributeSet attr = this.styles.standard(color);
            StyleConstants.setBold(attr, true);
            attr.addAttribute("start", start);
            rangesStyle.put(start, attr);
        }
    }

    private boolean inRanges(int i, Map<Integer, Integer> ranges) {
        for (Map.Entry<Integer, Integer> range : ranges.entrySet()) {
            if (i < range.getKey() || i > range.getValue()) continue;
            return true;
        }
        return false;
    }

    private boolean checkUrl(String uriToCheck) {
        try {
            new URI(uriToCheck);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        return true;
    }

    private Element getLastLine(Document doc) {
        return doc.getDefaultRootElement().getElement(this.insertTop ? 0 : doc.getDefaultRootElement().getElementCount() - 1);
    }

    private void print(String text, AttributeSet style) {
        try {
            int insertOffset;
            String newline = "";
            if (this.newlineRequired) {
                this.lengthSinceNewline = 0;
                newline = "\n";
                this.newlineRequired = false;
                this.clearSomeChat();
                insertOffset = this.insertTop ? 0 : this.doc.getLength();
            } else {
                insertOffset = this.insertTop ? this.doc.getParagraphElement(0).getEndOffset() - 1 : this.doc.getLength();
            }
            this.lengthSinceNewline += text.length();
            if (this.lengthSinceNewline > 2000) {
                int breakTarget = 2000 - (this.lengthSinceNewline - text.length());
                int firstSpace = text.indexOf(32, breakTarget);
                if (firstSpace != -1 && firstSpace - breakTarget < 100) {
                    breakTarget = firstSpace;
                }
                String part = text.substring(0, breakTarget);
                String remaining = text.substring(breakTarget);
                this.doc.insertString(insertOffset, this.insertTop ? part + newline : newline + part, style);
                this.doc.setParagraphAttributes(this.getCurrentParagraphOffset(), 1, this.styles.paragraph(), true);
                this.newlineRequired = true;
                this.print(remaining, style);
            } else {
                this.doc.insertString(insertOffset, this.insertTop ? text + newline : newline + text, style);
                this.doc.setParagraphAttributes(this.getCurrentParagraphOffset(), 1, this.styles.paragraph(), true);
                this.scrollDownIfNecessary();
            }
        }
        catch (BadLocationException e) {
            System.err.println("BadLocationException");
        }
    }

    private void scrollDownIfNecessary() {
        if (this.lastSearchPos == null && (this.scrollManager.isScrollPositionNearEnd() || this.scrollManager.scrolledUpTimeout())) {
            this.scrollManager.requestScrollDown();
        }
    }

    public void setScrollPane(JScrollPane scroll) {
        this.scrollManager.setScrollPane(scroll);
        scroll.getVerticalScrollBar().addAdjustmentListener(e -> {
            this.linkController.updatePopup();
            if (this.linePopup != null) {
                this.linePopup.update();
            }
        });
    }

    protected void printTimestamp(AttributeSet style) {
        this.printTimestamp(style, -1L);
    }

    protected void printTimestamp(AttributeSet style, long time) {
        Timestamp timestamp = this.styles.timestampFormat();
        if (timestamp != null) {
            this.print(timestamp.make(time, this.channel != null ? this.channel.getRoom() : null) + " ", this.styles.timestamp(style));
        } else {
            this.print("", style);
        }
    }

    public void refreshStyles() {
        this.styles.refresh();
    }

    public void setBufferSize(int size) {
        this.styles.setBufferSize(size);
    }

    @Override
    public void linkClicked(String url) {
        UrlOpener.openUrlPrompt(this.getTopLevelAncestor(), url);
    }

    public static ImageIcon addSpaceToIcon(ImageIcon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int hspace = 3;
        BufferedImage res = new BufferedImage(width + hspace, height, 2);
        Graphics g = res.getGraphics();
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        return new ImageIcon(res);
    }

    public static ImageIcon getIconWithOpacity(ImageIcon icon, float opacity) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage res = new BufferedImage(width, height, 2);
        Graphics2D g = res.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, opacity));
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        return new ImageIcon(res);
    }

    public boolean hasLineId(long lineId) {
        return this.getLineForId(lineId) != null;
    }

    private Element getLineForId(long lineId) {
        return this.findLineBy(line -> line.getAttributes().containsAttribute((Object)Attribute.LINE_ID, lineId));
    }

    public void scrollToLine(long lineId, String label) {
        Element line = this.getLineForId(lineId);
        if (line != null) {
            try {
                Rectangle rect = this.modelToView(line.getStartOffset());
                if (rect != null) {
                    rect.translate(0, -50);
                    this.scrollRectToVisible(rect);
                }
                if (this.linePopup == null) {
                    this.linePopup = new SimplePopup(this, () -> {});
                }
                this.linePopup.showPopup(label, line.getStartOffset(), 4000, SimplePopup.BorderStyle.REGULAR);
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad Location");
            }
        }
    }

    private class ScrollManager
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean fixedChat = false;
        private boolean pauseKeyPressed = false;
        private final KeyEventDispatcher keyListener;
        private Popup popup;
        private JLabel fixedChatInfoLabel;
        private long mouseLastMoved;
        private JScrollPane scrollpane;
        private long lastManualScrollChange = 0L;
        private boolean scrollingDownInProgress = false;
        private boolean scrollDownRequest = false;
        private int width;
        private int height;
        private final Timer updateTimer;

        ScrollManager() {
            this.updateTimer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (System.currentTimeMillis() - ScrollManager.this.mouseLastMoved > 700L) {
                        ScrollManager.this.setFixedChat(false);
                    }
                }
            });
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
            this.keyListener = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getKeyCode() == 17) {
                        if (e.getID() == 401) {
                            return ScrollManager.this.handleKeyPressed();
                        }
                        return ScrollManager.this.handleKeyReleased();
                    }
                    return false;
                }
            };
        }

        public void cleanUp() {
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.removeKeyEventDispatcher(this.keyListener);
            this.hideFixedChatInfo();
            this.updateTimer.stop();
        }

        public void setScrollPane(JScrollPane pane) {
            this.scrollpane = pane;
            this.addListeners();
        }

        private void addListeners() {
            this.scrollpane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Component c = e.getComponent();
                    if (c.getWidth() < ScrollManager.this.width || c.getHeight() < ScrollManager.this.height) {
                        ScrollManager.this.scrollDown();
                    }
                    ScrollManager.this.width = c.getWidth();
                    ScrollManager.this.height = c.getHeight();
                }
            });
            this.scrollpane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
                private int lastValue = 0;
                private int lastMax = 0;
                private int lastExtent = 0;

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    boolean manualScrolled;
                    boolean valueChanged = e.getValue() != this.lastValue;
                    boolean maxChanged = e.getAdjustable().getMaximum() != this.lastMax;
                    boolean extentChanged = e.getAdjustable().getVisibleAmount() != this.lastExtent;
                    this.lastValue = e.getValue();
                    this.lastMax = e.getAdjustable().getMaximum();
                    this.lastExtent = e.getAdjustable().getVisibleAmount();
                    boolean bl = manualScrolled = valueChanged && !maxChanged && !extentChanged && !ScrollManager.this.scrollingDownInProgress;
                    if (manualScrolled) {
                        ScrollManager.this.lastManualScrollChange = System.currentTimeMillis();
                        ScrollManager.this.fixedChat = false;
                        ScrollManager.this.hideFixedChatInfo();
                        ScrollManager.this.scrollDownRequest = false;
                    }
                    if (ScrollManager.this.scrollDownRequest && !ScrollManager.this.scrollingDownInProgress) {
                        ScrollManager.this.scrollDown();
                    }
                }
            });
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.addKeyEventDispatcher(this.keyListener);
        }

        private boolean isScrollPositionNearEnd() {
            JScrollBar vbar = this.scrollpane.getVerticalScrollBar();
            if (ChannelTextPane.this.insertTop) {
                return vbar.getMinimum() + 20 >= vbar.getValue();
            }
            return vbar.getMaximum() - 20 <= vbar.getValue() + vbar.getVisibleAmount();
        }

        private boolean scrolledUpTimeout() {
            if (this.scrollDownRequest) {
                return false;
            }
            if (this.fixedChat || this.pauseKeyPressed) {
                return false;
            }
            if (!ChannelTextPane.this.styles.isEnabled(Setting.AUTO_SCROLL)) {
                return false;
            }
            long timePassed = System.currentTimeMillis() - this.lastManualScrollChange;
            if (timePassed > (long)(1000 * ChannelTextPane.this.styles.getInt(Setting.AUTO_SCROLL_TIME))) {
                LOGGER.info("ScrolledUp Timeout (" + timePassed + ")");
                return true;
            }
            return false;
        }

        private void requestScrollDown() {
            this.scrollDownRequest = true;
        }

        private void cancelScrollDownRequest() {
            this.scrollDownRequest = false;
        }

        private void scrollDown() {
            if (this.fixedChat) {
                return;
            }
            this.scrollingDownInProgress = true;
            this.scrollDown1();
            this.scrollingDownInProgress = false;
        }

        private void scrollDown1() {
            this.scrollpane.getVerticalScrollBar().setValue(ChannelTextPane.this.insertTop ? this.scrollpane.getVerticalScrollBar().getMinimum() : this.scrollpane.getVerticalScrollBar().getMaximum());
        }

        private void scrollDown2() {
            ChannelTextPane.this.scrollRectToVisible(new Rectangle(0, ChannelTextPane.this.getPreferredSize().height, 10, 10));
        }

        private void scrollDown3() {
            try {
                int endPosition = ChannelTextPane.this.doc.getLength();
                Rectangle bottom = ChannelTextPane.this.modelToView(endPosition);
                if (bottom != null) {
                    bottom.height += 100;
                    ChannelTextPane.this.scrollRectToVisible(bottom);
                }
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad Location");
            }
        }

        private void scrollToOffset(int offset) {
            try {
                Rectangle rect = ChannelTextPane.this.modelToView(offset);
                if (rect != null) {
                    ChannelTextPane.this.scrollRectToVisible(rect);
                }
            }
            catch (BadLocationException ex) {
                LOGGER.warning("Bad Location");
            }
        }

        public void setFixedChat(boolean fixed) {
            if (!this.scrollpane.getVerticalScrollBar().isVisible()) {
                return;
            }
            if (!fixed && this.fixedChat) {
                this.fixedChat = fixed;
                this.scrollDown();
            }
            if (fixed) {
                this.showFixedChatInfo();
            } else {
                this.hideFixedChatInfo();
            }
            this.fixedChat = fixed;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseLastMoved = System.currentTimeMillis();
            if (this.isPauseEnabled() && this.isScrollPositionNearEnd()) {
                this.setFixedChat(true);
            }
        }

        private boolean isPauseEnabled() {
            if (!ChannelTextPane.this.styles.isEnabled(Setting.PAUSE_ON_MOUSEMOVE)) {
                return false;
            }
            return !ChannelTextPane.this.styles.isEnabled(Setting.PAUSE_ON_MOUSEMOVE_CTRL_REQUIRED) || this.pauseKeyPressed;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.pauseKeyPressed) {
                this.setFixedChat(false);
            }
        }

        private boolean handleKeyPressed() {
            this.pauseKeyPressed = true;
            if (this.fixedChat) {
                this.mouseLastMoved = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        private boolean handleKeyReleased() {
            this.pauseKeyPressed = false;
            return false;
        }

        private void createFixedChatInfoLabel() {
            JLabel label = new JLabel("chat paused");
            CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(2, 4, 2, 4));
            label.setBorder(border);
            label.setForeground(Color.BLACK);
            label.setBackground(HtmlColors.decode("#EEEEEE"));
            label.setOpaque(true);
            this.fixedChatInfoLabel = label;
        }

        private void showFixedChatInfo() {
            if (this.popup == null && ChannelTextPane.this.isShowing()) {
                if (this.fixedChatInfoLabel == null) {
                    this.createFixedChatInfoLabel();
                }
                JLabel label = this.fixedChatInfoLabel;
                Point p = this.scrollpane.getLocationOnScreen();
                int labelWidth = label.getPreferredSize().width;
                p.x += this.scrollpane.getViewport().getWidth() - labelWidth - 5;
                this.popup = PopupFactory.getSharedInstance().getPopup(ChannelTextPane.this, label, p.x, p.y);
                this.popup.show();
            }
        }

        private void hideFixedChatInfo() {
            if (this.popup != null) {
                this.popup.hide();
                this.popup = null;
            }
        }
    }

    public class Styles {
        private final String[] baseStyles = new String[]{"standard", "timestamp", "special", "info", "base", "highlight", "paragraph"};
        private final HashMap<String, MutableAttributeSet> styles = new HashMap();
        private final HashMap<String, AttributeSet> rawStyles = new HashMap();
        private final HashMap<Setting, Boolean> settings = new HashMap();
        private final Map<Setting, Integer> numericSettings = new HashMap<Setting, Integer>();
        private final ArrayList<String> changedStyles = new ArrayList();
        private Timestamp timestampFormat;
        private int bufferSize = -1;
        private ColorCorrector colorCorrector;
        private final HashMap<Usericon, MutableAttributeSet> savedIcons = new HashMap();

        public boolean setStyles() {
            int bottomMarginSetting;
            this.changedStyles.clear();
            boolean somethingChanged = false;
            for (String styleName : this.baseStyles) {
                if (!this.loadStyle(styleName)) continue;
                somethingChanged = true;
                this.changedStyles.add(styleName);
            }
            this.setSettings();
            SimpleAttributeSet nick = new SimpleAttributeSet(this.base());
            StyleConstants.setBold(nick, true);
            this.styles.put("nick", nick);
            MutableAttributeSet paragraph = this.styles.get("paragraph");
            paragraph.addAttribute((Object)Attribute.DELETED_LINE, false);
            int fontHeight = MyStyleConstants.getFontHeight(paragraph);
            int preferredSpaceAbove = (int)Math.ceil((float)fontHeight * StyleConstants.getLineSpacing(paragraph));
            int availableSpace = ((Long)paragraph.getAttribute((Object)Attribute.PARAGRAPH_SPACING)).intValue();
            int remainingSpace = Math.max(availableSpace - preferredSpaceAbove, 0);
            int actualSpaceAbove = Math.min(preferredSpaceAbove, availableSpace);
            int topSpacing = remainingSpace / 2 + actualSpaceAbove;
            int bottomSpacing = remainingSpace / 2 + remainingSpace % 2;
            if (Debugging.isEnabled("oldspacings")) {
                topSpacing = availableSpace / 3;
                bottomSpacing = availableSpace / 3 * 2 + availableSpace % 3;
            }
            StyleConstants.setSpaceAbove(paragraph, topSpacing);
            StyleConstants.setSpaceBelow(paragraph, bottomSpacing);
            this.styles.put("paragraph", paragraph);
            int prevBottomMargin = ChannelTextPane.this.getMargin().bottom;
            int bottomMargin = bottomMarginSetting = this.numericSettings.get((Object)Setting.BOTTOM_MARGIN).intValue();
            if (bottomMarginSetting < 0) {
                boolean alternatingBackgrounds = MyStyleConstants.getBackground2(paragraph) != null;
                boolean separators = MyStyleConstants.getSeparatorColor(paragraph) != null;
                int fullSpacing = preferredSpaceAbove + availableSpace;
                bottomMargin = !alternatingBackgrounds && !separators ? (int)Math.max((double)fullSpacing / 2.5, 1.0) : (!alternatingBackgrounds ? 2 : 0);
            }
            if (Debugging.isEnabled("oldspacings")) {
                bottomMargin = 3;
            }
            if (bottomMargin != prevBottomMargin) {
                Chatty.println("Bottom Margin: " + bottomMargin);
                if (ChannelTextPane.this.insertTop) {
                    ChannelTextPane.this.setMargin(new Insets(bottomMargin, 3, 3, 3));
                } else {
                    ChannelTextPane.this.setMargin(new Insets(3, 3, bottomMargin, 3));
                }
                ChannelTextPane.this.repaint();
            }
            SimpleAttributeSet even = new SimpleAttributeSet();
            even.addAttribute((Object)Attribute.EVEN, true);
            this.styles.put("even", even);
            SimpleAttributeSet odd = new SimpleAttributeSet();
            odd.addAttribute((Object)Attribute.EVEN, false);
            this.styles.put("odd", odd);
            SimpleAttributeSet deleted = new SimpleAttributeSet();
            StyleConstants.setStrikeThrough(deleted, true);
            StyleConstants.setUnderline(deleted, false);
            deleted.addAttribute((Object)Attribute.URL_DELETED, true);
            this.styles.put("deleted", deleted);
            SimpleAttributeSet deletedLine = new SimpleAttributeSet();
            deletedLine.addAttribute((Object)Attribute.DELETED_LINE, true);
            this.styles.put("deletedLine", deletedLine);
            SimpleAttributeSet searchResult = new SimpleAttributeSet();
            StyleConstants.setBackground(searchResult, ChannelTextPane.this.styleServer.getColor("searchResult"));
            StyleConstants.setItalic(searchResult, false);
            this.styles.put("searchResult", searchResult);
            SimpleAttributeSet searchResult2 = new SimpleAttributeSet();
            StyleConstants.setBackground(searchResult2, ChannelTextPane.this.styleServer.getColor("searchResult2"));
            this.styles.put("searchResult2", searchResult2);
            SimpleAttributeSet clearSearchResult = new SimpleAttributeSet();
            StyleConstants.setBackground(clearSearchResult, new Color(0, 0, 0, 0));
            StyleConstants.setItalic(clearSearchResult, false);
            this.styles.put("clearSearchResult", clearSearchResult);
            ChannelTextPane.this.setBackground(ChannelTextPane.this.transparency(ChannelTextPane.this.styleServer.getColor("background")));
            this.colorCorrector = ChannelTextPane.this.styleServer.getColorCorrector();
            return somethingChanged;
        }

        private void setSettings() {
            this.addSetting(Setting.EMOTICONS_ENABLED, true);
            this.addSetting(Setting.USERICONS_ENABLED, true);
            this.addSetting(Setting.TIMESTAMP_ENABLED, true);
            this.addSetting(Setting.SHOW_BANMESSAGES, false);
            this.addSetting(Setting.AUTO_SCROLL, true);
            this.addSetting(Setting.DELETE_MESSAGES, false);
            this.addSetting(Setting.ACTION_COLORED, false);
            this.addSetting(Setting.COMBINE_BAN_MESSAGES, true);
            this.addSetting(Setting.BAN_DURATION_APPENDED, true);
            this.addSetting(Setting.BAN_REASON_APPENDED, true);
            this.addSetting(Setting.BAN_DURATION_MESSAGE, true);
            this.addSetting(Setting.BAN_REASON_MESSAGE, true);
            this.addSetting(Setting.BOT_BADGE_ENABLED, true);
            this.addSetting(Setting.PAUSE_ON_MOUSEMOVE, true);
            this.addSetting(Setting.PAUSE_ON_MOUSEMOVE_CTRL_REQUIRED, false);
            this.addSetting(Setting.EMOTICONS_ANIMATED, false);
            this.addSetting(Setting.SHOW_TOOLTIPS, true);
            this.addSetting(Setting.SHOW_TOOLTIP_IMAGES, true);
            this.addSetting(Setting.LINKS_CUSTOM_COLOR, true);
            this.addNumericSetting(Setting.MENTIONS, 0, 0, 200);
            this.addNumericSetting(Setting.MENTIONS_INFO, 0, 0, 200);
            this.addNumericSetting(Setting.MENTION_MESSAGES, 0, 0, 200);
            this.addSetting(Setting.HIGHLIGHT_MATCHES_ALL, true);
            this.addNumericSetting(Setting.USERCOLOR_BACKGROUND, 1, 0, 200);
            this.addNumericSetting(Setting.FILTER_COMBINING_CHARACTERS, 1, 0, 2);
            this.addNumericSetting(Setting.DELETED_MESSAGES_MODE, 30, -1, 9999999);
            this.addNumericSetting(Setting.BUFFER_SIZE, 250, 10, 10000);
            this.addNumericSetting(Setting.AUTO_SCROLL_TIME, 30, 5, 1234);
            this.addNumericSetting(Setting.EMOTICON_MAX_HEIGHT, 200, 0, 300);
            this.addNumericSetting(Setting.EMOTICON_SCALE_FACTOR, 100, 1, 200);
            this.addNumericSetting(Setting.EMOTICON_SCALE_FACTOR_GIGANTIFIED, 150, 1, 200);
            this.addNumericSetting(Setting.USERICON_SCALE_FACTOR, 100, 1, 200);
            this.addNumericSetting(Setting.CUSTOM_USERICON_SCALE_MODE, 0, 0, 10);
            this.addNumericSetting(Setting.DISPLAY_NAMES_MODE, 0, 0, 10);
            this.addNumericSetting(Setting.BOTTOM_MARGIN, -1, -1, 100);
            this.addNumericSetting(Setting.HIGHLIGHT_HOVERED_USER, 0, 0, 4);
            this.addNumericSetting(Setting.CHANNEL_LOGO_SIZE, -1, -1, 100);
            this.addNumericSetting(Setting.SHOW_CHANNEL_NAME, -1, -1, 100);
            this.addNumericSetting(Setting.SHARED_BADGES, 0, 0, 100);
            this.addNumericSetting(Setting.SHARED_LOGO_SIZE, 22, 0, 60);
            this.addSetting(Setting.SHARED_LOGO_ALWAYS, true);
            this.timestampFormat = ChannelTextPane.this.styleServer.getTimestampFormat();
            ChannelTextPane.this.linkController.setPopupEnabled(this.settings.get((Object)Setting.SHOW_TOOLTIPS));
            ChannelTextPane.this.linkController.setPopupImagesEnabled(this.settings.get((Object)Setting.SHOW_TOOLTIP_IMAGES));
            ChannelTextPane.this.linkController.setUserHoverHighlightMode(this.getInt(Setting.HIGHLIGHT_HOVERED_USER));
            ChannelTextPane.this.linkController.setPopupMentionMessages(this.getInt(Setting.MENTION_MESSAGES));
        }

        private void addSetting(Setting key, boolean defaultValue) {
            MutableAttributeSet loadFrom = ChannelTextPane.this.styleServer.getStyle("settings");
            Object obj = loadFrom.getAttribute((Object)key);
            boolean result = defaultValue;
            if (obj != null && obj instanceof Boolean) {
                result = (Boolean)obj;
            }
            this.settings.put(key, result);
        }

        private void addNumericSetting(Setting key, int defaultValue, int min, int max) {
            MutableAttributeSet loadFrom = ChannelTextPane.this.styleServer.getStyle("settings");
            Object obj = loadFrom.getAttribute((Object)key);
            int result = defaultValue;
            if (obj != null && obj instanceof Number) {
                result = ((Number)obj).intValue();
            }
            if (result > max) {
                result = max;
            }
            if (result < min) {
                result = min;
            }
            this.numericSettings.put(key, result);
        }

        private boolean loadStyle(String name) {
            AttributeSet oldStyle;
            Color highlightBackground;
            SimpleAttributeSet newStyle = new SimpleAttributeSet(ChannelTextPane.this.styleServer.getStyle(name));
            Color background2 = MyStyleConstants.getBackground2(newStyle);
            if (background2 != null) {
                MyStyleConstants.setBackground2(newStyle, ChannelTextPane.this.transparency(background2));
            }
            if ((highlightBackground = MyStyleConstants.getHighlightBackground(newStyle)) != null) {
                MyStyleConstants.setHighlightBackground(newStyle, ChannelTextPane.this.transparency(highlightBackground));
            }
            if ((oldStyle = this.rawStyles.get(name)) != null && oldStyle.isEqual(newStyle)) {
                return false;
            }
            this.rawStyles.put(name, newStyle.copyAttributes());
            newStyle.addAttribute((Object)Attribute.BASE_STYLE, name);
            this.styles.put(name, newStyle);
            return true;
        }

        public void refresh() {
            if (!this.setStyles()) {
                return;
            }
            LOGGER.info("Update styles (only types " + this.changedStyles + ")");
            Element root = ChannelTextPane.this.doc.getDefaultRootElement();
            for (int i = 0; i < root.getElementCount(); ++i) {
                Element paragraph = root.getElement(i);
                if (this.changedStyles.contains("paragraph")) {
                    ChannelTextPane.this.doc.setParagraphAttributes(paragraph.getStartOffset(), 1, this.paragraph(), false);
                }
                for (int j = 0; j < paragraph.getElementCount(); ++j) {
                    Element element = paragraph.getElement(j);
                    String type = (String)element.getAttributes().getAttribute((Object)Attribute.BASE_STYLE);
                    int start = element.getStartOffset();
                    int end = element.getEndOffset();
                    int length = end - start;
                    if (type == null) {
                        type = "base";
                    }
                    MutableAttributeSet style = this.styles.get(type);
                    if (!this.changedStyles.contains(type)) continue;
                    if (type.equals("timestamp")) {
                        String originalBaseStyle = (String)element.getAttributes().getAttribute((Object)Attribute.ORIGINAL_BASE_STYLE);
                        style = this.timestamp(this.styles.get(originalBaseStyle));
                    }
                    ChannelTextPane.this.doc.setCharacterAttributes(start, length, style, false);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChannelTextPane.this.scrollManager.scrollDown();
                }
            });
        }

        public MutableAttributeSet base() {
            return this.styles.get("base");
        }

        public MutableAttributeSet info() {
            return this.styles.get("info");
        }

        public MutableAttributeSet info(Color color) {
            if (color != null) {
                SimpleAttributeSet specialColor = new SimpleAttributeSet(this.info());
                StyleConstants.setForeground(specialColor, color);
                specialColor.addAttribute((Object)Attribute.CUSTOM_FOREGROUND, color);
                return specialColor;
            }
            return this.info();
        }

        public MutableAttributeSet generalLink(AttributeSet base, MsgTags.Link target) {
            SimpleAttributeSet result = new SimpleAttributeSet(base);
            result.addAttribute((Object)Attribute.GENERAL_LINK, target);
            StyleConstants.setUnderline(result, true);
            return result;
        }

        public MutableAttributeSet compact() {
            return this.styles.get("special");
        }

        public MutableAttributeSet standard(Color color) {
            if (color != null) {
                SimpleAttributeSet specialColor = new SimpleAttributeSet(this.standard());
                StyleConstants.setForeground(specialColor, color);
                specialColor.addAttribute((Object)Attribute.CUSTOM_FOREGROUND, color);
                return specialColor;
            }
            return this.standard();
        }

        public MutableAttributeSet standard() {
            return this.styles.get("standard");
        }

        public SimpleAttributeSet timestamp(AttributeSet style) {
            SimpleAttributeSet resultStyle = new SimpleAttributeSet(style);
            AttributeSet timestamp = this.styles.get("timestamp");
            resultStyle.addAttribute((Object)Attribute.ORIGINAL_BASE_STYLE, style.getAttribute((Object)Attribute.BASE_STYLE));
            resultStyle.addAttributes(timestamp);
            Object inherit = timestamp.getAttribute((Object)Attribute.TIMESTAMP_COLOR_INHERIT);
            if (inherit != null && (style.containsAttribute((Object)Attribute.BASE_STYLE, "highlight") || style.containsAttribute((Object)Attribute.BASE_STYLE, "info") || style.getAttribute((Object)Attribute.CUSTOM_FOREGROUND) != null)) {
                float matchFactor = ((Float)inherit).floatValue();
                if ((double)matchFactor < 0.1) {
                    StyleConstants.setForeground(resultStyle, StyleConstants.getForeground(style));
                } else {
                    Color newColor = ColorCorrectionNew.matchLightness(StyleConstants.getForeground(style), StyleConstants.getForeground(timestamp), matchFactor);
                    StyleConstants.setForeground(resultStyle, newColor);
                }
            }
            return resultStyle;
        }

        public MutableAttributeSet banMessage(User user, String message) {
            SimpleAttributeSet style = new SimpleAttributeSet(this.standard());
            style.addAttribute((Object)Attribute.IS_BAN_MESSAGE, user);
            style.addAttribute((Object)Attribute.TIMESTAMP, System.currentTimeMillis());
            style.addAttribute((Object)Attribute.BAN_MESSAGE, message);
            return style;
        }

        public MutableAttributeSet banMessageCount(int count) {
            SimpleAttributeSet style = new SimpleAttributeSet(this.info());
            style.addAttribute((Object)Attribute.BAN_MESSAGE_COUNT, count);
            return style;
        }

        public MutableAttributeSet nick() {
            return this.styles.get("nick");
        }

        public MutableAttributeSet deleted() {
            return this.styles.get("deleted");
        }

        public MutableAttributeSet deletedLine() {
            return this.styles.get("deletedLine");
        }

        public MutableAttributeSet paragraph() {
            return this.styles.get("paragraph");
        }

        public MutableAttributeSet variableLineAttributes(boolean even, boolean updateTimestamp) {
            MutableAttributeSet style;
            MutableAttributeSet mutableAttributeSet = style = even ? this.styles.get("even") : this.styles.get("odd");
            if (updateTimestamp) {
                style.addAttribute((Object)Attribute.TIMESTAMP, System.currentTimeMillis());
            }
            return style;
        }

        public MutableAttributeSet highlight(Color color) {
            if (color != null) {
                SimpleAttributeSet specialColor = new SimpleAttributeSet(this.highlight());
                StyleConstants.setForeground(specialColor, color);
                specialColor.addAttribute((Object)Attribute.CUSTOM_FOREGROUND, color);
                return specialColor;
            }
            return this.highlight();
        }

        public MutableAttributeSet highlight() {
            return this.styles.get("highlight");
        }

        public MutableAttributeSet searchResult(boolean italic) {
            StyleConstants.setItalic(this.styles.get("searchResult"), italic);
            return this.styles.get("searchResult");
        }

        public MutableAttributeSet searchResult2(boolean italic) {
            StyleConstants.setItalic(this.styles.get("searchResult2"), italic);
            return this.styles.get("searchResult2");
        }

        public MutableAttributeSet clearSearchResult() {
            return this.styles.get("clearSearchResult");
        }

        private Color getUserColor(User user) {
            Color userColor = user.getColor();
            if (!user.hasCustomColor()) {
                userColor = this.colorCorrector.correctColor(userColor, ChannelTextPane.this.getBackground());
                user.setCorrectedColor(userColor);
            }
            return userColor;
        }

        public MutableAttributeSet messageUser(User user, String msgId, Color background) {
            int difference;
            int threshold;
            SimpleAttributeSet userStyle = new SimpleAttributeSet(this.nick());
            userStyle.addAttribute((Object)Attribute.IS_USER_MESSAGE, true);
            userStyle.addAttribute((Object)Attribute.USER, user);
            Color foreground = this.getUserColor(user);
            StyleConstants.setForeground(userStyle, foreground);
            switch (this.getInt(Setting.USERCOLOR_BACKGROUND)) {
                case 1: {
                    threshold = 38;
                    break;
                }
                case 2: {
                    threshold = 89;
                    break;
                }
                default: {
                    threshold = 0;
                }
            }
            if (threshold > 0 && background != null && (difference = ColorCorrectionNew.getLightnessDifferenceAbs(foreground, background)) < threshold && ColorCorrectionNew.getLightnessDifferenceAbs(foreground, ChannelTextPane.this.getBackground()) > difference) {
                MyStyleConstants.setLabelBackground(userStyle, ChannelTextPane.this.getBackground());
            }
            if (msgId != null) {
                userStyle.addAttribute((Object)Attribute.MSG_ID, msgId);
            }
            return userStyle;
        }

        public MutableAttributeSet user(User user, AttributeSet style) {
            SimpleAttributeSet userStyle = new SimpleAttributeSet(style);
            userStyle.addAttribute((Object)Attribute.USER, user);
            return userStyle;
        }

        public MutableAttributeSet mention(User user, AttributeSet style, Setting setting) {
            int settingValue = this.numericSettings.get((Object)setting);
            SimpleAttributeSet mentionStyle = new SimpleAttributeSet(style);
            if (MiscUtil.biton(settingValue, 1)) {
                StyleConstants.setBold(mentionStyle, true);
            }
            if (MiscUtil.biton(settingValue, 2)) {
                StyleConstants.setUnderline(mentionStyle, true);
            }
            if (MiscUtil.biton(settingValue, 3)) {
                StyleConstants.setForeground(mentionStyle, this.getUserColor(user));
            }
            mentionStyle.addAttribute((Object)Attribute.MENTION, user);
            return mentionStyle;
        }

        public MutableAttributeSet makeIconStyle(Usericon icon, User user, List<String> sourceStreams, boolean sharedStyle) {
            SimpleAttributeSet style = new SimpleAttributeSet(this.nick());
            CachedImage<Usericon> usericonImage = icon.getIcon(this.usericonScaleFactor(), this.getInt(Setting.CUSTOM_USERICON_SCALE_MODE), 0, sharedStyle ? 0.5f : -1.0f, ChannelTextPane.this);
            StyleConstants.setIcon(style, usericonImage.getImageIcon());
            style.addAttribute((Object)Attribute.USERICON, usericonImage);
            if (icon.type == Usericon.Type.TWITCH && (Usericon.typeFromBadgeId(icon.badgeType.id) == Usericon.Type.SUB || Usericon.typeFromBadgeId(icon.badgeType.id) == Usericon.Type.FOUNDER) && user != null && user.getSubMonths() > 0) {
                style.addAttribute((Object)Attribute.USERICON_INFO, DateTime.formatMonthsVerbose(user.getSubMonths()));
            }
            if (sourceStreams != null) {
                style.addAttribute((Object)Attribute.USERICON_SHARED_INFO, sourceStreams);
            }
            return style;
        }

        public int emoticonMaxHeight(boolean gigantified) {
            return (int)((float)this.numericSettings.get((Object)Setting.EMOTICON_MAX_HEIGHT).intValue() * this.gigantifiedFactor(gigantified));
        }

        public float emoticonScaleFactor(boolean gigantified) {
            return (float)((double)this.numericSettings.get((Object)Setting.EMOTICON_SCALE_FACTOR).intValue() / 100.0) * this.gigantifiedFactor(gigantified);
        }

        private float gigantifiedFactor(boolean gigantified) {
            if (gigantified) {
                return (float)((double)this.numericSettings.get((Object)Setting.EMOTICON_SCALE_FACTOR_GIGANTIFIED).intValue() / 100.0);
            }
            return 1.0f;
        }

        public float usericonScaleFactor() {
            return (float)((double)this.numericSettings.get((Object)Setting.USERICON_SCALE_FACTOR).intValue() / 100.0);
        }

        public int getInt(Setting setting) {
            return this.numericSettings.get((Object)setting);
        }

        public boolean isEnabled(Setting setting) {
            if (setting == Setting.MENTIONS || setting == Setting.MENTIONS_INFO) {
                return MiscUtil.biton(this.numericSettings.get((Object)setting), 0);
            }
            return this.settings.get((Object)setting);
        }

        public MutableAttributeSet url(String url, AttributeSet baseStyle) {
            SimpleAttributeSet urlStyle = new SimpleAttributeSet(baseStyle);
            StyleConstants.setUnderline(urlStyle, true);
            urlStyle.addAttribute(HTML.Attribute.HREF, url);
            return urlStyle;
        }

        public MutableAttributeSet replacement(String text, String replacement) {
            SimpleAttributeSet style = new SimpleAttributeSet(this.standard());
            StyleConstants.setUnderline(style, true);
            style.addAttribute((Object)Attribute.IS_REPLACEMENT, true);
            style.addAttribute((Object)Attribute.REPLACEMENT_FOR, text);
            style.addAttribute((Object)Attribute.REPLACED_WITH, replacement);
            return style;
        }

        public MutableAttributeSet emoticon(Emoticon emoticon, boolean gigantified) {
            SimpleAttributeSet emoteStyle = new SimpleAttributeSet();
            CachedImage<Emoticon> emoteImage = emoticon.getIcon(this.emoticonScaleFactor(gigantified), this.emoticonMaxHeight(gigantified), this.emoticonImageType(), ChannelTextPane.this);
            StyleConstants.setIcon(emoteStyle, emoteImage.getImageIcon());
            emoteStyle.addAttribute((Object)Attribute.EMOTICON, emoteImage);
            emoteStyle.addAttribute((Object)Attribute.IMAGE_ID, idCounter.getAndIncrement());
            emoteStyle.addAttribute((Object)Attribute.ANIMATED, emoticon.isAnimated());
            return emoteStyle;
        }

        public CachedImage.ImageType emoticonImageType() {
            return Emoticon.makeImageType(this.isEnabled(Setting.EMOTICONS_ANIMATED));
        }

        public Timestamp timestampFormat() {
            return this.timestampFormat;
        }

        public int bufferSize() {
            if (this.bufferSize > 0) {
                return this.bufferSize;
            }
            return this.numericSettings.get((Object)Setting.BUFFER_SIZE);
        }

        public void setBufferSize(int size) {
            this.bufferSize = size;
        }

        public long namesMode() {
            return this.numericSettings.get((Object)Setting.DISPLAY_NAMES_MODE).intValue();
        }

        public MutableAttributeSet reply(String parentUserText, String parentMsgId) {
            SimpleAttributeSet style = new SimpleAttributeSet();
            StyleConstants.setIcon(style, ChannelTextPane.addSpaceToIcon(REPLY_ICON));
            style.addAttribute((Object)Attribute.REPLY_PARENT_MSG, parentUserText);
            style.addAttribute((Object)Attribute.REPLY_PARENT_MSG_ID, parentMsgId);
            return style;
        }

        public MutableAttributeSet announcement(User user, MsgTags tags) {
            String colorString = tags.get("msg-param-color");
            if (colorString != null && colorString.length() > 20) {
                return null;
            }
            Color fallbackColor = StyleConstants.getForeground(this.info());
            Color color = HtmlColors.decode(colorString, fallbackColor);
            String id = "announcement";
            String version = HtmlColors.getNamedColorString(color);
            UsericonManager m = user.getUsericonManager();
            Usericon icon = m.getIcon(Usericon.Type.OTHER, "announcement", version, user, tags);
            if (icon == null) {
                String title = "Announcement";
                if (colorString != null && !colorString.equals("PRIMARY")) {
                    title = String.format("Announcement (%s)", colorString);
                }
                icon = UsericonFactory.createSpecialOtherIcon(id, version, MainGui.class.getResource("announcement.png"), MainGui.class.getResource("announcement@2x.png"), title);
                m.addDefaultIcon(icon);
            }
            if (icon.removeBadge) {
                return null;
            }
            SimpleAttributeSet style = new SimpleAttributeSet();
            CachedImage<Usericon> usericonImage = icon.getIcon(this.usericonScaleFactor(), this.getInt(Setting.CUSTOM_USERICON_SCALE_MODE), ChannelTextPane.this);
            StyleConstants.setIcon(style, usericonImage.getImageIcon());
            style.addAttribute((Object)Attribute.USERICON, usericonImage);
            return style;
        }

        public MutableAttributeSet hypeChat(AttributeSet baseStyle, MsgTags tags) {
            SimpleAttributeSet style = new SimpleAttributeSet(baseStyle);
            style.addAttribute((Object)Attribute.HYPE_CHAT, tags.getHypeChatInfo());
            return style;
        }
    }

    private class LineSelection
    implements UserListener {
        private Element currentSelection;
        private User currentUser;
        private Component shouldReturnFocusTo;
        private boolean subduedHl;

        private LineSelection(final UserListener userListener) {
            ChannelTextPane.this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (e.getOppositeComponent() != null && e.getOppositeComponent().getClass() == ChannelEditBox.class) {
                        LineSelection.this.shouldReturnFocusTo = e.getOppositeComponent();
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() != null && e.getOppositeComponent().getClass() == ChannelEditBox.class) {
                        LineSelection.this.disable();
                    }
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("W"), "LineSelection.moveUp");
            ChannelTextPane.this.getActionMap().put("LineSelection.moveUp", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineSelection.this.move(-1);
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("A"), "LineSelection.moveUpMore");
            ChannelTextPane.this.getActionMap().put("LineSelection.moveUpMore", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineSelection.this.move(-1);
                    LineSelection.this.move(-1);
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("D"), "LineSelection.moveDownMore");
            ChannelTextPane.this.getActionMap().put("LineSelection.moveDownMore", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineSelection.this.move(1);
                    LineSelection.this.move(1);
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("S"), "LineSelection.moveDown");
            ChannelTextPane.this.getActionMap().put("LineSelection.moveDown", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineSelection.this.move(1);
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("E"), "LineSelection.action");
            ChannelTextPane.this.getActionMap().put("LineSelection.action", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LineSelection.this.currentSelection != null && ChannelTextPane.this.doesLineExist(LineSelection.this.currentSelection)) {
                        userListener.userClicked(LineSelection.this.currentUser, LineSelection.this.getCurrentId(), null, null);
                    }
                }
            });
            ChannelTextPane.this.getInputMap(0).put(KeyStroke.getKeyStroke("Q"), "LineSelection.exit");
            ChannelTextPane.this.getActionMap().put("LineSelection.exit", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LineSelection.this.disable();
                }
            });
        }

        void toggleLineSelection() {
            if (this.currentSelection != null) {
                this.disable();
            } else {
                ChannelTextPane.this.requestFocusInWindow();
                this.move(-1);
            }
        }

        private void disable() {
            if (this.currentSelection == null) {
                return;
            }
            ChannelTextPane.this.resetSearch();
            if (this.currentSelection != null) {
                ChannelTextPane.this.scrollManager.scrollDown();
            }
            this.currentSelection = null;
            this.currentUser = null;
            if (this.shouldReturnFocusTo != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LineSelection.this.shouldReturnFocusTo.requestFocusInWindow();
                    }
                });
            }
        }

        private void move(int jump) {
            this.move(jump, false);
        }

        private void move(int jump, boolean exitAtBottom) {
            boolean startSearch;
            this.subduedHl = false;
            int count = ChannelTextPane.this.doc.getDefaultRootElement().getElementCount();
            if (this.currentSelection != null && !ChannelTextPane.this.doesLineExist(this.currentSelection)) {
                this.currentSelection = null;
            }
            boolean bl = startSearch = this.currentSelection == null;
            if (this.currentSelection == null && exitAtBottom) {
                return;
            }
            int start = 0;
            int direction = 1;
            if (jump < 0) {
                start = count - 1;
                direction = -1;
            }
            for (int i = start; i >= 0 && i < count + 1; i += direction) {
                boolean selected;
                if (i == count) {
                    if (exitAtBottom) {
                        this.disable();
                    }
                    return;
                }
                Element element = ChannelTextPane.this.doc.getDefaultRootElement().getElement(i);
                User user = ChannelTextPane.getUserFromLine(element);
                if (element == this.currentSelection) {
                    startSearch = true;
                    continue;
                }
                if (user != this.currentUser && startSearch && (selected = this.select(element))) break;
            }
        }

        private boolean select(Element line) {
            if (ChannelTextPane.this.isMessageLine(line)) {
                User user = ChannelTextPane.getUserFromLine(line);
                ChannelTextPane.this.clearSearchResult();
                this.highlightLine(line, true);
                this.currentSelection = line;
                this.currentUser = user;
                ArrayList lines = ChannelTextPane.this.getLinesFromUser(user, null, true);
                for (Integer lineNumber : lines) {
                    Element otherLine = ChannelTextPane.this.doc.getDefaultRootElement().getElement(lineNumber);
                    if (otherLine == this.currentSelection) continue;
                    this.highlightLine(otherLine, false);
                }
                return true;
            }
            return false;
        }

        private void highlightLine(Element element, boolean primary) {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset() - 1;
            int length = endOffset - startOffset;
            MutableAttributeSet style = primary ? ChannelTextPane.this.styles.searchResult2(primary) : ChannelTextPane.this.styles.searchResult(primary);
            ChannelTextPane.this.doc.setCharacterAttributes(startOffset, length, style, false);
            if (primary) {
                ChannelTextPane.this.scrollManager.scrollToOffset(startOffset);
            }
        }

        private void onLineAdded(Element element) {
            if (this.currentUser != null && ChannelTextPane.this.isLineFromUserAndId(element, this.currentUser, null, true)) {
                this.highlightLine(element, false);
            }
        }

        private String getCurrentId() {
            if (this.currentSelection != null) {
                return ChannelTextPane.getIdFromElement(ChannelTextPane.getUserElementFromLine(this.currentSelection, true));
            }
            return null;
        }

        @Override
        public void userClicked(User user, String messageId, String autoModMsgId, MouseEvent e) {
            if (e != null && (e.isAltDown() && e.isControlDown() || e.isAltGraphDown()) && !SwingUtilities.isMiddleMouseButton(e)) {
                Element element = LinkController.getElement(e);
                Element line = null;
                while (element.getParentElement() != null) {
                    line = element;
                    element = element.getParentElement();
                }
                this.select(line);
            }
        }

        public User getSelectedUser() {
            if (ChannelTextPane.this.doesLineExist(this.currentSelection)) {
                return this.currentUser;
            }
            return null;
        }

        @Override
        public void emoteClicked(Emoticon emote, MouseEvent e) {
        }

        @Override
        public void usericonClicked(Usericon usericon, MouseEvent e) {
        }

        @Override
        public void linkClicked(Channel channel, MsgTags.Link link) {
        }
    }

    public static enum Type {
        REGULAR,
        STREAM_CHAT,
        HIGHLIGHTS,
        IGNORED;

    }

    public static enum Setting {
        TIMESTAMP_ENABLED,
        EMOTICONS_ENABLED,
        AUTO_SCROLL,
        USERICONS_ENABLED,
        SHOW_BANMESSAGES,
        COMBINE_BAN_MESSAGES,
        DELETE_MESSAGES,
        DELETED_MESSAGES_MODE,
        BAN_DURATION_APPENDED,
        BAN_REASON_APPENDED,
        BAN_DURATION_MESSAGE,
        BAN_REASON_MESSAGE,
        ACTION_COLORED,
        LINKS_CUSTOM_COLOR,
        BUFFER_SIZE,
        AUTO_SCROLL_TIME,
        EMOTICON_MAX_HEIGHT,
        EMOTICON_SCALE_FACTOR,
        USERICON_SCALE_FACTOR,
        EMOTICON_SCALE_FACTOR_GIGANTIFIED,
        CUSTOM_USERICON_SCALE_MODE,
        BOT_BADGE_ENABLED,
        CHANNEL_LOGO_SIZE,
        SHOW_CHANNEL_NAME,
        FILTER_COMBINING_CHARACTERS,
        PAUSE_ON_MOUSEMOVE,
        PAUSE_ON_MOUSEMOVE_CTRL_REQUIRED,
        EMOTICONS_ANIMATED,
        SHOW_TOOLTIPS,
        SHOW_TOOLTIP_IMAGES,
        BOTTOM_MARGIN,
        DISPLAY_NAMES_MODE,
        MENTIONS,
        MENTIONS_INFO,
        MENTION_MESSAGES,
        HIGHLIGHT_HOVERED_USER,
        HIGHLIGHT_MATCHES_ALL,
        USERCOLOR_BACKGROUND,
        SHARED_BADGES,
        SHARED_LOGO_SIZE,
        SHARED_LOGO_ALWAYS;

    }

    public static enum Attribute {
        BASE_STYLE,
        ORIGINAL_BASE_STYLE,
        TIMESTAMP_COLOR_INHERIT,
        TIME_CREATED,
        IS_BAN_MESSAGE,
        BAN_MESSAGE_COUNT,
        TIMESTAMP,
        USER,
        IS_USER_MESSAGE,
        URL_DELETED,
        DELETED_LINE,
        EMOTICON,
        IS_APPENDED_INFO,
        INFO_TEXT,
        BANS,
        BAN_MESSAGE,
        MSG_ID,
        ID_AUTOMOD,
        AUTOMOD_ACTION,
        USERICON,
        IMAGE_ID,
        ANIMATED,
        APPENDED_INFO_UPDATED,
        MENTION,
        USERICON_INFO,
        USERICON_SHARED_INFO,
        GENERAL_LINK,
        REPEAT_MESSAGE_COUNT,
        LOW_TRUST_INFO,
        IS_RESTRICTED,
        POWER_UP_INFO,
        LINE_ID,
        LOCAL_USER,
        HIGHLIGHT_WORD,
        HIGHLIGHT_LINE,
        HIGHLIGHT_SOURCE,
        EVEN,
        PARAGRAPH_SPACING,
        CUSTOM_BACKGROUND,
        CUSTOM_BACKGROUND_ORIG,
        CUSTOM_FOREGROUND,
        CUSTOM_COLOR_SOURCE,
        ROUTING_SOURCE,
        IGNORE_SOURCE,
        IS_REPLACEMENT,
        REPLACEMENT_FOR,
        REPLACED_WITH,
        COMMAND,
        ACTION_BY,
        ACTION_REASON,
        REPLY_PARENT_MSG,
        REPLY_PARENT_MSG_ID,
        HYPE_CHAT,
        OBJECT_ID;

    }

    private static class MentionCheck {
        public final User user;
        public final Matcher matcher;

        public MentionCheck(User user) {
            this.user = user;
            this.matcher = Pattern.compile("(?i)\\b" + Pattern.quote(user.getName()) + "\\b").matcher("");
        }
    }

    private static interface InfoChanger {
        public void changeInfo(MutableAttributeSet var1);
    }

    private static class Userline {
        private User user;
        private Element line;
        private Element userElement;

        Userline(User user, Element userElement, Element line) {
            this.user = user;
            this.userElement = userElement;
            this.line = line;
        }
    }

    private static enum SpecialColor {
        RAINBOW,
        GOLD;

    }
}

