/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.util.Debugging;
import javax.swing.text.BoxView;
import javax.swing.text.Element;

class ChatBoxView
extends BoxView {
    private final boolean enabled;
    private int layouts = 0;

    public ChatBoxView(Element elem, int axis, boolean enabled) {
        super(elem, axis);
        this.enabled = enabled;
    }

    @Override
    protected void layout(int width, int height) {
        if (Debugging.isEnabled("layout")) {
            long start = System.currentTimeMillis();
            super.layout(width, height);
            long duration = System.currentTimeMillis() - start;
            if (duration > 1L) {
                ++this.layouts;
                Debugging.println("layout " + duration + " " + this.layouts);
            }
        } else {
            super.layout(width, height);
        }
    }

    @Override
    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        super.layoutMajorAxis(targetSpan, axis, offsets, spans);
        if (this.enabled) {
            int i;
            int textBlockHeight = 0;
            int offset = 0;
            for (i = 0; i < spans.length; ++i) {
                textBlockHeight += spans[i];
            }
            offset = targetSpan - textBlockHeight;
            if (offset > 0) {
                i = 0;
                while (i < offsets.length) {
                    int n = i++;
                    offsets[n] = offsets[n] + offset;
                }
            }
        }
    }
}

