/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FixSelection
implements DocumentListener {
    private final JTextComponent c;

    public static void install(JTextComponent c) {
        c.getDocument().addDocumentListener(new FixSelection(c));
    }

    public FixSelection(JTextComponent c) {
        this.c = c;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fix(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fix(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void fix(DocumentEvent e) {
        int dot = this.c.getCaret().getDot();
        int mark = this.c.getCaret().getMark();
        int docLength = e.getDocument().getLength();
        int change = 0;
        if (e.getType() == DocumentEvent.EventType.INSERT) {
            change = e.getLength();
        } else if (e.getType() == DocumentEvent.EventType.REMOVE) {
            change = -e.getLength();
        }
        if (dot > e.getOffset()) {
            dot += change;
        }
        if (mark > e.getOffset()) {
            mark += change;
        }
        mark = this.checkBounds(mark, docLength);
        dot = this.checkBounds(dot, docLength);
        this.c.getCaret().setDot(mark);
        if (mark != dot) {
            this.c.getCaret().moveDot(dot);
        }
    }

    private int checkBounds(int pos, int length) {
        if (pos < 0) {
            return 0;
        }
        if (pos > length) {
            return length;
        }
        return pos;
    }
}

