/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.User;
import chatty.gui.Highlighter;
import chatty.gui.components.textpane.Message;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InfoMessage {
    private static final Map<String, String> COMMANDS = new HashMap<String, String>();
    public final long createdTime = System.currentTimeMillis();
    public final Type msgType;
    public final String text;
    public final MsgTags tags;
    public final long lineId;
    public boolean highlighted;
    private boolean hidden;
    public Color color;
    public Color bgColor;
    public List<Highlighter.Match> highlightMatches;
    public Object colorSource;
    public Object highlightSource;
    public Object ignoreSource;
    public Object routingSource;
    public Object objectId;
    public User localUser;

    public static boolean msgIdHasCommand(String msgId) {
        return COMMANDS.containsValue(msgId);
    }

    public InfoMessage(Type msgType, String text) {
        this(msgType, text, MsgTags.EMPTY);
    }

    public InfoMessage(Type msgType, String text, MsgTags tags) {
        this.msgType = msgType;
        this.text = text;
        this.tags = tags;
        this.lineId = Message.getLineId();
    }

    public InfoMessage(InfoMessage other) {
        this.msgType = other.msgType;
        this.text = other.text;
        this.tags = other.tags;
        this.highlighted = other.highlighted;
        this.hidden = other.hidden;
        this.color = other.color;
        this.bgColor = other.bgColor;
        this.highlightMatches = other.highlightMatches;
        this.colorSource = other.colorSource;
        this.highlightSource = other.highlightSource;
        this.ignoreSource = other.ignoreSource;
        this.routingSource = other.routingSource;
        this.objectId = other.objectId;
        this.localUser = other.localUser;
        this.lineId = other.lineId;
    }

    public InfoMessage copy() {
        return new InfoMessage(this);
    }

    public static InfoMessage createInfo(String text) {
        return new InfoMessage(Type.INFO, text);
    }

    public static InfoMessage createInfo(String text, MsgTags tags) {
        return new InfoMessage(Type.INFO, text, tags);
    }

    public static InfoMessage createSystem(String text) {
        return new InfoMessage(Type.SYSTEM, text);
    }

    public static InfoMessage createAppend(Object objectId, String text) {
        InfoMessage m = new InfoMessage(Type.APPEND, text);
        m.objectId = objectId;
        return m;
    }

    public boolean isSystemMsg() {
        return this.msgType == Type.SYSTEM;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String makeCommand() {
        if (this.tags != null) {
            return COMMANDS.get(this.tags.get("msg-id"));
        }
        return null;
    }

    public long age() {
        return System.currentTimeMillis() - this.createdTime;
    }

    public int getMsgStart() {
        return -1;
    }

    public int getMsgEnd() {
        return -1;
    }

    public List<MsgTags.Link> getAppendedLinks() {
        ArrayList<MsgTags.Link> result = new ArrayList<MsgTags.Link>();
        if (this.tags != null) {
            for (MsgTags.Link link : this.tags.getLinks()) {
                if (link.startIndex != -1) continue;
                result.add(link);
            }
        }
        return result;
    }

    static {
        COMMANDS.put("subs_on", "subscribers");
        COMMANDS.put("subs_off", "subscribersoff");
        COMMANDS.put("followers_on", "followers");
        COMMANDS.put("followers_on_zero", "followers");
        COMMANDS.put("followers_off", "followersoff");
        COMMANDS.put("emote_only_on", "emoteonly");
        COMMANDS.put("emote_only_off", "emoteonlyoff");
        COMMANDS.put("host_on", "host");
        COMMANDS.put("host_off", "unhost");
        COMMANDS.put("r9k_on", "r9kbeta");
        COMMANDS.put("r9k_off", "r9kbetaoff");
        COMMANDS.put("slow_on", "slow");
        COMMANDS.put("slow_off", "slowoff");
    }

    public static enum Type {
        INFO,
        SYSTEM,
        APPEND;

    }
}

