/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.Helper;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.gui.LinkListener;
import chatty.gui.MainGui;
import chatty.gui.MouseClickedListener;
import chatty.gui.UserListener;
import chatty.gui.colors.ColorItem;
import chatty.gui.components.Channel;
import chatty.gui.components.menus.ChannelContextMenu;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.EmoteContextMenu;
import chatty.gui.components.menus.StreamsContextMenu;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.gui.components.menus.UrlContextMenu;
import chatty.gui.components.menus.UserContextMenu;
import chatty.gui.components.menus.UsericonContextMenu;
import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.notifications.Notification;
import chatty.lang.Language;
import chatty.util.CombinedEmoticon;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.ReplyManager;
import chatty.util.StringUtil;
import chatty.util.TwitchEmotesApi;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import chatty.util.api.Emoticons;
import chatty.util.api.usericons.Usericon;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import org.json.simple.JSONArray;

public class LinkController
extends MouseAdapter {
    private static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private static final Cursor NORMAL_CURSOR = Cursor.getDefaultCursor();
    private final Set<UserListener> userListener = new HashSet<UserListener>();
    private Consumer<User> userHoverListener;
    private int userHoverHighlightMode;
    private LinkListener linkListener;
    private MouseClickedListener mouseClickedListener;
    private ContextMenuListener contextMenuListener;
    private Supplier<ContextMenu> defaultContextMenuCreator;
    private Channel channel;
    private MyPopup popup = new MyPopup();
    private boolean popupImagesEnabled;
    private int mentionMessages;
    private Element prevHoverElement;
    private ChannelTextPane.Type type;
    private MainGui main;
    private static final String POPUP_HTML_PREFIX = "<html><body style='text-align:center;font-weight:bold;'>";
    private static final Object unique = new Object();

    public void setType(ChannelTextPane.Type type) {
        this.type = type;
    }

    public void addUserListener(UserListener listener) {
        if (listener != null) {
            this.userListener.add(listener);
        }
    }

    public void setUserHoverListener(Consumer<User> listener) {
        this.userHoverListener = listener;
    }

    public void setUserHoverHighlightMode(int mode) {
        this.userHoverHighlightMode = mode;
    }

    public void setLinkListener(LinkListener listener) {
        this.linkListener = listener;
    }

    public void setMouseClickedListener(MouseClickedListener listener) {
        this.mouseClickedListener = listener;
    }

    public void setContextMenuListener(ContextMenuListener listener) {
        this.contextMenuListener = listener;
    }

    public void setContextMenuCreator(Supplier<ContextMenu> contextMenu) {
        this.defaultContextMenuCreator = contextMenu;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setMainGui(MainGui main) {
        this.main = main;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
            Element element = LinkController.getElement(e);
            if (element != null) {
                this.handleSingleLeftClick(e, element);
            }
        } else if (e.getClickCount() == 1 && SwingUtilities.isMiddleMouseButton(e) && !e.isPopupTrigger()) {
            Element element = LinkController.getElement(e);
            if (element != null) {
                this.handleSingleMiddleClick(e, element);
            }
        } else if (e.isPopupTrigger()) {
            this.openContextMenu(e);
        }
    }

    private void handleSingleLeftClick(MouseEvent e, Element element) {
        block12: {
            block11: {
                String url = LinkController.getUrl(element);
                if (url == null || this.isUrlDeleted(element)) break block11;
                if (this.linkListener == null) break block12;
                this.linkListener.linkClicked(url);
                break block12;
            }
            MsgTags.Link link = this.getGeneralLink(element);
            if (link != null) {
                for (UserListener listener : this.userListener) {
                    listener.linkClicked(this.channel, link);
                }
            } else {
                User user = this.getUser(element);
                if (user != null || (user = this.getMention(element)) != null) {
                    for (UserListener listener : this.userListener) {
                        User finalUser = user;
                        SwingUtilities.invokeLater(() -> listener.userClicked(finalUser, this.getMsgId(element), this.getAutoModMsgId(element), e));
                    }
                } else {
                    CachedImage<Emoticon> emoteImage = this.getEmoticonImage(element);
                    if (emoteImage != null) {
                        for (UserListener listener : this.userListener) {
                            listener.emoteClicked(emoteImage.getObject(), e);
                        }
                    } else {
                        CachedImage<Usericon> usericonImage = this.getUsericonImage(element);
                        if (usericonImage != null) {
                            for (UserListener listener : this.userListener) {
                                listener.usericonClicked(usericonImage.getObject(), e);
                            }
                        }
                    }
                }
            }
        }
    }

    private void handleSingleMiddleClick(MouseEvent e, Element element) {
        User user = this.getUser(element);
        if (user != null || (user = this.getMention(element)) != null) {
            for (UserListener listener : this.userListener) {
                User finalUser = user;
                SwingUtilities.invokeLater(() -> listener.userClicked(finalUser, this.getMsgId(element), this.getAutoModMsgId(element), e));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.openContextMenu(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseClickedListener != null && e.getClickCount() == 1 && !e.isAltDown() && !e.isAltGraphDown() && e.getButton() == 1) {
            this.mouseClickedListener.mouseClicked(this.channel, false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isClickableElement;
        boolean isRestricted;
        Element element = LinkController.getElement(e);
        JTextPane textPane = (JTextPane)e.getSource();
        if (element == null) {
            textPane.setCursor(NORMAL_CURSOR);
            return;
        }
        this.hidePopupIfDifferentElement(element);
        if (Debugging.isEnabled("attr")) {
            this.popup.show(textPane, element, p -> LinkController.debugElement(element, p), -1);
            return;
        }
        CachedImage<Emoticon> emoteImage = this.getEmoticonImage(element);
        CachedImage<Usericon> usericonImage = this.getUsericonImage(element);
        String replacedText = this.getReplacedText(element);
        String replyMsgId = this.getReplyText(element);
        User mention = this.getMention(element);
        String hypeChatInfo = (String)element.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.HYPE_CHAT);
        boolean bl = isRestricted = element.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.IS_RESTRICTED) != null;
        if (emoteImage != null) {
            this.popup.show(textPane, element, p -> LinkController.makeEmoticonPopupText(emoteImage, this.popupImagesEnabled, p, element), emoteImage.getImageIcon().getIconWidth());
        } else if (usericonImage != null) {
            this.popup.show(textPane, element, p -> this.makeUsericonPopupText(usericonImage, this.getUsericonInfo(element), this.getUsericonSharedInfo(element), (MyPopup)p), usericonImage.getImageIcon().getIconWidth());
        } else if (replacedText != null) {
            this.popup.show(textPane, element, p -> LinkController.makeReplacementPopupText(replacedText, p), 1);
        } else if (replyMsgId != null) {
            this.popup.show(textPane, element, p -> LinkController.makeReplyPopupText(replyMsgId, p), 1);
        } else if (mention != null && this.mentionMessages > 0) {
            this.popup.show(textPane, element, p -> LinkController.makeMentionPopupText(mention, p, this.mentionMessages), 1);
        } else if (isRestricted) {
            this.popup.show(textPane, element, p -> p.setText("<html><body style='text-align:center;font-weight:bold;'>Message not posted to chat (restricted)"), 1);
        } else if (hypeChatInfo != null) {
            this.popup.show(textPane, element, p -> p.setText(POPUP_HTML_PREFIX + hypeChatInfo), 1);
        } else {
            this.popup.hide();
        }
        User user = null;
        boolean bl2 = isClickableElement = LinkController.getUrl(element) != null && !this.isUrlDeleted(element) || this.getGeneralLink(element) != null || (user = this.getUser(element)) != null || mention != null || emoteImage != null || usericonImage != null || isRestricted || hypeChatInfo != null;
        if (isClickableElement) {
            textPane.setCursor(HAND_CURSOR);
        } else {
            textPane.setCursor(NORMAL_CURSOR);
        }
        if (this.userHoverListener != null) {
            if (user == null) {
                user = mention;
            }
            if (this.userHoverHighlightMode == 3 && mention == null && !e.isControlDown() || this.userHoverHighlightMode == 4 && !e.isControlDown() || this.userHoverHighlightMode == 2 && mention == null) {
                user = null;
            }
            this.userHoverListener.accept(user);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.popup.hide();
    }

    private static String getUrl(Element e) {
        return (String)e.getAttributes().getAttribute(HTML.Attribute.HREF);
    }

    private boolean isUrlDeleted(Element e) {
        Boolean deleted = (Boolean)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.URL_DELETED);
        if (deleted == null) {
            return false;
        }
        return deleted;
    }

    private MsgTags.Link getGeneralLink(Element e) {
        return (MsgTags.Link)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.GENERAL_LINK);
    }

    private User getUser(Element e) {
        return (User)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.USER);
    }

    private User getMention(Element e) {
        return (User)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.MENTION);
    }

    private String getMsgId(Element e) {
        return (String)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.MSG_ID);
    }

    private String getAutoModMsgId(Element e) {
        return (String)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.ID_AUTOMOD);
    }

    private CachedImage<Emoticon> getEmoticonImage(Element e) {
        return (CachedImage)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.EMOTICON);
    }

    private CachedImage<Usericon> getUsericonImage(Element e) {
        return (CachedImage)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.USERICON);
    }

    private String getUsericonInfo(Element e) {
        return (String)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.USERICON_INFO);
    }

    private List<String> getUsericonSharedInfo(Element e) {
        return (List)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.USERICON_SHARED_INFO);
    }

    private String getReplacedText(Element e) {
        return (String)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.REPLACEMENT_FOR);
    }

    private String getReplyText(Element e) {
        return (String)e.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.REPLY_PARENT_MSG_ID);
    }

    private Object getSource(ChannelTextPane.Attribute attribute, Element e) {
        return e.getAttributes().getAttribute((Object)attribute);
    }

    private String getSelectedText(MouseEvent e) {
        JTextPane text = (JTextPane)e.getSource();
        return text.getSelectedText();
    }

    public static Element getElement(MouseEvent e) {
        Point mouseLocation;
        JTextPane text = (JTextPane)e.getSource();
        int pos = text.viewToModel(mouseLocation = new Point(e.getX(), e.getY()));
        if (pos >= 0) {
            try {
                StyledDocument doc;
                Element element;
                Rectangle rect = text.modelToView(pos);
                if (e.getX() < rect.x && e.getY() < rect.y + rect.height && pos > 0) {
                    --pos;
                }
                if (LinkController.getUrl(element = (doc = text.getStyledDocument()).getCharacterElement(pos)) != null) {
                    AttributeSet attr = element.getAttributes();
                    Font font = new Font(StyleConstants.getFontFamily(attr), 0, StyleConstants.getFontSize(attr));
                    int textWidth = text.getFontMetrics(font).stringWidth(doc.getText(pos, 1));
                    if (e.getX() - rect.x > textWidth) {
                        Element paragraph;
                        element = paragraph = doc.getParagraphElement(pos);
                    }
                }
                return element;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void openContextMenu(MouseEvent e) {
        if (!e.getComponent().isShowing()) {
            return;
        }
        JPopupMenu m = null;
        Element element = LinkController.getElement(e);
        if (element == null) {
            m = this.createDefaultMenu(element);
        } else {
            String selectedText = this.getSelectedText(e);
            User user = this.getUser(element);
            if (user == null) {
                user = this.getMention(element);
            }
            String url = LinkController.getUrl(element);
            MsgTags.Link link = this.getGeneralLink(element);
            CachedImage<Emoticon> emoteImage = this.getEmoticonImage(element);
            CachedImage<Usericon> usericonImage = this.getUsericonImage(element);
            if (user != null) {
                m = new UserContextMenu(user, this.getMsgId(element), this.getAutoModMsgId(element), this.contextMenuListener);
            } else if (url != null) {
                m = new UrlContextMenu(url, this.isUrlDeleted(element), this.contextMenuListener);
            } else if (link != null) {
                switch (link.type) {
                    case JOIN: {
                        String c = Helper.toStream(link.target);
                        m = new StreamsContextMenu(Arrays.asList(c), this.contextMenuListener);
                        break;
                    }
                    case URL: {
                        m = new UrlContextMenu(link.target, false, this.contextMenuListener);
                    }
                }
            } else {
                m = emoteImage != null ? new EmoteContextMenu(emoteImage, this.contextMenuListener) : (usericonImage != null ? new UsericonContextMenu(usericonImage, this.contextMenuListener) : (!StringUtil.isNullOrEmpty(selectedText) && ((JTextPane)e.getSource()).hasFocus() ? new TextSelectionMenu((JTextComponent)e.getSource(), false) : this.createDefaultMenu(element)));
            }
        }
        if (m != null) {
            JPopupMenu m2 = m;
            SwingUtilities.invokeLater(() -> m2.show(e.getComponent(), e.getX(), e.getY()));
        }
        this.popup.hide();
        if (this.mouseClickedListener != null) {
            this.mouseClickedListener.mouseClicked(this.channel, true);
        }
    }

    private void hidePopupIfDifferentElement(Element element) {
        if (this.prevHoverElement != element) {
            this.popup.hide();
        }
        this.prevHoverElement = element;
    }

    public void updatePopup() {
        this.popup.update();
    }

    public void setPopupEnabled(boolean enabled) {
        this.popup.setEnabled(enabled);
    }

    public void setPopupImagesEnabled(boolean enabled) {
        this.popupImagesEnabled = enabled;
    }

    public void setPopupMentionMessages(int amount) {
        this.mentionMessages = amount;
    }

    public void cleanUp() {
        this.popup.cleanUp();
    }

    private static void makeEmoticonPopupText(CachedImage<Emoticon> emoticonImage, boolean showImage, MyPopup popup, Element element) {
        Debugging.println("emoteinfo", "makePopupText %s", emoticonImage.getObject());
        popup.setText(LinkController.makeEmoticonPopupText2(emoticonImage, showImage, popup));
    }

    private static String makeEmoticonPopupText2(CachedImage<Emoticon> emoticonImage, boolean showImage, MyPopup popup) {
        String code;
        Emoticon emote = emoticonImage.getObject();
        String result = LinkController.getEmoteType(emote);
        String string = code = emote.type == Emoticon.Type.EMOJI ? emote.stringId : Emoticons.toWriteable(emote.code);
        if (emote instanceof CombinedEmoticon) {
            List<Emoticon> combinedEmotes = ((CombinedEmoticon)emote).getEmotes();
            code = combinedEmotes.get((int)0).code;
            String combinedWith = "";
            for (int i = 1; i < combinedEmotes.size(); ++i) {
                Emoticon cEmote = combinedEmotes.get(i);
                combinedWith = combinedWith + String.format("<br />+ <span style='font-weight:bold'>%s</span> (%s)", Helper.htmlspecialchars_encode(cEmote.code), LinkController.getEmoteType(cEmote));
            }
            if (!combinedWith.isEmpty()) {
                result = result + "<br />" + combinedWith;
            }
        }
        if (Debugging.isEnabled("tt")) {
            result = result + " [" + emoticonImage.getImageIcon().getDescription() + "]";
        }
        if (showImage) {
            CachedImage<Emoticon> icon = emote.getIcon(2.0f, 0, CachedImage.ImageType.ANIMATED_DARK, (o, n, c) -> popup.forceUpdate());
            popup.setIcon(icon.getImageIcon());
        }
        return String.format("%s%s<br /><span style='font-weight:normal'>%s</span>", POPUP_HTML_PREFIX, Helper.htmlspecialchars_encode(code), result);
    }

    private static String getEmoteType(Emoticon emote) {
        String result;
        if (emote.type == Emoticon.Type.TWITCH) {
            if (emote.subType == Emoticon.SubType.CHEER) {
                result = "Cheering Emote";
                result = emote.hasStreamRestrictions() ? result + " Local" : result + " Global";
            } else {
                result = TwitchEmotesApi.getEmoteType(emote);
            }
        } else if (emote.type == Emoticon.Type.CUSTOM2) {
            result = "Local Emote";
        } else {
            result = emote.type.label;
            if (emote.type != Emoticon.Type.EMOJI) {
                result = emote.hasStreamRestrictions() ? result + " Local" : result + " Global";
            }
        }
        return result;
    }

    private void makeUsericonPopupText(CachedImage<Usericon> usericonImage, String moreInfo, List<String> sharedInfo, MyPopup p) {
        Usericon usericon = usericonImage.getObject();
        String info = !usericon.metaTitle.isEmpty() ? "<html><body style='text-align:center;font-weight:bold;'>Badge: " + usericon.metaTitle : (usericon.type == Usericon.Type.HL || usericon.type == Usericon.Type.FIRSTMSG ? POPUP_HTML_PREFIX + usericon.type.label : (usericon.type == Usericon.Type.CHANNEL_LOGO ? "<html><body style='text-align:center;font-weight:bold;'>Channel Logo: " + usericon.channel : "<html><body style='text-align:center;font-weight:bold;'>Badge: " + usericon.type.label));
        if (!usericon.channel.isEmpty() && !usericon.channelInverse) {
            info = info + " (Local)";
        }
        if (usericon.source == 20) {
            info = info + " (Custom)";
        }
        if (Debugging.isEnabled("tt")) {
            info = info + " [" + usericonImage.getImageIcon().getDescription() + "]";
        }
        if (usericon.metaDescription != null && !usericon.metaDescription.isEmpty()) {
            info = info + "<br />" + usericon.metaDescription;
        }
        if (!StringUtil.isNullOrEmpty(moreInfo)) {
            info = info + "<br />(" + moreInfo + ")";
        }
        if (sharedInfo != null && !sharedInfo.isEmpty()) {
            if (usericon.type == Usericon.Type.CHANNEL_LOGO) {
                info = info + "<br />Shared Chat: " + StringUtil.join(sharedInfo, ", ") + "";
            } else {
                String activeChannel = "";
                ArrayList<String> chans = new ArrayList<String>(sharedInfo);
                if (chans.remove(this.channel.getName())) {
                    activeChannel = activeChannel + " and here";
                }
                info = info + "<br />Badge from: " + StringUtil.join(chans, ", ") + activeChannel;
            }
        }
        p.setText(info);
    }

    private static void makeReplacementPopupText(String replacedText, MyPopup p) {
        p.setText(String.format("%sFiltered Text<div style='text-align:left;font-weight:normal'>%s</div>", POPUP_HTML_PREFIX, StringUtil.addLinebreaks(Helper.htmlspecialchars_encode(replacedText), 70, true)));
    }

    private static void makeReplyPopupText(String replyMsgId, MyPopup p) {
        List<ReplyManager.Reply> replies = ReplyManager.getReplies(replyMsgId);
        StringBuilder b = new StringBuilder();
        if (replies != null) {
            for (ReplyManager.Reply reply : replies) {
                b.append(StringUtil.addLinebreaks(Helper.htmlspecialchars_encode(reply.userMsg), 70, true));
                b.append("<br />");
            }
        } else {
            b.append("No reply data found (may have expired).");
        }
        p.setText(String.format("%sThread:<div style='text-align:left;font-weight:normal'>%s</div>", POPUP_HTML_PREFIX, b.toString()));
    }

    private static void makeMentionPopupText(User user, MyPopup p, int amount) {
        List<User.Message> msgs = user.getMessages();
        int count = 0;
        StringBuilder b = new StringBuilder();
        for (int i = msgs.size() - 1; i >= 0; --i) {
            User.Message msg = msgs.get(i);
            if (msg instanceof User.TextMessage) {
                b.insert(0, String.format("[%s] %s<br />", DateTime.format2(msg.getTime()), StringUtil.addLinebreaks(Helper.htmlspecialchars_encode(((User.TextMessage)msg).text), 70, true)));
                ++count;
            }
            if (count >= amount) break;
        }
        p.setText(String.format("%sLatest messages of %s:<div style='text-align:left;font-weight:normal'>%s</div>", POPUP_HTML_PREFIX, user, b.toString()));
    }

    private static void debugElement(Element e, MyPopup p) {
        StringBuilder result = new StringBuilder();
        result.append("<html><body style='font-weight:normal;'>");
        try {
            String text = e.getDocument().getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
            text = text.replace("\n", "\\n");
            result.append("'").append(text).append("'");
            result.append("<br />");
            if (e.isLeaf() && e.getParentElement() != null) {
                Element parent = e.getParentElement();
                int elementIndex = parent.getElementIndex(e.getStartOffset());
                result.append("Index: ").append(elementIndex).append(" of ").append(parent.getElementCount());
                result.append(" (Length: ").append(e.getEndOffset() - e.getStartOffset()).append(")");
                result.append("<br />");
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(LinkController.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (AttributeSet attrs = e.getAttributes(); attrs != null; attrs = attrs.getResolveParent()) {
            result.append("<b>").append(attrs.toString()).append("</b>");
            result.append("<br />");
            Enumeration<?> en = attrs.getAttributeNames();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                Object value = attrs.getAttribute(key);
                result.append(Helper.htmlspecialchars_encode(String.valueOf(key)));
                result.append(" => ");
                result.append(Helper.htmlspecialchars_encode(String.valueOf(value)));
                result.append("<br />");
            }
        }
        p.setText(result.toString());
    }

    private JPopupMenu createDefaultMenu(Element element) {
        ContextMenu m = null;
        if (this.defaultContextMenuCreator == null) {
            if (this.channel != null) {
                m = new ChannelContextMenu(this.contextMenuListener, this.channel);
            }
        } else {
            ContextMenu menu = this.defaultContextMenuCreator.get();
            menu.addContextMenuListener(this.contextMenuListener);
            m = menu;
        }
        if (element != null && m != null) {
            this.addMessageInfoItems(m, element);
        }
        return m;
    }

    private void addMessageInfoItems(JPopupMenu m, Element element) {
        Object highlightSource = this.getSource(ChannelTextPane.Attribute.HIGHLIGHT_SOURCE, element);
        Object ignoreSource = this.getSource(ChannelTextPane.Attribute.IGNORE_SOURCE, element);
        Object colorSource = this.getSource(ChannelTextPane.Attribute.CUSTOM_COLOR_SOURCE, element);
        Object routingSource = this.getSource(ChannelTextPane.Attribute.ROUTING_SOURCE, element);
        if (highlightSource != null || ignoreSource != null || colorSource != null || routingSource != null) {
            String sourceChannel;
            JMenu menu = new JMenu("Message Info");
            this.addMessageInfoItem(menu, "Highlight Source", highlightSource);
            this.addMessageInfoItem(menu, "Ignore Source", ignoreSource);
            this.addMessageInfoItem(menu, "Custom Color Source", colorSource);
            this.addMessageInfoItem(menu, "Routing Source", routingSource);
            m.addSeparator();
            m.add(menu);
            Long lineId = (Long)this.getSource(ChannelTextPane.Attribute.LINE_ID, element);
            User user = (User)this.getSource(ChannelTextPane.Attribute.LOCAL_USER, element);
            if (user == null && element.getParentElement() != null) {
                user = ChannelTextPane.getUserFromLine(element.getParentElement());
            }
            String string = sourceChannel = user != null ? user.getChannel() : null;
            if (!(lineId == null || sourceChannel == null || this.channel != null && this.channel.getChannel().equals(sourceChannel) || this.main == null)) {
                JMenuItem item = new JMenuItem("Go to source message");
                item.setEnabled(this.main.hasLineId(sourceChannel, lineId));
                item.setToolTipText("Message from " + sourceChannel);
                item.addActionListener(e -> this.main.scrollToLineId(sourceChannel, lineId, "Source Message"));
                m.add(item);
            }
        }
    }

    private void addMessageInfoItem(JMenu menu, String label, Object source) {
        if (source != null) {
            String sourceLabel;
            String sourceText;
            String sourceType;
            JMenuItem item = new JMenuItem(label);
            if (source instanceof Highlighter.HighlightItem) {
                ArrayList<Highlighter.HighlightItem> temp = new ArrayList<Highlighter.HighlightItem>();
                temp.add((Highlighter.HighlightItem)((Object)source));
                source = temp;
            }
            if (source instanceof ColorItem) {
                sourceType = "msgColorSource";
                sourceText = ((ColorItem)((Object)source)).getId();
                sourceLabel = "[" + Language.getString("settings.page.msgColors") + "] " + sourceText;
            } else if (source instanceof Notification) {
                Notification n = (Notification)((Object)source);
                sourceType = "notificationSource";
                sourceText = String.valueOf(n.id);
                sourceLabel = String.format("[%s] %s", Language.getString("settings.page.notifications"), n.toString());
            } else if (source instanceof List) {
                Object sourceItem = LinkController.getSingleItem(source);
                if (sourceItem instanceof Highlighter.HighlightItem) {
                    Highlighter.HighlightItem hlItem = (Highlighter.HighlightItem)sourceItem;
                    if (hlItem.getUsedForFeature() != null) {
                        switch (hlItem.getUsedForFeature()) {
                            case "highlight": {
                                sourceType = "highlightSource";
                                sourceLabel = Language.getString("settings.page.highlight");
                                break;
                            }
                            case "ignore": {
                                sourceType = "ignoreSource";
                                sourceLabel = Language.getString("settings.page.ignore");
                                break;
                            }
                            case "msgcolor": {
                                sourceType = "msgColorSource";
                                sourceLabel = Language.getString("settings.page.msgColors");
                                break;
                            }
                            case "routing": {
                                sourceType = "routingSource";
                                sourceLabel = Language.getString("settings.page.customTabs");
                                break;
                            }
                            case "noPresetsUsernameHighlight": {
                                sourceType = "highlightSource";
                                sourceLabel = Language.getString("settings.boolean.highlightUsername");
                                break;
                            }
                            default: {
                                sourceType = "unknownSource";
                                sourceLabel = "Unknown";
                                break;
                            }
                        }
                    } else {
                        sourceType = "unknownSource";
                        sourceLabel = "UnknownType";
                    }
                    List list = source;
                    JSONArray rawList = new JSONArray();
                    list.forEach(entry -> rawList.add(entry.getRaw()));
                    sourceText = rawList.toJSONString();
                    sourceLabel = "[" + sourceLabel + "] ";
                    sourceLabel = sourceLabel + ((Highlighter.HighlightItem)list.get(0)).getRaw();
                    if (list.size() > 1) {
                        sourceLabel = sourceLabel + " (and " + (list.size() - 1) + " more for marked matches)";
                    }
                } else {
                    sourceType = "";
                    sourceText = "";
                    sourceLabel = "";
                }
            } else {
                sourceType = "";
                sourceText = "";
                sourceLabel = "";
            }
            item.addActionListener(e -> this.contextMenuListener.menuItemClicked(new ActionEvent(item, 1001, sourceType + "." + sourceText)));
            item.setToolTipText(sourceLabel);
            menu.add(item);
        }
    }

    private static Object getSingleItem(Object o) {
        if (o != null && o instanceof List && !((List)o).isEmpty()) {
            return ((List)o).get(0);
        }
        return o;
    }

    private static class MyPopup {
        private static final int SHOW_DELAY = 300;
        private static final int NO_DELAY_WINDOW = 800;
        private final JLabel label = new JLabel();
        private final Timer showTimer = new Timer(300, e -> this.showNow());
        private boolean enabled;
        private Popup popup;
        private long lastShown;
        private boolean preparingToShow;
        private JTextPane textPane;
        private int sourceWidth;
        private Element element;
        private Point position;
        private boolean contentChanged;
        private boolean contentSet;
        private Consumer<MyPopup> provider;

        public MyPopup() {
            this.showTimer.setRepeats(false);
            this.label.setHorizontalTextPosition(0);
            this.label.setVerticalTextPosition(3);
            this.label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void show(JTextPane textPane, Element element, Consumer<MyPopup> provider, int sourceWidth) {
            if (!this.enabled) {
                return;
            }
            if (this.popup != null) {
                return;
            }
            if (this.preparingToShow) {
                return;
            }
            this.textPane = textPane;
            this.sourceWidth = sourceWidth;
            this.element = element;
            this.provider = provider;
            this.contentSet = false;
            this.preparingToShow = true;
            if (System.currentTimeMillis() - this.lastShown < 800L) {
                this.showNow();
            } else {
                this.showTimer.restart();
            }
        }

        public void hide() {
            if (this.popup != null) {
                this.popup.hide();
                this.popup = null;
                this.lastShown = System.currentTimeMillis();
            }
            if (this.preparingToShow) {
                this.preparingToShow = false;
                this.showTimer.stop();
            }
        }

        public void setText(String newText) {
            if (!Objects.equals(newText, this.label.getText())) {
                this.label.setText(newText);
                this.contentChanged = true;
                this.update();
            }
        }

        public void setIcon(ImageIcon icon) {
            if (!Objects.equals(icon, this.label.getIcon())) {
                this.label.setIcon(icon);
                this.contentChanged = true;
                this.update();
            }
        }

        public boolean isCurrentElement(Element element) {
            return this.element == element;
        }

        public void forceUpdate() {
            this.contentChanged = true;
            this.update();
        }

        public void update() {
            if (this.popup != null) {
                Point newPos = this.determinePosition();
                if (newPos == null) {
                    this.hide();
                } else if (!newPos.equals(this.position) || this.contentChanged) {
                    this.hide();
                    this.showNow();
                }
            }
        }

        private void showNow() {
            if (this.popup != null) {
                return;
            }
            if (!this.contentSet) {
                this.label.setText(null);
                this.label.setIcon(null);
                this.provider.accept(this);
                this.contentSet = true;
            }
            this.contentChanged = false;
            Point p = this.determinePosition();
            if (p != null) {
                this.position = p;
                this.popup = PopupFactory.getSharedInstance().getPopup(this.textPane, this.label, p.x, p.y);
                this.popup.show();
            }
        }

        public void cleanUp() {
            this.hide();
        }

        private Point determinePosition() {
            try {
                if (!this.textPane.isShowing()) {
                    return null;
                }
                Dimension labelSize = this.label.getPreferredSize();
                Rectangle r = this.textPane.modelToView(this.element.getStartOffset());
                r.translate(0, -labelSize.height - 3);
                r.translate(this.sourceWidth / 2 - labelSize.width / 2, 0);
                r.translate(this.textPane.getLocationOnScreen().x, this.textPane.getLocationOnScreen().y);
                Container viewPort = this.textPane.getParent();
                if (viewPort instanceof JViewport) {
                    int overRightEdge;
                    Point bounds = viewPort.getLocationOnScreen();
                    if (bounds.y - 20 > r.y) {
                        r.y += labelSize.height + r.height + 4;
                        if (bounds.y > r.y) {
                            return null;
                        }
                    }
                    if (bounds.y + viewPort.getHeight() < r.y + labelSize.height) {
                        return null;
                    }
                    int overLeftEdge = bounds.x - 5 - r.x;
                    if (overLeftEdge > 0) {
                        r.x += overLeftEdge;
                    }
                    if ((overRightEdge = r.x + labelSize.width - (bounds.x + this.textPane.getWidth() + 10)) > 0) {
                        r.x -= overRightEdge;
                    }
                }
                return new Point(r.x, r.y);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }
}

