/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.Helper;
import chatty.gui.components.Channel;
import chatty.gui.components.textpane.InfoMessage;
import chatty.util.api.eventsub.payloads.ModActionPayload;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ModLogInfo
extends InfoMessage {
    private static final Set<String> BAN_COMMANDS = new HashSet<String>(Arrays.asList("timeout", "ban", "delete"));
    private static final Set<String> UNBAN_COMMANDS = new HashSet<String>(Arrays.asList("untimeout", "unban"));
    public final ModActionPayload data;
    public final boolean showActionBy;
    public final boolean ownAction;
    public final Channel chan;

    public ModLogInfo(Channel chan, ModActionPayload data, boolean showActionBy, boolean ownAction) {
        super(InfoMessage.Type.INFO, ModLogInfo.makeText(data));
        this.chan = chan;
        this.data = data;
        this.showActionBy = showActionBy;
        this.ownAction = ownAction;
    }

    public ModLogInfo(ModLogInfo other) {
        super(other);
        this.data = other.data;
        this.showActionBy = other.showActionBy;
        this.ownAction = other.ownAction;
        this.chan = other.chan;
    }

    @Override
    public ModLogInfo copy() {
        return new ModLogInfo(this);
    }

    private static String makeText(ModActionPayload data) {
        return String.format("[ModAction]%s %s: %s", data.isShared() ? String.format("[%s]", data.getSourceChannel()) : "", data.created_by, data.getPseudoCommandString());
    }

    @Override
    public String makeCommand() {
        return ModLogInfo.makeCommand(this.data);
    }

    public static String makeCommand(ModActionPayload data) {
        switch (data.moderation_action) {
            case "timeout": {
                return ModLogInfo.makeTimeoutCommand(data);
            }
            case "ban": {
                return ModLogInfo.makeBanCommand(data);
            }
            case "delete": {
                return ModLogInfo.makeDeleteCommand(data);
            }
        }
        return data.moderation_action;
    }

    public boolean isBanCommand() {
        return ModLogInfo.isBanCommand(this.data);
    }

    public static boolean isBanCommand(ModActionPayload data) {
        return BAN_COMMANDS.contains(data.moderation_action);
    }

    public static boolean isUnbanCommand(ModActionPayload data) {
        return UNBAN_COMMANDS.contains(data.moderation_action);
    }

    public static boolean isBanOrInfoAssociated(ModActionPayload data) {
        return ModLogInfo.isBanCommand(data) || InfoMessage.msgIdHasCommand(data.moderation_action);
    }

    public static boolean isAssociated(ModActionPayload data) {
        return ModLogInfo.isBanOrInfoAssociated(data) || ModLogInfo.isAutoModAction(data);
    }

    public boolean isAutoModAction() {
        return ModLogInfo.isAutoModAction(this.data);
    }

    public static boolean isAutoModAction(ModActionPayload data) {
        return data.type == ModActionPayload.Type.AUTOMOD_APPROVED || data.type == ModActionPayload.Type.AUTOMOD_DENIED;
    }

    public static String makeDeleteCommand(ModActionPayload data) {
        if (data.action instanceof ModActionPayload.Delete) {
            ModActionPayload.Delete delete = (ModActionPayload.Delete)data.action;
            return data.moderation_action + " " + delete.getMsgId();
        }
        return "";
    }

    public static String makeBanCommand(ModActionPayload data) {
        if (data.action instanceof ModActionPayload.Ban) {
            ModActionPayload.Ban ban = (ModActionPayload.Ban)data.action;
            return data.moderation_action + " " + ban.getTargetUsername();
        }
        return "";
    }

    public static String makeTimeoutCommand(ModActionPayload data) {
        if (data.action instanceof ModActionPayload.Timeout) {
            ModActionPayload.Timeout timeout = (ModActionPayload.Timeout)data.action;
            return data.moderation_action + " " + timeout.getTargetUsername();
        }
        return "";
    }

    public String getReason() {
        return ModLogInfo.getReason(this.data);
    }

    public static String getReason(ModActionPayload data) {
        switch (data.moderation_action) {
            case "timeout": {
                return ((ModActionPayload.Timeout)data.action).getReason();
            }
            case "ban": {
                return ((ModActionPayload.Ban)data.action).getReason();
            }
        }
        return null;
    }

    public static String getTargetUsername(ModActionPayload data) {
        ModActionPayload.ModActionUser userAction;
        if (data.action instanceof ModActionPayload.ModActionUser && Helper.isValidStream((userAction = (ModActionPayload.ModActionUser)data.action).getTargetUsername())) {
            return userAction.getTargetUsername();
        }
        return null;
    }

    public static String getBannedUsername(ModActionPayload data) {
        if (ModLogInfo.isBanCommand(data)) {
            return ModLogInfo.getTargetUsername(data);
        }
        return null;
    }

    public static String getUnbannedUsername(ModActionPayload data) {
        if (ModLogInfo.isUnbanCommand(data)) {
            return ModLogInfo.getTargetUsername(data);
        }
        return null;
    }

    public static String getTargetUserInfo(ModActionPayload data) {
        String targetUser = ModLogInfo.getTargetUsername(data);
        if (targetUser != null) {
            return String.format("@%s used \"%s\" on this user", data.created_by, data.getPseudoCommandString());
        }
        return null;
    }

    public String toString() {
        return this.text;
    }
}

