/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.ChatBoxView;
import chatty.gui.components.textpane.MyIconView;
import chatty.gui.components.textpane.MyParagraphView;
import chatty.gui.components.textpane.WrapLabelView;
import chatty.util.Debugging;
import java.awt.Image;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class MyEditorKit
extends StyledEditorKit {
    private static final Logger LOGGER = Logger.getLogger(MyEditorKit.class.getName());
    private final StyledViewFactory factory;

    public MyEditorKit(boolean startAtBottom) {
        this.factory = new StyledViewFactory(startAtBottom);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }

    public Collection<MyIconView> getByImage(Image image) {
        return this.factory.getByImage(image);
    }

    public void clearImages() {
        this.factory.clearImages();
    }

    public void clearImage(long imageId) {
        Debugging.edt();
        this.factory.clearImage(imageId);
    }

    public void changeImage(Image oldImage, Image newImage) {
        this.factory.changeImage(oldImage, newImage);
    }

    public void debug() {
        this.factory.updateDebugInfo();
    }

    static class StyledViewFactory
    implements ViewFactory {
        private final boolean startAtBottom;
        private final Map<Image, Map<Long, WeakReference<MyIconView>>> imageViews = new HashMap<Image, Map<Long, WeakReference<MyIconView>>>();

        StyledViewFactory(boolean startAtBottom) {
            this.startAtBottom = startAtBottom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changeImage(Image oldImage, Image newImage) {
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                Map<Long, WeakReference<MyIconView>> data = this.imageViews.get(oldImage);
                if (data != null) {
                    this.imageViews.put(newImage, data);
                    this.imageViews.remove(oldImage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<MyIconView> getByImage(Image image) {
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                Map<Long, WeakReference<MyIconView>> data = this.imageViews.get(image);
                if (data != null) {
                    ArrayList<MyIconView> result = new ArrayList<MyIconView>();
                    Iterator<Map.Entry<Long, WeakReference<MyIconView>>> it = data.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<Long, WeakReference<MyIconView>> entry = it.next();
                        MyIconView v = (MyIconView)entry.getValue().get();
                        if (v == null) {
                            it.remove();
                            LOGGER.warning("Removed reference for image " + entry.getKey());
                            continue;
                        }
                        result.add(v);
                    }
                    return result;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearImages() {
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                this.imageViews.clear();
                this.updateDebugInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearImage(long imageId) {
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                Iterator<Map<Long, WeakReference<MyIconView>>> it = this.imageViews.values().iterator();
                while (it.hasNext()) {
                    Map<Long, WeakReference<MyIconView>> d = it.next();
                    if (d.remove(imageId) != null && Debugging.isEnabled("gifd", "gifd2")) {
                        Debugging.println(String.format("Removed image %d (remaining: %s)", imageId, d.toString()));
                    }
                    Iterator<WeakReference<MyIconView>> it2 = d.values().iterator();
                    while (it2.hasNext()) {
                        if (it2.next().get() != null) continue;
                        it2.remove();
                        LOGGER.warning("Removed reference for image");
                    }
                    if (!d.isEmpty()) continue;
                    it.remove();
                }
                this.updateDebugInfo();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addImageView(Image image, MyIconView view, long id) {
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                if (!this.imageViews.containsKey(image)) {
                    this.imageViews.put(image, new HashMap());
                }
                this.imageViews.get(image).put(id, new WeakReference<MyIconView>(view));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDebugInfo() {
            if (!Debugging.isEnabled("gifd0")) {
                return;
            }
            Map<Image, Map<Long, WeakReference<MyIconView>>> map = this.imageViews;
            synchronized (map) {
                int totalViews = 0;
                int hiddenViews = 0;
                int animated = 0;
                for (Map<Long, WeakReference<MyIconView>> e : this.imageViews.values()) {
                    for (WeakReference<MyIconView> ref : e.values()) {
                        MyIconView view = (MyIconView)ref.get();
                        ++totalViews;
                        if (view == null) continue;
                        if (!view.getShouldRepaint()) {
                            ++hiddenViews;
                        }
                        if (!view.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.ANIMATED, true)) continue;
                        ++animated;
                    }
                }
                Debugging.printlnTimed("imageViews" + this.hashCode(), String.format("images: %d views: %d animated: %d hidden: %d", this.imageViews.size(), totalViews, animated, hiddenViews));
            }
        }

        @Override
        public View create(Element elem) {
            Debugging.edt();
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new MyParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new ChatBoxView(elem, 1, this.startAtBottom);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    Long id = (Long)elem.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.IMAGE_ID);
                    MyIconView view = new MyIconView(elem);
                    if (id != null) {
                        ImageIcon icon = (ImageIcon)StyleConstants.getIcon(elem.getAttributes());
                        Image image = icon.getImage();
                        this.addImageView(image, view, id);
                        if (Debugging.isEnabled("gifd", "gifd2")) {
                            Debugging.println(String.format("Added image %d (now %d)", id, this.imageViews.size()));
                        }
                        this.updateDebugInfo();
                    }
                    return view;
                }
            }
            return new LabelView(elem);
        }
    }
}

