/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.util.Debugging;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.StyleConstants;

class MyIconView
extends IconView {
    private static final int MARGIN = 2;
    private static final int VISIBILITY_CHECK_COOLDOWN = 500;
    private final Rectangle tempRect = new Rectangle();
    private boolean shouldRepaint = true;
    private int movedUpBy;
    private long lastChecked;

    public MyIconView(Element elem) {
        super(elem);
    }

    @Override
    public float getAlignment(int axis) {
        if (axis == 1 && Debugging.isEnabled("iconold1")) {
            return 1.0f;
        }
        if (axis == 1) {
            int fontHeight = MyStyleConstants.getFontHeight(this.getAttributes());
            float lineHeight = (float)fontHeight * 0.6f;
            float actualHeight = super.getPreferredSpan(1);
            float fakedHeight = this.getPreferredSpan(1);
            float height = fakedHeight - (actualHeight - fakedHeight);
            float moveDownBy = (height - lineHeight) / 2.0f;
            float result = (fakedHeight - (moveDownBy += (float)this.moveUpBy())) / fakedHeight;
            if (Debugging.isEnabled("icond")) {
                Debugging.println(String.format("Height: %f Faked: %f Font: %d Movedown: %f", Float.valueOf(actualHeight), Float.valueOf(fakedHeight), fontHeight, Float.valueOf(moveDownBy)));
            }
            return result;
        }
        return super.getAlignment(axis);
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == 1 && Debugging.isEnabled("iconold1")) {
            float height = super.getPreferredSpan(axis);
            return height * 0.7f;
        }
        if (axis == 1) {
            float spacing;
            float height;
            int fontHeight = MyStyleConstants.getFontHeight(this.getAttributes());
            if ((float)fontHeight >= (height = super.getPreferredSpan(axis))) {
                return height;
            }
            if (this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.ANIMATED, true)) {
                spacing = StyleConstants.getLineSpacing(this.getAttributes()) * (float)fontHeight;
            } else {
                spacing = StyleConstants.getLineSpacing(this.getAttributes()) * (float)fontHeight + StyleConstants.getSpaceBelow(this.getAttributes());
                if (!Debugging.isEnabled("iconold2")) {
                    spacing += Math.max(StyleConstants.getSpaceAbove(this.getAttributes()) - 1.0f - 2.0f, 0.0f);
                }
            }
            float toFontHeight = Math.max(height - (float)fontHeight - 2.0f, 0.0f);
            float availableSpace = Math.max(spacing - 2.0f, 0.0f);
            return height - Math.min(toFontHeight, availableSpace);
        }
        return super.getPreferredSpan(axis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRectangle(Rectangle r) {
        Rectangle rectangle = this.tempRect;
        synchronized (rectangle) {
            r.setBounds(this.tempRect);
        }
    }

    public boolean shouldCheckVisibility() {
        if (this.getShouldRepaint() && System.currentTimeMillis() - this.lastChecked > 500L) {
            this.lastChecked = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getShouldRepaint() {
        Rectangle rectangle = this.tempRect;
        synchronized (rectangle) {
            return this.shouldRepaint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDontRepaint() {
        Rectangle rectangle = this.tempRect;
        synchronized (rectangle) {
            this.shouldRepaint = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAdjustedHeight() {
        Rectangle rectangle = this.tempRect;
        synchronized (rectangle) {
            return this.tempRect.height - this.movedUpBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, Shape s) {
        int moveUpBy = this.moveUpBy();
        Rectangle r = s instanceof Rectangle ? (Rectangle)s : s.getBounds();
        Rectangle rectangle = this.tempRect;
        synchronized (rectangle) {
            this.tempRect.x = r.x;
            this.tempRect.y = r.y;
            this.tempRect.width = (int)super.getPreferredSpan(0);
            this.tempRect.height = (int)super.getPreferredSpan(1);
            this.movedUpBy = moveUpBy;
            if (moveUpBy > 0) {
                this.tempRect.translate(0, -moveUpBy);
            }
            this.shouldRepaint = true;
        }
        s = this.tempRect;
        super.paint(g, s);
    }

    private int moveUpBy() {
        if (!Debugging.isEnabled("iconold2")) {
            float height = super.getPreferredSpan(1);
            float fakedHeight = this.getPreferredSpan(1);
            int moveUp = (int)(height - fakedHeight) / 2;
            int space = (int)StyleConstants.getSpaceAbove(this.getAttributes());
            if ((moveUp = Math.min(moveUp, space)) > 0) {
                return moveUp;
            }
        }
        return 0;
    }

    @Override
    public float getMinimumSpan(int axis) {
        switch (axis) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return super.getMinimumSpan(axis);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }
}

