/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.gui.components.textpane.WrapLabelView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.ParagraphView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class MyParagraphView
extends ParagraphView {
    public static int MAX_VIEW_SIZE = 50;

    public MyParagraphView(Element elem) {
        super(elem);
        this.strategy = new MyFlowStrategy();
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
        this.resetBreakSpots();
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
        this.resetBreakSpots();
    }

    private void resetBreakSpots() {
        for (int i = 0; i < this.layoutPool.getViewCount(); ++i) {
            View v = this.layoutPool.getView(i);
            if (!(v instanceof WrapLabelView)) continue;
            ((WrapLabelView)v).resetBreakSpots();
        }
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Color separatorColor;
        boolean isEmpty = this.getDocument().getLength() < 2;
        Color bgColor = (Color)this.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.CUSTOM_BACKGROUND);
        if (bgColor == null && this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.HIGHLIGHT_LINE, true)) {
            bgColor = MyStyleConstants.getHighlightBackground(this.getAttributes());
        }
        if (bgColor == null && this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.EVEN, true)) {
            bgColor = MyStyleConstants.getBackground2(this.getAttributes());
        }
        if (bgColor != null && !isEmpty) {
            g.setColor(bgColor);
            Rectangle r = a.getBounds();
            g.fillRect(0, r.y, this.getContainer().getWidth(), r.height);
        }
        if ((separatorColor = MyStyleConstants.getSeparatorColor(this.getAttributes())) != null && !isEmpty) {
            g.setColor(separatorColor);
            Rectangle r = a.getBounds();
            g.drawLine(0, r.y, this.getContainer().getWidth(), r.y);
            if (bgColor != null) {
                g.drawLine(0, r.y + r.height, this.getContainer().getWidth(), r.y + r.height);
            }
        }
        super.paint(g, a);
    }

    @Override
    public float getAlignment(int axis) {
        System.out.println("ALIGNMENT" + super.getAlignment(1));
        return super.getAlignment(axis);
    }

    public static class MyFlowStrategy
    extends FlowView.FlowStrategy {
        @Override
        protected View createView(FlowView fv, int startOffset, int spanLeft, int rowIndex) {
            View res = super.createView(fv, startOffset, spanLeft, rowIndex);
            if (res.getEndOffset() - res.getStartOffset() > MAX_VIEW_SIZE) {
                // empty if block
            }
            return res;
        }
    }
}

