/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.User;
import chatty.gui.components.textpane.InfoMessage;
import chatty.util.StringUtil;
import chatty.util.api.Emoticons;
import chatty.util.irc.MsgTags;

public class UserNotice
extends InfoMessage {
    public final String type;
    public final User user;
    public final String attachedMessage;
    public final Emoticons.TagEmotes emotes;
    public final String infoText;
    private int msgStart;
    private int msgEnd;

    public UserNotice(String type, User user, String infoText, String message, MsgTags tags) {
        super(InfoMessage.Type.INFO, UserNotice.makeFullText(type, infoText, message, tags), tags);
        this.type = type;
        this.user = user;
        this.attachedMessage = message;
        this.emotes = Emoticons.parseEmotesTag(tags.getRawEmotes());
        this.infoText = infoText;
        if (!StringUtil.isNullOrEmpty(message)) {
            if (tags.isValue("msg-id", "announcement")) {
                this.msgStart = this.text.length() - message.length();
                this.msgEnd = this.text.length();
            } else {
                this.msgStart = this.text.length() - 1 - message.length();
                this.msgEnd = this.text.length() - 1;
            }
        }
    }

    public UserNotice(UserNotice other) {
        super(other);
        this.type = other.type;
        this.user = other.user;
        this.attachedMessage = other.attachedMessage;
        this.emotes = other.emotes;
        this.infoText = other.infoText;
        this.msgStart = other.msgStart;
        this.msgEnd = other.msgEnd;
    }

    @Override
    public UserNotice copy() {
        return new UserNotice(this);
    }

    @Override
    public int getMsgStart() {
        return this.msgStart;
    }

    @Override
    public int getMsgEnd() {
        return this.msgEnd;
    }

    private static String makeFullText(String type, String text, String message, MsgTags tags) {
        if (StringUtil.isNullOrEmpty(message)) {
            return String.format("[%s] %s", type, text);
        }
        if (tags != null && tags.isValue("msg-id", "announcement")) {
            return String.format("[%s] %s%s", type, text, message);
        }
        return String.format("[%s] %s [%s]", type, text, message);
    }
}

