/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.gui.components.textpane.ChannelTextPane;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class Util {
    public static Set<Long> getImageIds(Document doc, int startLine, int endLine) {
        HashSet<Long> ids = new HashSet<Long>();
        for (int line = startLine; line <= endLine && line < doc.getDefaultRootElement().getElementCount(); ++line) {
            Element e = doc.getDefaultRootElement().getElement(line);
            Util.getImageIds(e, ids);
        }
        return ids;
    }

    public static void getImageIds(Element element, Set<Long> ids) {
        Long id = (Long)element.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.IMAGE_ID);
        if (id != null) {
            ids.add(id);
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Util.getImageIds(element.getElement(i), ids);
        }
    }

    public static String debugContents(Element element) {
        StringBuilder b = new StringBuilder();
        Util.debugContents(element, b);
        return b.toString();
    }

    public static void debugContents(Element element, StringBuilder b) {
        Document doc = element.getDocument();
        b.append("[");
        if (element.isLeaf()) {
            try {
                String text = doc.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                b.append("'").append(text).append("'");
            }
            catch (BadLocationException ex) {
                System.out.println("Bad location");
            }
        } else {
            for (int i = 0; i < element.getElementCount(); ++i) {
                Element child = element.getElement(i);
                Util.debugContents(child, b);
            }
        }
        b.append("]");
    }

    public static String getText(Document doc, int start, int end) {
        try {
            return doc.getText(start, end - start);
        }
        catch (BadLocationException ex) {
            return "-";
        }
    }

    public static boolean hasAttributeKey(Element element, Object key) {
        return element.getAttributes().getAttribute(key) != null;
    }

    public static boolean hasAttributeKeyValue(Element element, Object key, Object value) {
        return element.getAttributes().containsAttribute(key, value);
    }

    public static int[] getMessageOffsets(Element line) {
        int count = line.getElementCount();
        int start = 0;
        int end = -1;
        for (int i = 0; i < count; ++i) {
            Element element = line.getElement(i);
            if (element.getAttributes().isDefined((Object)ChannelTextPane.Attribute.USER)) {
                start = i + 1;
            }
            if (!element.getAttributes().isDefined((Object)ChannelTextPane.Attribute.IS_APPENDED_INFO)) continue;
            end = i - 1;
            break;
        }
        boolean toLastElement = false;
        if (end == -1 || end < start) {
            end = count - 1;
            toLastElement = true;
        }
        if (start < count) {
            int startOffset = line.getElement(start).getStartOffset();
            int endOffset = line.getElement(end).getEndOffset();
            if (toLastElement) {
                // empty if block
            }
            return new int[]{startOffset + 1, --endOffset};
        }
        return new int[0];
    }
}

