/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.textpane;

import chatty.gui.components.textpane.ChannelTextPane;
import chatty.gui.components.textpane.MyStyleConstants;
import chatty.gui.components.textpane.Util;
import chatty.util.Debugging;
import chatty.util.colors.ColorCorrection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class WrapLabelView
extends LabelView {
    private boolean isResettingBreakSpots = false;
    long lastPaint = 0L;
    long shortPaintCount = 0L;

    public WrapLabelView(Element elem) {
        super(elem);
    }

    @Override
    public float getPreferredSpan(int axis) {
        boolean highlightMatchesEnabled = MyStyleConstants.getHighlightMatchesEnabled(this.getAttributes());
        if (axis == 0 && highlightMatchesEnabled && this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.HIGHLIGHT_WORD, true)) {
            return super.getPreferredSpan(axis) + 3.0f;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public void paint(Graphics g, Shape a) {
        boolean isHl;
        Rectangle r;
        Rectangle rectangle = r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        if (Debugging.isEnabled("gifd")) {
            long ms = Debugging.millisecondsElapsed("WrapLabelView.print");
            Debugging.println(String.format("%d %d-%d %s", ms, this.getStartOffset(), this.getEndOffset(), Util.getText(this.getDocument(), this.getStartOffset(), this.getEndOffset())));
        }
        if (Debugging.isEnabled("gifdd")) {
            long passed = System.currentTimeMillis() - this.lastPaint;
            this.lastPaint = System.currentTimeMillis();
            this.shortPaintCount = passed < 300L ? ++this.shortPaintCount : 0L;
            if (this.shortPaintCount > 10L) {
                g.setColor(Color.blue);
                g.drawRect(r.x, r.y, r.width, r.height);
                this.shortPaintCount = 10L;
            }
        }
        boolean isHoveredUser = ChannelTextPane.hoveredUser != null && (this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.USER, ChannelTextPane.hoveredUser) || this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.MENTION, ChannelTextPane.hoveredUser));
        boolean highlightMatchesEnabled = MyStyleConstants.getHighlightMatchesEnabled(this.getAttributes());
        boolean bl = isHl = highlightMatchesEnabled && this.getAttributes().containsAttribute((Object)ChannelTextPane.Attribute.HIGHLIGHT_WORD, true);
        if (isHl || isHoveredUser) {
            Color c3;
            Color c2;
            Color c = StyleConstants.getForeground(this.getAttributes());
            boolean darkText = ColorCorrection.isDarkColor(c);
            if (darkText) {
                c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 200);
                c3 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 60);
            } else {
                c3 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
                c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), 160);
            }
            g.setColor(isHoveredUser ? c3 : c2);
            g.drawLine(r.x + 1, r.y + r.height, r.x + r.width, r.y + r.height);
            g.drawLine(r.x + r.width, r.y + 1, r.x + r.width, r.y + r.height - 1);
            g.setColor(isHoveredUser ? c2 : c3);
            g.drawLine(r.x + 1, r.y, r.x + r.width, r.y);
            g.drawLine(r.x, r.y, r.x, r.y + r.height);
            if (isHl) {
                r.translate(2, 0);
            }
        } else {
            Color bgColor = MyStyleConstants.getLabelBackground(this.getAttributes());
            if (bgColor != null) {
                g.setColor(bgColor);
                g.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        if (this.getAttributes().getAttribute((Object)ChannelTextPane.Attribute.HYPE_CHAT) != null) {
            g.setColor(StyleConstants.getForeground(this.getAttributes()));
            g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, r.height / 2, r.height / 2);
        }
        if (Debugging.isEnabled("labeloutlines")) {
            g.setColor(Color.red);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        super.paint(g, r);
    }

    @Override
    public float getMinimumSpan(int axis) {
        switch (axis) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return super.getMinimumSpan(axis);
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public View breakView(int axis, int p0, float pos, float len) {
        if (axis == 0) {
            this.resetBreakSpots();
        }
        return super.breakView(axis, p0, pos, len);
    }

    public void resetBreakSpots() {
        this.isResettingBreakSpots = true;
        this.removeUpdate(null, null, null);
        this.isResettingBreakSpots = false;
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
    }

    @Override
    public void preferenceChanged(View child, boolean width, boolean height) {
        if (!this.isResettingBreakSpots) {
            super.preferenceChanged(child, width, height);
        }
    }
}

